/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.commons.compress.utils;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteOrder;

public class BitInputStream
implements Closeable {
    private static final int MAXIMUM_CACHE_SIZE = 63;
    private static final long[] MASKS = new long[64];
    private final InputStream in;
    private final ByteOrder byteOrder;
    private long bitsCached = 0L;
    private int bitsCachedSize = 0;

    public BitInputStream(InputStream in, ByteOrder byteOrder) {
        this.in = in;
        this.byteOrder = byteOrder;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public void clearBitCache() {
        this.bitsCached = 0L;
        this.bitsCachedSize = 0;
    }

    public long readBits(int count2) throws IOException {
        long bitsOut;
        if (count2 < 0 || count2 > 63) {
            throw new IllegalArgumentException("count must not be negative or greater than 63");
        }
        while (this.bitsCachedSize < count2) {
            long nextByte = this.in.read();
            if (nextByte < 0L) {
                return nextByte;
            }
            if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
                this.bitsCached |= nextByte << this.bitsCachedSize;
            } else {
                this.bitsCached <<= 8;
                this.bitsCached |= nextByte;
            }
            this.bitsCachedSize += 8;
        }
        if (this.byteOrder == ByteOrder.LITTLE_ENDIAN) {
            bitsOut = this.bitsCached & MASKS[count2];
            this.bitsCached >>>= count2;
        } else {
            bitsOut = this.bitsCached >> this.bitsCachedSize - count2 & MASKS[count2];
        }
        this.bitsCachedSize -= count2;
        return bitsOut;
    }

    static {
        for (int i2 = 1; i2 <= 63; ++i2) {
            BitInputStream.MASKS[i2] = (MASKS[i2 - 1] << 1) + 1L;
        }
    }
}

