/*
 * Decompiled with CFR 0.152.
 */
package org.python.apache.xerces.impl.xs;

import org.python.apache.xerces.impl.dv.xs.SchemaDVFactoryImpl;
import org.python.apache.xerces.impl.dv.xs.XSSimpleTypeDecl;
import org.python.apache.xerces.impl.xs.XSAttributeDecl;
import org.python.apache.xerces.impl.xs.XSAttributeUseImpl;
import org.python.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.python.apache.xerces.impl.xs.XSElementDecl;
import org.python.apache.xerces.impl.xs.XSModelGroupImpl;
import org.python.apache.xerces.impl.xs.XSParticleDecl;

public final class XSDeclarationPool {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private XSElementDecl[][] fElementDecl = new XSElementDecl[4][];
    private int fElementDeclIndex = 0;
    private XSParticleDecl[][] fParticleDecl = new XSParticleDecl[4][];
    private int fParticleDeclIndex = 0;
    private XSModelGroupImpl[][] fModelGroup = new XSModelGroupImpl[4][];
    private int fModelGroupIndex = 0;
    private XSAttributeDecl[][] fAttrDecl = new XSAttributeDecl[4][];
    private int fAttrDeclIndex = 0;
    private XSComplexTypeDecl[][] fCTDecl = new XSComplexTypeDecl[4][];
    private int fCTDeclIndex = 0;
    private XSSimpleTypeDecl[][] fSTDecl = new XSSimpleTypeDecl[4][];
    private int fSTDeclIndex = 0;
    private XSAttributeUseImpl[][] fAttributeUse = new XSAttributeUseImpl[4][];
    private int fAttributeUseIndex = 0;
    private SchemaDVFactoryImpl dvFactory;

    public void setDVFactory(SchemaDVFactoryImpl schemaDVFactoryImpl) {
        this.dvFactory = schemaDVFactoryImpl;
    }

    public final XSElementDecl getElementDecl() {
        int n2 = this.fElementDeclIndex >> 8;
        int n3 = this.fElementDeclIndex & 0xFF;
        this.ensureElementDeclCapacity(n2);
        if (this.fElementDecl[n2][n3] == null) {
            this.fElementDecl[n2][n3] = new XSElementDecl();
        } else {
            this.fElementDecl[n2][n3].reset();
        }
        ++this.fElementDeclIndex;
        return this.fElementDecl[n2][n3];
    }

    public final XSAttributeDecl getAttributeDecl() {
        int n2 = this.fAttrDeclIndex >> 8;
        int n3 = this.fAttrDeclIndex & 0xFF;
        this.ensureAttrDeclCapacity(n2);
        if (this.fAttrDecl[n2][n3] == null) {
            this.fAttrDecl[n2][n3] = new XSAttributeDecl();
        } else {
            this.fAttrDecl[n2][n3].reset();
        }
        ++this.fAttrDeclIndex;
        return this.fAttrDecl[n2][n3];
    }

    public final XSAttributeUseImpl getAttributeUse() {
        int n2 = this.fAttributeUseIndex >> 8;
        int n3 = this.fAttributeUseIndex & 0xFF;
        this.ensureAttributeUseCapacity(n2);
        if (this.fAttributeUse[n2][n3] == null) {
            this.fAttributeUse[n2][n3] = new XSAttributeUseImpl();
        } else {
            this.fAttributeUse[n2][n3].reset();
        }
        ++this.fAttributeUseIndex;
        return this.fAttributeUse[n2][n3];
    }

    public final XSComplexTypeDecl getComplexTypeDecl() {
        int n2 = this.fCTDeclIndex >> 8;
        int n3 = this.fCTDeclIndex & 0xFF;
        this.ensureCTDeclCapacity(n2);
        if (this.fCTDecl[n2][n3] == null) {
            this.fCTDecl[n2][n3] = new XSComplexTypeDecl();
        } else {
            this.fCTDecl[n2][n3].reset();
        }
        ++this.fCTDeclIndex;
        return this.fCTDecl[n2][n3];
    }

    public final XSSimpleTypeDecl getSimpleTypeDecl() {
        int n2 = this.fSTDeclIndex >> 8;
        int n3 = this.fSTDeclIndex & 0xFF;
        this.ensureSTDeclCapacity(n2);
        if (this.fSTDecl[n2][n3] == null) {
            this.fSTDecl[n2][n3] = this.dvFactory.newXSSimpleTypeDecl();
        } else {
            this.fSTDecl[n2][n3].reset();
        }
        ++this.fSTDeclIndex;
        return this.fSTDecl[n2][n3];
    }

    public final XSParticleDecl getParticleDecl() {
        int n2 = this.fParticleDeclIndex >> 8;
        int n3 = this.fParticleDeclIndex & 0xFF;
        this.ensureParticleDeclCapacity(n2);
        if (this.fParticleDecl[n2][n3] == null) {
            this.fParticleDecl[n2][n3] = new XSParticleDecl();
        } else {
            this.fParticleDecl[n2][n3].reset();
        }
        ++this.fParticleDeclIndex;
        return this.fParticleDecl[n2][n3];
    }

    public final XSModelGroupImpl getModelGroup() {
        int n2 = this.fModelGroupIndex >> 8;
        int n3 = this.fModelGroupIndex & 0xFF;
        this.ensureModelGroupCapacity(n2);
        if (this.fModelGroup[n2][n3] == null) {
            this.fModelGroup[n2][n3] = new XSModelGroupImpl();
        } else {
            this.fModelGroup[n2][n3].reset();
        }
        ++this.fModelGroupIndex;
        return this.fModelGroup[n2][n3];
    }

    private boolean ensureElementDeclCapacity(int n2) {
        if (n2 >= this.fElementDecl.length) {
            this.fElementDecl = XSDeclarationPool.resize(this.fElementDecl, this.fElementDecl.length * 2);
        } else if (this.fElementDecl[n2] != null) {
            return false;
        }
        this.fElementDecl[n2] = new XSElementDecl[256];
        return true;
    }

    private static XSElementDecl[][] resize(XSElementDecl[][] xSElementDeclArray, int n2) {
        XSElementDecl[][] xSElementDeclArray2 = new XSElementDecl[n2][];
        System.arraycopy(xSElementDeclArray, 0, xSElementDeclArray2, 0, xSElementDeclArray.length);
        return xSElementDeclArray2;
    }

    private boolean ensureParticleDeclCapacity(int n2) {
        if (n2 >= this.fParticleDecl.length) {
            this.fParticleDecl = XSDeclarationPool.resize(this.fParticleDecl, this.fParticleDecl.length * 2);
        } else if (this.fParticleDecl[n2] != null) {
            return false;
        }
        this.fParticleDecl[n2] = new XSParticleDecl[256];
        return true;
    }

    private boolean ensureModelGroupCapacity(int n2) {
        if (n2 >= this.fModelGroup.length) {
            this.fModelGroup = XSDeclarationPool.resize(this.fModelGroup, this.fModelGroup.length * 2);
        } else if (this.fModelGroup[n2] != null) {
            return false;
        }
        this.fModelGroup[n2] = new XSModelGroupImpl[256];
        return true;
    }

    private static XSParticleDecl[][] resize(XSParticleDecl[][] xSParticleDeclArray, int n2) {
        XSParticleDecl[][] xSParticleDeclArray2 = new XSParticleDecl[n2][];
        System.arraycopy(xSParticleDeclArray, 0, xSParticleDeclArray2, 0, xSParticleDeclArray.length);
        return xSParticleDeclArray2;
    }

    private static XSModelGroupImpl[][] resize(XSModelGroupImpl[][] xSModelGroupImplArray, int n2) {
        XSModelGroupImpl[][] xSModelGroupImplArray2 = new XSModelGroupImpl[n2][];
        System.arraycopy(xSModelGroupImplArray, 0, xSModelGroupImplArray2, 0, xSModelGroupImplArray.length);
        return xSModelGroupImplArray2;
    }

    private boolean ensureAttrDeclCapacity(int n2) {
        if (n2 >= this.fAttrDecl.length) {
            this.fAttrDecl = XSDeclarationPool.resize(this.fAttrDecl, this.fAttrDecl.length * 2);
        } else if (this.fAttrDecl[n2] != null) {
            return false;
        }
        this.fAttrDecl[n2] = new XSAttributeDecl[256];
        return true;
    }

    private static XSAttributeDecl[][] resize(XSAttributeDecl[][] xSAttributeDeclArray, int n2) {
        XSAttributeDecl[][] xSAttributeDeclArray2 = new XSAttributeDecl[n2][];
        System.arraycopy(xSAttributeDeclArray, 0, xSAttributeDeclArray2, 0, xSAttributeDeclArray.length);
        return xSAttributeDeclArray2;
    }

    private boolean ensureAttributeUseCapacity(int n2) {
        if (n2 >= this.fAttributeUse.length) {
            this.fAttributeUse = XSDeclarationPool.resize(this.fAttributeUse, this.fAttributeUse.length * 2);
        } else if (this.fAttributeUse[n2] != null) {
            return false;
        }
        this.fAttributeUse[n2] = new XSAttributeUseImpl[256];
        return true;
    }

    private static XSAttributeUseImpl[][] resize(XSAttributeUseImpl[][] xSAttributeUseImplArray, int n2) {
        XSAttributeUseImpl[][] xSAttributeUseImplArray2 = new XSAttributeUseImpl[n2][];
        System.arraycopy(xSAttributeUseImplArray, 0, xSAttributeUseImplArray2, 0, xSAttributeUseImplArray.length);
        return xSAttributeUseImplArray2;
    }

    private boolean ensureSTDeclCapacity(int n2) {
        if (n2 >= this.fSTDecl.length) {
            this.fSTDecl = XSDeclarationPool.resize(this.fSTDecl, this.fSTDecl.length * 2);
        } else if (this.fSTDecl[n2] != null) {
            return false;
        }
        this.fSTDecl[n2] = new XSSimpleTypeDecl[256];
        return true;
    }

    private static XSSimpleTypeDecl[][] resize(XSSimpleTypeDecl[][] xSSimpleTypeDeclArray, int n2) {
        XSSimpleTypeDecl[][] xSSimpleTypeDeclArray2 = new XSSimpleTypeDecl[n2][];
        System.arraycopy(xSSimpleTypeDeclArray, 0, xSSimpleTypeDeclArray2, 0, xSSimpleTypeDeclArray.length);
        return xSSimpleTypeDeclArray2;
    }

    private boolean ensureCTDeclCapacity(int n2) {
        if (n2 >= this.fCTDecl.length) {
            this.fCTDecl = XSDeclarationPool.resize(this.fCTDecl, this.fCTDecl.length * 2);
        } else if (this.fCTDecl[n2] != null) {
            return false;
        }
        this.fCTDecl[n2] = new XSComplexTypeDecl[256];
        return true;
    }

    private static XSComplexTypeDecl[][] resize(XSComplexTypeDecl[][] xSComplexTypeDeclArray, int n2) {
        XSComplexTypeDecl[][] xSComplexTypeDeclArray2 = new XSComplexTypeDecl[n2][];
        System.arraycopy(xSComplexTypeDeclArray, 0, xSComplexTypeDeclArray2, 0, xSComplexTypeDeclArray.length);
        return xSComplexTypeDeclArray2;
    }

    public void reset() {
        this.fElementDeclIndex = 0;
        this.fParticleDeclIndex = 0;
        this.fModelGroupIndex = 0;
        this.fSTDeclIndex = 0;
        this.fCTDeclIndex = 0;
        this.fAttrDeclIndex = 0;
        this.fAttributeUseIndex = 0;
    }
}

