/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import org.python.bouncycastle.asn1.ASN1InputStream;
import org.python.bouncycastle.asn1.LimitedInputStream;

class StreamUtil {
    private static final long MAX_MEMORY = Runtime.getRuntime().maxMemory();

    StreamUtil() {
    }

    static int findLimit(InputStream inputStream) {
        if (inputStream instanceof LimitedInputStream) {
            return ((LimitedInputStream)inputStream).getRemaining();
        }
        if (inputStream instanceof ASN1InputStream) {
            return ((ASN1InputStream)inputStream).getLimit();
        }
        if (inputStream instanceof ByteArrayInputStream) {
            return ((ByteArrayInputStream)inputStream).available();
        }
        if (inputStream instanceof FileInputStream) {
            try {
                long l2;
                FileChannel fileChannel = ((FileInputStream)inputStream).getChannel();
                long l3 = l2 = fileChannel != null ? fileChannel.size() : Integer.MAX_VALUE;
                if (l2 < Integer.MAX_VALUE) {
                    return (int)l2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (MAX_MEMORY > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)MAX_MEMORY;
    }

    static int calculateBodyLength(int n2) {
        int n3 = 1;
        if (n2 > 127) {
            int n4 = 1;
            int n5 = n2;
            while ((n5 >>>= 8) != 0) {
                ++n4;
            }
            for (int i2 = (n4 - 1) * 8; i2 >= 0; i2 -= 8) {
                ++n3;
            }
        }
        return n3;
    }

    static int calculateTagLength(int n2) throws IOException {
        int n3 = 1;
        if (n2 >= 31) {
            if (n2 < 128) {
                ++n3;
            } else {
                byte[] byArray = new byte[5];
                int n4 = byArray.length;
                byArray[--n4] = (byte)(n2 & 0x7F);
                do {
                    byArray[--n4] = (byte)((n2 >>= 7) & 0x7F | 0x80);
                } while (n2 > 127);
                n3 += byArray.length - n4;
            }
        }
        return n3;
    }
}

