/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cert.cmp;

import org.python.bouncycastle.asn1.cmp.CertConfirmContent;
import org.python.bouncycastle.asn1.cmp.CertStatus;
import org.python.bouncycastle.cert.cmp.CertificateStatus;
import org.python.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.python.bouncycastle.operator.DigestAlgorithmIdentifierFinder;

public class CertificateConfirmationContent {
    private DigestAlgorithmIdentifierFinder digestAlgFinder;
    private CertConfirmContent content;

    public CertificateConfirmationContent(CertConfirmContent certConfirmContent) {
        this(certConfirmContent, new DefaultDigestAlgorithmIdentifierFinder());
    }

    public CertificateConfirmationContent(CertConfirmContent certConfirmContent, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder) {
        this.digestAlgFinder = digestAlgorithmIdentifierFinder;
        this.content = certConfirmContent;
    }

    public CertConfirmContent toASN1Structure() {
        return this.content;
    }

    public CertificateStatus[] getStatusMessages() {
        CertStatus[] certStatusArray = this.content.toCertStatusArray();
        CertificateStatus[] certificateStatusArray = new CertificateStatus[certStatusArray.length];
        for (int i2 = 0; i2 != certificateStatusArray.length; ++i2) {
            certificateStatusArray[i2] = new CertificateStatus(this.digestAlgFinder, certStatusArray[i2]);
        }
        return certificateStatusArray;
    }
}

