/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.cert.ocsp;

import java.util.Date;
import org.python.bouncycastle.asn1.ASN1Sequence;
import org.python.bouncycastle.asn1.ocsp.ResponseData;
import org.python.bouncycastle.asn1.ocsp.SingleResponse;
import org.python.bouncycastle.asn1.x509.Extensions;
import org.python.bouncycastle.cert.ocsp.OCSPUtils;
import org.python.bouncycastle.cert.ocsp.RespID;
import org.python.bouncycastle.cert.ocsp.SingleResp;

public class RespData {
    private ResponseData data;

    public RespData(ResponseData responseData) {
        this.data = responseData;
    }

    public int getVersion() {
        return this.data.getVersion().getValue().intValue() + 1;
    }

    public RespID getResponderId() {
        return new RespID(this.data.getResponderID());
    }

    public Date getProducedAt() {
        return OCSPUtils.extractDate(this.data.getProducedAt());
    }

    public SingleResp[] getResponses() {
        ASN1Sequence aSN1Sequence = this.data.getResponses();
        SingleResp[] singleRespArray = new SingleResp[aSN1Sequence.size()];
        for (int i2 = 0; i2 != singleRespArray.length; ++i2) {
            singleRespArray[i2] = new SingleResp(SingleResponse.getInstance(aSN1Sequence.getObjectAt(i2)));
        }
        return singleRespArray;
    }

    public Extensions getResponseExtensions() {
        return this.data.getResponseExtensions();
    }
}

