/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.modes.gcm;

import org.python.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.python.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.python.bouncycastle.util.Arrays;

public class BasicGCMExponentiator
implements GCMExponentiator {
    private int[] x;

    public void init(byte[] byArray) {
        this.x = GCMUtil.asInts(byArray);
    }

    public void exponentiateX(long l2, byte[] byArray) {
        int[] nArray = GCMUtil.oneAsInts();
        if (l2 > 0L) {
            int[] nArray2 = Arrays.clone(this.x);
            do {
                if ((l2 & 1L) != 0L) {
                    GCMUtil.multiply(nArray, nArray2);
                }
                GCMUtil.multiply(nArray2, nArray2);
            } while ((l2 >>>= 1) > 0L);
        }
        GCMUtil.asBytes(nArray, byArray);
    }
}

