/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.modes.gcm;

import java.util.Vector;
import org.python.bouncycastle.crypto.modes.gcm.GCMExponentiator;
import org.python.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.python.bouncycastle.util.Arrays;

public class Tables1kGCMExponentiator
implements GCMExponentiator {
    private Vector lookupPowX2;

    public void init(byte[] byArray) {
        int[] nArray = GCMUtil.asInts(byArray);
        if (this.lookupPowX2 != null && Arrays.areEqual(nArray, (int[])this.lookupPowX2.elementAt(0))) {
            return;
        }
        this.lookupPowX2 = new Vector(8);
        this.lookupPowX2.addElement(nArray);
    }

    public void exponentiateX(long l2, byte[] byArray) {
        int[] nArray = GCMUtil.oneAsInts();
        int n2 = 0;
        while (l2 > 0L) {
            if ((l2 & 1L) != 0L) {
                this.ensureAvailable(n2);
                GCMUtil.multiply(nArray, (int[])this.lookupPowX2.elementAt(n2));
            }
            ++n2;
            l2 >>>= 1;
        }
        GCMUtil.asBytes(nArray, byArray);
    }

    private void ensureAvailable(int n2) {
        int n3 = this.lookupPowX2.size();
        if (n3 <= n2) {
            int[] nArray = (int[])this.lookupPowX2.elementAt(n3 - 1);
            do {
                nArray = Arrays.clone(nArray);
                GCMUtil.multiply(nArray, nArray);
                this.lookupPowX2.addElement(nArray);
            } while (++n3 <= n2);
        }
    }
}

