/*
 * Decompiled with CFR 0.152.
 */
package org.python.bouncycastle.crypto.paddings;

import java.security.SecureRandom;
import org.python.bouncycastle.crypto.InvalidCipherTextException;
import org.python.bouncycastle.crypto.paddings.BlockCipherPadding;

public class ISO10126d2Padding
implements BlockCipherPadding {
    SecureRandom random;

    public void init(SecureRandom secureRandom) throws IllegalArgumentException {
        this.random = secureRandom != null ? secureRandom : new SecureRandom();
    }

    public String getPaddingName() {
        return "ISO10126-2";
    }

    public int addPadding(byte[] byArray, int n2) {
        byte by2 = (byte)(byArray.length - n2);
        while (n2 < byArray.length - 1) {
            byArray[n2] = (byte)this.random.nextInt();
            ++n2;
        }
        byArray[n2] = by2;
        return by2;
    }

    public int padCount(byte[] byArray) throws InvalidCipherTextException {
        int n2 = byArray[byArray.length - 1] & 0xFF;
        if (n2 > byArray.length) {
            throw new InvalidCipherTextException("pad block corrupted");
        }
        return n2;
    }
}

