/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.python.compiler.Code;
import org.python.compiler.ProxyCodeHelpers;
import org.python.core.imp;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.ClassWriter;
import org.python.objectweb.asm.FieldVisitor;
import org.python.objectweb.asm.MethodVisitor;
import org.python.objectweb.asm.Type;

public class ClassFile {
    ClassWriter cw;
    int access;
    long mtime;
    public String name;
    String superclass;
    String sfilename;
    String[] interfaces;
    List<MethodVisitor> methodVisitors;
    List<FieldVisitor> fieldVisitors;
    List<AnnotationVisitor> annotationVisitors;

    public static String fixName(String n2) {
        if (n2.indexOf(46) == -1) {
            return n2;
        }
        char[] c2 = n2.toCharArray();
        for (int i2 = 0; i2 < c2.length; ++i2) {
            if (c2[i2] != '.') continue;
            c2[i2] = 47;
        }
        return new String(c2);
    }

    public static void visitAnnotations(AnnotationVisitor av, Map<String, Object> fields) {
        for (Map.Entry<String, Object> field : fields.entrySet()) {
            ClassFile.visitAnnotation(av, field.getKey(), field.getValue());
        }
    }

    public static void visitAnnotation(AnnotationVisitor av, String fieldName, Object fieldValue) {
        Class<?> fieldValueClass = fieldValue.getClass();
        if (fieldValue instanceof Class) {
            av.visit(fieldName, Type.getType((Class)fieldValue));
        } else if (fieldValueClass.isEnum()) {
            av.visitEnum(fieldName, ProxyCodeHelpers.mapType(fieldValueClass), fieldValue.toString());
        } else if (fieldValue instanceof List) {
            AnnotationVisitor arrayVisitor = av.visitArray(fieldName);
            List fieldList = (List)fieldValue;
            for (Object arrayField : fieldList) {
                ClassFile.visitAnnotation(arrayVisitor, null, arrayField);
            }
            arrayVisitor.visitEnd();
        } else {
            av.visit(fieldName, fieldValue);
        }
    }

    public ClassFile(String name) {
        this(name, "java/lang/Object", 33, -1L);
    }

    public ClassFile(String name, String superclass, int access) {
        this(name, superclass, access, -1L);
    }

    public ClassFile(String name, String superclass, int access, long mtime) {
        this.name = ClassFile.fixName(name);
        this.superclass = ClassFile.fixName(superclass);
        this.interfaces = new String[0];
        this.access = access;
        this.mtime = mtime;
        this.cw = new ClassWriter(2);
        this.methodVisitors = Collections.synchronizedList(new ArrayList());
        this.fieldVisitors = Collections.synchronizedList(new ArrayList());
        this.annotationVisitors = Collections.synchronizedList(new ArrayList());
    }

    public void setSource(String name) {
        this.sfilename = name;
    }

    public void addInterface(String name) throws IOException {
        String[] new_interfaces = new String[this.interfaces.length + 1];
        System.arraycopy(this.interfaces, 0, new_interfaces, 0, this.interfaces.length);
        new_interfaces[this.interfaces.length] = name;
        this.interfaces = new_interfaces;
    }

    public Code addMethod(String name, String type, int access) throws IOException {
        MethodVisitor mv = this.cw.visitMethod(access, name, type, null, null);
        Code pmv = new Code(mv, type, access);
        this.methodVisitors.add(pmv);
        return pmv;
    }

    public Code addMethod(String name, String type, int access, String[] exceptions2) throws IOException {
        MethodVisitor mv = this.cw.visitMethod(access, name, type, null, exceptions2);
        Code pmv = new Code(mv, type, access);
        this.methodVisitors.add(pmv);
        return pmv;
    }

    public Code addMethod(String name, String type, int access, String[] exceptions2, ProxyCodeHelpers.AnnotationDescr[] methodAnnotationDescrs, ProxyCodeHelpers.AnnotationDescr[][] parameterAnnotationDescrs) throws IOException {
        MethodVisitor mv = this.cw.visitMethod(access, name, type, null, exceptions2);
        for (ProxyCodeHelpers.AnnotationDescr ad : methodAnnotationDescrs) {
            AnnotationVisitor av = mv.visitAnnotation(ad.getName(), true);
            if (ad.hasFields()) {
                ClassFile.visitAnnotations(av, ad.getFields());
            }
            av.visitEnd();
        }
        for (int i2 = 0; i2 < parameterAnnotationDescrs.length; ++i2) {
            for (ProxyCodeHelpers.AnnotationDescr ad : parameterAnnotationDescrs[i2]) {
                AnnotationVisitor av = mv.visitParameterAnnotation(i2, ad.getName(), true);
                if (ad.hasFields()) {
                    ClassFile.visitAnnotations(av, ad.getFields());
                }
                av.visitEnd();
            }
        }
        Code pmv = new Code(mv, type, access);
        this.methodVisitors.add(pmv);
        return pmv;
    }

    public void addClassAnnotation(ProxyCodeHelpers.AnnotationDescr annotationDescr) {
        AnnotationVisitor av = this.cw.visitAnnotation(annotationDescr.getName(), true);
        if (annotationDescr.hasFields()) {
            ClassFile.visitAnnotations(av, annotationDescr.getFields());
        }
        this.annotationVisitors.add(av);
    }

    public void addField(String name, String type, int access) throws IOException {
        this.addField(name, type, access, null);
    }

    public void addField(String name, String type, int access, ProxyCodeHelpers.AnnotationDescr[] annotationDescrs) throws IOException {
        FieldVisitor fv = this.cw.visitField(access, name, type, null, null);
        if (annotationDescrs != null) {
            for (ProxyCodeHelpers.AnnotationDescr ad : annotationDescrs) {
                AnnotationVisitor av = fv.visitAnnotation(ad.getName(), true);
                if (ad.hasFields()) {
                    ClassFile.visitAnnotations(av, ad.getFields());
                }
                av.visitEnd();
            }
        }
        this.fieldVisitors.add(fv);
    }

    public void endFields() throws IOException {
        for (FieldVisitor fv : this.fieldVisitors) {
            fv.visitEnd();
        }
    }

    public void endMethods() throws IOException {
        for (int i2 = 0; i2 < this.methodVisitors.size(); ++i2) {
            MethodVisitor mv = this.methodVisitors.get(i2);
            mv.visitMaxs(0, 0);
            mv.visitEnd();
        }
    }

    public void endClassAnnotations() {
        for (AnnotationVisitor av : this.annotationVisitors) {
            av.visitEnd();
        }
    }

    public void write(OutputStream stream) throws IOException {
        this.cw.visit(49, 33, this.name, null, this.superclass, this.interfaces);
        AnnotationVisitor av = this.cw.visitAnnotation("Lorg/python/compiler/APIVersion;", true);
        av.visit("value", new Integer(imp.getAPIVersion()));
        av.visitEnd();
        av = this.cw.visitAnnotation("Lorg/python/compiler/MTime;", true);
        av.visit("value", new Long(this.mtime));
        av.visitEnd();
        if (this.sfilename != null) {
            av = this.cw.visitAnnotation("Lorg/python/compiler/Filename;", true);
            av.visit("value", this.sfilename);
            av.visitEnd();
            this.cw.visitSource(this.sfilename, null);
        }
        this.endClassAnnotations();
        this.endFields();
        this.endMethods();
        byte[] ba = this.cw.toByteArray();
        ByteArrayOutputStream baos = new ByteArrayOutputStream(ba.length);
        baos.write(ba, 0, ba.length);
        baos.writeTo(stream);
        baos.close();
    }
}

