/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.python.core.ArgParser;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PySlice;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.codecs;

@Untraversable
public abstract class BaseBytes
extends PySequence
implements List<PyInteger> {
    protected static final byte[] emptyStorage;
    protected byte[] storage = emptyStorage;
    protected int size = 0;
    protected int offset = 0;
    private static PyString PICKLE_ENCODING;
    private static final int SWAP_CASE = 32;
    private static final byte UPPER = 1;
    private static final byte LOWER = 2;
    private static final byte DIGIT = 4;
    private static final byte SPACE = 8;
    private static final byte ALPHA = 3;
    private static final byte ALNUM = 7;
    private static final byte[] ctype;
    protected final List<PyInteger> listDelegate = new AbstractList<PyInteger>(){

        @Override
        public PyInteger get(int index) {
            BaseBytes.this.indexCheck(index);
            return BaseBytes.this.pyget(index);
        }

        @Override
        public int size() {
            return BaseBytes.this.size;
        }

        @Override
        public PyInteger set(int index, PyInteger element) throws PyException {
            BaseBytes.this.indexCheck(index);
            PyInteger result = BaseBytes.this.pyget(index);
            BaseBytes.this.pyset(index, element);
            return result;
        }

        @Override
        public void add(int index, PyInteger element) throws PyException {
            BaseBytes.this.indexCheck(index);
            BaseBytes.this.pyinsert(index, element);
        }

        @Override
        public PyInteger remove(int index) {
            BaseBytes.this.indexCheck(index);
            PyInteger result = BaseBytes.this.pyget(index);
            BaseBytes.this.del(index);
            return result;
        }
    };

    public BaseBytes(PyType type) {
        super(type, null);
        this.delegator = new IndexDelegate();
        this.setStorage(emptyStorage);
    }

    public BaseBytes(PyType type, int size) {
        super(type, null);
        this.delegator = new IndexDelegate();
        this.newStorage(size);
    }

    public BaseBytes(PyType type, int[] value) {
        super(type, null);
        this.delegator = new IndexDelegate();
        int n2 = value.length;
        this.newStorage(n2);
        int i2 = this.offset;
        for (int j2 = 0; j2 < n2; ++j2) {
            this.storage[i2] = BaseBytes.byteCheck(value[j2]);
            ++i2;
        }
    }

    protected BaseBytes(PyType type, String value) throws PyException {
        super(type, null);
        this.delegator = new IndexDelegate();
        int n2 = value.length();
        this.newStorage(n2);
        int i2 = this.offset;
        for (int j2 = 0; j2 < n2; ++j2) {
            this.storage[i2++] = BaseBytes.byteCheck(value.charAt(j2));
        }
    }

    protected void setStorage(byte[] storage, int size, int offset) throws IllegalArgumentException {
        if (size < 0 || offset < 0 || offset + size > storage.length) {
            throw new IllegalArgumentException();
        }
        this.storage = storage;
        this.size = size;
        this.offset = offset;
    }

    protected void setStorage(byte[] storage, int size) throws IllegalArgumentException {
        if (size < 0 || size > storage.length) {
            throw new IllegalArgumentException();
        }
        this.storage = storage;
        this.size = size;
        this.offset = 0;
    }

    protected void setStorage(byte[] storage) {
        this.storage = storage;
        this.size = storage.length;
        this.offset = 0;
    }

    protected void init(PyObject arg) {
        if (arg == null) {
            this.setStorage(emptyStorage);
        } else if (arg instanceof PyString) {
            this.init((PyString)arg, (String)null, (String)null);
        } else if (arg.isIndex()) {
            this.init(arg.asIndex(Py.OverflowError));
        } else if (arg instanceof BaseBytes) {
            this.init((BaseBytes)arg);
        } else if (arg instanceof BufferProtocol) {
            this.init((BufferProtocol)((Object)arg));
        } else {
            this.init(arg.asIterable());
        }
    }

    protected void init(PyString arg, PyObject encoding, PyObject errors) {
        String enc = encoding == null ? null : encoding.asString();
        String err = errors == null ? null : errors.asString();
        this.init(arg, enc, err);
    }

    protected void init(PyString arg, String encoding, String errors) {
        String encoded = BaseBytes.encode(arg, encoding, errors);
        this.newStorage(encoded.length());
        this.setBytes(0, encoded);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static String encode(PyString arg, String encoding, String errors) throws PyException {
        if (arg instanceof PyUnicode) {
            if (encoding == null) throw Py.TypeError("unicode argument without an encoding");
            return codecs.encode(arg, encoding, errors);
        }
        if (encoding == null) return arg.getString();
        return codecs.encode(arg, encoding, errors);
    }

    protected void setBytes(int start, String value) throws PyException {
        int n2 = value.length();
        int io = this.offset + start;
        for (int j2 = 0; j2 < n2; ++j2) {
            this.storage[io++] = BaseBytes.byteCheck(value.charAt(j2));
        }
    }

    protected void setBytes(int start, int step, String value) throws PyException {
        int n2 = value.length();
        int io = this.offset + start;
        for (int j2 = 0; j2 < n2; ++j2) {
            this.storage[io] = BaseBytes.byteCheck(value.charAt(j2));
            io += step;
        }
    }

    protected void init(int n2) {
        if (n2 < 0) {
            throw Py.ValueError("negative count");
        }
        this.newStorage(n2);
    }

    protected void init(BufferProtocol value) throws PyException {
        try (PyBuffer view = value.getBuffer(284);){
            this.newStorage(view.getLen());
            view.copyTo(this.storage, this.offset);
        }
    }

    protected void init(BaseBytes source) {
        this.newStorage(source.size);
        System.arraycopy(source.storage, source.offset, this.storage, this.offset, this.size);
    }

    protected void init(Iterable<? extends PyObject> iter2) {
        FragmentList fragList = new FragmentList();
        fragList.loadFrom(iter2);
        if (fragList.totalCount > 0) {
            if (fragList.size() == 1) {
                Fragment frag = (Fragment)fragList.getFirst();
                this.setStorage(frag.storage, frag.count);
            } else {
                this.newStorage(fragList.totalCount);
                fragList.emptyInto(this.storage, this.offset);
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    protected final void indexCheck(int index) throws PyException {
        if (index < 0 || index >= this.size) {
            throw Py.IndexError(this.getType().fastGetName() + " index out of range");
        }
    }

    protected void newStorage(int needed) {
        if (needed > 0) {
            try {
                this.setStorage(new byte[needed]);
            }
            catch (OutOfMemoryError e2) {
                throw Py.MemoryError(e2.getMessage());
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    protected static final byte byteCheck(int value) throws PyException {
        if (value < 0 || value > 255) {
            throw Py.ValueError("byte must be in range(0, 256)");
        }
        return (byte)value;
    }

    protected static final byte byteCheck(PyInteger value) throws PyException {
        return BaseBytes.byteCheck(value.asInt());
    }

    protected static final byte byteCheck(PyObject value) throws PyException {
        if (value.isIndex()) {
            return BaseBytes.byteCheck(value.asIndex());
        }
        if (value.getType() == PyString.TYPE) {
            String strValue = ((PyString)value).getString();
            if (strValue.length() != 1) {
                throw Py.ValueError("string must be of size 1");
            }
            return BaseBytes.byteCheck(strValue.charAt(0));
        }
        throw Py.TypeError("an integer or string of size 1 is required");
    }

    protected static PyBuffer getView(PyObject b2) {
        if (b2 == null) {
            return null;
        }
        if (b2 instanceof PyUnicode) {
            return null;
        }
        if (b2 instanceof BufferProtocol) {
            return ((BufferProtocol)((Object)b2)).getBuffer(284);
        }
        return null;
    }

    protected static PyBuffer getViewOrError(PyObject b2) {
        PyBuffer buffer = BaseBytes.getView(b2);
        if (buffer != null) {
            return buffer;
        }
        String fmt = "Type %s doesn't support the buffer API";
        throw Py.TypeError(String.format(fmt, b2.getType().fastGetName()));
    }

    @Override
    protected PyInteger pyget(int index) {
        return new PyInteger(this.intAt(index));
    }

    @Override
    protected abstract BaseBytes getslice(int var1, int var2, int var3);

    @Override
    protected abstract BaseBytes repeat(int var1);

    public void pyinsert(int index, PyObject element) {
        this.pyset(index, element);
    }

    protected BaseBytes getslice(int start, int stop2) {
        return this.getslice(start, stop2, 1);
    }

    @Override
    public int __len__() {
        return this.size;
    }

    private static int compare(BaseBytes a2, PyBuffer b2) {
        int ap = a2.offset;
        int aEnd = ap + a2.size;
        int bp = 0;
        int bEnd = b2.getLen();
        while (ap < aEnd) {
            int bVal;
            int aVal;
            int diff;
            if (bp >= bEnd) {
                return 1;
            }
            if ((diff = (aVal = 0xFF & a2.storage[ap++]) - (bVal = b2.intAt(bp++))) == 0) continue;
            return diff < 0 ? -1 : 1;
        }
        if (bp < bEnd) {
            return -1;
        }
        return 0;
    }

    private synchronized int basebytes_cmp(PyObject b2) {
        if (this == b2) {
            return 0;
        }
        try (PyBuffer bv = BaseBytes.getView(b2);){
            if (bv == null) {
                int n2 = -2;
                return n2;
            }
            int n3 = BaseBytes.compare(this, bv);
            return n3;
        }
    }

    private synchronized int basebytes_cmpeq(PyObject b2) {
        if (this == b2) {
            return 0;
        }
        try (PyBuffer bv = BaseBytes.getView(b2);){
            if (bv == null) {
                int n2 = -2;
                return n2;
            }
            if (bv.getLen() != this.size) {
                int n3 = 1;
                return n3;
            }
            int n4 = BaseBytes.compare(this, bv);
            return n4;
        }
    }

    final PyObject basebytes___eq__(PyObject other) {
        int cmp = this.basebytes_cmpeq(other);
        if (cmp == 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject basebytes___ne__(PyObject other) {
        int cmp = this.basebytes_cmpeq(other);
        if (cmp == 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject basebytes___lt__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp >= 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject basebytes___le__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp > 0) {
            return Py.False;
        }
        if (cmp > -2) {
            return Py.True;
        }
        return null;
    }

    final PyObject basebytes___ge__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp >= 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    final PyObject basebytes___gt__(PyObject other) {
        int cmp = this.basebytes_cmp(other);
        if (cmp > 0) {
            return Py.True;
        }
        if (cmp > -2) {
            return Py.False;
        }
        return null;
    }

    protected final synchronized boolean basebytes___contains__(PyObject target) {
        if (target.isIndex()) {
            byte b2 = BaseBytes.byteCheck(target.asIndex());
            return this.index(b2) >= 0;
        }
        try (PyBuffer targetView = BaseBytes.getViewOrError(target);){
            Finder finder = new Finder(targetView);
            finder.setText(this);
            boolean bl = finder.nextIndex() >= 0;
            return bl;
        }
    }

    protected final synchronized boolean basebytes_starts_or_endswith(PyObject target, PyObject ostart, PyObject oend, boolean endswith) {
        int[] index = this.indicesEx(ostart, oend);
        if (target instanceof PyTuple) {
            for (PyObject t2 : ((PyTuple)target).getList()) {
                if (!this.match(t2, index[0], index[3], endswith)) continue;
                return true;
            }
            return false;
        }
        return this.match(target, index[0], index[3], endswith);
    }

    private boolean match(PyObject target, int pos, int n2, boolean endswith) {
        try (PyBuffer vt = BaseBytes.getViewOrError(target);){
            int j2 = 0;
            int len = vt.getLen();
            if (!endswith) {
                if (len > n2) {
                    boolean bl = false;
                    return bl;
                }
            } else {
                j2 = n2 - len;
                if (j2 < 0) {
                    boolean bl = false;
                    return bl;
                }
            }
            j2 += this.offset + pos;
            for (int i2 = 0; i2 < len; ++i2) {
                if (this.storage[j2++] == vt.byteAt(i2)) continue;
                boolean x2 = false;
                return x2;
            }
            boolean bl = true;
            return bl;
        }
    }

    private int[] indicesEx(PyObject ostart, PyObject oend) {
        PySlice s2 = new PySlice(ostart, oend, null);
        return s2.indicesEx(this.size);
    }

    @Override
    public synchronized String asString() {
        char[] buf = new char[this.size];
        int j2 = this.offset + this.size;
        int i2 = this.size;
        while (--i2 >= 0) {
            buf[i2] = (char)(0xFF & this.storage[--j2]);
        }
        return new String(buf);
    }

    public PyObject decode() {
        return this.decode(null, null);
    }

    public PyObject decode(String encoding) {
        return this.decode(encoding, null);
    }

    public PyObject decode(String encoding, String errors) {
        PyString this_ = new PyString(this.asString());
        return codecs.decode(this_, encoding, errors);
    }

    protected final PyObject basebytes_decode(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("decode", args, keywords, "encoding", "errors");
        String encoding = ap.getString(0, null);
        String errors = ap.getString(1, null);
        return this.decode(encoding, errors);
    }

    static PyException ConcatenationTypeError(PyType type, PyType toType) {
        String fmt = "can't concat %s to %s";
        return Py.TypeError(String.format(fmt, type.fastGetName(), toType.fastGetName()));
    }

    @Override
    public PyObject __reduce__() {
        return this.basebytes___reduce__();
    }

    final PyTuple basebytes___reduce__() {
        PyUnicode encoded = new PyUnicode(this.asString());
        PyTuple args = new PyTuple(encoded, BaseBytes.getPickleEncoding());
        PyObject dict = this.__findattr__("__dict__");
        return new PyTuple(this.getType(), args, dict != null ? dict : Py.None);
    }

    private static final PyString getPickleEncoding() {
        if (PICKLE_ENCODING == null) {
            PICKLE_ENCODING = new PyString("latin-1");
        }
        return PICKLE_ENCODING;
    }

    protected int index(byte b2) {
        int limit = this.offset + this.size;
        for (int p2 = this.offset; p2 < limit; ++p2) {
            if (this.storage[p2] != b2) continue;
            return p2 - this.offset;
        }
        return -1;
    }

    protected static final int checkForEmptySeparator(PyBuffer separator) throws PyException {
        int n2 = separator.getLen();
        if (n2 == 0) {
            throw Py.ValueError("empty separator");
        }
        return n2;
    }

    protected int lstripIndex(ByteSet byteSet) {
        int limit = this.offset + this.size;
        for (int left = this.offset; left < limit; ++left) {
            if (byteSet.contains(this.storage[left])) continue;
            return left - this.offset;
        }
        return this.size;
    }

    protected int lstripIndex() {
        int limit = this.offset + this.size;
        for (int left = this.offset; left < limit; ++left) {
            if (BaseBytes.isspace(this.storage[left])) continue;
            return left - this.offset;
        }
        return this.size;
    }

    protected int rstripIndex(ByteSet byteSet) {
        for (int right = this.offset + this.size; right > this.offset; --right) {
            if (byteSet.contains(this.storage[right - 1])) continue;
            return right - this.offset;
        }
        return 0;
    }

    protected int rstripIndex() {
        for (int right = this.offset + this.size; right > this.offset; --right) {
            if (BaseBytes.isspace(this.storage[right - 1])) continue;
            return right - this.offset;
        }
        return this.size;
    }

    final int basebytes_count(PyObject sub, PyObject ostart, PyObject oend) {
        try (PyBuffer vsub = BaseBytes.getViewOrError(sub);){
            Finder finder = new Finder(vsub);
            int[] index = this.indicesEx(ostart, oend);
            int n2 = finder.count(this.storage, this.offset + index[0], index[3]);
            return n2;
        }
    }

    final int basebytes_find(PyObject sub, PyObject ostart, PyObject oend) {
        try (PyBuffer vsub = BaseBytes.getViewOrError(sub);){
            Finder finder = new Finder(vsub);
            int n2 = this.find(finder, ostart, oend);
            return n2;
        }
    }

    static void basebytes_fromhex(BaseBytes result, String hex) throws PyException {
        int hexlen = hex.length();
        result.newStorage(hexlen / 2);
        String fmt = "non-hexadecimal number found in fromhex() arg at position %d";
        byte[] r2 = result.storage;
        int p2 = result.offset;
        int i2 = 0;
        while (i2 < hexlen) {
            char c2;
            if ((c2 = hex.charAt(i2++)) == ' ') continue;
            try {
                int value = BaseBytes.hexDigit(c2);
                c2 = hex.charAt(i2++);
                value = (value << 4) + BaseBytes.hexDigit(c2);
                r2[p2++] = (byte)value;
            }
            catch (IllegalArgumentException e2) {
                throw Py.ValueError(String.format(fmt, i2 - 1));
            }
            catch (IndexOutOfBoundsException e3) {
                throw Py.ValueError(String.format(fmt, i2 - 2));
            }
        }
        result.size = p2 - result.offset;
    }

    private static int hexDigit(char c2) throws IllegalArgumentException {
        int result = c2 - 48;
        if (result >= 0) {
            if (result < 10) {
                return result;
            }
            result = (c2 & 0xDF) - 65;
            if (result >= 0 && result < 6) {
                return result + 10;
            }
        }
        throw new IllegalArgumentException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    final synchronized PyByteArray basebytes_join(Iterable<? extends PyObject> iter2) {
        LinkedList<PyBuffer> iterList = new LinkedList<PyBuffer>();
        long mysize = this.size;
        long totalSize = 0L;
        boolean first = true;
        try {
            for (PyObject pyObject : iter2) {
                PyBuffer v2 = BaseBytes.getView(pyObject);
                if (v2 == null) {
                    String fmt = "can only join an iterable of bytes (item %d has type '%.80s')";
                    throw Py.TypeError(String.format(fmt, iterList.size(), pyObject.getType().fastGetName()));
                }
                iterList.add(v2);
                totalSize += (long)v2.getLen();
                if (!first) {
                    totalSize += mysize;
                } else {
                    first = false;
                }
                if (totalSize <= Integer.MAX_VALUE) continue;
                throw Py.OverflowError("join() result would be too long");
            }
            PyByteArray result = new PyByteArray((int)totalSize);
            int n2 = result.offset;
            first = true;
            for (PyBuffer v3 : iterList) {
                void var9_9;
                if (!first) {
                    System.arraycopy(this.storage, this.offset, result.storage, (int)var9_9, this.size);
                    var9_9 += this.size;
                } else {
                    first = false;
                }
                v3.copyTo(result.storage, (int)var9_9);
                var9_9 += v3.getLen();
            }
            PyByteArray pyByteArray = result;
            return pyByteArray;
        }
        finally {
            for (PyBuffer v4 : iterList) {
                v4.release();
            }
        }
    }

    public PyTuple partition(PyObject sep) {
        return this.basebytes_partition(sep);
    }

    final synchronized PyTuple basebytes_partition(PyObject sep) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            int n2 = BaseBytes.checkForEmptySeparator(separator);
            Finder finder = new Finder(separator);
            finder.setText(this);
            int p2 = finder.nextIndex() - this.offset;
            if (p2 >= 0) {
                PyTuple pyTuple = this.partition(p2, p2 + n2);
                return pyTuple;
            }
            PyTuple pyTuple = this.partition(this.size, this.size);
            return pyTuple;
        }
    }

    private PyTuple partition(int p2, int q2) {
        BaseBytes head = this.getslice(0, p2);
        BaseBytes sep = this.getslice(p2, q2);
        BaseBytes tail = this.getslice(q2, this.size);
        return new PyTuple(head, sep, tail);
    }

    final int basebytes_rfind(PyObject sub, PyObject ostart, PyObject oend) {
        try (PyBuffer vsub = BaseBytes.getViewOrError(sub);){
            ReverseFinder finder = new ReverseFinder(vsub);
            int n2 = this.find(finder, ostart, oend);
            return n2;
        }
    }

    private final int find(Finder finder, PyObject ostart, PyObject oend) {
        int[] index = this.indicesEx(ostart, oend);
        finder.setText(this.storage, this.offset + index[0], index[3]);
        int result = finder.nextIndex();
        return result < 0 ? -1 : result - this.offset;
    }

    /*
     * Exception decompiling
     */
    final synchronized PyByteArray basebytes_replace(PyObject oldB, PyObject newB, int maxcount) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 65[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private PyByteArray replace_substring(PyBuffer from, PyBuffer to, int maxcount) {
        int q2;
        byte[] r2;
        Finder finder = new Finder(from);
        int count2 = finder.count(this.storage, this.offset, this.size, maxcount);
        if (count2 == 0) {
            return new PyByteArray(this);
        }
        int from_len = from.getLen();
        int to_len = to.getLen();
        long result_len = this.size + count2 * (to_len - from_len);
        try {
            r2 = new byte[(int)result_len];
        }
        catch (OutOfMemoryError e2) {
            throw Py.OverflowError("replace bytes is too long");
        }
        int p2 = this.offset;
        int rp = 0;
        finder.setText(this.storage, p2, this.size);
        while (count2-- > 0 && (q2 = finder.nextIndex()) >= 0) {
            int length = q2 - p2;
            if (length > 0) {
                System.arraycopy(this.storage, p2, r2, rp, length);
                rp += length;
            }
            p2 = q2 + from_len;
            to.copyTo(r2, rp);
            rp += to_len;
        }
        int length = this.size + this.offset - p2;
        if (length > 0) {
            System.arraycopy(this.storage, p2, r2, rp, length);
            rp += length;
        }
        return new PyByteArray(r2);
    }

    private PyByteArray replace_interleave(PyBuffer to, int maxcount) {
        byte[] r2;
        int count2 = this.size + 1;
        if (maxcount < count2) {
            count2 = maxcount;
        }
        int to_len = to.getLen();
        long result_len = (long)count2 * (long)to_len + (long)this.size;
        try {
            r2 = new byte[(int)result_len];
        }
        catch (OutOfMemoryError e2) {
            throw Py.OverflowError("replace bytes is too long");
        }
        int p2 = this.offset;
        int rp = 0;
        to.copyTo(r2, rp);
        rp += to_len;
        for (int i2 = 1; i2 < count2; ++i2) {
            r2[rp++] = this.storage[p2++];
            to.copyTo(r2, rp);
            rp += to_len;
        }
        int length = this.size + this.offset - p2;
        if (length > 0) {
            System.arraycopy(this.storage, p2, r2, rp, length);
            rp += length;
        }
        return new PyByteArray(r2);
    }

    private PyByteArray replace_delete_substring(PyBuffer from, int maxcount) {
        int q2;
        byte[] r2;
        Finder finder = new Finder(from);
        int count2 = finder.count(this.storage, this.offset, this.size, maxcount);
        if (count2 == 0) {
            return new PyByteArray(this);
        }
        int from_len = from.getLen();
        long result_len = this.size - count2 * from_len;
        assert (result_len >= 0L);
        try {
            r2 = new byte[(int)result_len];
        }
        catch (OutOfMemoryError e2) {
            throw Py.OverflowError("replace bytes is too long");
        }
        int p2 = this.offset;
        int rp = 0;
        finder.setText(this.storage, this.offset, this.size);
        while (count2-- > 0 && (q2 = finder.nextIndex()) >= 0) {
            int length = q2 - p2;
            if (length > 0) {
                System.arraycopy(this.storage, p2, r2, rp, length);
                rp += length;
            }
            p2 = q2 + from_len;
        }
        int length = this.size + this.offset - p2;
        if (length > 0) {
            System.arraycopy(this.storage, p2, r2, rp, length);
            rp += length;
        }
        return new PyByteArray(r2);
    }

    private PyByteArray replace_substring_in_place(PyBuffer from, PyBuffer to, int maxcount) {
        int q2;
        byte[] r2;
        Finder finder = new Finder(from);
        int count2 = maxcount;
        try {
            r2 = new byte[this.size];
        }
        catch (OutOfMemoryError e2) {
            throw Py.OverflowError("replace bytes is too long");
        }
        System.arraycopy(this.storage, this.offset, r2, 0, this.size);
        finder.setText(r2);
        while (count2-- > 0 && (q2 = finder.nextIndex()) >= 0) {
            to.copyTo(r2, q2);
        }
        return new PyByteArray(r2);
    }

    public PyTuple rpartition(PyObject sep) {
        return this.basebytes_rpartition(sep);
    }

    final synchronized PyTuple basebytes_rpartition(PyObject sep) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            int n2 = BaseBytes.checkForEmptySeparator(separator);
            ReverseFinder finder = new ReverseFinder(separator);
            finder.setText(this);
            int p2 = ((Finder)finder).nextIndex() - this.offset;
            if (p2 >= 0) {
                PyTuple pyTuple = this.partition(p2, p2 + n2);
                return pyTuple;
            }
            PyTuple pyTuple = this.partition(0, 0);
            return pyTuple;
        }
    }

    public PyList rsplit() {
        return this.basebytes_rsplit_whitespace(-1);
    }

    public PyList rsplit(PyObject sep) {
        return this.basebytes_rsplit(sep, -1);
    }

    public PyList rsplit(PyObject sep, int maxsplit) {
        return this.basebytes_rsplit(sep, maxsplit);
    }

    final PyList basebytes_rsplit(PyObject sep, int maxsplit) {
        if (sep == null || sep == Py.None) {
            return this.basebytes_rsplit_whitespace(maxsplit);
        }
        return this.basebytes_rsplit_explicit(sep, maxsplit);
    }

    final synchronized PyList basebytes_rsplit_explicit(PyObject sep, int maxsplit) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            int n2 = BaseBytes.checkForEmptySeparator(separator);
            PyList result = new PyList();
            ReverseFinder finder = new ReverseFinder(separator);
            finder.setText(this);
            int q2 = this.offset + this.size;
            while (q2 > this.offset && maxsplit-- != 0) {
                int r2 = q2;
                q2 = ((Finder)finder).nextIndex();
                int p2 = q2 < 0 ? this.offset : q2 + n2;
                BaseBytes word = this.getslice(p2 - this.offset, r2 - this.offset);
                result.add(0, word);
            }
            if (q2 >= this.offset) {
                BaseBytes word = this.getslice(0, q2 - this.offset);
                result.add(0, word);
            }
            PyList pyList = result;
            return pyList;
        }
    }

    final synchronized PyList basebytes_rsplit_whitespace(int maxsplit) {
        BaseBytes word;
        int q2;
        PyList result = new PyList();
        for (q2 = this.offset + this.size; q2 > this.offset && BaseBytes.isspace(this.storage[q2 - 1]); --q2) {
        }
        while (q2 > this.offset && maxsplit-- != 0) {
            int p2;
            for (p2 = q2; p2 > this.offset && !BaseBytes.isspace(this.storage[p2 - 1]); --p2) {
            }
            word = this.getslice(p2 - this.offset, q2 - this.offset);
            result.add(0, word);
            for (q2 = p2; q2 > this.offset && BaseBytes.isspace(this.storage[q2 - 1]); --q2) {
            }
        }
        if (q2 > this.offset) {
            word = this.getslice(0, q2 - this.offset);
            result.add(0, word);
        }
        return result;
    }

    public PyList split() {
        return this.basebytes_split_whitespace(-1);
    }

    public PyList split(PyObject sep) {
        return this.basebytes_split(sep, -1);
    }

    public PyList split(PyObject sep, int maxsplit) {
        return this.basebytes_split(sep, maxsplit);
    }

    final PyList basebytes_split(PyObject sep, int maxsplit) {
        if (sep == null || sep == Py.None) {
            return this.basebytes_split_whitespace(maxsplit);
        }
        return this.basebytes_split_explicit(sep, maxsplit);
    }

    final synchronized PyList basebytes_split_explicit(PyObject sep, int maxsplit) {
        try (PyBuffer separator = BaseBytes.getViewOrError(sep);){
            BaseBytes.checkForEmptySeparator(separator);
            PyList result = new PyList();
            Finder finder = new Finder(separator);
            finder.setText(this);
            int p2 = finder.currIndex();
            int q2 = finder.nextIndex();
            while (q2 >= 0 && maxsplit-- != 0) {
                result.append(this.getslice(p2 - this.offset, q2 - this.offset));
                p2 = finder.currIndex();
                q2 = finder.nextIndex();
            }
            result.append(this.getslice(p2 - this.offset, this.size));
            PyList pyList = result;
            return pyList;
        }
    }

    final synchronized PyList basebytes_split_whitespace(int maxsplit) {
        int p2;
        PyList result = new PyList();
        int limit = this.offset + this.size;
        for (p2 = this.offset; p2 < limit && BaseBytes.isspace(this.storage[p2]); ++p2) {
        }
        while (p2 < limit && maxsplit-- != 0) {
            int q2;
            for (q2 = p2; q2 < limit && !BaseBytes.isspace(this.storage[q2]); ++q2) {
            }
            result.append(this.getslice(p2 - this.offset, q2 - this.offset));
            for (p2 = q2; p2 < limit && BaseBytes.isspace(this.storage[p2]); ++p2) {
            }
        }
        if (p2 < limit) {
            result.append(this.getslice(p2 - this.offset, this.size));
        }
        return result;
    }

    public PyList splitlines() {
        return this.basebytes_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.basebytes_splitlines(keepends);
    }

    protected final synchronized PyList basebytes_splitlines(boolean keepends) {
        PyList list = new PyList();
        int limit = this.offset + this.size;
        int p2 = this.offset;
        while (p2 < limit) {
            int q2;
            int lenEOL = 0;
            for (q2 = p2; q2 < limit; ++q2) {
                byte b2 = this.storage[q2];
                if (b2 == 13) {
                    lenEOL = this.storage[q2 + 1] == 10 ? 2 : 1;
                    break;
                }
                if (b2 != 10) continue;
                lenEOL = 1;
                break;
            }
            if (keepends) {
                list.append(this.getslice(p2 - this.offset, q2 + lenEOL - this.offset));
            } else {
                list.append(this.getslice(p2 - this.offset, q2 - this.offset));
            }
            p2 = q2 + lenEOL;
        }
        return list;
    }

    protected static byte fillByteCheck(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.length() == 1) {
            return (byte)fillchar.charAt(0);
        }
        throw Py.TypeError(function + "() argument 2 must be char, not str");
    }

    private BaseBytes padHelper(byte pad, int left, int right) {
        if (left + right <= 0) {
            return this.getslice(0, this.size);
        }
        Builder builder = this.getBuilder(left + this.size + right);
        builder.repeat(pad, left);
        builder.append(this);
        builder.repeat(pad, right);
        return builder.getResult();
    }

    final BaseBytes basebytes_center(int width, String fillchar) {
        byte pad = BaseBytes.fillByteCheck("center", fillchar);
        int fill = width - this.size;
        int left = fill / 2 + (fill & width & 1);
        return this.padHelper(pad, left, fill - left);
    }

    final BaseBytes basebytes_ljust(int width, String fillchar) {
        byte pad = BaseBytes.fillByteCheck("rjust", fillchar);
        int fill = width - this.size;
        return this.padHelper(pad, 0, fill);
    }

    final BaseBytes basebytes_rjust(int width, String fillchar) {
        byte pad = BaseBytes.fillByteCheck("rjust", fillchar);
        int fill = width - this.size;
        return this.padHelper(pad, fill, 0);
    }

    final BaseBytes basebytes_expandtabs(int tabsize) {
        int estimatedSize = this.size + this.size / 8;
        Builder builder = this.getBuilder(estimatedSize);
        int carriagePosition = 0;
        int limit = this.offset + this.size;
        for (int i2 = this.offset; i2 < limit; ++i2) {
            byte c2 = this.storage[i2];
            if (c2 == 9) {
                int spaces = tabsize - carriagePosition % tabsize;
                builder.repeat((byte)32, spaces);
                carriagePosition += spaces;
                continue;
            }
            builder.append(c2);
            carriagePosition = c2 == 10 || c2 == 13 ? 0 : carriagePosition + 1;
        }
        return builder.getResult();
    }

    final BaseBytes basebytes_zfill(int width) {
        int fill = width - this.size;
        Builder builder = this.getBuilder(fill > 0 ? width : this.size);
        if (fill <= 0) {
            builder.append(this);
        } else {
            byte sign;
            int p2 = 0;
            if (this.size > 0 && ((sign = this.storage[this.offset]) == 45 || sign == 43)) {
                builder.append(sign);
                p2 = 1;
            }
            builder.repeat((byte)48, fill);
            if (this.size > p2) {
                builder.append(this, p2, this.size);
            }
        }
        return builder.getResult();
    }

    static final boolean isupper(byte b2) {
        return (ctype[128 + b2] & 1) != 0;
    }

    static final boolean islower(byte b2) {
        return (ctype[128 + b2] & 2) != 0;
    }

    static final boolean isalpha(byte b2) {
        return (ctype[128 + b2] & 3) != 0;
    }

    static final boolean isdigit(byte b2) {
        return (ctype[128 + b2] & 4) != 0;
    }

    static final boolean isalnum(byte b2) {
        return (ctype[128 + b2] & 7) != 0;
    }

    static final boolean isspace(byte b2) {
        return (ctype[128 + b2] & 8) != 0;
    }

    public boolean isalnum() {
        return this.basebytes_isalnum();
    }

    final boolean basebytes_isalnum() {
        if (this.size == 1) {
            return BaseBytes.isalnum(this.storage[this.offset]);
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (BaseBytes.isalnum(this.storage[this.offset + i2])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean isalpha() {
        return this.basebytes_isalpha();
    }

    final boolean basebytes_isalpha() {
        if (this.size == 1) {
            return BaseBytes.isalpha(this.storage[this.offset]);
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (BaseBytes.isalpha(this.storage[this.offset + i2])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean isdigit() {
        return this.basebytes_isdigit();
    }

    final boolean basebytes_isdigit() {
        if (this.size == 1) {
            return BaseBytes.isdigit(this.storage[this.offset]);
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (BaseBytes.isdigit(this.storage[this.offset + i2])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean islower() {
        return this.basebytes_islower();
    }

    final boolean basebytes_islower() {
        int i2;
        if (this.size == 1) {
            return BaseBytes.islower(this.storage[this.offset]);
        }
        byte c2 = 0;
        for (i2 = 0; i2 < this.size && !BaseBytes.isalpha(c2 = this.storage[this.offset + i2]); ++i2) {
        }
        if (i2 == this.size || BaseBytes.isupper(c2)) {
            return false;
        }
        ++i2;
        while (i2 < this.size) {
            if (BaseBytes.isupper(this.storage[this.offset + i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public boolean isspace() {
        return this.basebytes_isspace();
    }

    final boolean basebytes_isspace() {
        if (this.size == 1) {
            return BaseBytes.isspace(this.storage[this.offset]);
        }
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (BaseBytes.isspace(this.storage[this.offset + i2])) continue;
            return false;
        }
        return this.size > 0;
    }

    public boolean istitle() {
        return this.basebytes_istitle();
    }

    final boolean basebytes_istitle() {
        int state = 0;
        for (int i2 = 0; i2 < this.size; ++i2) {
            byte c2 = this.storage[this.offset + i2];
            if (BaseBytes.isupper(c2)) {
                if (state == 2) {
                    return false;
                }
                state = 2;
                continue;
            }
            if (BaseBytes.islower(c2)) {
                if (state == 2) continue;
                return false;
            }
            if (state != 2) continue;
            state = 1;
        }
        return state != 0;
    }

    public boolean isupper() {
        return this.basebytes_isupper();
    }

    final boolean basebytes_isupper() {
        int i2;
        if (this.size == 1) {
            return BaseBytes.isupper(this.storage[this.offset]);
        }
        byte c2 = 0;
        for (i2 = 0; i2 < this.size && !BaseBytes.isalpha(c2 = this.storage[this.offset + i2]); ++i2) {
        }
        if (i2 == this.size || BaseBytes.islower(c2)) {
            return false;
        }
        ++i2;
        while (i2 < this.size) {
            if (BaseBytes.islower(this.storage[this.offset + i2])) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    public BaseBytes capitalize() {
        return this.basebytes_capitalize();
    }

    final BaseBytes basebytes_capitalize() {
        Builder builder = this.getBuilder(this.size);
        if (this.size > 0) {
            byte c2 = this.storage[this.offset];
            if (BaseBytes.islower(c2)) {
                c2 = (byte)(c2 ^ 0x20);
            }
            builder.append(c2);
            for (int i2 = 1; i2 < this.size; ++i2) {
                c2 = this.storage[this.offset + i2];
                if (BaseBytes.isupper(c2)) {
                    c2 = (byte)(c2 ^ 0x20);
                }
                builder.append(c2);
            }
        }
        return builder.getResult();
    }

    public BaseBytes lower() {
        return this.basebytes_lower();
    }

    final BaseBytes basebytes_lower() {
        Builder builder = this.getBuilder(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            byte c2 = this.storage[this.offset + i2];
            if (BaseBytes.isupper(c2)) {
                c2 = (byte)(c2 ^ 0x20);
            }
            builder.append(c2);
        }
        return builder.getResult();
    }

    public BaseBytes swapcase() {
        return this.basebytes_swapcase();
    }

    final BaseBytes basebytes_swapcase() {
        Builder builder = this.getBuilder(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            byte c2 = this.storage[this.offset + i2];
            if (BaseBytes.isalpha(c2)) {
                c2 = (byte)(c2 ^ 0x20);
            }
            builder.append(c2);
        }
        return builder.getResult();
    }

    public BaseBytes title() {
        return this.basebytes_title();
    }

    final BaseBytes basebytes_title() {
        Builder builder = this.getBuilder(this.size);
        boolean inWord = false;
        for (int i2 = 0; i2 < this.size; ++i2) {
            byte c2 = this.storage[this.offset + i2];
            if (!inWord) {
                if (BaseBytes.islower(c2)) {
                    c2 = (byte)(c2 ^ 0x20);
                    inWord = true;
                } else if (BaseBytes.isupper(c2)) {
                    inWord = true;
                }
            } else if (BaseBytes.isupper(c2)) {
                c2 = (byte)(c2 ^ 0x20);
            } else if (!BaseBytes.islower(c2)) {
                inWord = false;
            }
            builder.append(c2);
        }
        return builder.getResult();
    }

    public BaseBytes upper() {
        return this.basebytes_upper();
    }

    final BaseBytes basebytes_upper() {
        Builder builder = this.getBuilder(this.size);
        for (int i2 = 0; i2 < this.size; ++i2) {
            byte c2 = this.storage[this.offset + i2];
            if (BaseBytes.islower(c2)) {
                c2 = (byte)(c2 ^ 0x20);
            }
            builder.append(c2);
        }
        return builder.getResult();
    }

    private final synchronized byte byteAt(int index) {
        return this.storage[index + this.offset];
    }

    public synchronized int intAt(int index) throws PyException {
        this.indexCheck(index);
        return 0xFF & this.byteAt(index);
    }

    protected synchronized byte[] repeatImpl(int count2) {
        byte[] dst;
        if (count2 <= 0) {
            return emptyStorage;
        }
        long newSize = (long)count2 * (long)this.size;
        try {
            dst = new byte[(int)newSize];
        }
        catch (OutOfMemoryError e2) {
            throw Py.MemoryError(e2.getMessage());
        }
        int i2 = 0;
        int p2 = 0;
        while (i2 < count2) {
            System.arraycopy(this.storage, this.offset, dst, p2, this.size);
            ++i2;
            p2 += this.size;
        }
        return dst;
    }

    private static final void appendHexEscape(StringBuilder buf, int c2) {
        buf.append("\\x").append(Character.forDigit((c2 & 0xF0) >> 4, 16)).append(Character.forDigit(c2 & 0xF, 16));
    }

    final synchronized String basebytes_repr(String before, String after) {
        if (before == null) {
            before = "";
        }
        if (after == null) {
            after = "";
        }
        int guess = this.size + (this.size >> 2) + before.length() + after.length() + 10;
        StringBuilder buf = new StringBuilder(guess);
        buf.append(before).append('\'');
        int jmax = this.offset + this.size;
        for (int j2 = this.offset; j2 < jmax; ++j2) {
            int c2 = 0xFF & this.storage[j2];
            if (c2 >= 127) {
                BaseBytes.appendHexEscape(buf, c2);
                continue;
            }
            if (c2 >= 32) {
                if (c2 == 92 || c2 == 39) {
                    buf.append('\\');
                }
                buf.append((char)c2);
                continue;
            }
            if (c2 == 9) {
                buf.append("\\t");
                continue;
            }
            if (c2 == 10) {
                buf.append("\\n");
                continue;
            }
            if (c2 == 13) {
                buf.append("\\r");
                continue;
            }
            BaseBytes.appendHexEscape(buf, c2);
        }
        buf.append('\'').append(after);
        return buf.toString();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public boolean contains(Object o2) {
        return this.listDelegate.contains(o2);
    }

    @Override
    public Iterator<PyInteger> iterator() {
        return this.listDelegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.listDelegate.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.listDelegate.toArray(a2);
    }

    @Override
    public boolean add(PyInteger o2) {
        return this.listDelegate.add(o2);
    }

    @Override
    public boolean remove(Object o2) {
        return this.listDelegate.remove(o2);
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        return this.listDelegate.containsAll(c2);
    }

    @Override
    public boolean addAll(Collection<? extends PyInteger> c2) {
        return this.listDelegate.addAll(c2);
    }

    @Override
    public boolean addAll(int index, Collection<? extends PyInteger> c2) {
        return this.listDelegate.addAll(index, c2);
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        return this.listDelegate.removeAll(c2);
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        return this.listDelegate.retainAll(c2);
    }

    @Override
    public void clear() {
        this.listDelegate.clear();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other instanceof PyObject) {
            return super.equals(other);
        }
        return this.listDelegate.equals(other);
    }

    @Override
    public int hashCode() {
        return this.listDelegate.hashCode();
    }

    @Override
    public PyInteger get(int index) {
        return this.listDelegate.get(index);
    }

    @Override
    public PyInteger set(int index, PyInteger element) {
        return this.listDelegate.set(index, element);
    }

    @Override
    public void add(int index, PyInteger element) {
        this.listDelegate.add(index, element);
    }

    @Override
    public PyInteger remove(int index) {
        return this.listDelegate.remove(index);
    }

    @Override
    public int indexOf(Object o2) {
        return this.listDelegate.indexOf(o2);
    }

    @Override
    public int lastIndexOf(Object o2) {
        return this.listDelegate.lastIndexOf(o2);
    }

    @Override
    public ListIterator<PyInteger> listIterator() {
        return this.listDelegate.listIterator();
    }

    @Override
    public ListIterator<PyInteger> listIterator(int index) {
        return this.listDelegate.listIterator(index);
    }

    @Override
    public List<PyInteger> subList(int fromIndex, int toIndex) {
        return this.listDelegate.subList(fromIndex, toIndex);
    }

    protected static final int roundUp(int size) {
        int ALLOC = 16;
        int SIZE2 = 10;
        if (size >= 10) {
            return size + (size >> 3) + 21 & 0xFFFFFFF0;
        }
        if (size > 0) {
            return 16;
        }
        return 0;
    }

    protected abstract Builder getBuilder(int var1);

    static {
        int c2;
        emptyStorage = new byte[0];
        ctype = new byte[256];
        for (c2 = 65; c2 <= 90; ++c2) {
            BaseBytes.ctype[128 + c2] = 1;
            BaseBytes.ctype[160 + c2] = 2;
        }
        for (c2 = 48; c2 <= 57; ++c2) {
            BaseBytes.ctype[128 + c2] = 4;
        }
        for (char c3 : " \t\n\u000b\f\r".toCharArray()) {
            BaseBytes.ctype[128 + c3] = 8;
        }
    }

    protected static abstract class Builder {
        private byte[] storage = emptyStorage;
        private int size = 0;

        abstract BaseBytes getResult();

        Builder(int capacity) {
            this.makeRoomFor(capacity);
        }

        byte[] getStorage() {
            byte[] s2 = this.storage;
            this.storage = emptyStorage;
            return s2;
        }

        final int getSize() {
            return this.size;
        }

        void append(byte b2) {
            this.makeRoomFor(1);
            this.storage[this.size++] = b2;
        }

        void repeat(byte b2, int n2) {
            if (n2 > 0) {
                this.makeRoomFor(n2);
                while (n2-- > 0) {
                    this.storage[this.size++] = b2;
                }
            }
        }

        void append(BaseBytes b2) {
            this.append(b2, 0, b2.size);
        }

        void append(BaseBytes b2, int start, int end) {
            int n2 = end - start;
            this.makeRoomFor(n2);
            System.arraycopy(b2.storage, b2.offset + start, this.storage, this.size, n2);
            this.size += n2;
        }

        void append(PyBuffer v2) {
            int n2 = v2.getLen();
            this.makeRoomFor(n2);
            v2.copyTo(this.storage, this.size);
            this.size += n2;
        }

        void makeRoomFor(int n2) throws PyException {
            int needed = this.size + n2;
            if (needed > this.storage.length) {
                try {
                    if (this.storage == emptyStorage) {
                        this.size = 0;
                        if (n2 > 0) {
                            this.storage = new byte[n2];
                        }
                    } else {
                        byte[] old = this.storage;
                        this.storage = new byte[BaseBytes.roundUp(needed)];
                        System.arraycopy(old, 0, this.storage, 0, this.size);
                    }
                }
                catch (OutOfMemoryError e2) {
                    throw Py.MemoryError(e2.getMessage());
                }
            }
        }
    }

    protected static class ByteSet {
        protected final long[] map = new long[4];

        public ByteSet(PyBuffer bytes) {
            int n2 = bytes.getLen();
            for (int i2 = 0; i2 < n2; ++i2) {
                int word;
                int c2 = bytes.intAt(i2);
                long mask = 1L << c2;
                int n3 = word = c2 >> 6;
                this.map[n3] = this.map[n3] | mask;
            }
        }

        public boolean contains(byte b2) {
            int word = (b2 & 0xFF) >> 6;
            long mask = 1L << b2;
            return (this.map[word] & mask) != 0L;
        }

        public boolean contains(int b2) {
            int word = b2 >> 6;
            long mask = 1L << b2;
            return (this.map[word] & mask) != 0L;
        }
    }

    protected static class ReverseFinder
    extends Finder {
        private static final byte MASK = 31;

        public ReverseFinder(PyBuffer pattern) {
            super(pattern);
        }

        @Override
        protected int[] calculateSkipTable() {
            int[] skipTable = new int[32];
            int m4 = this.pattern.getLen();
            Arrays.fill(skipTable, m4);
            int i2 = m4;
            while (--i2 >= 0) {
                skipTable[0x1F & this.pattern.byteAt((int)i2)] = i2;
            }
            return skipTable;
        }

        @Override
        public int currIndex() {
            return this.right + this.pattern.getLen() - 1;
        }

        @Override
        public int nextIndex() {
            int m4 = this.pattern.getLen();
            if (this.skipTable != null) {
                int i2 = this.right - 1;
                while (i2 >= this.left) {
                    int skip = this.skipTable[0x1F & this.text[i2]];
                    if (skip == 0) {
                        int j2;
                        int k2 = i2;
                        for (j2 = 0; j2 < m4 && this.text[k2++] == this.pattern.byteAt(j2); ++j2) {
                        }
                        if (j2 == m4) {
                            this.right = i2 - m4 + 1;
                            return i2;
                        }
                        --i2;
                        continue;
                    }
                    i2 -= skip;
                }
            } else if (m4 == 1) {
                byte b2 = this.pattern.byteAt(0);
                int i3 = this.right;
                while (--i3 >= this.left) {
                    if (this.text[i3] != b2) continue;
                    this.right = i3;
                    return i3;
                }
            } else {
                int i4 = this.right;
                if (--i4 >= this.left) {
                    this.right = i4;
                    return i4;
                }
            }
            return -1;
        }
    }

    protected static class Finder {
        private static final byte MASK = 31;
        protected int[] skipTable = null;
        protected final PyBuffer pattern;
        protected byte[] text = emptyStorage;
        protected int left = 0;
        protected int right = 0;

        public Finder(PyBuffer pattern) {
            this.pattern = pattern;
        }

        protected int[] calculateSkipTable() {
            int[] skipTable = new int[32];
            int m4 = this.pattern.getLen();
            Arrays.fill(skipTable, m4);
            for (int i2 = 0; i2 < m4; ++i2) {
                skipTable[0x1F & this.pattern.byteAt((int)i2)] = m4 - i2 - 1;
            }
            return skipTable;
        }

        public void setText(byte[] text) {
            this.setText(text, 0, text.length);
        }

        public void setText(BaseBytes text) {
            this.setText(text.storage, text.offset, text.size);
        }

        public void setText(byte[] text, int start, int size) {
            this.text = text;
            this.left = start;
            this.right = start + size - this.pattern.getLen() + 1;
            if (this.pattern.getLen() > 1 && this.skipTable == null) {
                this.skipTable = this.calculateSkipTable();
            }
        }

        public int currIndex() {
            return this.left;
        }

        public int nextIndex() {
            int m4 = this.pattern.getLen();
            if (this.skipTable != null) {
                int i2 = this.left;
                while (i2 < this.right) {
                    int skip = this.skipTable[0x1F & this.text[i2 + (m4 - 1)]];
                    if (skip == 0) {
                        int j2;
                        int k2 = i2;
                        for (j2 = 0; j2 < m4 && this.text[k2++] == this.pattern.byteAt(j2); ++j2) {
                        }
                        if (j2 == m4) {
                            this.left = k2;
                            return i2;
                        }
                        ++i2;
                        continue;
                    }
                    i2 += skip;
                }
            } else if (m4 == 1) {
                byte b2 = this.pattern.byteAt(0);
                for (int i3 = this.left; i3 < this.right; ++i3) {
                    if (this.text[i3] != b2) continue;
                    this.left = i3 + 1;
                    return i3;
                }
            } else {
                int i4 = this.left;
                if (i4 <= this.right) {
                    this.left = i4 + 1;
                    return i4;
                }
            }
            return -1;
        }

        public int count(byte[] text) {
            return this.count(text, 0, text.length, Integer.MAX_VALUE);
        }

        public int count(byte[] text, int start, int size) {
            return this.count(text, start, size, Integer.MAX_VALUE);
        }

        public int count(byte[] text, int start, int size, int maxcount) {
            int count2;
            this.setText(text, start, size);
            for (count2 = 0; count2 < maxcount && this.nextIndex() >= 0; ++count2) {
            }
            return count2;
        }
    }

    private class IndexDelegate
    extends PySequence.DefaultIndexDelegate {
        private IndexDelegate() {
            super(BaseBytes.this);
        }

        @Override
        public void checkIdxAndSetSlice(PySlice slice2, PyObject value) {
            if (value.__len__() != 0) {
                super.checkIdxAndSetSlice(slice2, value);
            } else {
                this.checkIdxAndDelItem(slice2);
            }
        }

        @Override
        protected void delSlice(int[] indices) {
            BaseBytes.this.delslice(indices[0], indices[1], indices[2], indices[3]);
        }
    }

    protected static class FragmentList
    extends LinkedList<Fragment> {
        int totalCount = 0;

        protected FragmentList() {
        }

        void loadFrom(Iterable<? extends PyObject> iter2) throws PyException {
            int fragSize = 8;
            Fragment curr = null;
            try {
                for (PyObject pyObject : iter2) {
                    if (curr == null) {
                        curr = new Fragment(fragSize);
                        this.add(curr);
                        if (fragSize < 1024) {
                            fragSize <<= 1;
                        }
                    }
                    if (!curr.isFilledBy(pyObject)) continue;
                    this.totalCount += curr.count;
                    curr = null;
                }
            }
            catch (OutOfMemoryError e2) {
                throw Py.MemoryError(e2.getMessage());
            }
            if (curr != null) {
                this.totalCount += curr.count;
            }
        }

        void emptyInto(byte[] target, int p2) {
            for (Fragment frag : this) {
                System.arraycopy(frag.storage, 0, target, p2, frag.count);
                p2 += frag.count;
            }
            this.clear();
            this.totalCount = 0;
        }

        void emptyInto(byte[] target, int start, int step) {
            int p2 = start;
            for (Fragment frag : this) {
                for (int i2 = 0; i2 < frag.count; ++i2) {
                    target[p2] = frag.storage[i2];
                    p2 += step;
                }
            }
            this.clear();
            this.totalCount = 0;
        }
    }

    protected static class Fragment {
        static final int MINSIZE = 8;
        static final int MAXSIZE = 1024;
        byte[] storage;
        int count = 0;

        Fragment(int size) {
            this.storage = new byte[size];
        }

        boolean isFilledBy(PyObject value) {
            this.storage[this.count++] = BaseBytes.byteCheck(value);
            return this.count == this.storage.length;
        }
    }
}

