/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.CodeFlag;
import org.python.core.CompilerFlags;
import org.python.core.Py;
import org.python.core.PyCode;
import org.python.core.PyDictionary;
import org.python.core.PyException;
import org.python.core.PyFrame;
import org.python.core.PyGenerator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.ThreadState;
import org.python.core.ThreadStateMapping;
import org.python.google.common.base.CharMatcher;
import org.python.modules._systemrestart;

public abstract class PyBaseCode
extends PyCode {
    public int co_argcount;
    int nargs;
    public int co_firstlineno = -1;
    public String[] co_varnames;
    public String[] co_cellvars;
    public int jy_npurecell;
    public String[] co_freevars;
    public String co_filename;
    public CompilerFlags co_flags = new CompilerFlags();
    public int co_nlocals;
    public boolean varargs;
    public boolean varkwargs;

    public boolean hasFreevars() {
        return this.co_freevars != null && this.co_freevars.length > 0;
    }

    @Override
    public PyObject call(ThreadState ts, PyFrame frame, PyObject closure) {
        PyObject ret;
        if (ts.getSystemState() == null) {
            ts.setSystemState(Py.defaultSystemState);
        }
        PyException previous_exception = ts.exception;
        frame.f_back = ts.frame;
        if (frame.f_builtins == null) {
            frame.f_builtins = frame.f_back != null ? frame.f_back.f_builtins : ts.getSystemState().builtins;
        }
        frame.setupEnv((PyTuple)closure);
        ts.frame = frame;
        if (ts.tracefunc != null) {
            frame.f_lineno = this.co_firstlineno;
            frame.tracefunc = ts.tracefunc.traceCall(frame);
        }
        if (ts.profilefunc != null) {
            ts.profilefunc.traceCall(frame);
        }
        ThreadStateMapping.enterCall(ts);
        try {
            ret = this.interpret(frame, ts);
        }
        catch (Throwable t2) {
            PyException pye = Py.JavaError(t2);
            pye.tracebackHere(frame);
            frame.f_lasti = -1;
            if (frame.tracefunc != null) {
                frame.tracefunc.traceException(frame, pye);
            }
            if (ts.profilefunc != null) {
                ts.profilefunc.traceException(frame, pye);
            }
            ts.exception = previous_exception;
            ts.frame = ts.frame.f_back;
            throw pye;
        }
        finally {
            ThreadStateMapping.exitCall(ts);
        }
        if (frame.tracefunc != null) {
            frame.tracefunc.traceReturn(frame, ret);
        }
        if (ts.profilefunc != null) {
            ts.profilefunc.traceReturn(frame, ret);
        }
        ts.exception = previous_exception;
        ts.frame = ts.frame.f_back;
        if (ts.getSystemState()._systemRestart && Thread.currentThread().isInterrupted()) {
            throw new PyException(_systemrestart.SystemRestart);
        }
        return ret;
    }

    @Override
    public PyObject call(ThreadState state, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 0 || this.varargs || this.varkwargs) {
            return this.call(state, Py.EmptyObjects, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 1 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject arg2, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 2 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1, arg2}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        frame.f_fastlocals[1] = arg2;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject arg2, PyObject arg3, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 3 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1, arg2, arg3}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        frame.f_fastlocals[1] = arg2;
        frame.f_fastlocals[2] = arg3;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject arg1, PyObject arg2, PyObject arg3, PyObject arg4, PyObject globals, PyObject[] defaults, PyObject closure) {
        if (this.co_argcount != 4 || this.varargs || this.varkwargs) {
            return this.call(state, new PyObject[]{arg1, arg2, arg3, arg4}, Py.NoKeywords, globals, defaults, closure);
        }
        PyFrame frame = new PyFrame(this, globals);
        frame.f_fastlocals[0] = arg1;
        frame.f_fastlocals[1] = arg2;
        frame.f_fastlocals[2] = arg3;
        frame.f_fastlocals[3] = arg4;
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject self, PyObject[] args, String[] keywords, PyObject globals, PyObject[] defaults, PyObject closure) {
        PyObject[] os2 = new PyObject[args.length + 1];
        os2[0] = self;
        System.arraycopy(args, 0, os2, 1, args.length);
        return this.call(state, os2, keywords, globals, defaults, closure);
    }

    @Override
    public PyObject call(ThreadState state, PyObject[] args, String[] kws, PyObject globals, PyObject[] defs, PyObject closure) {
        PyFrame frame = new PyFrame(this, globals);
        int argcount = args.length - kws.length;
        if (this.co_argcount > 0 || this.varargs || this.varkwargs) {
            int i2;
            int n2 = argcount;
            PyDictionary kwdict = null;
            PyObject[] fastlocals = frame.f_fastlocals;
            if (this.varkwargs) {
                kwdict = new PyDictionary();
                i2 = this.co_argcount;
                if (this.varargs) {
                    ++i2;
                }
                fastlocals[i2] = kwdict;
            }
            if (argcount > this.co_argcount) {
                if (!this.varargs) {
                    int defcount = defs != null ? defs.length : 0;
                    String msg = String.format("%.200s() takes %s %d %sargument%s (%d given)", this.co_name, defcount > 0 ? "at most" : "exactly", this.co_argcount, kws.length > 0 ? "" : "", this.co_argcount == 1 ? "" : "s", args.length);
                    throw Py.TypeError(msg);
                }
                n2 = this.co_argcount;
            }
            System.arraycopy(args, 0, fastlocals, 0, n2);
            if (this.varargs) {
                PyObject[] u2 = new PyObject[argcount - n2];
                System.arraycopy(args, n2, u2, 0, argcount - n2);
                PyTuple uTuple = new PyTuple(u2);
                fastlocals[this.co_argcount] = uTuple;
            }
            for (i2 = 0; i2 < kws.length; ++i2) {
                int j2;
                String keyword2 = kws[i2];
                PyObject value = args[i2 + argcount];
                for (j2 = 0; j2 < this.co_argcount && !this.co_varnames[j2].equals(keyword2); ++j2) {
                }
                if (j2 >= this.co_argcount) {
                    if (kwdict == null) {
                        throw Py.TypeError(String.format("%.200s() got an unexpected keyword argument '%.400s'", this.co_name, Py.newUnicode(keyword2).encode("ascii", "replace")));
                    }
                    if (CharMatcher.ASCII.matchesAllOf(keyword2)) {
                        kwdict.__setitem__(keyword2, value);
                        continue;
                    }
                    ((PyObject)kwdict).__setitem__(Py.newUnicode(keyword2), value);
                    continue;
                }
                if (fastlocals[j2] != null) {
                    throw Py.TypeError(String.format("%.200s() got multiple values for keyword argument '%.400s'", this.co_name, keyword2));
                }
                fastlocals[j2] = value;
            }
            if (argcount < this.co_argcount) {
                int defcount = defs != null ? defs.length : 0;
                int m4 = this.co_argcount - defcount;
                for (i2 = argcount; i2 < m4; ++i2) {
                    if (fastlocals[i2] != null) continue;
                    String msg = String.format("%.200s() takes %s %d %sargument%s (%d given)", this.co_name, this.varargs || defcount > 0 ? "at least" : "exactly", m4, kws.length > 0 ? "" : "", m4 == 1 ? "" : "s", args.length);
                    throw Py.TypeError(msg);
                }
                for (i2 = n2 > m4 ? n2 - m4 : 0; i2 < defcount; ++i2) {
                    if (fastlocals[m4 + i2] != null) continue;
                    fastlocals[m4 + i2] = defs[i2];
                }
            }
        } else if (argcount > 0 || args.length > 0 && this.co_argcount == 0 && !this.varargs && !this.varkwargs) {
            throw Py.TypeError(String.format("%.200s() takes no arguments (%d given)", this.co_name, args.length));
        }
        if (this.co_flags.isFlagSet(CodeFlag.CO_GENERATOR)) {
            return new PyGenerator(frame, closure);
        }
        return this.call(state, frame, closure);
    }

    @Override
    public String toString() {
        return String.format("<code object %.100s at %s, file \"%.300s\", line %d>", this.co_name, Py.idstr(this), this.co_filename, this.co_firstlineno);
    }

    protected abstract PyObject interpret(PyFrame var1, ThreadState var2);

    protected int getline(PyFrame f2) {
        return f2.f_lineno;
    }

    public CompilerFlags getCompilerFlags() {
        return this.co_flags;
    }
}

