/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyBoolean$PyExposer;
import org.python.core.PyInteger;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.core.Untraversable;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="bool", isBaseType=false, doc="bool(x) -> bool\n\nReturns True when the argument x is true, False otherwise.\nThe builtins True and False are the only two instances of the class bool.\nThe class bool is a subclass of the class int, and cannot be subclassed.")
public class PyBoolean
extends PyInteger {
    public static final PyType TYPE;
    private final boolean value;

    public boolean getBooleanValue() {
        return this.value;
    }

    @Override
    public int getValue() {
        return this.getBooleanValue() ? 1 : 0;
    }

    public PyBoolean(boolean value) {
        super(TYPE, value ? 1 : 0);
        this.value = value;
    }

    @ExposedNew
    public static PyObject bool_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("bool", args, keywords, new String[]{"x"}, 0);
        PyObject obj = ap.getPyObject(0, null);
        if (obj == null) {
            return Py.False;
        }
        return obj.__nonzero__() ? Py.True : Py.False;
    }

    @Override
    public String toString() {
        return this.bool_toString();
    }

    final String bool_toString() {
        return this.getBooleanValue() ? "True" : "False";
    }

    @Override
    public int hashCode() {
        return this.bool___hash__();
    }

    final int bool___hash__() {
        return this.getBooleanValue() ? 1 : 0;
    }

    @Override
    public boolean __nonzero__() {
        return this.bool___nonzero__();
    }

    final boolean bool___nonzero__() {
        return this.getBooleanValue();
    }

    @Override
    public Object __tojava__(Class<?> c2) {
        if (c2 == Boolean.TYPE || c2 == Boolean.class || c2 == Object.class) {
            return this.getBooleanValue();
        }
        if (c2 == Integer.TYPE || c2 == Number.class || c2 == Integer.class) {
            return this.getValue();
        }
        if (c2 == Byte.TYPE || c2 == Byte.class) {
            return (byte)this.getValue();
        }
        if (c2 == Short.TYPE || c2 == Short.class) {
            return (short)this.getValue();
        }
        if (c2 == Long.TYPE || c2 == Long.class) {
            return (long)this.getValue();
        }
        if (c2 == Float.TYPE || c2 == Float.class) {
            return Float.valueOf(this.getValue());
        }
        if (c2 == Double.TYPE || c2 == Double.class) {
            return (double)this.getValue();
        }
        return super.__tojava__(c2);
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.bool___and__(right);
    }

    final PyObject bool___and__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() & ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() & ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.bool___xor__(right);
    }

    final PyObject bool___xor__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() ^ ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() ^ ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.bool___or__(right);
    }

    final PyObject bool___or__(PyObject right) {
        if (right instanceof PyBoolean) {
            return Py.newBoolean(this.getBooleanValue() | ((PyBoolean)right).getBooleanValue());
        }
        if (right instanceof PyInteger) {
            return Py.newInteger(this.getValue() | ((PyInteger)right).getValue());
        }
        return null;
    }

    @Override
    public PyObject __neg__() {
        return this.bool___neg__();
    }

    final PyObject bool___neg__() {
        return Py.newInteger(this.getBooleanValue() ? -1 : 0);
    }

    @Override
    public PyObject __pos__() {
        return this.bool___pos__();
    }

    final PyObject bool___pos__() {
        return Py.newInteger(this.getValue());
    }

    @Override
    public PyObject __abs__() {
        return this.bool___abs__();
    }

    final PyObject bool___abs__() {
        return Py.newInteger(this.getValue());
    }

    static {
        PyType.addBuilder(PyBoolean.class, new PyBoolean$PyExposer());
        TYPE = PyType.fromClass(PyBoolean.class);
    }
}

