/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyByteArray$PyExposer;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleWritableBuffer;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="bytearray", base=PyObject.class, doc="bytearray(iterable_of_ints) -> bytearray.\nbytearray(string, encoding[, errors]) -> bytearray.\nbytearray(bytes_or_bytearray) -> mutable copy of bytes_or_bytearray.\nbytearray(memory_view) -> bytearray.\n\nConstruct an mutable bytearray object from:\n  - an iterable yielding integers in range(256)\n  - a text string encoded using the specified encoding\n  - a bytes or a bytearray object\n  - any object implementing the buffer API.\n\nbytearray(int) -> bytearray.\n\nConstruct a zero-initialized bytearray of the given length.")
public class PyByteArray
extends BaseBytes
implements BufferProtocol {
    public static final PyType TYPE;
    private WeakReference<BaseBuffer> export;

    public PyByteArray(PyType type) {
        super(type);
    }

    public PyByteArray() {
        super(TYPE);
    }

    public PyByteArray(int size) {
        super(TYPE);
        this.init(size);
    }

    public PyByteArray(int[] value) {
        super(TYPE, value);
    }

    public PyByteArray(BaseBytes value) {
        super(TYPE);
        this.init(value);
    }

    PyByteArray(PyBuffer value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(BufferProtocol value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(Iterable<? extends PyObject> value) {
        super(TYPE);
        this.init(value);
    }

    public PyByteArray(PyString arg, PyObject encoding, PyObject errors) {
        super(TYPE);
        this.init(arg, encoding, errors);
    }

    public PyByteArray(PyString arg, String encoding, String errors) {
        super(TYPE);
        this.init(arg, encoding, errors);
    }

    public PyByteArray(PyString arg) {
        super(TYPE);
        this.init(arg, (String)null, (String)null);
    }

    public PyByteArray(byte[] storage) {
        super(TYPE);
        this.setStorage(storage);
    }

    public PyByteArray(byte[] storage, int size) {
        super(TYPE);
        this.setStorage(storage, size);
    }

    public PyByteArray(PyObject arg) throws PyException {
        super(TYPE);
        this.init(arg);
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        BaseBuffer pybuf = this.getExistingBuffer(flags);
        if (pybuf == null) {
            pybuf = new SimpleWritableBuffer(flags, this.storage, this.offset, this.size);
            this.export = new WeakReference<BaseBuffer>(pybuf);
        }
        return pybuf;
    }

    private BaseBuffer getExistingBuffer(int flags) throws PyException {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = (BaseBuffer)this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    protected void resizeCheck() throws PyException {
        if (this.export != null) {
            PyBuffer pybuf = (PyBuffer)this.export.get();
            if (pybuf != null && !pybuf.isReleased()) {
                throw Py.BufferError("Existing exports of data: object cannot be re-sized");
            }
            this.export = null;
        }
    }

    @Override
    protected synchronized PyByteArray getslice(int start, int stop2, int step) {
        if (step == 1) {
            return this.getslice(start, stop2);
        }
        int n2 = PyByteArray.sliceLength(start, stop2, step);
        PyByteArray ret = new PyByteArray(n2);
        n2 += ret.offset;
        byte[] dst = ret.storage;
        int io = start + this.offset;
        for (int jo = ret.offset; jo < n2; ++jo) {
            dst[jo] = this.storage[io];
            io += step;
        }
        return ret;
    }

    @Override
    protected synchronized PyByteArray getslice(int start, int stop2) {
        int n2 = stop2 - start;
        if (n2 <= 0) {
            return new PyByteArray();
        }
        PyByteArray ret = new PyByteArray(n2);
        System.arraycopy(this.storage, this.offset + start, ret.storage, ret.offset, n2);
        return ret;
    }

    @Override
    protected synchronized PyByteArray repeat(int count2) {
        PyByteArray ret = new PyByteArray();
        ret.setStorage(this.repeatImpl(count2));
        return ret;
    }

    protected synchronized void irepeat(int count2) {
        block6: {
            if (this.size == 0 || count2 == 1) break block6;
            if (count2 <= 0) {
                this.resizeCheck();
                this.setStorage(emptyStorage);
            } else {
                int orginalSize = this.size;
                this.storageExtend(orginalSize * (count2 - 1));
                if (orginalSize == 1) {
                    byte b2 = this.storage[this.offset];
                    int p2 = this.offset + 1;
                    for (int i2 = 1; i2 < count2; ++i2) {
                        this.storage[p2++] = b2;
                    }
                } else {
                    int i3 = 1;
                    int p3 = this.offset + orginalSize;
                    while (i3 < count2) {
                        System.arraycopy(this.storage, this.offset, this.storage, p3, orginalSize);
                        ++i3;
                        p3 += orginalSize;
                    }
                }
            }
        }
    }

    @Override
    public synchronized void pyset(int index, PyObject value) throws PyException {
        this.storage[index + this.offset] = PyByteArray.byteCheck(value);
    }

    @Override
    public synchronized void pyinsert(int index, PyObject element) {
        this.storageReplace(index, 0, 1);
        this.storage[this.offset + index] = PyByteArray.byteCheck(element);
    }

    @Override
    protected synchronized void setslice(int start, int stop2, int step, PyObject value) {
        if (step == 1 && stop2 < start) {
            stop2 = start;
        }
        if (value instanceof PyString) {
            this.setslice(start, stop2, step, (PyString)value);
        } else if (value.isIndex()) {
            this.setslice(start, stop2, step, value.asIndex(Py.OverflowError));
        } else if (value instanceof BaseBytes) {
            this.setslice(start, stop2, step, (BaseBytes)value);
        } else if (value instanceof BufferProtocol) {
            this.setslice(start, stop2, step, (BufferProtocol)((Object)value));
        } else {
            this.setslice(start, stop2, step, value.asIterable());
        }
    }

    private void setslice(int start, int stop2, int step, int len) throws PyException {
        if (step == 1) {
            this.storageReplace(start, stop2 - start, len);
            Arrays.fill(this.storage, start + this.offset, start + this.offset + len, (byte)0);
        } else {
            int n2 = PyByteArray.sliceLength(start, stop2, step);
            if (n2 != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n2);
            }
            int io = start + this.offset;
            while (n2 > 0) {
                this.storage[io] = 0;
                io += step;
                --n2;
            }
        }
    }

    private void setslice(int start, int stop2, int step, PyString value) throws PyException {
        if (value instanceof PyUnicode) {
            throw Py.TypeError("can't set bytearray slice from unicode");
        }
        String v2 = value.asString();
        int len = v2.length();
        if (step == 1) {
            this.storageReplace(start, stop2 - start, len);
            this.setBytes(start, v2);
        } else {
            int n2 = PyByteArray.sliceLength(start, stop2, step);
            if (n2 != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n2);
            }
            this.setBytes(start, step, v2);
        }
    }

    private void setslice(int start, int stop2, int step, BufferProtocol value) throws PyException {
        try (PyBuffer view = value.getBuffer(284);){
            int len = view.getLen();
            if (step == 1) {
                this.storageReplace(start, stop2 - start, len);
                view.copyTo(this.storage, start + this.offset);
            } else {
                int n2 = PyByteArray.sliceLength(start, stop2, step);
                if (n2 != len) {
                    throw PyByteArray.SliceSizeError("bytes", len, n2);
                }
                int io = start + this.offset;
                for (int j2 = 0; j2 < n2; ++j2) {
                    this.storage[io] = view.byteAt(j2);
                    io += step;
                }
            }
        }
    }

    private void setslice(int start, int stop2, int step, BaseBytes value) throws PyException {
        if (value == this) {
            value = new PyByteArray(value);
        }
        int len = value.size;
        if (step == 1) {
            this.storageReplace(start, stop2 - start, len);
            System.arraycopy(value.storage, value.offset, this.storage, start + this.offset, len);
        } else {
            int n2 = PyByteArray.sliceLength(start, stop2, step);
            if (n2 != len) {
                throw PyByteArray.SliceSizeError("bytes", len, n2);
            }
            int no = n2 + value.offset;
            int io = start + this.offset;
            for (int jo = value.offset; jo < no; ++jo) {
                this.storage[io] = value.storage[jo];
                io += step;
            }
        }
    }

    private void setslice(int start, int stop2, int step, Iterable<? extends PyObject> iter2) {
        BaseBytes.FragmentList fragList = new BaseBytes.FragmentList();
        fragList.loadFrom(iter2);
        if (step == 1) {
            this.storageReplace(start, stop2 - start, fragList.totalCount);
            if (fragList.totalCount > 0) {
                fragList.emptyInto(this.storage, start + this.offset);
            }
        } else {
            int n2 = PyByteArray.sliceLength(start, stop2, step);
            if (n2 != fragList.totalCount) {
                throw PyByteArray.SliceSizeError("bytes", fragList.totalCount, n2);
            }
            fragList.emptyInto(this.storage, start + this.offset, step);
        }
    }

    @Override
    protected synchronized void del(int index) {
        this.storageDelete(index, 1);
    }

    @Override
    protected synchronized void delRange(int start, int stop2) {
        this.storageDelete(start, stop2 - start);
    }

    @Override
    protected synchronized void delslice(int start, int stop2, int step, int n2) {
        this.resizeCheck();
        if (step == 1) {
            this.storageDelete(start, n2);
        } else if (step == -1) {
            this.storageDelete(stop2 + 1, n2);
        } else {
            int m4;
            int p2;
            if (step > 1) {
                p2 = start;
                m4 = step - 1;
            } else {
                p2 = start + (n2 - 1) * step;
                m4 = -1 - step;
            }
            p2 += this.offset;
            for (int i2 = 1; i2 < n2; ++i2) {
                int q2 = p2 + i2;
                for (int j2 = 0; j2 < m4; ++j2) {
                    this.storage[p2++] = this.storage[q2++];
                }
            }
            this.storageDelete(p2 - this.offset, n2);
        }
    }

    public static PyException SliceSizeError(String valueType, int valueSize, int sliceSize) {
        String fmt = "attempt to assign %s of size %d to extended slice of size %d";
        return Py.ValueError(String.format(fmt, valueType, valueSize, sliceSize));
    }

    @ExposedNew
    final synchronized void bytearray___init__(PyObject[] args, String[] kwds) {
        ArgParser ap = new ArgParser("bytearray", args, kwds, "source", "encoding", "errors");
        PyObject arg = ap.getPyObject(0, null);
        PyObject encoding = ap.getPyObjectByType(1, PyBaseString.TYPE, null);
        PyObject errors = ap.getPyObjectByType(2, PyBaseString.TYPE, null);
        if (encoding != null || errors != null) {
            if (arg == null || !(arg instanceof PyString)) {
                throw Py.TypeError("encoding or errors without sequence argument");
            }
            this.init((PyString)arg, encoding, errors);
        } else {
            this.init(arg);
        }
    }

    @Override
    protected BaseBytes.Builder getBuilder(int capacity) {
        return new BaseBytes.Builder(capacity){

            @Override
            PyByteArray getResult() {
                return new PyByteArray(this.getStorage(), this.getSize());
            }
        };
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.basebytes___eq__(other);
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.basebytes___ne__(other);
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.basebytes___lt__(other);
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.basebytes___le__(other);
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.basebytes___ge__(other);
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.basebytes___gt__(other);
    }

    final synchronized PyObject bytearray___eq__(PyObject other) {
        return this.basebytes___eq__(other);
    }

    final synchronized PyObject bytearray___ne__(PyObject other) {
        return this.basebytes___ne__(other);
    }

    final synchronized PyObject bytearray___lt__(PyObject other) {
        return this.basebytes___lt__(other);
    }

    final synchronized PyObject bytearray___le__(PyObject other) {
        return this.basebytes___le__(other);
    }

    final synchronized PyObject bytearray___ge__(PyObject other) {
        return this.basebytes___ge__(other);
    }

    final synchronized PyObject bytearray___gt__(PyObject other) {
        return this.basebytes___gt__(other);
    }

    @Override
    public PyObject __add__(PyObject o2) {
        return this.bytearray___add__(o2);
    }

    final synchronized PyObject bytearray___add__(PyObject o2) {
        PyByteArray sum = null;
        if (o2 instanceof BaseBytes) {
            BaseBytes ob = (BaseBytes)o2;
            sum = new PyByteArray(this.size + ob.size);
            System.arraycopy(this.storage, this.offset, sum.storage, sum.offset, this.size);
            System.arraycopy(ob.storage, ob.offset, sum.storage, sum.offset + this.size, ob.size);
        } else if (o2.getType() == PyString.TYPE) {
            PyString os2 = (PyString)o2;
            sum = new PyByteArray(this.size + os2.__len__());
            System.arraycopy(this.storage, this.offset, sum.storage, sum.offset, this.size);
            sum.setslice(this.size, sum.size, 1, os2);
        } else {
            throw PyByteArray.ConcatenationTypeError(TYPE, o2.getType());
        }
        return sum;
    }

    public int __alloc__() {
        return this.bytearray___alloc__();
    }

    final int bytearray___alloc__() {
        return this.storage.length;
    }

    @Override
    public PyObject __imul__(PyObject n2) {
        return this.bytearray___imul__(n2);
    }

    final PyObject bytearray___imul__(PyObject n2) {
        if (!n2.isIndex()) {
            return null;
        }
        this.irepeat(n2.asIndex(Py.OverflowError));
        return this;
    }

    @Override
    public PyObject __mul__(PyObject n2) {
        return this.bytearray___mul__(n2);
    }

    final PyObject bytearray___mul__(PyObject n2) {
        if (!n2.isIndex()) {
            return null;
        }
        return this.repeat(n2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject n2) {
        return this.bytearray___rmul__(n2);
    }

    final PyObject bytearray___rmul__(PyObject n2) {
        if (!n2.isIndex()) {
            return null;
        }
        return this.repeat(n2.asIndex(Py.OverflowError));
    }

    public void append(byte element) {
        this.storageExtend(1);
        this.storage[this.offset + this.size - 1] = element;
    }

    public void append(PyObject element) {
        this.bytearray_append(element);
    }

    final synchronized void bytearray_append(PyObject element) {
        this.storageExtend(1);
        this.storage[this.offset + this.size - 1] = PyByteArray.byteCheck(element);
    }

    @Override
    public boolean __contains__(PyObject o2) {
        return this.basebytes___contains__(o2);
    }

    final boolean bytearray___contains__(PyObject o2) {
        return this.basebytes___contains__(o2);
    }

    final PyObject bytearray_decode(PyObject[] args, String[] keywords) {
        return this.basebytes_decode(args, keywords);
    }

    public PyByteArray center(int width) {
        return (PyByteArray)this.basebytes_center(width, " ");
    }

    public PyByteArray center(int width, String fillchar) {
        return (PyByteArray)this.basebytes_center(width, fillchar);
    }

    final PyByteArray bytearray_center(int width, String fillchar) {
        return (PyByteArray)this.basebytes_center(width, fillchar);
    }

    public int count(PyObject sub) {
        return this.basebytes_count(sub, null, null);
    }

    public int count(PyObject sub, PyObject start) {
        return this.basebytes_count(sub, start, null);
    }

    public int count(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_count(sub, start, end);
    }

    final int bytearray_count(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_count(sub, start, end);
    }

    public boolean endswith(PyObject suffix) {
        return this.basebytes_starts_or_endswith(suffix, null, null, true);
    }

    public boolean endswith(PyObject suffix, PyObject start) {
        return this.basebytes_starts_or_endswith(suffix, start, null, true);
    }

    public boolean endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(suffix, start, end, true);
    }

    final boolean bytearray_endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(suffix, start, end, true);
    }

    public PyByteArray expandtabs() {
        return (PyByteArray)this.basebytes_expandtabs(8);
    }

    public PyByteArray expandtabs(int tabsize) {
        return (PyByteArray)this.basebytes_expandtabs(tabsize);
    }

    final PyByteArray bytearray_expandtabs(int tabsize) {
        return (PyByteArray)this.basebytes_expandtabs(tabsize);
    }

    public void extend(PyObject o2) {
        this.bytearray_extend(o2);
    }

    final synchronized void bytearray_extend(PyObject o2) {
        o2.__iter__();
        this.setslice(this.size, this.size, 1, o2);
    }

    public int find(PyObject sub) {
        return this.basebytes_find(sub, null, null);
    }

    public int find(PyObject sub, PyObject start) {
        return this.basebytes_find(sub, start, null);
    }

    public int find(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_find(sub, start, end);
    }

    final int bytearray_find(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_find(sub, start, end);
    }

    static PyByteArray fromhex(String hex) throws PyException {
        return PyByteArray.bytearray_fromhex(TYPE, hex);
    }

    static PyByteArray bytearray_fromhex(PyType type, String hex) {
        PyByteArray result = new PyByteArray();
        PyByteArray.basebytes_fromhex(result, hex);
        return result;
    }

    final synchronized PyObject bytearray___getitem__(PyObject index) {
        return this.delegator.checkIdxAndGetItem(index);
    }

    @Override
    public PyObject __iadd__(PyObject o2) {
        return this.bytearray___iadd__(o2);
    }

    final synchronized PyObject bytearray___iadd__(PyObject o2) {
        PyType oType = o2.getType();
        if (oType == TYPE) {
            this.setslice(this.size, this.size, 1, (BaseBytes)o2);
        } else if (oType == PyString.TYPE) {
            this.setslice(this.size, this.size, 1, (PyString)o2);
        } else {
            throw PyByteArray.ConcatenationTypeError(oType, TYPE);
        }
        return this;
    }

    public int index(PyObject sub) {
        return this.bytearray_index(sub, null, null);
    }

    public int index(PyObject sub, PyObject start) {
        return this.bytearray_index(sub, start, null);
    }

    @Override
    public int hashCode() throws PyException {
        return this.bytearray___hash__();
    }

    final int bytearray___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    public int index(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.bytearray_index(sub, start, end);
    }

    final int bytearray_index(PyObject sub, PyObject start, PyObject end) {
        int pos = this.basebytes_find(sub, start, end);
        if (pos < 0) {
            throw Py.ValueError("subsection not found");
        }
        return pos;
    }

    public void insert(PyObject index, PyObject value) {
        this.bytearray_insert(index, value);
    }

    final synchronized void bytearray_insert(PyObject index, PyObject value) {
        this.pyinsert(this.boundToSequence(index.asIndex()), value);
    }

    final boolean bytearray_isalnum() {
        return this.basebytes_isalnum();
    }

    final boolean bytearray_isalpha() {
        return this.basebytes_isalpha();
    }

    final boolean bytearray_isdigit() {
        return this.basebytes_isdigit();
    }

    final boolean bytearray_islower() {
        return this.basebytes_islower();
    }

    final boolean bytearray_isspace() {
        return this.basebytes_isspace();
    }

    final boolean bytearray_istitle() {
        return this.basebytes_istitle();
    }

    final boolean bytearray_isupper() {
        return this.basebytes_isupper();
    }

    final PyByteArray bytearray_capitalize() {
        return (PyByteArray)this.basebytes_capitalize();
    }

    final PyByteArray bytearray_lower() {
        return (PyByteArray)this.basebytes_lower();
    }

    final PyByteArray bytearray_swapcase() {
        return (PyByteArray)this.basebytes_swapcase();
    }

    final PyByteArray bytearray_title() {
        return (PyByteArray)this.basebytes_title();
    }

    final PyByteArray bytearray_upper() {
        return (PyByteArray)this.basebytes_upper();
    }

    public PyByteArray join(PyObject iterable) {
        return this.bytearray_join(iterable);
    }

    final PyByteArray bytearray_join(PyObject iterable) {
        return this.basebytes_join(iterable.asIterable());
    }

    final int bytearray___len__() {
        return super.__len__();
    }

    public PyByteArray ljust(int width) {
        return (PyByteArray)this.basebytes_ljust(width, " ");
    }

    public PyByteArray ljust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_ljust(width, fillchar);
    }

    final PyByteArray bytearray_ljust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_ljust(width, fillchar);
    }

    public PyByteArray lstrip() {
        return this.bytearray_lstrip(null);
    }

    public PyByteArray lstrip(PyObject bytes) {
        return this.bytearray_lstrip(bytes);
    }

    final synchronized PyByteArray bytearray_lstrip(PyObject bytes) {
        int left;
        if (bytes == null || bytes == Py.None) {
            left = this.lstripIndex();
        } else {
            BaseBytes.ByteSet byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes));
            left = this.lstripIndex(byteSet);
        }
        return this.getslice(left, this.size);
    }

    final PyTuple bytearray_partition(PyObject sep) {
        return this.basebytes_partition(sep);
    }

    public PyInteger pop() {
        return this.bytearray_pop(-1);
    }

    public PyInteger pop(int i2) {
        return this.bytearray_pop(i2);
    }

    final synchronized PyInteger bytearray_pop(int i2) {
        if (this.size == 0) {
            throw Py.IndexError("pop from empty list");
        }
        if (i2 < 0) {
            i2 += this.size;
        }
        return this.remove(i2);
    }

    final PyObject bytearray___reduce__() {
        return this.basebytes___reduce__();
    }

    public void remove(PyObject o2) throws PyException {
        this.bytearray_remove(o2);
    }

    final synchronized void bytearray_remove(PyObject o2) {
        byte b2 = PyByteArray.byteCheck(o2);
        int pos = this.index(b2);
        if (pos < 0) {
            throw Py.ValueError("value not found in bytearray");
        }
        this.storageDelete(pos, 1);
    }

    public PyByteArray replace(PyObject oldB, PyObject newB) {
        return this.basebytes_replace(oldB, newB, -1);
    }

    public PyByteArray replace(PyObject oldB, PyObject newB, int maxcount) {
        return this.basebytes_replace(oldB, newB, maxcount);
    }

    final PyByteArray bytearray_replace(PyObject oldB, PyObject newB, PyObject count2) {
        int maxcount = count2 == null ? -1 : count2.asInt();
        return this.basebytes_replace(oldB, newB, maxcount);
    }

    public void reverse() {
        this.bytearray_reverse();
    }

    final synchronized void bytearray_reverse() {
        int a2 = this.offset;
        int b2 = this.offset + this.size;
        while (--b2 > a2) {
            byte t2 = this.storage[b2];
            this.storage[b2] = this.storage[a2];
            this.storage[a2++] = t2;
        }
    }

    public int rfind(PyObject sub) {
        return this.basebytes_rfind(sub, null, null);
    }

    public int rfind(PyObject sub, PyObject start) {
        return this.basebytes_rfind(sub, start, null);
    }

    public int rfind(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_rfind(sub, start, end);
    }

    final int bytearray_rfind(PyObject sub, PyObject start, PyObject end) {
        return this.basebytes_rfind(sub, start, end);
    }

    public int rindex(PyObject sub) {
        return this.bytearray_rindex(sub, null, null);
    }

    public int rindex(PyObject sub, PyObject start) {
        return this.bytearray_rindex(sub, start, null);
    }

    public PyByteArray rjust(int width) {
        return (PyByteArray)this.basebytes_rjust(width, " ");
    }

    public PyByteArray rjust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_rjust(width, fillchar);
    }

    final PyByteArray bytearray_rjust(int width, String fillchar) {
        return (PyByteArray)this.basebytes_rjust(width, fillchar);
    }

    public int rindex(PyObject sub, PyObject start, PyObject end) {
        return this.bytearray_rindex(sub, start, end);
    }

    final int bytearray_rindex(PyObject sub, PyObject start, PyObject end) {
        int pos = this.basebytes_rfind(sub, start, end);
        if (pos < 0) {
            throw Py.ValueError("subsection not found");
        }
        return pos;
    }

    final PyTuple bytearray_rpartition(PyObject sep) {
        return this.basebytes_rpartition(sep);
    }

    final PyList bytearray_rsplit(PyObject sep, int maxsplit) {
        return this.basebytes_rsplit(sep, maxsplit);
    }

    public PyByteArray rstrip() {
        return this.bytearray_rstrip(null);
    }

    public PyByteArray rstrip(PyObject bytes) {
        return this.bytearray_rstrip(bytes);
    }

    final synchronized PyByteArray bytearray_rstrip(PyObject bytes) {
        int right;
        if (bytes == null || bytes == Py.None) {
            right = this.rstripIndex();
        } else {
            BaseBytes.ByteSet byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes));
            right = this.rstripIndex(byteSet);
        }
        return this.getslice(0, right);
    }

    final PyList bytearray_split(PyObject sep, int maxsplit) {
        return this.basebytes_split(sep, maxsplit);
    }

    final PyList bytearray_splitlines(boolean keepends) {
        return this.basebytes_splitlines(keepends);
    }

    public boolean startswith(PyObject prefix) {
        return this.basebytes_starts_or_endswith(prefix, null, null, false);
    }

    public boolean startswith(PyObject prefix, PyObject start) {
        return this.basebytes_starts_or_endswith(prefix, start, null, false);
    }

    public boolean startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(prefix, start, end, false);
    }

    final boolean bytearray_startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.basebytes_starts_or_endswith(prefix, start, end, false);
    }

    public PyByteArray strip() {
        return this.bytearray_strip(null);
    }

    public PyByteArray strip(PyObject bytes) {
        return this.bytearray_strip(bytes);
    }

    final synchronized PyByteArray bytearray_strip(PyObject bytes) {
        BaseBytes.ByteSet byteSet;
        int left;
        int right = bytes == null || bytes == Py.None ? ((left = this.lstripIndex()) == this.size ? this.size : this.rstripIndex()) : ((left = this.lstripIndex(byteSet = new BaseBytes.ByteSet(PyByteArray.getViewOrError(bytes)))) == this.size ? this.size : this.rstripIndex(byteSet));
        return this.getslice(left, right);
    }

    final synchronized void bytearray___setitem__(PyObject index, PyObject value) {
        this.delegator.checkIdxAndSetItem(index, value);
    }

    @Override
    public String toString() {
        return this.bytearray_repr();
    }

    final synchronized String bytearray_repr() {
        return this.basebytes_repr("bytearray(b", ")");
    }

    @Override
    public PyString __str__() {
        return this.bytearray_str();
    }

    final PyString bytearray_str() {
        return new PyString(this.asString());
    }

    public PyByteArray translate(PyObject table) {
        return this.bytearray_translate(table, null);
    }

    public PyByteArray translate(PyObject table, PyObject deletechars) {
        return this.bytearray_translate(table, deletechars);
    }

    final PyByteArray bytearray_translate(PyObject table, PyObject deletechars) {
        try (PyBuffer tab = this.getTranslationTable(table);){
            PyByteArray result = new PyByteArray();
            if (deletechars != null) {
                try (PyBuffer d2 = PyByteArray.getViewOrError(deletechars);){
                    BaseBytes.ByteSet del = new BaseBytes.ByteSet(d2);
                    int limit = this.offset + this.size;
                    if (tab == null) {
                        for (int i2 = this.offset; i2 < limit; ++i2) {
                            int b2 = this.storage[i2] & 0xFF;
                            if (del.contains(b2)) continue;
                            result.append((byte)b2);
                        }
                    }
                    for (int i3 = this.offset; i3 < limit; ++i3) {
                        int b3 = this.storage[i3] & 0xFF;
                        if (del.contains(b3)) continue;
                        result.append(tab.byteAt(b3));
                    }
                }
            } else if (tab == null) {
                result.extend(this);
            } else {
                int limit = this.offset + this.size;
                for (int i4 = this.offset; i4 < limit; ++i4) {
                    int b4 = this.storage[i4] & 0xFF;
                    result.append(tab.byteAt(b4));
                }
            }
            PyByteArray pyByteArray = result;
            return pyByteArray;
        }
    }

    private PyBuffer getTranslationTable(PyObject table) throws PyException {
        PyBuffer tab = null;
        if (table != null && table != Py.None && (tab = PyByteArray.getViewOrError(table)).getLen() != 256) {
            throw Py.ValueError("translation table must be 256 bytes long");
        }
        return tab;
    }

    public PyByteArray zfill(int width) {
        return (PyByteArray)this.basebytes_zfill(width);
    }

    final PyByteArray bytearray_zfill(int width) {
        return (PyByteArray)this.basebytes_zfill(width);
    }

    private final int recLength(int needed) {
        int L2 = this.storage.length;
        if (needed > L2 || needed * 2 < L2) {
            return PyByteArray.roundUp(needed);
        }
        return L2;
    }

    @Override
    protected void newStorage(int needed) {
        if (needed > 0) {
            int L2 = this.recLength(needed);
            try {
                byte[] s2 = new byte[L2];
                this.setStorage(s2, needed, (L2 - needed) / 2);
            }
            catch (OutOfMemoryError e2) {
                throw Py.MemoryError(e2.getMessage());
            }
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void storageReplace(int a2, int d2, int e2) {
        int b2 = this.size - (a2 + d2);
        int c2 = e2 - d2;
        if (c2 == 0) {
            return;
        }
        if (c2 > 0 && b2 == 0) {
            this.storageExtend(c2);
            return;
        }
        this.resizeCheck();
        int L2 = this.storage.length;
        int f2 = this.offset;
        int s2 = a2 + e2 + b2;
        int L22 = this.recLength(s2);
        if (L22 == L2) {
            if (a2 <= b2) {
                int f22 = f2 - c2;
                if (f22 >= 0) {
                    if (a2 > 0) {
                        System.arraycopy(this.storage, f2, this.storage, f22, a2);
                    }
                    this.offset = f22;
                    this.size = s2;
                } else {
                    this.newStorageAvoided(a2, d2, b2, e2);
                }
            } else {
                int g2 = f2 + a2 + e2;
                if (g2 + b2 <= L2) {
                    if (b2 > 0) {
                        System.arraycopy(this.storage, g2 - c2, this.storage, g2, b2);
                    }
                    this.size = s2;
                } else {
                    this.newStorageAvoided(a2, d2, b2, e2);
                }
            }
        } else if (L22 > 0) {
            this.newStorage(L22, a2, d2, b2, e2);
        } else {
            this.setStorage(emptyStorage);
        }
    }

    private void newStorageAvoided(int a2, int d2, int b2, int e2) {
        int f2;
        int f3 = this.offset;
        int g2 = f3 + a2 + d2;
        int s2 = a2 + e2 + b2;
        if (a2 == b2) {
            f2 = (this.storage.length - s2) / 2;
        } else {
            long spare = this.storage.length - s2;
            f2 = (int)(spare * (long)b2 / (long)(a2 + b2));
        }
        int g22 = f2 + a2 + e2;
        if (f2 + a2 > g2) {
            if (b2 > 0) {
                System.arraycopy(this.storage, g2, this.storage, g22, b2);
            }
            if (a2 > 0) {
                System.arraycopy(this.storage, f3, this.storage, f2, a2);
            }
        } else {
            if (a2 > 0) {
                System.arraycopy(this.storage, f3, this.storage, f2, a2);
            }
            if (b2 > 0) {
                System.arraycopy(this.storage, g2, this.storage, g22, b2);
            }
        }
        this.size = s2;
        this.offset = f2;
    }

    private void newStorage(int L2, int a2, int d2, int b2, int e2) {
        int f2;
        int f3 = this.offset;
        int g2 = f3 + a2 + d2;
        int s2 = a2 + e2 + b2;
        byte[] newStorage = new byte[L2];
        if (a2 == b2) {
            f2 = (L2 - s2) / 2;
        } else {
            long spare = L2 - s2;
            f2 = (int)(spare * (long)b2 / (long)(a2 + b2));
        }
        if (a2 > 0) {
            System.arraycopy(this.storage, f3, newStorage, f2, a2);
        }
        if (b2 > 0) {
            System.arraycopy(this.storage, g2, newStorage, f2 + a2 + e2, b2);
        }
        this.setStorage(newStorage, s2, f2);
    }

    private void storageExtend(int e2) {
        if (e2 == 0) {
            return;
        }
        this.resizeCheck();
        int L2 = this.storage.length;
        int f2 = this.offset;
        int s2 = this.size + e2;
        int L22 = this.recLength(s2);
        if (L22 <= L2) {
            int g2 = f2 + s2;
            if (g2 > L2) {
                if (this.size > 0) {
                    System.arraycopy(this.storage, this.offset, this.storage, 0, this.size);
                }
                this.offset = 0;
            }
            this.size = s2;
        } else {
            byte[] newStorage = new byte[L22];
            if (this.size > 0) {
                System.arraycopy(this.storage, f2, newStorage, 0, this.size);
            }
            this.setStorage(newStorage, s2);
        }
    }

    private void storageDelete(int a2, int d2) {
        if (d2 == 0) {
            return;
        }
        this.resizeCheck();
        int L2 = this.storage.length;
        int f2 = this.offset;
        int b2 = this.size - (a2 + d2);
        int s2 = a2 + b2;
        int L22 = this.recLength(s2);
        if (L22 == L2) {
            if (a2 <= b2) {
                int f22 = f2 + d2;
                if (a2 > 0) {
                    System.arraycopy(this.storage, f2, this.storage, f22, a2);
                }
                this.offset = f22;
                this.size = s2;
            } else {
                int g2 = f2 + a2;
                if (b2 > 0) {
                    System.arraycopy(this.storage, g2 + d2, this.storage, g2, b2);
                }
                this.size = s2;
            }
        } else if (L22 > 0) {
            int g2 = f2 + a2 + d2;
            int f23 = (L22 - s2) / 2;
            byte[] newStorage = new byte[L22];
            if (a2 > 0) {
                System.arraycopy(this.storage, f2, newStorage, f23, a2);
            }
            if (b2 > 0) {
                System.arraycopy(this.storage, g2, newStorage, f23 + a2, b2);
            }
            this.setStorage(newStorage, s2, f23);
        } else {
            this.setStorage(emptyStorage);
        }
    }

    static {
        PyType.addBuilder(PyByteArray.class, new PyByteArray$PyExposer());
        TYPE = PyType.fromClass(PyByteArray.class);
    }
}

