/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import org.python.core.BaseBytes;
import org.python.core.BaseBytesTest;
import org.python.core.Py;
import org.python.core.PyByteArray;
import org.python.core.PyException;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyType;
import org.python.util.PythonInterpreter;

public class PyByteArrayTest
extends BaseBytesTest {
    public PyByteArrayTest(String name) {
        super(name);
    }

    public static int[] patternInts(int na, int nd, int nb, String c2) {
        int i2;
        int[] r2 = new int[na + nd + nb];
        int p2 = 0;
        for (i2 = 0; i2 < na; ++i2) {
            r2[p2++] = c2.charAt(0);
        }
        for (i2 = 0; i2 < nd; ++i2) {
            r2[p2++] = c2.charAt(1);
        }
        for (i2 = 0; i2 < nb; ++i2) {
            r2[p2++] = c2.charAt(2);
        }
        return r2;
    }

    public static int[] adbInts(int na, int nd, int nb) {
        return PyByteArrayTest.patternInts(na, nd, nb, "aDb");
    }

    public static int[] aebInts(int na, int ne, int nb) {
        return PyByteArrayTest.patternInts(na, ne, nb, "aEb");
    }

    public static int[][] randomSliceProblem(Random random, int na, int nd, int nb, int ne) {
        int i2;
        int[] adb = new int[na + nd + nb];
        int[] aeb = new int[na + ne + nb];
        int[] e2 = new int[ne];
        int[][] ret = new int[][]{adb, aeb, e2};
        int p2 = 0;
        int q2 = 0;
        for (i2 = 0; i2 < na; ++i2) {
            int a2 = random.nextInt(256);
            adb[p2++] = a2;
            aeb[q2++] = a2;
        }
        for (i2 = 0; i2 < nd; ++i2) {
            int d2 = random.nextInt(256);
            adb[p2++] = d2;
        }
        for (i2 = 0; i2 < ne; ++i2) {
            int x2 = random.nextInt(256);
            e2[p2++] = x2;
            aeb[q2++] = x2;
        }
        for (i2 = 0; i2 < nb; ++i2) {
            int b2 = random.nextInt(256);
            adb[p2++] = b2;
            aeb[q2++] = b2;
        }
        return ret;
    }

    public static void checkSlice(int na, int nd, int nb, int ne, int[] x2, int[] y2, BaseBytes result) {
        PyByteArrayTest.assertEquals((String)"size", (int)(na + ne + nb), (int)result.size());
        PyByteArrayTest.checkInts(x2, 0, result, 0, na);
        PyByteArrayTest.checkInts(y2, 0, result, na, ne);
        PyByteArrayTest.checkInts(x2, na + nd, result, na + ne, nb);
    }

    public static void checkSlice(int start, int step, int n2, int[] x2, int[] y2, BaseBytes u2) {
        PyByteArrayTest.assertEquals((String)"size", (int)x2.length, (int)u2.size());
        if (step > 0) {
            int px;
            int py = 0;
            for (px = 0; px < start; ++px) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x2[px], (int)u2.intAt(px));
            }
            if (n2 > 0) {
                PyByteArrayTest.assertEquals((String)"first affected", (int)y2[py++], (int)u2.intAt(px++));
            }
            for (int i2 = 1; i2 < n2; ++i2) {
                int j2 = 1;
                while (j2 < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x2[px], (int)u2.intAt(px));
                    ++j2;
                    ++px;
                }
                PyByteArrayTest.assertEquals((String)"next affected", (int)y2[py++], (int)u2.intAt(px++));
            }
            while (px < x2.length) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x2[px], (int)u2.intAt(px));
                ++px;
            }
        } else {
            int px;
            step = -step;
            int py = 0;
            for (px = x2.length - 1; px > start; --px) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x2[px], (int)u2.intAt(px));
            }
            if (n2 > 0) {
                PyByteArrayTest.assertEquals((String)"first affected", (int)y2[py++], (int)u2.intAt(px--));
            }
            for (int i3 = 1; i3 < n2; ++i3) {
                int j3 = 1;
                while (j3 < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x2[px], (int)u2.intAt(px));
                    ++j3;
                    --px;
                }
                PyByteArrayTest.assertEquals((String)"next affected", (int)y2[py++], (int)u2.intAt(px--));
            }
            while (px >= 0) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x2[px], (int)u2.intAt(px));
                --px;
            }
        }
    }

    public static void checkDelSlice(int start, int step, int n2, int[] x2, BaseBytes u2) {
        PyByteArrayTest.assertEquals((String)"size", (int)(x2.length - n2), (int)u2.size());
        if (step > 0) {
            int px;
            int pu = 0;
            for (px = 0; px < start; ++px) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x2[px], (int)u2.intAt(pu++));
            }
            ++px;
            for (int i2 = 1; i2 < n2; ++i2) {
                int j2 = 1;
                while (j2 < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x2[px], (int)u2.intAt(pu++));
                    ++j2;
                    ++px;
                }
                ++px;
            }
            while (px < x2.length) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x2[px], (int)u2.intAt(pu++));
                ++px;
            }
        } else {
            int px;
            step = -step;
            int pu = u2.size - 1;
            for (px = x2.length - 1; px > start; --px) {
                PyByteArrayTest.assertEquals((String)"after slice", (int)x2[px], (int)u2.intAt(pu--));
            }
            --px;
            for (int i3 = 1; i3 < n2; ++i3) {
                int j3 = 1;
                while (j3 < step) {
                    PyByteArrayTest.assertEquals((String)"in gap", (int)x2[px], (int)u2.intAt(pu--));
                    ++j3;
                    --px;
                }
                --px;
            }
            while (px >= 0) {
                PyByteArrayTest.assertEquals((String)"before slice", (int)x2[px], (int)u2.intAt(pu--));
                --px;
            }
        }
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void test__getslice__2() {
        int[] posStart;
        int verbose = 0;
        String ver = "L'un a la pourpre de nos \u00e2mes";
        int L2 = ver.length();
        int[] aRef = PyByteArrayTest.toInts(ver);
        PyByteArray a2 = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L2);
        this.interp = new PythonInterpreter();
        for (int start : posStart = new int[]{0, 8, 16, L2 - 5, L2 - 1}) {
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L2) : Py.None;
            for (int stop2 = start; stop2 <= L2; ++stop2) {
                bList.clear();
                for (int i2 = start; i2 < stop2; ++i2) {
                    if (verbose >= 5) {
                        System.out.printf("    (%d,%d) i=%d\n", start, stop2, i2);
                    }
                    bList.add(new PyInteger(aRef[i2]));
                }
                PyObject pyStop_L = stop2 < L2 ? new PyInteger(stop2 - L2) : Py.None;
                PyInteger pyStop = new PyInteger(stop2);
                this.doTest__getslice__2(a2, pyStart, pyStop, bList, verbose + 2);
                this.doTest__getslice__2(a2, pyStart_L, pyStop, bList, verbose);
                this.doTest__getslice__2(a2, pyStart, pyStop_L, bList, verbose);
                this.doTest__getslice__2(a2, pyStart_L, pyStop_L, bList, verbose);
            }
        }
    }

    private void doTest__getslice__2(BaseBytes a2, PyObject pyStart, PyObject pyStop, List<PyInteger> bList, int verbose) {
        if (verbose >= 4) {
            System.out.printf("    __getslice__(%s,%s)\n", pyStart, pyStop);
        }
        PyObject b2 = a2.__getslice__(pyStart, pyStop);
        if (verbose >= 3) {
            System.out.println(this.toString((BaseBytes)b2));
        }
        PyByteArrayTest.checkInts(bList, b2);
    }

    public void test__getslice__3() {
        int verbose = 0;
        String ver = "Quand je br\u00fble et que tu t'enflammes ;";
        int L2 = ver.length();
        int[] aRef = PyByteArrayTest.toInts(ver);
        PyByteArray a2 = this.getInstance(aRef);
        ArrayList<PyInteger> bList = new ArrayList<PyInteger>(L2);
        this.interp = new PythonInterpreter();
        int[] posStart = new int[]{0, 9, 22, L2 - 11, L2 - 1};
        for (int step = 1; step < 4; ++step) {
            PyInteger pyStep = new PyInteger(step);
            for (int start : posStart) {
                PyInteger pyStart = new PyInteger(start);
                PyObject pyStart_L = start > 0 ? new PyInteger(start - L2) : Py.None;
                for (int stop2 = start; stop2 <= L2; ++stop2) {
                    bList.clear();
                    for (int i2 = start; i2 < stop2; i2 += step) {
                        if (verbose >= 5) {
                            System.out.printf("    (%d,%d,%d) i=%d\n", start, stop2, step, i2);
                        }
                        bList.add(new PyInteger(aRef[i2]));
                    }
                    PyObject pyStop_L = stop2 < L2 ? new PyInteger(stop2 - L2) : Py.None;
                    PyInteger pyStop = new PyInteger(stop2);
                    this.doTest__getslice__3(a2, pyStart, pyStop, pyStep, bList, verbose + 2);
                    this.doTest__getslice__3(a2, pyStart_L, pyStop, pyStep, bList, verbose);
                    this.doTest__getslice__3(a2, pyStart, pyStop_L, pyStep, bList, verbose);
                    this.doTest__getslice__3(a2, pyStart_L, pyStop_L, pyStep, bList, verbose);
                }
            }
        }
        int[] negStart = new int[]{0, 5, 14, L2 - 10, L2 - 1};
        for (int step = -1; step > -4; --step) {
            PyInteger pyStep = new PyInteger(step);
            for (int start : negStart) {
                PyInteger pyStart = new PyInteger(start);
                PyObject pyStart_L = start < L2 - 1 ? new PyInteger(start - L2) : Py.None;
                for (int stop3 = start; stop3 >= -1; --stop3) {
                    PyObject pyStop_L;
                    bList.clear();
                    for (int i3 = start; i3 > stop3; i3 += step) {
                        if (verbose >= 5) {
                            System.out.printf("    (%d,%d,%d) i=%d\n", start, stop3, step, i3);
                        }
                        bList.add(new PyInteger(aRef[i3]));
                    }
                    if (stop3 >= 0) {
                        pyStop_L = new PyInteger(stop3 - L2);
                    } else {
                        stop3 = -(L2 + 1);
                        pyStop_L = Py.None;
                    }
                    PyInteger pyStop = new PyInteger(stop3);
                    this.doTest__getslice__3(a2, pyStart, pyStop, pyStep, bList, verbose + 2);
                    this.doTest__getslice__3(a2, pyStart_L, pyStop, pyStep, bList, verbose);
                    this.doTest__getslice__3(a2, pyStart, pyStop_L, pyStep, bList, verbose);
                    this.doTest__getslice__3(a2, pyStart_L, pyStop_L, pyStep, bList, verbose);
                }
            }
        }
    }

    private void doTest__getslice__3(BaseBytes a2, PyObject pyStart, PyObject pyStop, PyObject pyStep, List<PyInteger> bList, int verbose) {
        if (verbose >= 4) {
            System.out.printf("    __getslice__(%s,%s,%s)\n", pyStart, pyStop, pyStep);
        }
        PyObject b2 = a2.__getslice__(pyStart, pyStop, pyStep);
        if (verbose >= 3) {
            System.out.println(this.toString((BaseBytes)b2));
        }
        PyByteArrayTest.checkInts(bList, b2);
    }

    @Override
    public void testPyset() {
        int[] badValue;
        int verbose = 0;
        this.interp = new PythonInterpreter();
        int[] aRef = PyByteArrayTest.randomInts(this.random, 25);
        PyByteArray a2 = this.getInstance(aRef);
        for (int i2 = 0; i2 < 25; ++i2) {
            int b2 = aRef[i2] ^ 0x55;
            PyInteger pyb = new PyInteger(b2);
            a2.__setitem__(i2, (PyObject)pyb);
            int ai = a2.pyget(i2).asInt();
            if (verbose >= 3) {
                System.out.printf("    __setitem__(%2d,%3d) : a[%2d]=%3d\n", i2, b2, i2, ai);
            }
            PyByteArrayTest.assertEquals((int)b2, (int)ai);
        }
        for (int i3 : badValue = new int[]{256, Integer.MAX_VALUE, -1, -2, -100, -65536, Integer.MIN_VALUE}) {
            PyInteger b3 = new PyInteger(i3);
            try {
                a2.__setitem__(0, (PyObject)b3);
                PyByteArrayTest.fail((String)("Exception not thrown for __setitem__(0, " + b3 + ")"));
            }
            catch (PyException pye) {
                PyByteArrayTest.assertEquals((Object)Py.ValueError, (Object)pye.type);
                if (verbose < 2) continue;
                System.out.printf("    Exception: %s\n", pye);
            }
        }
        PyInteger x2 = new PyInteger(10);
        for (int i4 : new int[]{-26, -125, 25, 26}) {
            try {
                a2.__setitem__(i4, (PyObject)x2);
                PyByteArrayTest.fail((String)("Exception not thrown for __setitem__(" + i4 + ", x)"));
            }
            catch (PyException pye) {
                PyByteArrayTest.assertEquals((Object)Py.IndexError, (Object)pye.type);
                if (verbose < 2) continue;
                System.out.printf("    Exception: %s\n", pye);
            }
        }
    }

    public void testSetslice2() {
        int[] neList;
        int verbose = 0;
        int[] naList = new int[]{2, 5, 0};
        int[] ndList = new int[]{5, 20, 0};
        int[] nbList = new int[]{4, 7, 0};
        for (int ne : neList = new int[]{4, 5, 6, 20, 0}) {
            int[] eInts = new int[ne];
            Arrays.fill(eInts, 69);
            PyByteArray e2 = new PyByteArray(eInts);
            for (int nd : ndList) {
                for (int na : naList) {
                    for (int nb : nbList) {
                        int[] aRef = PyByteArrayTest.adbInts(na, nd, nb);
                        int[] bRef = PyByteArrayTest.aebInts(na, ne, nb);
                        PyByteArray b2 = this.getInstance(aRef);
                        byte[] oldStorage = b2.storage;
                        if (verbose >= 2) {
                            System.out.printf("setslice(%d,%d,%d,e[len=%d])\n", na, na + nd, 1, ne);
                            if (verbose >= 3) {
                                System.out.println(this.toString(b2));
                            }
                        }
                        b2.setslice(na, na + nd, 1, (PyObject)e2);
                        if (verbose >= 2) {
                            boolean avAlloc;
                            boolean bl = avAlloc = b2.storage != oldStorage && bRef.length <= oldStorage.length;
                            if (b2.storage.length * 2 < oldStorage.length) {
                                avAlloc = false;
                            }
                            System.out.println(this.toString(b2) + (avAlloc ? " avoidable new" : ""));
                        }
                        PyByteArrayTest.checkInts(bRef, (BaseBytes)b2);
                    }
                }
            }
        }
        int AMAX = 7;
        int BMAX = 7;
        int DMAX = 25;
        int EMAX = 25;
        int[] xInts = PyByteArrayTest.randomInts(this.random, 39, 117, 122);
        int[] yInts = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        PyByteArray x2 = this.getInstance(xInts);
        PyByteArray y2 = this.getInstance(yInts);
        int[] nbList2 = new int[]{0, 1, 7};
        for (int na = 0; na <= 7; ++na) {
            for (int nb : nbList2) {
                for (int nd = 0; nd < 25; ++nd) {
                    for (int ne = 0; ne < 25; ++ne) {
                        PyByteArray u2 = x2.getslice(0, na + nd + nb, 1);
                        PyByteArray e3 = y2.getslice(0, ne, 1);
                        if (verbose >= 2) {
                            System.out.printf("setslice(start=%d, stop=%d, step=%d, e[len=%d])\n", na, na + nd, 1, ne);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u2));
                                System.out.println("e = " + this.toString(e3));
                            }
                        }
                        u2.setslice(na, na + nd, 1, (PyObject)e3);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u2));
                        }
                        PyByteArrayTest.checkSlice(na, nd, nb, ne, xInts, yInts, u2);
                    }
                }
            }
        }
    }

    public void test__setslice__2() {
        int verbose = 0;
        String ver = "Cet autre affecte tes langueurs";
        int L2 = ver.length();
        int[] uRef = PyByteArrayTest.toInts(ver);
        this.interp = new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 14, 86, 90);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] posStart = new int[]{0, 4, 10, 18, L2 - 9};
        int[] posStop = new int[]{0, 3, 9, 17, L2 - 10, L2};
        for (int start : posStart) {
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L2) : Py.None;
            for (int stop2 : posStop) {
                if (stop2 < start) continue;
                PyObject pyStop_L = stop2 < L2 ? new PyInteger(stop2 - L2) : Py.None;
                PyInteger pyStop = new PyInteger(stop2);
                for (int n2 = 0; n2 <= eRef.length; ++n2) {
                    this.doTest__setslice__2(uRef, pyStart, pyStop, eFull, n2, eRef, start, stop2, verbose + 2);
                    this.doTest__setslice__2(uRef, pyStart_L, pyStop, eFull, n2, eRef, start, stop2, verbose);
                    this.doTest__setslice__2(uRef, pyStart, pyStop_L, eFull, n2, eRef, start, stop2, verbose);
                    this.doTest__setslice__2(uRef, pyStart_L, pyStop_L, eFull, n2, eRef, start, stop2, verbose);
                }
            }
        }
    }

    private void doTest__setslice__2(int[] uRef, PyObject pyStart, PyObject pyStop, BaseBytes eFull, int n2, int[] eRef, int start, int stop2, int verbose) {
        PyByteArray u2 = this.getInstance(uRef);
        BaseBytes e2 = eFull.getslice(0, n2, 1);
        if (verbose >= 4) {
            System.out.printf("    __setslice__(%s,%s,e[0:%d])\n", pyStart, pyStop, n2);
            System.out.println("u = " + this.toString(u2));
            System.out.println("e = " + this.toString(e2));
        }
        u2.__setslice__(pyStart, pyStop, e2);
        if (verbose >= 3) {
            System.out.println("u'= " + this.toString(u2));
        }
        int nd = stop2 - start;
        int nb = uRef.length - stop2;
        PyByteArrayTest.checkSlice(start, nd, nb, n2, uRef, eRef, u2);
    }

    @Override
    public void testSetslice3() {
        int verbose = 0;
        this.interp = new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            int len = uRef.length - start;
            for (int step : posStep) {
                int nmax = (len + step - 1) / step;
                for (int n2 = 1; n2 <= nmax; ++n2) {
                    int last = start + step * (n2 - 1) + 1;
                    for (int stop2 = last + 1; stop2 < last + step; ++stop2) {
                        PyByteArray u2 = this.getInstance(uRef);
                        BaseBytes e2 = ((BaseBytes)eFull).getslice(0, n2, 1);
                        if (verbose >= 2) {
                            System.out.printf("setslice(start=%d, stop=%d, step=%d, e[len=%d])\n", start, stop2, step, n2);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u2));
                                System.out.println("e = " + this.toString(e2));
                            }
                        }
                        u2.setslice(start, stop2, step, (PyObject)e2);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u2));
                        }
                        PyByteArrayTest.checkSlice(start, step, n2, uRef, eRef, u2);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            int len = start + 1;
            for (int step : negStep) {
                int nmax = (len + -step - 1) / -step;
                for (int n3 = 1; n3 <= nmax; ++n3) {
                    int last;
                    for (int stop3 = last = start + step * (n3 - 1) - 1; stop3 > last - -step && stop3 >= 0; --stop3) {
                        PyByteArray u3 = this.getInstance(uRef);
                        BaseBytes e3 = ((BaseBytes)eFull).getslice(0, n3, 1);
                        if (verbose >= 2) {
                            System.out.printf("setslice(start=%d, stop=%d, step=%d, e[len=%d])\n", start, stop3, step, n3);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u3));
                                System.out.println("e = " + this.toString(e3));
                            }
                        }
                        u3.setslice(start, stop3, step, (PyObject)e3);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u3));
                        }
                        PyByteArrayTest.checkSlice(start, step, n3, uRef, eRef, u3);
                    }
                }
            }
        }
    }

    public void test__setslice__3() {
        int verbose = 0;
        this.interp = new PythonInterpreter();
        int[] eRef = PyByteArrayTest.randomInts(this.random, 25, 65, 72);
        BaseBytesTest.MyBytes eFull = new BaseBytesTest.MyBytes(eRef);
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            PyInteger pyStart = new PyInteger(start);
            int len = uRef.length - start;
            for (int step : posStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + step - 1) / step;
                for (int n2 = 1; n2 <= nmax; ++n2) {
                    int last = start + step * (n2 - 1) + 1;
                    for (int stop2 = last + 1; stop2 < last + step; ++stop2) {
                        PyInteger pyStop = new PyInteger(stop2);
                        PyByteArray u2 = this.getInstance(uRef);
                        BaseBytes e2 = ((BaseBytes)eFull).getslice(0, n2, 1);
                        if (verbose >= 2) {
                            System.out.printf("setslice(%d,%d,%d, e[len=%d])\n", start, stop2, step, n2);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u2));
                                System.out.println("e = " + this.toString(e2));
                            }
                        }
                        u2.__setslice__(pyStart, pyStop, pyStep, e2);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u2));
                        }
                        PyByteArrayTest.checkSlice(start, step, n2, uRef, eRef, u2);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            PyInteger pyStart = new PyInteger(start);
            int len = start + 1;
            for (int step : negStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + -step - 1) / -step;
                for (int n3 = 1; n3 <= nmax; ++n3) {
                    int last;
                    for (int stop3 = last = start + step * (n3 - 1) - 1; stop3 > last - -step && stop3 >= 0; --stop3) {
                        PyInteger pyStop = new PyInteger(stop3);
                        PyByteArray u3 = this.getInstance(uRef);
                        BaseBytes e3 = ((BaseBytes)eFull).getslice(0, n3, 1);
                        if (verbose >= 2) {
                            System.out.printf("setslice(%d,%d,%d, e[len=%d])\n", start, stop3, step, n3);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u3));
                                System.out.println("e = " + this.toString(e3));
                            }
                        }
                        u3.__setslice__(pyStart, pyStop, pyStep, e3);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u3));
                        }
                        PyByteArrayTest.checkSlice(start, step, n3, uRef, eRef, u3);
                    }
                }
            }
        }
    }

    public void testSetsliceTime() {
        int verbose = 1;
        this.timeSetslice(50, 100, 7, 14, verbose);
        this.timeSetslice(50, 100, 25, 25, verbose);
        this.timeSetslice(500, 20, 2000, 400, verbose);
    }

    private void timeSetslice(int trials, int repeats, int N2, int M2, int verbose) {
        int[] startList = new int[11];
        for (int i2 = 0; i2 < startList.length; ++i2) {
            startList[i2] = N2 * i2 / (startList.length - 1);
        }
        int[] changeList = new int[11];
        for (int i3 = 0; i3 < changeList.length; ++i3) {
            changeList[i3] = M2 * i3 / (changeList.length - 1);
        }
        long[][] elapsed = new long[startList.length][changeList.length];
        for (int row = 0; row < startList.length; ++row) {
            for (int col = 0; col < changeList.length; ++col) {
                elapsed[row][col] = Long.MAX_VALUE;
            }
        }
        int[] xRef = PyByteArrayTest.randomInts(this.random, N2, 117, 122);
        PyByteArray x2 = this.getInstance(xRef);
        int[] yRef = PyByteArrayTest.randomInts(this.random, M2, 65, 72);
        PyByteArray y2 = this.getInstance(yRef);
        PyByteArray[] u2 = new PyByteArray[repeats];
        for (int trial = 0; trial < trials; ++trial) {
            for (int irow = 0; irow < startList.length; ++irow) {
                int row = (irow + 5 * trial) % startList.length;
                int na = startList[row];
                int nd = 0;
                for (int icol = 0; icol < changeList.length; ++icol) {
                    long t2;
                    int col = (icol + trial) % changeList.length;
                    int ne = changeList[col];
                    int start = na;
                    int stop2 = na + nd;
                    PyByteArray e2 = y2.getslice(0, ne, 1);
                    if (trial == 0) {
                        this.doTimeSetslice(u2, start, stop2, e2, x2, verbose);
                        PyByteArrayTest.checkSlice(na, nd, N2 - (na + nd), ne, xRef, yRef, u2[0]);
                    }
                    if ((t2 = this.doTimeSetslice(u2, start, stop2, e2, x2, -1)) >= elapsed[row][col]) continue;
                    elapsed[row][col] = t2;
                }
            }
        }
        if (verbose >= 1) {
            System.out.print("     N  ,     na  ");
            for (int col = 0; col < changeList.length; ++col) {
                System.out.printf(", ne=%7d", changeList[col]);
            }
            System.out.println(", elements inserted: time in microseconds.");
            for (int row = 0; row < startList.length; ++row) {
                System.out.printf("%8d, %8d", N2, startList[row]);
                for (int col = 0; col < changeList.length; ++col) {
                    double usPerCall = 0.001 * (double)elapsed[row][col] / (double)repeats;
                    System.out.printf(", %10.3f", usPerCall);
                }
                System.out.println();
            }
        }
    }

    private long doTimeSetslice(PyByteArray[] u2, int start, int stop2, BaseBytes e2, BaseBytes x2, int verbose) {
        int repeats = 1;
        if (verbose < 0) {
            repeats = u2.length;
        }
        for (int i2 = 0; i2 < repeats; ++i2) {
            u2[i2] = new PyByteArray(x2);
        }
        PyByteArray v2 = u2[0];
        byte[] oldStorage = v2.storage;
        if (verbose >= 3) {
            System.out.printf("setslice(%d,%d,%d,e[%d])\n", start, stop2, 1, e2.size());
            System.out.println("u = " + this.toString(v2));
            System.out.println("e = " + this.toString(e2));
        }
        long beginTime = System.nanoTime();
        for (int i3 = 0; i3 < repeats; ++i3) {
            u2[i3].setslice(start, stop2, 1, (PyObject)e2);
        }
        long t2 = System.nanoTime() - beginTime;
        if (verbose >= 2) {
            boolean avAlloc;
            boolean bl = avAlloc = v2.storage != oldStorage;
            if (v2.size * 2 <= oldStorage.length) {
                avAlloc = false;
            }
            if (v2.size > oldStorage.length) {
                avAlloc = false;
            }
            System.out.println("u'= " + this.toString(v2) + (avAlloc ? " new" : ""));
        }
        return t2;
    }

    public void testDelslice2() {
        int verbose = 0;
        int[] naList = new int[]{2, 5, 0};
        int[] ndList = new int[]{5, 20, 0};
        int[] nbList = new int[]{4, 7, 0};
        for (int nd : ndList) {
            for (int na : naList) {
                for (int nb : nbList) {
                    int[] aRef = PyByteArrayTest.adbInts(na, nd, nb);
                    int[] bRef = PyByteArrayTest.aebInts(na, 0, nb);
                    PyByteArray b2 = this.getInstance(aRef);
                    byte[] oldStorage = b2.storage;
                    if (verbose >= 2) {
                        System.out.printf("delslice(%d,%d,%d,%d)\n", na, na + nd, 1, nd);
                        if (verbose >= 3) {
                            System.out.println(this.toString(b2));
                        }
                    }
                    b2.delslice(na, na + nd, 1, nd);
                    if (verbose >= 2) {
                        boolean avAlloc;
                        boolean bl = avAlloc = b2.storage != oldStorage;
                        if (bRef.length * 2 <= oldStorage.length) {
                            avAlloc = false;
                        }
                        System.out.println(this.toString(b2) + (avAlloc ? " avoidable new" : ""));
                    }
                    PyByteArrayTest.checkInts(bRef, (BaseBytes)b2);
                }
            }
        }
        int AMAX = 7;
        int BMAX = 7;
        int DMAX = 25;
        int[] xInts = PyByteArrayTest.randomInts(this.random, 39, 117, 122);
        PyByteArray x2 = this.getInstance(xInts);
        int[] nbList2 = new int[]{0, 1, 7};
        for (int na = 0; na <= 7; ++na) {
            for (int nb : nbList2) {
                for (int nd = 0; nd < 25; ++nd) {
                    PyByteArray u2 = x2.getslice(0, na + nd + nb, 1);
                    if (verbose >= 2) {
                        System.out.printf("delslice(start=%d, stop=%d, step=%d, n=%d)\n", na, na + nd, 1, nd);
                        if (verbose >= 3) {
                            System.out.println("u = " + this.toString(u2));
                        }
                    }
                    u2.delslice(na, na + nd, 1, nd);
                    if (verbose >= 1) {
                        System.out.println("u'= " + this.toString(u2));
                    }
                    PyByteArrayTest.checkSlice(na, nd, nb, 0, xInts, null, u2);
                }
            }
        }
    }

    public void test__delslice__2() {
        int verbose = 0;
        String ver = "Et tes p\u00e2leurs, alors que lasse,";
        int L2 = ver.length();
        int[] uRef = PyByteArrayTest.toInts(ver);
        this.interp = new PythonInterpreter();
        int[] posStart = new int[]{0, 3, 7, 16, L2 - 1};
        int[] posStop = new int[]{0, 3, 7, 16, L2 - 6, L2};
        for (int start : posStart) {
            PyInteger pyStart = new PyInteger(start);
            PyObject pyStart_L = start > 0 ? new PyInteger(start - L2) : Py.None;
            for (int stop2 : posStop) {
                if (stop2 < start) continue;
                PyObject pyStop_L = stop2 < L2 ? new PyInteger(stop2 - L2) : Py.None;
                PyInteger pyStop = new PyInteger(stop2);
                this.doTest__delslice__2(uRef, pyStart, pyStop, start, stop2, verbose + 2);
                this.doTest__delslice__2(uRef, pyStart_L, pyStop, start, stop2, verbose);
                this.doTest__delslice__2(uRef, pyStart, pyStop_L, start, stop2, verbose);
                this.doTest__delslice__2(uRef, pyStart_L, pyStop_L, start, stop2, verbose);
            }
        }
    }

    private void doTest__delslice__2(int[] uRef, PyObject pyStart, PyObject pyStop, int start, int stop2, int verbose) {
        PyByteArray u2 = this.getInstance(uRef);
        if (verbose >= 4) {
            System.out.printf("    __delslice__(%s,%s,1)\n", pyStart, pyStop);
            System.out.println("u = " + this.toString(u2));
        }
        u2.__delslice__(pyStart, pyStop);
        if (verbose >= 3) {
            System.out.println("u'= " + this.toString(u2));
        }
        int nd = stop2 - start;
        int nb = uRef.length - stop2;
        PyByteArrayTest.checkSlice(start, nd, nb, 0, uRef, null, u2);
    }

    public void test__delslice__3() {
        int verbose = 0;
        this.interp = new PythonInterpreter();
        int[] uRef = PyByteArrayTest.randomInts(this.random, 25, 109, 115);
        int[] posStep = new int[]{2, 3, 5, 8, 25, 100};
        for (int start = 0; start < uRef.length; ++start) {
            PyInteger pyStart = new PyInteger(start);
            int len = uRef.length - start;
            for (int step : posStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + step - 1) / step;
                for (int n2 = 1; n2 <= nmax; ++n2) {
                    int last = start + step * (n2 - 1) + 1;
                    for (int stop2 = last + 1; stop2 < last + step; ++stop2) {
                        PyInteger pyStop = new PyInteger(stop2);
                        PyByteArray u2 = this.getInstance(uRef);
                        if (verbose >= 2) {
                            System.out.printf("__delslice__(%d,%d,%d) (%d deletions)\n", start, stop2, step, n2);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u2));
                            }
                        }
                        u2.__delslice__(pyStart, pyStop, pyStep);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u2));
                        }
                        PyByteArrayTest.checkDelSlice(start, step, n2, uRef, u2);
                    }
                }
            }
        }
        int[] negStep = new int[]{-1, -2, -5, -8, -25, -100};
        for (int start = uRef.length - 1; start >= 0; --start) {
            PyInteger pyStart = new PyInteger(start);
            int len = start + 1;
            for (int step : negStep) {
                PyInteger pyStep = new PyInteger(step);
                int nmax = (len + -step - 1) / -step;
                for (int n3 = 1; n3 <= nmax; ++n3) {
                    int last;
                    for (int stop3 = last = start + step * (n3 - 1) - 1; stop3 > last - -step && stop3 >= 0; --stop3) {
                        PyInteger pyStop = new PyInteger(stop3);
                        PyByteArray u3 = this.getInstance(uRef);
                        if (verbose >= 2) {
                            System.out.printf("__delslice__(%d,%d,%d) (%d deletions)\n", start, stop3, step, n3);
                            if (verbose >= 3) {
                                System.out.println("u = " + this.toString(u3));
                            }
                        }
                        u3.__delslice__(pyStart, pyStop, pyStep);
                        if (verbose >= 1) {
                            System.out.println("u'= " + this.toString(u3));
                        }
                        PyByteArrayTest.checkDelSlice(start, step, n3, uRef, u3);
                    }
                }
            }
        }
    }

    public void testDelsliceTime3() {
        int verbose = 1;
        this.timeDelslice3(50, 100, 7, verbose);
        this.timeDelslice3(50, 100, 25, verbose);
        this.timeDelslice3(20, 4, 2000, verbose);
    }

    private void timeDelslice3(int trials, int repeats, int N2, int verbose) {
        int[] startList = new int[10];
        for (int i2 = 0; i2 < startList.length; ++i2) {
            startList[i2] = N2 * i2 / startList.length;
        }
        int[] posStep = new int[]{1, 2, 3, 5, 10};
        int[] stepList = new int[2 * posStep.length];
        for (int i3 = 0; i3 < posStep.length; ++i3) {
            stepList[posStep.length - i3 - 1] = posStep[i3];
            stepList[posStep.length + i3] = -posStep[i3];
        }
        long[][] elapsed = new long[startList.length][stepList.length];
        for (int row = 0; row < startList.length; ++row) {
            for (int col = 0; col < stepList.length; ++col) {
                elapsed[row][col] = Long.MAX_VALUE;
            }
        }
        int[] xRef = PyByteArrayTest.randomInts(this.random, N2, 117, 122);
        PyByteArray x2 = this.getInstance(xRef);
        PyByteArray[] u2 = new PyByteArray[repeats];
        for (int trial = 0; trial < trials; ++trial) {
            for (int irow = 0; irow < startList.length; ++irow) {
                int row = (irow + 5 * trial) % startList.length;
                int start = startList[row];
                for (int icol = 0; icol < stepList.length; ++icol) {
                    long t2;
                    int col = (icol + trial) % stepList.length;
                    int step = stepList[col];
                    int n2 = step > 0 ? (xRef.length - start + step - 1) / step : (start + -step) / -step;
                    PyInteger pyStart = new PyInteger(start);
                    PyObject pyStop = Py.None;
                    PyInteger pyStep = new PyInteger(step);
                    if (trial == 0) {
                        this.doTimeDelslice3(u2, pyStart, pyStop, pyStep, x2, verbose);
                        PyByteArrayTest.checkDelSlice(start, step, n2, xRef, u2[0]);
                    }
                    if ((t2 = this.doTimeDelslice3(u2, pyStart, pyStop, pyStep, x2, -1)) >= elapsed[row][col]) continue;
                    elapsed[row][col] = t2;
                }
            }
        }
        System.out.print("     N  ,    start");
        for (int col = 0; col < stepList.length; ++col) {
            System.out.printf(", step=%5d", stepList[col]);
        }
        System.out.println(", deletion time in microseconds.");
        for (int row = 0; row < startList.length; ++row) {
            System.out.printf("%8d, %8d", N2, startList[row]);
            for (int col = 0; col < stepList.length; ++col) {
                double usPerCall = 0.001 * (double)elapsed[row][col] / (double)repeats;
                System.out.printf(", %10.3f", usPerCall);
            }
            System.out.println();
        }
    }

    private long doTimeDelslice3(PyByteArray[] u2, PyObject pyStart, PyObject pyStop, PyObject pyStep, BaseBytes x2, int verbose) {
        int repeats = 1;
        if (verbose < 0) {
            repeats = u2.length;
        }
        for (int i2 = 0; i2 < repeats; ++i2) {
            u2[i2] = new PyByteArray(x2);
        }
        PyByteArray v2 = u2[0];
        byte[] oldStorage = v2.storage;
        if (verbose >= 3) {
            System.out.printf("__delslice__(%s,%s,%s)\n", pyStart, pyStop, pyStep);
            System.out.println("u = " + this.toString(v2));
        }
        long beginTime = System.nanoTime();
        for (int i3 = 0; i3 < repeats; ++i3) {
            u2[i3].__delslice__(pyStart, pyStop, pyStep);
        }
        long t2 = System.nanoTime() - beginTime;
        if (verbose >= 2) {
            boolean avAlloc;
            boolean bl = avAlloc = v2.storage != oldStorage;
            if (v2.size * 2 <= oldStorage.length) {
                avAlloc = false;
            }
            if (v2.size > oldStorage.length) {
                avAlloc = false;
            }
            System.out.println("u'= " + this.toString(v2) + (avAlloc ? " new" : ""));
        }
        return t2;
    }

    @Override
    public PyByteArray getInstance(PyType type) {
        return new PyByteArray(type);
    }

    @Override
    public PyByteArray getInstance() {
        return new PyByteArray();
    }

    @Override
    public PyByteArray getInstance(int size) {
        return new PyByteArray(size);
    }

    @Override
    public PyByteArray getInstance(int[] value) {
        return new PyByteArray(value);
    }

    @Override
    public PyByteArray getInstance(BaseBytes source) {
        return new PyByteArray(source);
    }

    @Override
    public PyByteArray getInstance(Iterable<? extends PyObject> source) {
        return new PyByteArray(source);
    }

    @Override
    public PyByteArray getInstance(PyString arg, PyObject encoding, PyObject errors) {
        return new PyByteArray(arg, encoding, errors);
    }

    @Override
    public PyByteArray getInstance(PyString arg, String encoding, String errors) {
        return new PyByteArray(arg, encoding, errors);
    }

    @Override
    public PyByteArray getInstance(PyObject arg) throws PyException {
        return new PyByteArray(arg);
    }
}

