/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.IOException;
import java.io.Writer;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;

@Untraversable
public class PyFileWriter
extends PyObject {
    private final Writer writer;
    private boolean closed;
    public boolean softspace = false;

    public PyFileWriter(Writer writer) {
        this.writer = writer;
        this.closed = false;
    }

    public boolean closed() {
        return this.closed;
    }

    public void checkClosed() {
        if (this.closed()) {
            throw Py.ValueError("I/O operation on closed file");
        }
    }

    public synchronized void flush() {
        this.checkClosed();
        try {
            this.writer.flush();
        }
        catch (IOException e2) {
            throw Py.IOError(e2);
        }
    }

    public void close() {
        try {
            this.writer.close();
            this.closed = true;
        }
        catch (IOException e2) {
            throw Py.IOError(e2);
        }
    }

    public void write(PyObject o2) {
        if (o2 instanceof PyUnicode) {
            this.write(((PyUnicode)o2).getString());
        } else if (o2 instanceof PyString) {
            this.write(((PyString)o2).getString());
        } else {
            throw Py.TypeError("write requires a string as its argument");
        }
    }

    public synchronized void write(String s2) {
        this.checkClosed();
        try {
            this.writer.write(s2);
        }
        catch (IOException e2) {
            throw Py.IOError(e2);
        }
    }

    public synchronized void writelines(PyObject a2) {
        this.checkClosed();
        PyObject iter2 = Py.iter(a2, "writelines() requires an iterable argument");
        PyObject item = null;
        while ((item = iter2.__iternext__()) != null) {
            if (!(item instanceof PyString)) {
                throw Py.TypeError("writelines() argument must be a sequence of strings");
            }
            this.write(item);
        }
    }
}

