/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.Serializable;
import java.math.BigInteger;
import org.python.core.ArgParser;
import org.python.core.Options;
import org.python.core.Py;
import org.python.core.PyBoolean;
import org.python.core.PyByteArray;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger$PyExposer;
import org.python.core.PyIntegerDerived;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.stringlib.FloatFormatter;
import org.python.core.stringlib.IntegerFormatter;
import org.python.core.stringlib.InternalFormat;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="int", doc="int(x[, base]) -> integer\n\nConvert a string or number to an integer, if possible.  A floating point\nargument will be truncated towards zero (this does not include a string\nrepresentation of a floating point number!)  When converting a string, use\nthe optional base.  It is an error to supply a base when converting a\nnon-string.  If base is zero, the proper base is guessed based on the\nstring content.  If the argument is outside the integer range a\nlong object will be returned instead.")
public class PyInteger
extends PyObject {
    public static final PyType TYPE;
    public static final BigInteger MIN_INT;
    public static final BigInteger MAX_INT;
    @Deprecated
    public static final BigInteger minInt;
    @Deprecated
    public static final BigInteger maxInt;
    private static final String LOOKUP = "0123456789abcdef";
    private final int value;

    public PyInteger(PyType subType, int v2) {
        super(subType);
        this.value = v2;
    }

    public PyInteger(int v2) {
        this(TYPE, v2);
    }

    @ExposedNew
    public static PyObject int_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("int", args, keywords, new String[]{"x", "base"}, 0);
        PyObject x2 = ap.getPyObject(0, null);
        int base = ap.getInt(1, -909);
        if (new_.for_type == subtype) {
            if (x2 == null) {
                return Py.Zero;
            }
            if (base == -909) {
                if (x2 instanceof PyBoolean) {
                    return PyInteger.coerce(x2) == 0 ? Py.Zero : Py.One;
                }
                if (x2 instanceof PyByteArray) {
                    PyString xs = new PyString(x2.asString());
                    return PyInteger.asPyInteger(xs);
                }
                return PyInteger.asPyInteger(x2);
            }
            if (!(x2 instanceof PyString)) {
                throw Py.TypeError("int: can't convert non-string with explicit base");
            }
            try {
                return Py.newInteger(((PyString)x2).atoi(base));
            }
            catch (PyException pye) {
                if (pye.match(Py.OverflowError)) {
                    return ((PyString)x2).atol(base);
                }
                throw pye;
            }
        }
        if (x2 == null) {
            return new PyIntegerDerived(subtype, 0);
        }
        if (base == -909) {
            PyObject intOrLong = PyInteger.asPyInteger(x2);
            if (intOrLong instanceof PyInteger) {
                return new PyIntegerDerived(subtype, ((PyInteger)intOrLong).getValue());
            }
            throw Py.OverflowError("long int too large to convert to int");
        }
        if (!(x2 instanceof PyString)) {
            throw Py.TypeError("int: can't convert non-string with explicit base");
        }
        return new PyIntegerDerived(subtype, ((PyString)x2).atoi(base));
    }

    private static PyObject asPyInteger(PyObject x2) throws PyException {
        try {
            return x2.__int__();
        }
        catch (PyException pye) {
            if (!pye.match(Py.AttributeError)) {
                throw pye;
            }
            try {
                PyObject integral = x2.invoke("__trunc__");
                return PyInteger.convertIntegralToInt(integral);
            }
            catch (PyException pye2) {
                if (!pye2.match(Py.AttributeError)) {
                    throw pye2;
                }
                String fmt = "int() argument must be a string or a number, not '%.200s'";
                throw Py.TypeError(String.format(fmt, x2));
            }
        }
    }

    private static PyObject convertIntegralToInt(PyObject integral) {
        if (!(integral instanceof PyInteger) && !(integral instanceof PyLong)) {
            PyObject i2 = integral.invoke("__int__");
            if (!(i2 instanceof PyInteger) && !(i2 instanceof PyLong)) {
                throw Py.TypeError(String.format("__trunc__ returned non-Integral (type %.200s)", integral.getType().fastGetName()));
            }
            return i2;
        }
        return integral;
    }

    public PyObject getReal() {
        return this.int___int__();
    }

    public PyObject getImag() {
        return Py.newInteger(0);
    }

    public PyObject getNumerator() {
        return this.int___int__();
    }

    public PyObject getDenominator() {
        return Py.newInteger(1);
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return this.int_toString();
    }

    final String int_toString() {
        return Integer.toString(this.getValue());
    }

    @Override
    public int hashCode() {
        return this.int_hashCode();
    }

    final int int_hashCode() {
        return this.getValue();
    }

    @Override
    public boolean __nonzero__() {
        return this.int___nonzero__();
    }

    final boolean int___nonzero__() {
        return this.getValue() != 0;
    }

    @Override
    public Object __tojava__(Class<?> c2) {
        if (c2 == Integer.TYPE || c2 == Number.class || c2 == Object.class || c2 == Integer.class || c2 == Serializable.class) {
            return new Integer(this.getValue());
        }
        if (c2 == Boolean.TYPE || c2 == Boolean.class) {
            return new Boolean(this.getValue() != 0);
        }
        if (c2 == Byte.TYPE || c2 == Byte.class) {
            return new Byte((byte)this.getValue());
        }
        if (c2 == Short.TYPE || c2 == Short.class) {
            return new Short((short)this.getValue());
        }
        if (c2 == Long.TYPE || c2 == Long.class) {
            return new Long(this.getValue());
        }
        if (c2 == Float.TYPE || c2 == Float.class) {
            return new Float(this.getValue());
        }
        if (c2 == Double.TYPE || c2 == Double.class) {
            return new Double(this.getValue());
        }
        return super.__tojava__(c2);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.int___cmp__(other);
    }

    final int int___cmp__(PyObject other) {
        if (!PyInteger.canCoerce(other)) {
            return -2;
        }
        int v2 = PyInteger.coerce(other);
        return this.getValue() < v2 ? -1 : (this.getValue() > v2 ? 1 : 0);
    }

    @Override
    public Object __coerce_ex__(PyObject other) {
        return this.int___coerce_ex__(other);
    }

    final PyObject int___coerce__(PyObject other) {
        return this.adaptToCoerceTuple(this.int___coerce_ex__(other));
    }

    final Object int___coerce_ex__(PyObject other) {
        return other instanceof PyInteger ? other : Py.None;
    }

    private static final boolean canCoerce(PyObject other) {
        return other instanceof PyInteger;
    }

    private static final int coerce(PyObject other) {
        if (other instanceof PyInteger) {
            return ((PyInteger)other).getValue();
        }
        throw Py.TypeError("xxx");
    }

    @Override
    public PyObject __add__(PyObject right) {
        return this.int___add__(right);
    }

    final PyObject int___add__(PyObject right) {
        int b2;
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int a2 = this.getValue();
        int x2 = a2 + (b2 = rightv);
        if ((x2 ^ a2) >= 0 || (x2 ^ b2) >= 0) {
            return Py.newInteger(x2);
        }
        return new PyLong((long)a2 + (long)b2);
    }

    @Override
    public PyObject __radd__(PyObject left) {
        return this.int___radd__(left);
    }

    final PyObject int___radd__(PyObject left) {
        return this.__add__(left);
    }

    private static PyObject _sub(int a2, int b2) {
        int x2 = a2 - b2;
        if ((x2 ^ a2) >= 0 || (x2 ^ ~b2) >= 0) {
            return Py.newInteger(x2);
        }
        return new PyLong((long)a2 - (long)b2);
    }

    @Override
    public PyObject __sub__(PyObject right) {
        return this.int___sub__(right);
    }

    final PyObject int___sub__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return PyInteger._sub(this.getValue(), PyInteger.coerce(right));
    }

    @Override
    public PyObject __rsub__(PyObject left) {
        return this.int___rsub__(left);
    }

    final PyObject int___rsub__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._sub(PyInteger.coerce(left), this.getValue());
    }

    @Override
    public PyObject __mul__(PyObject right) {
        return this.int___mul__(right);
    }

    final PyObject int___mul__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        double x2 = this.getValue();
        if ((x2 *= (double)rightv) <= 2.147483647E9 && x2 >= -2.147483648E9) {
            return Py.newInteger((int)x2);
        }
        return this.__long__().__mul__(right);
    }

    @Override
    public PyObject __rmul__(PyObject left) {
        return this.int___rmul__(left);
    }

    final PyObject int___rmul__(PyObject left) {
        return this.__mul__(left);
    }

    private static long divide(long x2, long y2) {
        if (y2 == 0L) {
            throw Py.ZeroDivisionError("integer division or modulo by zero");
        }
        long xdivy = x2 / y2;
        long xmody = x2 - xdivy * y2;
        if (xmody != 0L && (y2 < 0L && xmody > 0L || y2 > 0L && xmody < 0L)) {
            xmody += y2;
            --xdivy;
        }
        return xdivy;
    }

    @Override
    public PyObject __div__(PyObject right) {
        return this.int___div__(right);
    }

    final PyObject int___div__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        if (Options.division_warning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rdiv__(PyObject left) {
        return this.int___rdiv__(left);
    }

    final PyObject int___rdiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        if (Options.division_warning > 0) {
            Py.warning(Py.DeprecationWarning, "classic int division");
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __floordiv__(PyObject right) {
        return this.int___floordiv__(right);
    }

    final PyObject int___floordiv__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(this.getValue(), PyInteger.coerce(right)));
    }

    @Override
    public PyObject __rfloordiv__(PyObject left) {
        return this.int___rfloordiv__(left);
    }

    final PyObject int___rfloordiv__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return Py.newInteger(PyInteger.divide(PyInteger.coerce(left), this.getValue()));
    }

    @Override
    public PyObject __truediv__(PyObject right) {
        return this.int___truediv__(right);
    }

    final PyObject int___truediv__(PyObject right) {
        if (right instanceof PyInteger) {
            return this.__float__().__truediv__(right);
        }
        if (right instanceof PyLong) {
            return this.int___long__().__truediv__(right);
        }
        return null;
    }

    @Override
    public PyObject __rtruediv__(PyObject left) {
        return this.int___rtruediv__(left);
    }

    final PyObject int___rtruediv__(PyObject left) {
        if (left instanceof PyInteger) {
            return left.__float__().__truediv__(this);
        }
        if (left instanceof PyLong) {
            return left.__truediv__(this.int___long__());
        }
        return null;
    }

    private static long modulo(long x2, long y2, long xdivy) {
        return x2 - xdivy * y2;
    }

    @Override
    public PyObject __mod__(PyObject right) {
        return this.int___mod__(right);
    }

    final PyObject int___mod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v2 = this.getValue();
        return Py.newInteger(PyInteger.modulo(v2, rightv, PyInteger.divide(v2, rightv)));
    }

    @Override
    public PyObject __rmod__(PyObject left) {
        return this.int___rmod__(left);
    }

    final PyObject int___rmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v2 = this.getValue();
        return Py.newInteger(PyInteger.modulo(leftv, v2, PyInteger.divide(leftv, v2)));
    }

    @Override
    public PyObject __divmod__(PyObject right) {
        return this.int___divmod__(right);
    }

    final PyObject int___divmod__(PyObject right) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        int rightv = PyInteger.coerce(right);
        int v2 = this.getValue();
        long xdivy = PyInteger.divide(v2, rightv);
        return new PyTuple(Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(v2, rightv, xdivy)));
    }

    final PyObject int___rdivmod__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        int leftv = PyInteger.coerce(left);
        int v2 = this.getValue();
        long xdivy = PyInteger.divide(leftv, v2);
        return new PyTuple(Py.newInteger(xdivy), Py.newInteger(PyInteger.modulo(leftv, v2, xdivy)));
    }

    @Override
    public PyObject __pow__(PyObject right, PyObject modulo) {
        return this.int___pow__(right, modulo);
    }

    final PyObject int___pow__(PyObject right, PyObject modulo) {
        if (!PyInteger.canCoerce(right)) {
            return null;
        }
        PyObject pyObject = modulo = modulo == Py.None ? null : modulo;
        if (modulo != null && !PyInteger.canCoerce(modulo)) {
            return null;
        }
        return PyInteger._pow(this.getValue(), PyInteger.coerce(right), modulo, this, right);
    }

    @Override
    public PyObject __rpow__(PyObject left) {
        if (!PyInteger.canCoerce(left)) {
            return null;
        }
        return PyInteger._pow(PyInteger.coerce(left), this.getValue(), null, left, this);
    }

    final PyObject int___rpow__(PyObject left) {
        return this.__rpow__(left);
    }

    private static PyObject _pow(int value, int pow, PyObject modulo, PyObject left, PyObject right) {
        int mod2 = 0;
        long tmp = value;
        boolean neg = false;
        if (tmp < 0L) {
            tmp = -tmp;
            neg = (pow & 1) != 0;
        }
        long result = 1L;
        if (pow < 0) {
            if (value != 0) {
                return left.__float__().__pow__(right, modulo);
            }
            throw Py.ZeroDivisionError("0.0 cannot be raised to a negative power");
        }
        if (modulo != null && (mod2 = PyInteger.coerce(modulo)) == 0) {
            throw Py.ValueError("pow(x, y, z) with z==0");
        }
        while (pow > 0) {
            if ((pow & 1) != 0) {
                result *= tmp;
                if (mod2 != 0) {
                    result %= (long)mod2;
                }
                if (result > Integer.MAX_VALUE) {
                    return left.__long__().__pow__(right, modulo);
                }
            }
            if ((pow >>= 1) == 0) break;
            tmp *= tmp;
            if (mod2 != 0) {
                tmp %= (long)mod2;
            }
            if (tmp <= Integer.MAX_VALUE) continue;
            return left.__long__().__pow__(right, modulo);
        }
        if (neg) {
            result = -result;
        }
        if (mod2 != 0) {
            result = PyInteger.modulo(result, mod2, PyInteger.divide(result, mod2));
        }
        return Py.newInteger(result);
    }

    @Override
    public PyObject __lshift__(PyObject right) {
        return this.int___lshift__(right);
    }

    final PyObject int___lshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__lshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv >= 32) {
            return this.__long__().__lshift__(right);
        }
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        int result = this.getValue() << rightv;
        if (this.getValue() != result >> rightv) {
            return this.__long__().__lshift__(right);
        }
        return Py.newInteger(result);
    }

    final PyObject int___rlshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rlshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() >= 32) {
            return left.__long__().__lshift__(this);
        }
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        int result = leftv << this.getValue();
        if (leftv != result >> this.getValue()) {
            return left.__long__().__lshift__(this);
        }
        return Py.newInteger(result);
    }

    @Override
    public PyObject __rshift__(PyObject right) {
        return this.int___rshift__(right);
    }

    final PyObject int___rshift__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__rshift__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        if (rightv < 0) {
            throw Py.ValueError("negative shift count");
        }
        if (rightv >= 32) {
            return Py.newInteger(this.getValue() < 0 ? -1 : 0);
        }
        return Py.newInteger(this.getValue() >> rightv);
    }

    final PyObject int___rrshift__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rshift__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        if (this.getValue() < 0) {
            throw Py.ValueError("negative shift count");
        }
        if (this.getValue() >= 32) {
            return Py.newInteger(leftv < 0 ? -1 : 0);
        }
        return Py.newInteger(leftv >> this.getValue());
    }

    @Override
    public PyObject __and__(PyObject right) {
        return this.int___and__(right);
    }

    final PyObject int___and__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__and__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() & rightv);
    }

    final PyObject int___rand__(PyObject left) {
        return this.int___and__(left);
    }

    @Override
    public PyObject __xor__(PyObject right) {
        return this.int___xor__(right);
    }

    final PyObject int___xor__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__xor__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() ^ rightv);
    }

    final PyObject int___rxor__(PyObject left) {
        if (!(left instanceof PyInteger)) {
            if (left instanceof PyLong) {
                return left.__rxor__(this.int___long__());
            }
            return null;
        }
        int leftv = ((PyInteger)left).getValue();
        return Py.newInteger(leftv ^ this.getValue());
    }

    @Override
    public PyObject __or__(PyObject right) {
        return this.int___or__(right);
    }

    final PyObject int___or__(PyObject right) {
        if (!(right instanceof PyInteger)) {
            if (right instanceof PyLong) {
                return this.int___long__().__or__(right);
            }
            return null;
        }
        int rightv = ((PyInteger)right).getValue();
        return Py.newInteger(this.getValue() | rightv);
    }

    final PyObject int___ror__(PyObject left) {
        return this.int___or__(left);
    }

    @Override
    public PyObject __neg__() {
        return this.int___neg__();
    }

    final PyObject int___neg__() {
        long x2 = this.getValue();
        long result = -x2;
        if (x2 < 0L && result == x2) {
            return new PyLong(x2).__neg__();
        }
        return Py.newInteger(result);
    }

    @Override
    public PyObject __pos__() {
        return this.int___pos__();
    }

    final PyObject int___pos__() {
        return this.int___int__();
    }

    @Override
    public PyObject __abs__() {
        return this.int___abs__();
    }

    final PyObject int___abs__() {
        if (this.getValue() < 0) {
            return this.int___neg__();
        }
        return this.int___int__();
    }

    @Override
    public PyObject __invert__() {
        return this.int___invert__();
    }

    final PyObject int___invert__() {
        return Py.newInteger(~this.getValue());
    }

    @Override
    public PyObject __int__() {
        return this.int___int__();
    }

    final PyInteger int___int__() {
        return this.getType() == TYPE ? this : Py.newInteger(this.getValue());
    }

    @Override
    public PyObject __long__() {
        return this.int___long__();
    }

    final PyObject int___long__() {
        return new PyLong(this.getValue());
    }

    @Override
    public PyFloat __float__() {
        return this.int___float__();
    }

    final PyFloat int___float__() {
        return new PyFloat((double)this.getValue());
    }

    @Override
    public PyObject __trunc__() {
        return this.int___trunc__();
    }

    final PyObject int___trunc__() {
        return this;
    }

    @Override
    public PyObject conjugate() {
        return this.int_conjugate();
    }

    final PyObject int_conjugate() {
        return this;
    }

    @Override
    public PyComplex __complex__() {
        return new PyComplex(this.getValue(), 0.0);
    }

    @Override
    public PyString __oct__() {
        return this.int___oct__();
    }

    final PyString int___oct__() {
        return this.formatImpl(IntegerFormatter.OCT);
    }

    @Override
    public PyString __hex__() {
        return this.int___hex__();
    }

    final PyString int___hex__() {
        return this.formatImpl(IntegerFormatter.HEX);
    }

    private PyString formatImpl(InternalFormat.Spec spec) {
        IntegerFormatter.Traditional f2 = new IntegerFormatter.Traditional(spec);
        f2.format(this.value);
        return new PyString(f2.getResult());
    }

    final PyTuple int___getnewargs__() {
        return new PyTuple(new PyInteger(this.getValue()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.int___getnewargs__();
    }

    @Override
    public PyObject __index__() {
        return this.int___index__();
    }

    final PyObject int___index__() {
        return this;
    }

    @Override
    public int bit_length() {
        return this.int_bit_length();
    }

    final int int_bit_length() {
        int v2 = this.value;
        if (v2 < 0) {
            v2 = -v2;
        }
        return BigInteger.valueOf(v2).bitLength();
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.int___format__(formatSpec);
    }

    final PyObject int___format__(PyObject formatSpec) {
        InternalFormat.Formatter f2;
        InternalFormat.Spec spec = InternalFormat.fromText(formatSpec, "__format__");
        IntegerFormatter fi = PyInteger.prepareFormatter(spec);
        if (fi != null) {
            fi.setBytes(!(formatSpec instanceof PyUnicode));
            fi.format(this.value);
            f2 = fi;
        } else {
            FloatFormatter ff = PyFloat.prepareFormatter(spec);
            if (ff != null) {
                ff.setBytes(!(formatSpec instanceof PyUnicode));
                ff.format(this.value);
                f2 = ff;
            } else {
                throw InternalFormat.Formatter.unknownFormat(spec.type, "integer");
            }
        }
        return f2.pad().getPyResult();
    }

    static IntegerFormatter prepareFormatter(InternalFormat.Spec spec) throws PyException {
        switch (spec.type) {
            case 'c': {
                if (InternalFormat.Spec.specified(spec.sign)) {
                    throw IntegerFormatter.signNotAllowed("integer", spec.type);
                }
                if (spec.alternate) {
                    throw IntegerFormatter.alternateFormNotAllowed("integer", spec.type);
                }
            }
            case 'X': 
            case 'b': 
            case 'n': 
            case 'o': 
            case 'x': {
                if (spec.grouping) {
                    throw IntegerFormatter.notAllowed("Grouping", "integer", spec.type);
                }
            }
            case 'd': 
            case '\uffff': {
                if (InternalFormat.Spec.specified(spec.precision)) {
                    throw IntegerFormatter.precisionNotAllowed("integer");
                }
                spec = spec.withDefaults(InternalFormat.Spec.NUMERIC);
                return new IntegerFormatter(spec);
            }
        }
        return null;
    }

    @Override
    public boolean isIndex() {
        return true;
    }

    @Override
    public int asIndex(PyObject err) {
        return this.getValue();
    }

    @Override
    public boolean isMappingType() {
        return false;
    }

    @Override
    public boolean isNumberType() {
        return true;
    }

    @Override
    public boolean isSequenceType() {
        return false;
    }

    @Override
    public long asLong(int index) {
        return this.getValue();
    }

    @Override
    public int asInt(int index) {
        return this.getValue();
    }

    @Override
    public int asInt() {
        return this.getValue();
    }

    @Override
    public long asLong() {
        return this.getValue();
    }

    static {
        PyType.addBuilder(PyInteger.class, new PyInteger$PyExposer());
        TYPE = PyType.fromClass(PyInteger.class);
        MIN_INT = BigInteger.valueOf(Integer.MIN_VALUE);
        MAX_INT = BigInteger.valueOf(Integer.MAX_VALUE);
        minInt = MIN_INT;
        maxInt = MAX_INT;
    }
}

