/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySlice$PyExposer;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Traverseproc;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@ExposedType(name="slice", isBaseType=false, doc="slice([start,] stop[, step])\n\nCreate a slice object.  This is used for extended slicing (e.g. a[0:10:2]).")
public class PySlice
extends PyObject
implements Traverseproc {
    public static final PyType TYPE;
    public PyObject start = Py.None;
    public PyObject stop = Py.None;
    public PyObject step = Py.None;

    public PySlice() {
        super(TYPE);
    }

    public PySlice(PyObject start, PyObject stop2, PyObject step) {
        super(TYPE);
        if (start != null) {
            this.start = start;
        }
        if (stop2 != null) {
            this.stop = stop2;
        }
        if (step != null) {
            this.step = step;
        }
    }

    @ExposedNew
    static PyObject slice_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        if (args.length == 0) {
            throw Py.TypeError("slice expected at least 1 arguments, got " + args.length);
        }
        if (args.length > 3) {
            throw Py.TypeError("slice expected at most 3 arguments, got " + args.length);
        }
        ArgParser ap = new ArgParser("slice", args, keywords, "start", "stop", "step");
        PySlice slice2 = new PySlice();
        if (args.length == 1) {
            slice2.stop = ap.getPyObject(0);
        } else if (args.length == 2) {
            slice2.start = ap.getPyObject(0);
            slice2.stop = ap.getPyObject(1);
        } else if (args.length == 3) {
            slice2.start = ap.getPyObject(0);
            slice2.stop = ap.getPyObject(1);
            slice2.step = ap.getPyObject(2);
        }
        return slice2;
    }

    @Override
    public int hashCode() {
        return this.slice___hash__();
    }

    final int slice___hash__() {
        throw Py.TypeError(String.format("unhashable type: '%.200s'", this.getType().fastGetName()));
    }

    @Override
    public PyObject __eq__(PyObject o2) {
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        if (this == o2) {
            return Py.True;
        }
        PySlice oSlice = (PySlice)o2;
        return Py.newBoolean(PySlice.eq(this.getStart(), oSlice.getStart()) && PySlice.eq(this.getStop(), oSlice.getStop()) && PySlice.eq(this.getStep(), oSlice.getStep()));
    }

    private static final boolean eq(PyObject o1, PyObject o2) {
        return o1._cmp(o2) == 0;
    }

    @Override
    public PyObject __ne__(PyObject o2) {
        return this.__eq__(o2).__not__();
    }

    public PyObject indices(PyObject len) {
        return this.slice_indices(len);
    }

    final PyObject slice_indices(PyObject len) {
        int[] indices = this.indicesEx(len.asIndex(Py.OverflowError));
        return new PyTuple(Py.newInteger(indices[0]), Py.newInteger(indices[1]), Py.newInteger(indices[2]));
    }

    public int[] indicesEx(int length) {
        int result_stop;
        int result_start;
        int defstop;
        int result_step;
        if (this.step == Py.None) {
            result_step = 1;
        } else {
            result_step = PySlice.calculateSliceIndex(this.step);
            if (result_step == 0) {
                throw Py.ValueError("slice step cannot be zero");
            }
        }
        int defstart = result_step < 0 ? length - 1 : 0;
        int n2 = defstop = result_step < 0 ? -1 : length;
        if (this.start == Py.None) {
            result_start = defstart;
        } else {
            result_start = PySlice.calculateSliceIndex(this.start);
            if (result_start < 0) {
                result_start += length;
            }
            if (result_start < 0) {
                int n3 = result_start = result_step < 0 ? -1 : 0;
            }
            if (result_start >= length) {
                int n4 = result_start = result_step < 0 ? length - 1 : length;
            }
        }
        if (this.stop == Py.None) {
            result_stop = defstop;
        } else {
            result_stop = PySlice.calculateSliceIndex(this.stop);
            if (result_stop < 0) {
                result_stop += length;
            }
            if (result_stop < 0) {
                int n5 = result_stop = result_step < 0 ? -1 : 0;
            }
            if (result_stop >= length) {
                int n6 = result_stop = result_step < 0 ? length - 1 : length;
            }
        }
        int result_slicelength = result_step < 0 && result_stop >= result_start || result_step > 0 && result_start >= result_stop ? 0 : (result_step < 0 ? (result_stop - result_start + 1) / result_step + 1 : (result_stop - result_start - 1) / result_step + 1);
        return new int[]{result_start, result_stop, result_step, result_slicelength};
    }

    public static PyObject[] indices2(PyObject obj, PyObject start, PyObject stop2) {
        int istop;
        int istart;
        PyObject[] indices;
        block5: {
            indices = new PyObject[2];
            istart = start == null || start == Py.None ? 0 : PySlice.calculateSliceIndex(start);
            int n2 = istop = stop2 == null || stop2 == Py.None ? Integer.MAX_VALUE : PySlice.calculateSliceIndex(stop2);
            if (istart < 0 || istop < 0) {
                try {
                    int len = obj.__len__();
                    if (istart < 0) {
                        istart += len;
                    }
                    if (istop < 0) {
                        istop += len;
                    }
                }
                catch (PyException pye) {
                    if (pye.match(Py.TypeError)) break block5;
                    throw pye;
                }
            }
        }
        indices[0] = Py.newInteger(istart);
        indices[1] = Py.newInteger(istop);
        return indices;
    }

    public static int calculateSliceIndex(PyObject v2) {
        if (v2.isIndex()) {
            return v2.asIndex();
        }
        throw Py.TypeError("slice indices must be integers or None or have an __index__ method");
    }

    @Override
    public String toString() {
        return this.slice_toString();
    }

    final String slice_toString() {
        return String.format("slice(%s, %s, %s)", this.getStart(), this.getStop(), this.getStep());
    }

    public final PyObject getStart() {
        return this.start;
    }

    public final PyObject getStop() {
        return this.stop;
    }

    public final PyObject getStep() {
        return this.step;
    }

    final PyObject slice___reduce__() {
        return new PyTuple(this.getType(), new PyTuple(this.start, this.stop, this.step));
    }

    final PyObject slice___reduce_ex__(PyObject protocol) {
        return new PyTuple(this.getType(), new PyTuple(this.start, this.stop, this.step));
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = visit.visit(this.start, arg);
        if (retVal != 0) {
            return retVal;
        }
        retVal = visit.visit(this.stop, arg);
        if (retVal != 0) {
            return retVal;
        }
        return visit.visit(this.step, arg);
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob == this.start || ob == this.stop || ob == this.step;
    }

    static {
        PyType.addBuilder(PySlice.class, new PySlice$PyExposer());
        TYPE = PyType.fromClass(PySlice.class);
    }
}

