/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.python.core.ArgParser;
import org.python.core.BaseBytes;
import org.python.core.BufferProtocol;
import org.python.core.Py;
import org.python.core.PyBaseString;
import org.python.core.PyBuffer;
import org.python.core.PyComplex;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyList;
import org.python.core.PyLong;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PySequence;
import org.python.core.PyString$PyExposer;
import org.python.core.PyStringDerived;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.StringFormatter;
import org.python.core.Untraversable;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.SimpleStringBuffer;
import org.python.core.codecs;
import org.python.core.imp;
import org.python.core.stringlib.FieldNameIterator;
import org.python.core.stringlib.InternalFormat;
import org.python.core.stringlib.MarkupIterator;
import org.python.core.stringlib.TextFormatter;
import org.python.core.ucnhashAPI;
import org.python.core.util.StringUtil;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;

@Untraversable
@ExposedType(name="str", base=PyBaseString.class, doc="str(object) -> string\n\nReturn a nice string representation of the object.\nIf the argument is a string, the return value is the same object.")
public class PyString
extends PyBaseString
implements BufferProtocol {
    public static final PyType TYPE;
    protected String string;
    protected transient boolean interned = false;
    private Reference<BaseBuffer> export;
    private static char[] hexdigit;
    private static ucnhashAPI pucnHash;
    private static final int SWAP_CASE = 32;
    private static final String UF_RE = "(?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+)";
    private static Pattern floatPattern;
    private static Pattern complexPattern;

    public String getString() {
        return this.string;
    }

    public PyString() {
        this("", true);
    }

    public PyString(PyType subType, String string) {
        super(subType);
        if (string == null) {
            throw new IllegalArgumentException("Cannot create PyString from null");
        }
        if (!PyString.isBytes(string)) {
            throw new IllegalArgumentException("Cannot create PyString with non-byte value");
        }
        this.string = string;
    }

    public PyString(String string) {
        this(TYPE, string);
    }

    public PyString(char c2) {
        this(TYPE, String.valueOf(c2));
    }

    PyString(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    private PyString(String string, boolean isBytes) {
        super(TYPE);
        if (!isBytes && !PyString.isBytes(string)) {
            throw new IllegalArgumentException("Cannot create PyString with non-byte value");
        }
        this.string = string;
    }

    private static boolean isBytes(String s2) {
        int k2 = s2.length();
        if (k2 == 0) {
            return true;
        }
        int c2 = 0;
        while (k2 > 8) {
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
            c2 = (char)(c2 | s2.charAt(--k2));
        }
        while (k2 > 0) {
            c2 = (char)(c2 | s2.charAt(--k2));
        }
        return c2 < 256;
    }

    public static PyString fromInterned(String interned) {
        PyString str = new PyString(TYPE, interned);
        str.interned = true;
        return str;
    }

    public boolean isBasicPlane() {
        return true;
    }

    @ExposedNew
    static PyObject str_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("str", args, keywords, new String[]{"object"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String str = S == null ? "" : ((S = S.__str__()) instanceof PyUnicode ? codecs.encode((PyUnicode)S, null, null) : S.toString());
        if (new_.for_type == subtype) {
            return new PyString(str);
        }
        return new PyStringDerived(subtype, str);
    }

    public int[] toCodePoints() {
        int n2 = this.getString().length();
        int[] codePoints = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            codePoints[i2] = this.getString().charAt(i2);
        }
        return codePoints;
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        BaseBuffer pybuf = this.getExistingBuffer(flags);
        if (pybuf == null) {
            pybuf = new SimpleStringBuffer(flags, this.getString());
            this.export = new SoftReference<BaseBuffer>(pybuf);
        }
        return pybuf;
    }

    private BaseBuffer getExistingBuffer(int flags) {
        BaseBuffer pybuf = null;
        if (this.export != null && (pybuf = this.export.get()) != null) {
            pybuf = pybuf.getBufferAgain(flags);
        }
        return pybuf;
    }

    public String substring(int start, int end) {
        return this.getString().substring(start, end);
    }

    @Override
    public PyString __str__() {
        return this.str___str__();
    }

    final PyString str___str__() {
        if (this.getClass() == PyString.class) {
            return this;
        }
        return new PyString(this.getString(), true);
    }

    @Override
    public PyUnicode __unicode__() {
        return new PyUnicode(this);
    }

    @Override
    public int __len__() {
        return this.str___len__();
    }

    final int str___len__() {
        return this.getString().length();
    }

    @Override
    public String toString() {
        return this.getString();
    }

    public String internedString() {
        if (this.interned) {
            return this.getString();
        }
        this.string = this.getString().intern();
        this.interned = true;
        return this.getString();
    }

    @Override
    public PyString __repr__() {
        return this.str___repr__();
    }

    final PyString str___repr__() {
        return new PyString(PyString.encode_UnicodeEscape(this.getString(), true));
    }

    public static String encode_UnicodeEscape(String str, boolean use_quotes) {
        int size = str.length();
        StringBuilder v2 = new StringBuilder(str.length());
        char quote = '\u0000';
        if (use_quotes) {
            quote = str.indexOf(39) >= 0 && str.indexOf(34) == -1 ? (char)'\"' : '\'';
            v2.append(quote);
        }
        int i2 = 0;
        while (size-- > 0) {
            char ch = str.charAt(i2++);
            if (use_quotes && ch == quote || ch == '\\') {
                v2.append('\\');
                v2.append(ch);
                continue;
            }
            if (size > 0 && ch >= '\ud800' && ch < '\udc00') {
                char ch2 = str.charAt(i2++);
                --size;
                if (ch2 >= '\udc00' && ch2 <= '\udfff') {
                    int ucs = ((ch & 0x3FF) << 10 | ch2 & 0x3FF) + 65536;
                    v2.append('\\');
                    v2.append('U');
                    v2.append(hexdigit[ucs >> 28 & 0xF]);
                    v2.append(hexdigit[ucs >> 24 & 0xF]);
                    v2.append(hexdigit[ucs >> 20 & 0xF]);
                    v2.append(hexdigit[ucs >> 16 & 0xF]);
                    v2.append(hexdigit[ucs >> 12 & 0xF]);
                    v2.append(hexdigit[ucs >> 8 & 0xF]);
                    v2.append(hexdigit[ucs >> 4 & 0xF]);
                    v2.append(hexdigit[ucs & 0xF]);
                    continue;
                }
                --i2;
                ++size;
            }
            if (ch >= '\u0100') {
                v2.append('\\');
                v2.append('u');
                v2.append(hexdigit[ch >> 12 & 0xF]);
                v2.append(hexdigit[ch >> 8 & 0xF]);
                v2.append(hexdigit[ch >> 4 & 0xF]);
                v2.append(hexdigit[ch & 0xF]);
                continue;
            }
            if (ch == '\t') {
                v2.append("\\t");
                continue;
            }
            if (ch == '\n') {
                v2.append("\\n");
                continue;
            }
            if (ch == '\r') {
                v2.append("\\r");
                continue;
            }
            if (ch < ' ' || ch >= '\u007f') {
                v2.append('\\');
                v2.append('x');
                v2.append(hexdigit[ch >> 4 & 0xF]);
                v2.append(hexdigit[ch & 0xF]);
                continue;
            }
            v2.append(ch);
        }
        if (use_quotes) {
            v2.append(quote);
        }
        return v2.toString();
    }

    public static String decode_UnicodeEscape(String str, int start, int end, String errors, boolean unicode) {
        StringBuilder v2 = new StringBuilder(end - start);
        int s2 = start;
        while (s2 < end) {
            char ch = str.charAt(s2);
            if (ch != '\\') {
                v2.append(ch);
                ++s2;
                continue;
            }
            int loopStart = s2++;
            if (s2 == end) {
                s2 = codecs.insertReplacementAndGetResume(v2, errors, "unicodeescape", str, loopStart, s2 + 1, "\\ at end of string");
                continue;
            }
            ch = str.charAt(s2++);
            switch (ch) {
                case '\n': {
                    break;
                }
                case '\\': {
                    v2.append('\\');
                    break;
                }
                case '\'': {
                    v2.append('\'');
                    break;
                }
                case '\"': {
                    v2.append('\"');
                    break;
                }
                case 'b': {
                    v2.append('\b');
                    break;
                }
                case 'f': {
                    v2.append('\f');
                    break;
                }
                case 't': {
                    v2.append('\t');
                    break;
                }
                case 'n': {
                    v2.append('\n');
                    break;
                }
                case 'r': {
                    v2.append('\r');
                    break;
                }
                case 'v': {
                    v2.append('\u000b');
                    break;
                }
                case 'a': {
                    v2.append('\u0007');
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    int x2 = Character.digit(ch, 8);
                    for (int j2 = 0; j2 < 2 && s2 < end && (ch = str.charAt(s2)) >= '0' && ch <= '7'; ++j2, ++s2) {
                        x2 = (x2 << 3) + Character.digit(ch, 8);
                    }
                    v2.append((char)x2);
                    break;
                }
                case 'x': {
                    s2 = PyString.hexescape(v2, errors, 2, s2, str, end, "truncated \\xXX");
                    break;
                }
                case 'u': {
                    if (!unicode) {
                        v2.append('\\');
                        v2.append('u');
                        break;
                    }
                    s2 = PyString.hexescape(v2, errors, 4, s2, str, end, "truncated \\uXXXX");
                    break;
                }
                case 'U': {
                    if (!unicode) {
                        v2.append('\\');
                        v2.append('U');
                        break;
                    }
                    s2 = PyString.hexescape(v2, errors, 8, s2, str, end, "truncated \\UXXXXXXXX");
                    break;
                }
                case 'N': {
                    if (!unicode) {
                        v2.append('\\');
                        v2.append('N');
                        break;
                    }
                    if (pucnHash == null) {
                        PyObject mod2 = imp.importName("ucnhash", true);
                        pucnHash = (ucnhashAPI)(mod2 = mod2.__call__()).__tojava__(Object.class);
                        if (pucnHash.getCchMax() < 0) {
                            throw Py.UnicodeError("Unicode names not loaded");
                        }
                    }
                    if (str.charAt(s2) == '{') {
                        int startName;
                        int endBrace;
                        int maxLen = pucnHash.getCchMax();
                        for (endBrace = startName = s2 + 1; endBrace < end && str.charAt(endBrace) != '}' && endBrace - startName <= maxLen; ++endBrace) {
                        }
                        if (endBrace != end && str.charAt(endBrace) == '}') {
                            int value = pucnHash.getValue(str, startName, endBrace);
                            if (PyString.storeUnicodeCharacter(value, v2)) {
                                s2 = endBrace + 1;
                                break;
                            }
                            s2 = codecs.insertReplacementAndGetResume(v2, errors, "unicodeescape", str, loopStart, endBrace + 1, "illegal Unicode character");
                            break;
                        }
                        s2 = codecs.insertReplacementAndGetResume(v2, errors, "unicodeescape", str, loopStart, endBrace, "malformed \\N character escape");
                        break;
                    }
                    s2 = codecs.insertReplacementAndGetResume(v2, errors, "unicodeescape", str, loopStart, s2 + 1, "malformed \\N character escape");
                    break;
                }
                default: {
                    v2.append('\\');
                    v2.append(str.charAt(s2 - 1));
                }
            }
        }
        return v2.toString();
    }

    private static int hexescape(StringBuilder partialDecode, String errors, int digits, int hexDigitStart, String str, int size, String errorMessage) {
        int i2;
        if (hexDigitStart + digits > size) {
            return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, size, errorMessage);
        }
        int x2 = 0;
        for (i2 = 0; i2 < digits; ++i2) {
            char c2 = str.charAt(hexDigitStart + i2);
            int d2 = Character.digit(c2, 16);
            if (d2 == -1) {
                return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i2 + 1, errorMessage);
            }
            x2 = x2 << 4 & 0xFFFFFFF0;
            if (c2 >= '0' && c2 <= '9') {
                x2 += c2 - 48;
                continue;
            }
            if (c2 >= 'a' && c2 <= 'f') {
                x2 += 10 + c2 - 97;
                continue;
            }
            x2 += 10 + c2 - 65;
        }
        if (PyString.storeUnicodeCharacter(x2, partialDecode)) {
            return hexDigitStart + i2;
        }
        return codecs.insertReplacementAndGetResume(partialDecode, errors, "unicodeescape", str, hexDigitStart - 2, hexDigitStart + i2 + 1, "illegal Unicode character");
    }

    private static boolean storeUnicodeCharacter(int value, StringBuilder partialDecode) {
        if (value < 0 || value >= 55296 && value <= 57343) {
            return false;
        }
        if (value <= 0x10FFFF) {
            partialDecode.appendCodePoint(value);
            return true;
        }
        return false;
    }

    final PyObject str___getitem__(PyObject index) {
        PyObject ret = this.seq___finditem__(index);
        if (ret == null) {
            throw Py.IndexError("string index out of range");
        }
        return ret;
    }

    final PyObject str___getslice__(PyObject start, PyObject stop2, PyObject step) {
        return this.seq___getslice__(start, stop2, step);
    }

    @Override
    public int __cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final int str___cmp__(PyObject other) {
        if (!(other instanceof PyString)) {
            return -2;
        }
        int c2 = this.getString().compareTo(((PyString)other).getString());
        return c2 < 0 ? -1 : (c2 > 0 ? 1 : 0);
    }

    @Override
    public PyObject __eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject str___eq__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().equals(s2) ? Py.True : Py.False;
    }

    @Override
    public PyObject __ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final PyObject str___ne__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().equals(s2) ? Py.False : Py.True;
    }

    @Override
    public PyObject __lt__(PyObject other) {
        return this.str___lt__(other);
    }

    final PyObject str___lt__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) < 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __le__(PyObject other) {
        return this.str___le__(other);
    }

    final PyObject str___le__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) <= 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __gt__(PyObject other) {
        return this.str___gt__(other);
    }

    final PyObject str___gt__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) > 0 ? Py.True : Py.False;
    }

    @Override
    public PyObject __ge__(PyObject other) {
        return this.str___ge__(other);
    }

    final PyObject str___ge__(PyObject other) {
        String s2 = PyString.coerce(other);
        if (s2 == null) {
            return null;
        }
        return this.getString().compareTo(s2) >= 0 ? Py.True : Py.False;
    }

    private static String coerce(PyObject o2) {
        if (o2 instanceof PyString) {
            return o2.toString();
        }
        return null;
    }

    @Override
    public int hashCode() {
        return this.str___hash__();
    }

    final int str___hash__() {
        return this.getString().hashCode();
    }

    public byte[] toBytes() {
        return StringUtil.toBytes(this.getString());
    }

    @Override
    public Object __tojava__(Class<?> c2) {
        if (c2.isAssignableFrom(String.class)) {
            return this.getString();
        }
        if ((c2 == Character.TYPE || c2 == Character.class) && this.getString().length() == 1) {
            return new Character(this.getString().charAt(0));
        }
        if (c2.isArray()) {
            if (c2.getComponentType() == Byte.TYPE) {
                return this.toBytes();
            }
            if (c2.getComponentType() == Character.TYPE) {
                return this.getString().toCharArray();
            }
        }
        if (c2.isAssignableFrom(Collection.class)) {
            ArrayList<Object> list = new ArrayList<Object>();
            for (int i2 = 0; i2 < this.__len__(); ++i2) {
                list.add(this.pyget(i2).__tojava__(String.class));
            }
            return list;
        }
        if (c2.isInstance(this)) {
            return this;
        }
        return Py.NoConversion;
    }

    @Override
    protected PyObject pyget(int i2) {
        return Py.makeCharacter(this.string.charAt(i2));
    }

    public int getInt(int i2) {
        return this.string.charAt(i2);
    }

    @Override
    protected PyObject getslice(int start, int stop2, int step) {
        if (step > 0 && stop2 < start) {
            stop2 = start;
        }
        if (step == 1) {
            return this.fromSubstring(start, stop2);
        }
        int n2 = PyString.sliceLength(start, stop2, step);
        char[] new_chars = new char[n2];
        int j2 = 0;
        int i2 = start;
        while (j2 < n2) {
            new_chars[j2++] = this.getString().charAt(i2);
            i2 += step;
        }
        return this.createInstance(new String(new_chars), true);
    }

    public PyString createInstance(String str) {
        return new PyString(str);
    }

    protected PyString createInstance(String str, boolean isBasic) {
        return new PyString(str);
    }

    private static String asUTF16StringOrNull(PyObject obj) {
        if (obj instanceof PyString) {
            return ((PyString)obj).getString();
        }
        if (obj instanceof BufferProtocol) {
            try (PyBuffer buf = ((BufferProtocol)((Object)obj)).getBuffer(284);){
                String string = buf.toString();
                return string;
            }
        }
        return null;
    }

    private static String asStringOrNull(PyObject obj) {
        return obj instanceof PyUnicode ? null : PyString.asUTF16StringOrNull(obj);
    }

    private static String asStringOrError(PyObject obj) throws PyException {
        String ret;
        String string = ret = obj instanceof PyUnicode ? null : PyString.asUTF16StringOrNull(obj);
        if (ret != null) {
            return ret;
        }
        throw Py.TypeError("expected str, bytearray or other buffer compatible object");
    }

    private static String asStringNullOrError(PyObject obj, String name) throws PyException {
        String ret;
        if (obj == null || obj == Py.None) {
            return null;
        }
        String string = ret = obj instanceof PyUnicode ? null : PyString.asUTF16StringOrNull(obj);
        if (ret != null) {
            return ret;
        }
        if (name == null) {
            throw Py.TypeError("expected None, str or buffer compatible object");
        }
        throw Py.TypeError(name + " arg must be None, str or buffer compatible object");
    }

    private static String asUTF16StringOrError(PyObject obj) {
        String ret = PyString.asUTF16StringOrNull(obj);
        if (ret != null) {
            return ret;
        }
        throw Py.TypeError("expected str, bytearray, unicode or buffer compatible object");
    }

    @Override
    public boolean __contains__(PyObject o2) {
        return this.str___contains__(o2);
    }

    final boolean str___contains__(PyObject o2) {
        String other = PyString.asUTF16StringOrError(o2);
        return this.getString().indexOf(other) >= 0;
    }

    @Override
    protected PyObject repeat(int count2) {
        int s2;
        if (count2 < 0) {
            count2 = 0;
        }
        if ((long)(s2 = this.getString().length()) * (long)count2 > Integer.MAX_VALUE) {
            throw Py.OverflowError("max str len is 2147483647");
        }
        char[] new_chars = new char[s2 * count2];
        for (int i2 = 0; i2 < count2; ++i2) {
            this.getString().getChars(0, s2, new_chars, i2 * s2);
        }
        return this.createInstance(new String(new_chars));
    }

    @Override
    public PyObject __mul__(PyObject o2) {
        return this.str___mul__(o2);
    }

    final PyObject str___mul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __rmul__(PyObject o2) {
        return this.str___rmul__(o2);
    }

    final PyObject str___rmul__(PyObject o2) {
        if (!o2.isIndex()) {
            return null;
        }
        return this.repeat(o2.asIndex(Py.OverflowError));
    }

    @Override
    public PyObject __add__(PyObject other) {
        return this.str___add__(other);
    }

    final PyObject str___add__(PyObject other) {
        String otherStr = PyString.asStringOrNull(other);
        if (otherStr != null) {
            return new PyString(this.getString().concat(otherStr), true);
        }
        if (other instanceof PyUnicode) {
            return this.decode().__add__(other);
        }
        return null;
    }

    final PyTuple str___getnewargs__() {
        return new PyTuple(new PyString(this.getString()));
    }

    @Override
    public PyTuple __getnewargs__() {
        return this.str___getnewargs__();
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.str___mod__(other);
    }

    public PyObject str___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.getString(), false);
        return fmt.format(other);
    }

    @Override
    public PyObject __int__() {
        try {
            return Py.newInteger(this.atoi(10));
        }
        catch (PyException e2) {
            if (e2.match(Py.OverflowError)) {
                return this.atol(10);
            }
            throw e2;
        }
    }

    @Override
    public PyObject __long__() {
        return this.atol(10);
    }

    @Override
    public PyFloat __float__() {
        return new PyFloat(this.atof());
    }

    @Override
    public PyObject __pos__() {
        throw Py.TypeError("bad operand type for unary +");
    }

    @Override
    public PyObject __neg__() {
        throw Py.TypeError("bad operand type for unary -");
    }

    @Override
    public PyObject __invert__() {
        throw Py.TypeError("bad operand type for unary ~");
    }

    @Override
    public PyComplex __complex__() {
        return this.atocx();
    }

    public String lower() {
        return this.str_lower();
    }

    final String str_lower() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            char c2 = s2.charAt(0);
            return this._isupper(c2) ? String.valueOf((char)(c2 ^ 0x20)) : s2;
        }
        char[] buf = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = s2.charAt(i2);
            buf[i2] = this._isupper(c3) ? (char)(c3 ^ 0x20) : c3;
        }
        return new String(buf);
    }

    public String upper() {
        return this.str_upper();
    }

    final String str_upper() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            char c2 = s2.charAt(0);
            return this._islower(c2) ? String.valueOf((char)(c2 ^ 0x20)) : s2;
        }
        char[] buf = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = s2.charAt(i2);
            buf[i2] = this._islower(c3) ? (char)(c3 ^ 0x20) : c3;
        }
        return new String(buf);
    }

    public String title() {
        return this.str_title();
    }

    final String str_title() {
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        boolean previous_is_cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = chars[i2];
            if (this._isalpha(ch)) {
                if (previous_is_cased) {
                    if (this._isupper(ch)) {
                        chars[i2] = (char)(ch ^ 0x20);
                    }
                } else if (this._islower(ch)) {
                    chars[i2] = (char)(ch ^ 0x20);
                }
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new String(chars);
    }

    public String swapcase() {
        return this.str_swapcase();
    }

    final String str_swapcase() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            char c2 = s2.charAt(0);
            return this._isalpha(c2) ? String.valueOf((char)(c2 ^ 0x20)) : s2;
        }
        char[] buf = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            char c3 = s2.charAt(i2);
            buf[i2] = this._isalpha(c3) ? (char)(c3 ^ 0x20) : c3;
        }
        return new String(buf);
    }

    public String strip() {
        return this._strip();
    }

    public String strip(String stripChars) {
        return this._strip(stripChars);
    }

    public PyObject strip(PyObject stripChars) {
        return this.str_strip(stripChars);
    }

    final PyObject str_strip(PyObject chars) {
        if (chars instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_strip(chars);
        }
        String stripChars = PyString.asStringNullOrError(chars, "strip");
        return new PyString(this._strip(stripChars), true);
    }

    protected final String _strip() {
        String s2 = this.getString();
        int right = PyString._stripRight(s2);
        if (right < 0) {
            return "";
        }
        int left = PyString._stripLeft(s2, right);
        return s2.substring(left, right + 1);
    }

    protected final String _strip(String stripChars) {
        if (stripChars == null) {
            return this._strip();
        }
        String s2 = this.getString();
        int right = PyString._stripRight(s2, stripChars);
        if (right < 0) {
            return "";
        }
        int left = PyString._stripLeft(s2, stripChars, right);
        return s2.substring(left, right + 1);
    }

    private static final int _stripLeft(String s2, int right) {
        for (int left = 0; left < right; ++left) {
            if (Character.isWhitespace(s2.charAt(left))) continue;
            return left;
        }
        return right;
    }

    private static final int _stripLeft(String s2, String stripChars, int right) {
        for (int left = 0; left < right; ++left) {
            if (stripChars.indexOf(s2.charAt(left)) >= 0) continue;
            return left;
        }
        return right;
    }

    private static final int _stripRight(String s2) {
        int right = s2.length();
        while (--right >= 0) {
            if (Character.isWhitespace(s2.charAt(right))) continue;
            return right;
        }
        return -1;
    }

    private static final int _stripRight(String s2, String stripChars) {
        int right = s2.length();
        while (--right >= 0) {
            if (stripChars.indexOf(s2.charAt(right)) >= 0) continue;
            return right;
        }
        return -1;
    }

    public String lstrip() {
        return this._lstrip();
    }

    public String lstrip(String stripChars) {
        return this._lstrip(stripChars);
    }

    public PyObject lstrip(PyObject stripChars) {
        return this.str_lstrip(stripChars);
    }

    final PyObject str_lstrip(PyObject chars) {
        if (chars instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_lstrip(chars);
        }
        String stripChars = PyString.asStringNullOrError(chars, "lstrip");
        return new PyString(this._lstrip(stripChars), true);
    }

    protected final String _lstrip() {
        String s2 = this.getString();
        int left = PyString._stripLeft(s2, s2.length());
        return s2.substring(left);
    }

    protected final String _lstrip(String stripChars) {
        if (stripChars == null) {
            return this._lstrip();
        }
        String s2 = this.getString();
        int left = PyString._stripLeft(s2, stripChars, s2.length());
        return s2.substring(left);
    }

    public String rstrip() {
        return this._rstrip();
    }

    public String rstrip(String stripChars) {
        return this._rstrip(stripChars);
    }

    public PyObject rstrip(PyObject stripChars) {
        return this.str_rstrip(stripChars);
    }

    final PyObject str_rstrip(PyObject chars) {
        if (chars instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_rstrip(chars);
        }
        String stripChars = PyString.asStringNullOrError(chars, "rstrip");
        return new PyString(this._rstrip(stripChars), true);
    }

    protected final String _rstrip() {
        String s2 = this.getString();
        int right = PyString._stripRight(s2);
        if (right < 0) {
            return "";
        }
        return s2.substring(0, right + 1);
    }

    protected final String _rstrip(String stripChars) {
        if (stripChars == null) {
            return this._rstrip();
        }
        String s2 = this.getString();
        int right = PyString._stripRight(s2, stripChars);
        return s2.substring(0, right + 1);
    }

    public PyList split() {
        return this._split(null, -1);
    }

    public PyList split(String sep) {
        return this._split(sep, -1);
    }

    public PyList split(String sep, int maxsplit) {
        return this._split(sep, maxsplit);
    }

    public PyList split(PyObject sep) {
        return this.str_split(sep, -1);
    }

    public PyList split(PyObject sep, int maxsplit) {
        return this.str_split(sep, maxsplit);
    }

    final PyList str_split(PyObject sepObj, int maxsplit) {
        if (sepObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_split(sepObj, maxsplit);
        }
        String sep = PyString.asStringNullOrError(sepObj, "split");
        return this._split(sep, maxsplit);
    }

    protected final PyList _split(String sep, int maxsplit) {
        if (sep == null) {
            return this.splitfields(maxsplit);
        }
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        return this.splitfields(sep, maxsplit);
    }

    private PyList splitfields(int maxsplit) {
        PyList list = new PyList();
        String s2 = this.getString();
        int length = s2.length();
        int start = 0;
        int splits = 0;
        if (maxsplit < 0) {
            maxsplit = length;
        }
        while (start < length) {
            int index;
            while (start < length && Character.isWhitespace(s2.charAt(start))) {
                ++start;
            }
            if (start >= length) break;
            if (splits >= maxsplit) {
                index = length;
            } else {
                for (index = start; index < length && !Character.isWhitespace(s2.charAt(index)); ++index) {
                }
            }
            list.append(this.fromSubstring(start, index));
            ++splits;
            start = index;
        }
        return list;
    }

    private PyList splitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        String s2 = this.getString();
        int length = s2.length();
        int sepLength = sep.length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        if (maxsplit == 0) {
            list.append(this);
        } else if (sepLength == 0) {
            int index;
            int m4 = maxsplit > length ? length + 1 : maxsplit;
            list.append(this.createInstance(""));
            for (index = 0; index < m4 - 1; ++index) {
                list.append(this.fromSubstring(index, index + 1));
            }
            list.append(this.fromSubstring(index, length));
        } else {
            int index;
            int start = 0;
            for (int splits = 0; splits < maxsplit && (index = s2.indexOf(sep, start)) >= 0; ++splits) {
                list.append(this.fromSubstring(start, index));
                start = index + sepLength;
            }
            list.append(this.fromSubstring(start, length));
        }
        return list;
    }

    public PyList rsplit() {
        return this._rsplit(null, -1);
    }

    public PyList rsplit(String sep) {
        return this._rsplit(sep, -1);
    }

    public PyList rsplit(String sep, int maxsplit) {
        return this._rsplit(sep, maxsplit);
    }

    public PyList rsplit(PyObject sep) {
        return this.str_rsplit(sep, -1);
    }

    public PyList rsplit(PyObject sep, int maxsplit) {
        return this.str_rsplit(sep, maxsplit);
    }

    final PyList str_rsplit(PyObject sepObj, int maxsplit) {
        if (sepObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_rsplit(sepObj, maxsplit);
        }
        String sep = PyString.asStringNullOrError(sepObj, "rsplit");
        return this._rsplit(sep, maxsplit);
    }

    protected final PyList _rsplit(String sep, int maxsplit) {
        if (sep == null) {
            return this.rsplitfields(maxsplit);
        }
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        return this.rsplitfields(sep, maxsplit);
    }

    private PyList rsplitfields(int maxsplit) {
        PyList list = new PyList();
        String s2 = this.getString();
        int length = s2.length();
        int end = length - 1;
        int splits = 0;
        if (maxsplit < 0) {
            maxsplit = length;
        }
        while (end >= 0) {
            int index;
            while (end >= 0 && Character.isWhitespace(s2.charAt(end))) {
                --end;
            }
            if (end < 0) break;
            if (splits >= maxsplit) {
                index = -1;
            } else {
                for (index = end; index >= 0 && !Character.isWhitespace(s2.charAt(index)); --index) {
                }
            }
            list.append(this.fromSubstring(index + 1, end + 1));
            ++splits;
            end = index;
        }
        list.reverse();
        return list;
    }

    private PyList rsplitfields(String sep, int maxsplit) {
        PyList list = new PyList();
        String s2 = this.getString();
        int length = s2.length();
        int sepLength = sep.length();
        if (maxsplit < 0) {
            maxsplit = length + 1;
        }
        if (maxsplit == 0) {
            list.append(this);
        } else {
            int index;
            if (sepLength == 0) {
                throw Py.ValueError("empty separator");
            }
            int end = length;
            for (int splits = 0; splits < maxsplit && (index = s2.lastIndexOf(sep, end - sepLength)) >= 0; ++splits) {
                list.append(this.fromSubstring(index + sepLength, end));
                end = index;
            }
            list.append(this.fromSubstring(0, end));
        }
        list.reverse();
        return list;
    }

    public PyTuple partition(PyObject sepObj) {
        return this.str_partition(sepObj);
    }

    final PyTuple str_partition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodePartition(sepObj);
        }
        String sep = PyString.asStringOrError(sepObj);
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().indexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(this, Py.EmptyString, Py.EmptyString);
    }

    final PyTuple unicodePartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.indexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(this, emptyUnicode, emptyUnicode);
    }

    public PyTuple rpartition(PyObject sepObj) {
        return this.str_rpartition(sepObj);
    }

    final PyTuple str_rpartition(PyObject sepObj) {
        if (sepObj instanceof PyUnicode) {
            return this.unicodeRpartition(sepObj);
        }
        String sep = PyString.asStringOrError(sepObj);
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = this.getString().lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(this.fromSubstring(0, index), sepObj, this.fromSubstring(index + sep.length(), this.getString().length()));
        }
        return new PyTuple(Py.EmptyString, Py.EmptyString, this);
    }

    final PyTuple unicodeRpartition(PyObject sepObj) {
        PyUnicode strObj = this.__unicode__();
        String str = strObj.getString();
        String sep = sepObj.asString();
        sepObj = sepObj.__unicode__();
        if (sep.length() == 0) {
            throw Py.ValueError("empty separator");
        }
        int index = str.lastIndexOf(sep);
        if (index != -1) {
            return new PyTuple(strObj.fromSubstring(0, index), sepObj, strObj.fromSubstring(index + sep.length(), str.length()));
        }
        PyUnicode emptyUnicode = Py.newUnicode("");
        return new PyTuple(emptyUnicode, emptyUnicode, this);
    }

    public PyList splitlines() {
        return this.str_splitlines(false);
    }

    public PyList splitlines(boolean keepends) {
        return this.str_splitlines(keepends);
    }

    final PyList str_splitlines(boolean keepends) {
        PyList list = new PyList();
        char[] chars = this.getString().toCharArray();
        int n2 = chars.length;
        int j2 = 0;
        int i2 = 0;
        while (i2 < n2) {
            while (i2 < n2 && chars[i2] != '\n' && chars[i2] != '\r' && Character.getType(chars[i2]) != 13) {
                ++i2;
            }
            int eol = i2;
            if (i2 < n2) {
                i2 = chars[i2] == '\r' && i2 + 1 < n2 && chars[i2 + 1] == '\n' ? (i2 += 2) : ++i2;
                if (keepends) {
                    eol = i2;
                }
            }
            list.append(this.fromSubstring(j2, eol));
            j2 = i2;
        }
        if (j2 < n2) {
            list.append(this.fromSubstring(j2, n2));
        }
        return list;
    }

    protected PyString fromSubstring(int begin, int end) {
        return new PyString(this.getString().substring(begin, end), true);
    }

    public int index(PyObject sub) {
        return this.str_index(sub, null, null);
    }

    public int index(PyObject sub, PyObject start) throws PyException {
        return this.str_index(sub, start, null);
    }

    public int index(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.checkIndex(this.str_index(sub, start, end));
    }

    public int index(String sub) {
        return this.index(sub, null, null);
    }

    public int index(String sub, PyObject start) {
        return this.index(sub, start, null);
    }

    public int index(String sub, PyObject start, PyObject end) {
        return this.checkIndex(this._find(sub, start, end));
    }

    final int str_index(PyObject subObj, PyObject start, PyObject end) {
        return this.checkIndex(this.str_find(subObj, start, end));
    }

    public int rindex(PyObject sub) {
        return this.str_rindex(sub, null, null);
    }

    public int rindex(PyObject sub, PyObject start) throws PyException {
        return this.str_rindex(sub, start, null);
    }

    public int rindex(PyObject sub, PyObject start, PyObject end) throws PyException {
        return this.checkIndex(this.str_rindex(sub, start, end));
    }

    public int rindex(String sub) {
        return this.rindex(sub, null, null);
    }

    public int rindex(String sub, PyObject start) {
        return this.rindex(sub, start, null);
    }

    public int rindex(String sub, PyObject start, PyObject end) {
        return this.checkIndex(this._rfind(sub, start, end));
    }

    final int str_rindex(PyObject subObj, PyObject start, PyObject end) {
        return this.checkIndex(this.str_rfind(subObj, start, end));
    }

    protected final int checkIndex(int index) throws PyException {
        if (index >= 0) {
            return index;
        }
        throw Py.ValueError("substring not found");
    }

    public int count(PyObject sub) {
        return this.count(sub, null, null);
    }

    public int count(PyObject sub, PyObject start) {
        return this.count(sub, start, null);
    }

    public int count(PyObject sub, PyObject start, PyObject end) {
        return this.str_count(sub, start, end);
    }

    public int count(String sub) {
        return this.count(sub, null, null);
    }

    public int count(String sub, PyObject start) {
        return this.count(sub, start, null);
    }

    public int count(String sub, PyObject start, PyObject end) {
        return this._count(sub, start, end);
    }

    final int str_count(PyObject subObj, PyObject start, PyObject end) {
        if (subObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_count(subObj, start, end);
        }
        String sub = PyString.asStringOrError(subObj);
        return this._count(sub, start, end);
    }

    protected final int _count(String sub, PyObject startObj, PyObject endObj) {
        int index;
        int[] indices = this.translateIndices(startObj, endObj);
        int subLen = sub.length();
        if (subLen == 0) {
            int start = indices[2];
            int end = indices[3];
            int n2 = this.__len__();
            if (end < 0 || end < start || start > n2) {
                return 0;
            }
            return Math.min(end, n2) - Math.max(start, 0) + 1;
        }
        int start = indices[0];
        int end = indices[1];
        int limit = end - subLen;
        int count2 = 0;
        while (start <= limit && (index = this.getString().indexOf(sub, start)) >= 0 && index <= limit) {
            ++count2;
            start = index + subLen;
        }
        return count2;
    }

    public int find(PyObject sub) {
        return this.find(sub, null, null);
    }

    public int find(PyObject sub, PyObject start) {
        return this.find(sub, start, null);
    }

    public int find(PyObject sub, PyObject start, PyObject end) {
        return this.str_find(sub, start, end);
    }

    public int find(String sub) {
        return this.find(sub, null, null);
    }

    public int find(String sub, PyObject start) {
        return this.find(sub, start, null);
    }

    public int find(String sub, PyObject start, PyObject end) {
        return this._find(sub, start, end);
    }

    final int str_find(PyObject subObj, PyObject start, PyObject end) {
        if (subObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_find(subObj, start, end);
        }
        String sub = PyString.asStringOrError(subObj);
        return this._find(sub, start, end);
    }

    protected final int _find(String sub, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int subLen = sub.length();
        if (subLen == 0) {
            int start = indices[2];
            int end = indices[3];
            if (end < 0 || end < start || start > this.__len__()) {
                return -1;
            }
            return indices[0];
        }
        int start = indices[0];
        int end = indices[1];
        int found = this.getString().indexOf(sub, start);
        if (found >= 0 && found + subLen <= end) {
            return found;
        }
        return -1;
    }

    public int rfind(PyObject sub) {
        return this.rfind(sub, null, null);
    }

    public int rfind(PyObject sub, PyObject start) {
        return this.rfind(sub, start, null);
    }

    public int rfind(PyObject sub, PyObject start, PyObject end) {
        return this.str_rfind(sub, start, end);
    }

    public int rfind(String sub) {
        return this.rfind(sub, null, null);
    }

    public int rfind(String sub, PyObject start) {
        return this.rfind(sub, start, null);
    }

    public int rfind(String sub, PyObject start, PyObject end) {
        return this._rfind(sub, start, end);
    }

    final int str_rfind(PyObject subObj, PyObject start, PyObject end) {
        if (subObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_rfind(subObj, start, end);
        }
        String sub = PyString.asStringOrError(subObj);
        return this._rfind(sub, start, end);
    }

    protected final int _rfind(String sub, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int subLen = sub.length();
        if (subLen == 0) {
            int start = indices[2];
            int end = indices[3];
            if (end < 0 || end < start || start > this.__len__()) {
                return -1;
            }
            return indices[1];
        }
        int start = indices[0];
        int end = indices[1];
        int found = this.getString().lastIndexOf(sub, end - subLen);
        if (found >= start) {
            return found;
        }
        return -1;
    }

    public double atof() {
        double x2 = 0.0;
        Matcher m4 = PyString.getFloatPattern().matcher(this.getString());
        boolean valid = m4.matches();
        if (valid) {
            String number = m4.group(1);
            try {
                char lastChar = number.charAt(number.length() - 1);
                x2 = Character.isLetter(lastChar) ? PyString.atofSpecials(m4.group(1)) : Double.parseDouble(m4.group(1));
            }
            catch (NumberFormatException e2) {
                valid = false;
            }
        }
        if (valid) {
            return x2;
        }
        String fmt = "invalid literal for float: %s";
        throw Py.ValueError(String.format(fmt, this.getString().trim()));
    }

    private static synchronized Pattern getFloatPattern() {
        if (floatPattern == null) {
            floatPattern = Pattern.compile("\\s*([+-]?(?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+))\\s*");
        }
        return floatPattern;
    }

    private static synchronized Pattern getComplexPattern() {
        if (complexPattern == null) {
            complexPattern = Pattern.compile("\\s*(?<a>\\(\\s*)?(?<x>[+-]?(?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+)?)(?<y>[+-](?:(?:(?:\\d+\\.?|\\.\\d)\\d*(?:[eE][+-]?\\d+)?)|[infatyINFATY]+)?)?(?<j>[jJ])?\\s*(?<b>\\)\\s*)?");
        }
        return complexPattern;
    }

    private static double atofSpecials(String s2) throws NumberFormatException {
        switch (s2.toLowerCase()) {
            case "nan": 
            case "+nan": 
            case "-nan": {
                return Double.NaN;
            }
            case "inf": 
            case "+inf": 
            case "infinity": 
            case "+infinity": {
                return Double.POSITIVE_INFINITY;
            }
            case "-inf": 
            case "-infinity": {
                return Double.NEGATIVE_INFINITY;
            }
        }
        throw new NumberFormatException();
    }

    private PyComplex atocx() {
        double x2 = 0.0;
        double y2 = 0.0;
        Matcher m4 = PyString.getComplexPattern().matcher(this.getString());
        boolean valid = m4.matches();
        if (valid) {
            if (m4.group("a") != null != (m4.group("b") != null)) {
                valid = false;
            } else {
                try {
                    String xs = m4.group("x");
                    String ys = m4.group("y");
                    if (m4.group("j") != null) {
                        if (ys != null) {
                            y2 = PyString.toComplexPart(ys);
                            x2 = PyString.toComplexPart(xs);
                        } else {
                            y2 = xs != null ? PyString.toComplexPart(xs) : 1.0;
                        }
                    } else {
                        x2 = Double.parseDouble(xs);
                        if (ys != null) {
                            throw new NumberFormatException();
                        }
                    }
                }
                catch (NumberFormatException e2) {
                    valid = false;
                }
            }
        }
        if (valid) {
            return new PyComplex(x2, y2);
        }
        String fmt = "complex() arg is a malformed string: %s";
        throw Py.ValueError(String.format(fmt, this.getString().trim()));
    }

    private static double toComplexPart(String s2) throws NumberFormatException {
        if (s2.length() == 0) {
            return 1.0;
        }
        char lastChar = s2.charAt(s2.length() - 1);
        if (Character.isLetter(lastChar)) {
            return PyString.atofSpecials(s2);
        }
        if (lastChar == '+') {
            return 1.0;
        }
        if (lastChar == '-') {
            return -1.0;
        }
        return Double.parseDouble(s2);
    }

    private BigInteger asciiToBigInteger(int base, boolean isLong) {
        int b2;
        String str = this.getString();
        int e2 = str.length();
        for (b2 = 0; b2 < e2 && Character.isWhitespace(str.charAt(b2)); ++b2) {
        }
        while (e2 > b2 && Character.isWhitespace(str.charAt(e2 - 1))) {
            --e2;
        }
        char sign = '\u0000';
        if (b2 < e2) {
            sign = str.charAt(b2);
            if (sign == '-' || sign == '+') {
                ++b2;
                while (b2 < e2 && Character.isWhitespace(str.charAt(b2))) {
                    ++b2;
                }
            }
            if (base == 16) {
                if (str.charAt(b2) == '0' && b2 < e2 - 1 && Character.toUpperCase(str.charAt(b2 + 1)) == 'X') {
                    b2 += 2;
                }
            } else if (base == 0) {
                if (str.charAt(b2) == '0') {
                    if (b2 < e2 - 1 && Character.toUpperCase(str.charAt(b2 + 1)) == 'X') {
                        base = 16;
                        b2 += 2;
                    } else if (b2 < e2 - 1 && Character.toUpperCase(str.charAt(b2 + 1)) == 'O') {
                        base = 8;
                        b2 += 2;
                    } else if (b2 < e2 - 1 && Character.toUpperCase(str.charAt(b2 + 1)) == 'B') {
                        base = 2;
                        b2 += 2;
                    } else {
                        base = 8;
                    }
                }
            } else if (base == 8) {
                if (b2 < e2 - 1 && Character.toUpperCase(str.charAt(b2 + 1)) == 'O') {
                    b2 += 2;
                }
            } else if (base == 2 && b2 < e2 - 1 && Character.toUpperCase(str.charAt(b2 + 1)) == 'B') {
                b2 += 2;
            }
        }
        if (base == 0) {
            base = 10;
        }
        if (isLong && base < 22 && e2 > b2 && (str.charAt(e2 - 1) == 'L' || str.charAt(e2 - 1) == 'l')) {
            --e2;
        }
        String s2 = str;
        if (b2 > 0 || e2 < str.length()) {
            s2 = str.substring(b2, e2);
        }
        BigInteger bi = sign == '-' ? new BigInteger("-" + s2, base) : new BigInteger(s2, base);
        return bi;
    }

    public int atoi() {
        return this.atoi(10);
    }

    public int atoi(int base) {
        if (base != 0 && base < 2 || base > 36) {
            throw Py.ValueError("invalid base for atoi()");
        }
        try {
            BigInteger bi = this.asciiToBigInteger(base, false);
            if (bi.compareTo(PyInteger.MAX_INT) > 0 || bi.compareTo(PyInteger.MIN_INT) < 0) {
                throw Py.OverflowError("long int too large to convert to int");
            }
            return bi.intValue();
        }
        catch (NumberFormatException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base + ": '" + this.getString() + "'");
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for int() with base " + base + ": '" + this.getString() + "'");
        }
    }

    public PyLong atol() {
        return this.atol(10);
    }

    public PyLong atol(int base) {
        if (base != 0 && base < 2 || base > 36) {
            throw Py.ValueError("invalid base for long literal:" + base);
        }
        try {
            BigInteger bi = this.asciiToBigInteger(base, true);
            return new PyLong(bi);
        }
        catch (NumberFormatException exc) {
            if (this instanceof PyUnicode) {
                throw Py.UnicodeEncodeError("decimal", "codec can't encode character", 0, 0, "invalid decimal Unicode string");
            }
            throw Py.ValueError("invalid literal for long() with base " + base + ": '" + this.getString() + "'");
        }
        catch (StringIndexOutOfBoundsException exc) {
            throw Py.ValueError("invalid literal for long() with base " + base + ": '" + this.getString() + "'");
        }
    }

    private static String padding(int n2, char pad) {
        char[] chars = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            chars[i2] = pad;
        }
        return new String(chars);
    }

    private static char parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return ' ';
        }
        if (fillchar.length() != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.charAt(0);
    }

    public String ljust(int width) {
        return this.str_ljust(width, null);
    }

    public String ljust(int width, String padding) {
        return this.str_ljust(width, padding);
    }

    final String str_ljust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("ljust", fillchar);
        int n2 = width - this.getString().length();
        if (n2 <= 0) {
            return this.getString();
        }
        return this.getString() + PyString.padding(n2, pad);
    }

    public String rjust(int width) {
        return this.str_rjust(width, null);
    }

    final String str_rjust(int width, String fillchar) {
        char pad = PyString.parse_fillchar("rjust", fillchar);
        int n2 = width - this.getString().length();
        if (n2 <= 0) {
            return this.getString();
        }
        return PyString.padding(n2, pad) + this.getString();
    }

    public String center(int width) {
        return this.str_center(width, null);
    }

    final String str_center(int width, String fillchar) {
        char pad = PyString.parse_fillchar("center", fillchar);
        int n2 = width - this.getString().length();
        if (n2 <= 0) {
            return this.getString();
        }
        int half = n2 / 2;
        if (n2 % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        return PyString.padding(half, pad) + this.getString() + PyString.padding(n2 - half, pad);
    }

    public String zfill(int width) {
        return this.str_zfill(width);
    }

    final String str_zfill(int width) {
        char start;
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 >= width) {
            return s2;
        }
        char[] chars = new char[width];
        int nzeros = width - n2;
        int i2 = 0;
        int sStart = 0;
        if (n2 > 0 && ((start = s2.charAt(0)) == '+' || start == '-')) {
            chars[0] = start;
            ++i2;
            ++nzeros;
            sStart = 1;
        }
        while (i2 < nzeros) {
            chars[i2] = 48;
            ++i2;
        }
        s2.getChars(sStart, s2.length(), chars, i2);
        return new String(chars);
    }

    public String expandtabs() {
        return this.str_expandtabs(8);
    }

    public String expandtabs(int tabsize) {
        return this.str_expandtabs(tabsize);
    }

    final String str_expandtabs(int tabsize) {
        String s2 = this.getString();
        StringBuilder buf = new StringBuilder((int)((double)s2.length() * 1.5));
        char[] chars = s2.toCharArray();
        int n2 = chars.length;
        int position = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = chars[i2];
            if (c2 == '\t') {
                int spaces = tabsize - position % tabsize;
                position += spaces;
                while (spaces-- > 0) {
                    buf.append(' ');
                }
                continue;
            }
            if (c2 == '\n' || c2 == '\r') {
                position = -1;
            }
            buf.append(c2);
            ++position;
        }
        return buf.toString();
    }

    public String capitalize() {
        return this.str_capitalize();
    }

    final String str_capitalize() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 0) {
            return s2;
        }
        char[] buf = new char[n2];
        char c2 = s2.charAt(0);
        buf[0] = this._islower(c2) ? (char)(c2 ^ 0x20) : c2;
        for (int i2 = 1; i2 < n2; ++i2) {
            c2 = s2.charAt(i2);
            buf[i2] = this._isupper(c2) ? (char)(c2 ^ 0x20) : c2;
        }
        return new String(buf);
    }

    public PyString replace(PyObject oldPiece, PyObject newPiece) {
        return this.str_replace(oldPiece, newPiece, -1);
    }

    public PyString replace(PyObject oldPiece, PyObject newPiece, int count2) {
        return this.str_replace(oldPiece, newPiece, count2);
    }

    final PyString str_replace(PyObject oldPieceObj, PyObject newPieceObj, int count2) {
        if (oldPieceObj instanceof PyUnicode || newPieceObj instanceof PyUnicode) {
            return ((PyUnicode)this.decode()).unicode_replace(oldPieceObj, newPieceObj, count2);
        }
        String oldPiece = PyString.asStringOrError(oldPieceObj);
        String newPiece = PyString.asStringOrError(newPieceObj);
        return this._replace(oldPiece, newPiece, count2);
    }

    protected final PyString _replace(String oldPiece, String newPiece, int count2) {
        String s2 = this.getString();
        int len = s2.length();
        int oldLen = oldPiece.length();
        int newLen = newPiece.length();
        if (len == 0) {
            if (count2 < 0 && oldLen == 0) {
                return this.createInstance(newPiece, true);
            }
            return this.createInstance(s2, true);
        }
        if (oldLen == 0 && newLen != 0 && count2 != 0) {
            int i2;
            StringBuilder buffer = new StringBuilder();
            buffer.append(newPiece);
            for (i2 = 0; i2 < len && (count2 < 0 || i2 < count2 - 1); ++i2) {
                buffer.append(s2.charAt(i2)).append(newPiece);
            }
            buffer.append(s2.substring(i2));
            return this.createInstance(buffer.toString(), true);
        }
        if (count2 < 0) {
            count2 = oldLen == 0 ? len + 1 : len;
        }
        return this.createInstance(newPiece).join(this.splitfields(oldPiece, count2));
    }

    public PyString join(PyObject seq) {
        return this.str_join(seq);
    }

    final PyString str_join(PyObject obj) {
        int i2;
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return Py.EmptyString;
        }
        if (seqLen == 1 && ((item = seq.pyget(0)).getType() == TYPE || item.getType() == PyUnicode.TYPE)) {
            return (PyString)item;
        }
        long size = 0L;
        int sepLen = this.getString().length();
        for (i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string, %.80s found", i2, item.getType().fastGetName()));
            }
            if (item instanceof PyUnicode) {
                return this.unicodeJoin(seq);
            }
            if (i2 != 0) {
                size += (long)sepLen;
            }
            if ((size += (long)((PyString)item).getString().length()) <= Integer.MAX_VALUE) continue;
            throw Py.OverflowError("join() result is too long for a Python string");
        }
        StringBuilder buf = new StringBuilder((int)size);
        for (i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (i2 != 0) {
                buf.append(this.getString());
            }
            buf.append(((PyString)item).getString());
        }
        return new PyString(buf.toString(), true);
    }

    final PyUnicode unicodeJoin(PyObject obj) {
        PyObject item;
        PySequence seq = PyString.fastSequence(obj, "");
        int seqLen = seq.__len__();
        if (seqLen == 0) {
            return new PyUnicode();
        }
        if (seqLen == 1 && (item = seq.pyget(0)).getType() == PyUnicode.TYPE) {
            return (PyUnicode)item;
        }
        String sep = null;
        if (seqLen > 1) {
            if (this instanceof PyUnicode) {
                sep = this.getString();
            } else {
                sep = ((PyUnicode)this.decode()).getString();
                seqLen = seq.__len__();
            }
        }
        long size = 0L;
        int sepLen = this.getString().length();
        StringBuilder buf = new StringBuilder();
        for (int i2 = 0; i2 < seqLen; ++i2) {
            item = seq.pyget(i2);
            if (!(item instanceof PyString)) {
                throw Py.TypeError(String.format("sequence item %d: expected string or Unicode, %.80s found", i2, item.getType().fastGetName()));
            }
            if (!(item instanceof PyUnicode)) {
                item = ((PyString)item).decode();
                seqLen = seq.__len__();
            }
            String itemString = ((PyUnicode)item).getString();
            if (i2 != 0) {
                size += (long)sepLen;
                buf.append(sep);
            }
            if ((size += (long)itemString.length()) > Integer.MAX_VALUE) {
                throw Py.OverflowError("join() result is too long for a Python string");
            }
            buf.append(itemString);
        }
        return new PyUnicode(buf.toString());
    }

    public boolean startswith(PyObject prefix) {
        return this.str_startswith(prefix, null, null);
    }

    public boolean startswith(PyObject prefix, PyObject start) {
        return this.str_startswith(prefix, start, null);
    }

    public boolean startswith(PyObject prefix, PyObject start, PyObject end) {
        return this.str_startswith(prefix, start, end);
    }

    final boolean str_startswith(PyObject prefix, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        int start = indices[0];
        int sliceLen = indices[1] - start;
        if (!(prefix instanceof PyTuple)) {
            String s2 = PyString.asUTF16StringOrError(prefix);
            return sliceLen >= s2.length() && this.getString().startsWith(s2, start);
        }
        for (PyObject prefixObj : ((PyTuple)prefix).getArray()) {
            String s3 = PyString.asUTF16StringOrError(prefixObj);
            if (sliceLen < s3.length() || !this.getString().startsWith(s3, start)) continue;
            return true;
        }
        return false;
    }

    public boolean endswith(PyObject suffix) {
        return this.str_endswith(suffix, null, null);
    }

    public boolean endswith(PyObject suffix, PyObject start) {
        return this.str_endswith(suffix, start, null);
    }

    public boolean endswith(PyObject suffix, PyObject start, PyObject end) {
        return this.str_endswith(suffix, start, end);
    }

    final boolean str_endswith(PyObject suffix, PyObject startObj, PyObject endObj) {
        int[] indices = this.translateIndices(startObj, endObj);
        String substr = this.getString().substring(indices[0], indices[1]);
        if (!(suffix instanceof PyTuple)) {
            String s2 = PyString.asUTF16StringOrError(suffix);
            return substr.endsWith(s2);
        }
        for (PyObject suffixObj : ((PyTuple)suffix).getArray()) {
            String s3 = PyString.asUTF16StringOrError(suffixObj);
            if (!substr.endsWith(s3)) continue;
            return true;
        }
        return false;
    }

    protected int[] translateIndices(PyObject startObj, PyObject endObj) {
        int end;
        int start;
        int n2 = this.__len__();
        int[] result = new int[4];
        if (startObj == null || startObj == Py.None) {
            start = 0;
        } else {
            start = startObj.asIndex(null);
            if (start < 0) {
                start = n2 + start;
            }
            result[2] = start;
        }
        if (endObj == null || endObj == Py.None) {
            result[3] = end = n2;
            result[1] = end;
        } else {
            end = endObj.asIndex(null);
            if (end < 0) {
                result[3] = end += n2;
                if (end < 0) {
                    end = 0;
                } else {
                    result[1] = end;
                }
            } else {
                result[3] = end;
                result[1] = end > n2 ? (end = n2) : end;
            }
        }
        if (start < 0) {
            start = 0;
        } else {
            result[0] = start > end ? (start = end) : start;
        }
        return result;
    }

    public String translate(PyObject table) {
        return this.translate(table, null);
    }

    public String translate(PyObject table, PyObject deletechars) {
        return this.str_translate(table, deletechars);
    }

    public String translate(String table) {
        return this._translate(table, null);
    }

    public String translate(String table, String deletechars) {
        return this._translate(table, deletechars);
    }

    final String str_translate(PyObject tableObj, PyObject deletecharsObj) {
        String table = PyString.asStringNullOrError(tableObj, null);
        String deletechars = PyString.asStringNullOrError(deletecharsObj, null);
        return this._translate(table, deletechars);
    }

    private final String _translate(String table, String deletechars) {
        if (table != null && table.length() != 256) {
            throw Py.ValueError("translation table must be 256 characters long");
        }
        StringBuilder buf = new StringBuilder(this.getString().length());
        for (int i2 = 0; i2 < this.getString().length(); ++i2) {
            char c2 = this.getString().charAt(i2);
            if (deletechars != null && deletechars.indexOf(c2) >= 0) continue;
            if (table == null) {
                buf.append(c2);
                continue;
            }
            try {
                buf.append(table.charAt(c2));
                continue;
            }
            catch (IndexOutOfBoundsException e2) {
                throw Py.TypeError("translate() only works for 8-bit character strings");
            }
        }
        return buf.toString();
    }

    public boolean islower() {
        return this.str_islower();
    }

    final boolean str_islower() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._islower(s2.charAt(0));
        }
        boolean cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = s2.charAt(i2);
            if (this._isupper(ch)) {
                return false;
            }
            if (cased || !this._islower(ch)) continue;
            cased = true;
        }
        return cased;
    }

    private boolean _islower(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.islower((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isupper() {
        return this.str_isupper();
    }

    final boolean str_isupper() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._isupper(s2.charAt(0));
        }
        boolean cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = s2.charAt(i2);
            if (this._islower(ch)) {
                return false;
            }
            if (cased || !this._isupper(ch)) continue;
            cased = true;
        }
        return cased;
    }

    private boolean _isupper(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isupper((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isalpha() {
        return this.str_isalpha();
    }

    final boolean str_isalpha() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._isalpha(s2.charAt(0));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._isalpha(s2.charAt(i2))) continue;
            return false;
        }
        return n2 > 0;
    }

    private boolean _isalpha(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isalpha((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isalnum() {
        return this.str_isalnum();
    }

    final boolean str_isalnum() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._isalnum(s2.charAt(0));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._isalnum(s2.charAt(i2))) continue;
            return false;
        }
        return n2 > 0;
    }

    private boolean _isalnum(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isalnum((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isdecimal() {
        return this.str_isdecimal();
    }

    final boolean str_isdecimal() {
        return this.str_isdigit();
    }

    private boolean _isdecimal(char ch) {
        return Character.getType(ch) == 9;
    }

    public boolean isdigit() {
        return this.str_isdigit();
    }

    final boolean str_isdigit() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._isdigit(s2.charAt(0));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._isdigit(s2.charAt(i2))) continue;
            return false;
        }
        return n2 > 0;
    }

    private boolean _isdigit(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isdigit((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isnumeric() {
        return this.str_isnumeric();
    }

    final boolean str_isnumeric() {
        return this.str_isdigit();
    }

    public boolean istitle() {
        return this.str_istitle();
    }

    final boolean str_istitle() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._isupper(s2.charAt(0));
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = s2.charAt(i2);
            if (this._isupper(ch)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (this._islower(ch)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    public boolean isspace() {
        return this.str_isspace();
    }

    final boolean str_isspace() {
        String s2 = this.getString();
        int n2 = s2.length();
        if (n2 == 1) {
            return this._isspace(s2.charAt(0));
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this._isspace(s2.charAt(i2))) continue;
            return false;
        }
        return n2 > 0;
    }

    private boolean _isspace(char ch) {
        if (ch < '\u0100') {
            return BaseBytes.isspace((byte)ch);
        }
        throw new IllegalArgumentException("non-byte character in PyString");
    }

    public boolean isunicode() {
        return this.str_isunicode();
    }

    final boolean str_isunicode() {
        Py.warning(Py.DeprecationWarning, "isunicode is deprecated.");
        int n2 = this.getString().length();
        for (int i2 = 0; i2 < n2; ++i2) {
            char ch = this.getString().charAt(i2);
            if (ch <= '\u00ff') continue;
            return true;
        }
        return false;
    }

    public String encode() {
        return this.encode(null, null);
    }

    public String encode(String encoding) {
        return this.encode(encoding, null);
    }

    public String encode(String encoding, String errors) {
        return codecs.encode(this, encoding, errors);
    }

    final String str_encode(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("encode", args, keywords, "encoding", "errors");
        String encoding = ap.getString(0, null);
        String errors = ap.getString(1, null);
        return this.encode(encoding, errors);
    }

    public PyObject decode() {
        return this.decode(null, null);
    }

    public PyObject decode(String encoding) {
        return this.decode(encoding, null);
    }

    public PyObject decode(String encoding, String errors) {
        return codecs.decode(this, encoding, errors);
    }

    final PyObject str_decode(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("decode", args, keywords, "encoding", "errors");
        String encoding = ap.getString(0, null);
        String errors = ap.getString(1, null);
        return this.decode(encoding, errors);
    }

    final PyObject str__formatter_parser() {
        return new MarkupIterator(this);
    }

    final PyObject str__formatter_field_name_split() {
        FieldNameIterator iterator = new FieldNameIterator(this);
        return new PyTuple(iterator.pyHead(), iterator);
    }

    final PyObject str_format(PyObject[] args, String[] keywords) {
        try {
            return new PyString(this.buildFormattedString(args, keywords, null, null));
        }
        catch (IllegalArgumentException e2) {
            throw Py.ValueError(e2.getMessage());
        }
    }

    protected String buildFormattedString(PyObject[] args, String[] keywords, MarkupIterator enclosingIterator, String value) {
        MarkupIterator.Chunk chunk;
        MarkupIterator it = enclosingIterator == null ? new MarkupIterator(this) : new MarkupIterator(enclosingIterator, value);
        StringBuilder result = new StringBuilder();
        while ((chunk = it.nextChunk()) != null) {
            PyObject fieldObj;
            result.append(chunk.literalText);
            if (chunk.fieldName == null || (fieldObj = this.getFieldObject(chunk.fieldName, it.isBytes(), args, keywords)) == null) continue;
            if ("r".equals(chunk.conversion)) {
                fieldObj = fieldObj.__repr__();
            } else if ("s".equals(chunk.conversion)) {
                fieldObj = fieldObj.__str__();
            } else if (chunk.conversion != null) {
                throw Py.ValueError("Unknown conversion specifier " + chunk.conversion);
            }
            if (fieldObj instanceof PyUnicode && !(this instanceof PyUnicode)) {
                fieldObj = ((PyUnicode)fieldObj).__str__();
            }
            String formatSpec = chunk.formatSpec;
            if (chunk.formatSpecNeedsExpanding) {
                if (enclosingIterator != null) {
                    throw Py.ValueError("Max string recursion exceeded");
                }
                formatSpec = this.buildFormattedString(args, keywords, it, formatSpec);
            }
            this.renderField(fieldObj, formatSpec, result);
        }
        return result.toString();
    }

    private PyObject getFieldObject(String fieldName, boolean bytes, PyObject[] args, String[] keywords) {
        FieldNameIterator.Chunk chunk;
        FieldNameIterator iterator = new FieldNameIterator(fieldName, bytes);
        PyObject head = iterator.pyHead();
        PyObject obj = null;
        int positionalCount = args.length - keywords.length;
        if (head.isIndex()) {
            int index = head.asIndex();
            if (index >= positionalCount) {
                throw Py.IndexError("tuple index out of range");
            }
            obj = args[index];
        } else {
            for (int i2 = 0; i2 < keywords.length; ++i2) {
                if (!keywords[i2].equals(head.asString())) continue;
                obj = args[positionalCount + i2];
                break;
            }
            if (obj == null) {
                throw Py.KeyError(head);
            }
        }
        while (obj != null && (chunk = iterator.nextChunk()) != null) {
            Object key = chunk.value;
            if (chunk.is_attr) {
                obj = obj.__getattr__((String)key);
                continue;
            }
            if (key instanceof Integer) {
                obj = obj.__getitem__((Integer)key);
                continue;
            }
            obj = obj.__getitem__(new PyString(key.toString()));
        }
        return obj;
    }

    private void renderField(PyObject fieldObj, String formatSpec, StringBuilder result) {
        PyString formatSpecStr = formatSpec == null ? Py.EmptyString : new PyString(formatSpec);
        result.append(fieldObj.__format__(formatSpecStr).asString());
    }

    @Override
    public PyObject __format__(PyObject formatSpec) {
        return this.str___format__(formatSpec);
    }

    final PyObject str___format__(PyObject formatSpec) {
        InternalFormat.Spec spec = InternalFormat.fromText(formatSpec, "__format__");
        TextFormatter f2 = PyString.prepareFormatter(spec);
        if (f2 == null) {
            throw InternalFormat.Formatter.unknownFormat(spec.type, "string");
        }
        boolean unicode = this instanceof PyUnicode || formatSpec instanceof PyUnicode;
        f2.setBytes(!unicode);
        f2.format(this.getString());
        return f2.pad().getPyResult();
    }

    static TextFormatter prepareFormatter(InternalFormat.Spec spec) throws PyException {
        switch (spec.type) {
            case 's': 
            case '\uffff': {
                if (spec.grouping) {
                    throw InternalFormat.Formatter.notAllowed("Grouping", "string", spec.type);
                }
                if (InternalFormat.Spec.specified(spec.sign)) {
                    throw InternalFormat.Formatter.signNotAllowed("string", '\u0000');
                }
                if (spec.alternate) {
                    throw InternalFormat.Formatter.alternateFormNotAllowed("string");
                }
                if (spec.align == '=') {
                    throw InternalFormat.Formatter.alignmentNotAllowed('=', "string");
                }
                spec = spec.withDefaults(InternalFormat.Spec.STRING);
                return new TextFormatter(spec);
            }
        }
        return null;
    }

    @Override
    public String asString(int index) throws PyObject.ConversionException {
        return this.getString();
    }

    @Override
    public String asString() {
        return this.getString();
    }

    @Override
    public int asInt() {
        this.asNumberCheck("__int__", "an integer");
        return super.asInt();
    }

    @Override
    public long asLong() {
        this.asNumberCheck("__long__", "an integer");
        return super.asLong();
    }

    @Override
    public double asDouble() {
        this.asNumberCheck("__float__", "a float");
        return super.asDouble();
    }

    private void asNumberCheck(String methodName, String description) {
        PyType type = this.getType();
        if (type == TYPE || type == PyUnicode.TYPE || type.lookup(methodName) == null) {
            throw Py.TypeError(description + " is required");
        }
    }

    @Override
    public String asName(int index) throws PyObject.ConversionException {
        return this.internedString();
    }

    @Override
    protected String unsupportedopMessage(String op, PyObject o2) {
        if (op.equals("+")) {
            return "cannot concatenate ''{1}'' and ''{2}'' objects";
        }
        return super.unsupportedopMessage(op, o2);
    }

    static {
        PyType.addBuilder(PyString.class, new PyString$PyExposer());
        TYPE = PyType.fromClass(PyString.class);
        hexdigit = "0123456789abcdef".toCharArray();
        pucnHash = null;
        floatPattern = null;
        complexPattern = null;
    }
}

