/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Properties;
import junit.framework.TestCase;
import org.python.core.PySystemState;

public class PySystemState_registry_Test
extends TestCase {
    private static final String REGISTRY = "registry";
    private static final String USER_REGISTRY = ".jython";
    private static final String DIST = "dist";
    private static final String FIRST_PROP = "first.test.property";
    private static final String SECOND_PROP = "second.test.property";
    private static final String USER_HOME = "user.home";
    private static final String PYTHON_HOME = "python.home";
    private static final String ANY = "any";
    private static final String PRE = "pre";
    private static final String POST = "post";
    private static final String INSTALLED = "installed";
    private static final String USER = "user";
    private String _originalUserHome;
    private File _root;
    private String _originalRegistryContent;
    private Properties _originalRegistry;
    private File _tmpDir;

    protected void setUp() throws Exception {
        this.findRoot();
        this.storeOriginals();
        this.uninitialize();
    }

    protected void tearDown() throws Exception {
        this.restoreOriginals();
        this.cleanup();
    }

    public void testInitialize_PrePostProperties() throws Exception {
        Properties preProps = this.createPreProperties();
        preProps.setProperty(FIRST_PROP, PRE);
        preProps.setProperty(SECOND_PROP, PRE);
        Properties postProps = this.createPostProperties();
        postProps.setProperty(SECOND_PROP, POST);
        PySystemState.initialize(preProps, postProps);
        Properties registry = PySystemState.registry;
        String first = registry.getProperty(FIRST_PROP, ANY);
        String second = registry.getProperty(SECOND_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)PRE, (String)first);
        PySystemState_registry_Test.assertEquals((String)POST, (String)second);
    }

    public void testInitialize_Registry_User() throws Exception {
        String installedContent = FIRST_PROP.concat("=").concat(INSTALLED);
        this.appendToInstalledRegistry(installedContent);
        String userContent = FIRST_PROP.concat("=").concat(USER);
        this.addUserRegistry(userContent);
        Properties preProps = this.createPreProperties();
        Properties postProps = this.createPostProperties();
        PySystemState.initialize(preProps, postProps);
        Properties registry = PySystemState.registry;
        String first = registry.getProperty(FIRST_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)USER, (String)first);
    }

    public void testInitialize_Pre_Registries() throws Exception {
        String contentToAppend = FIRST_PROP.concat("=").concat(INSTALLED);
        this.appendToInstalledRegistry(contentToAppend);
        String userContent = FIRST_PROP.concat("=").concat(USER);
        this.addUserRegistry(userContent);
        Properties preProps = this.createPreProperties();
        preProps.setProperty(FIRST_PROP, PRE);
        Properties postProps = this.createPostProperties();
        PySystemState.initialize(preProps, postProps);
        Properties registry = PySystemState.registry;
        String first = registry.getProperty(FIRST_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)PRE, (String)first);
    }

    public void testInitialize_Post_Registries() throws Exception {
        String contentToAppend = FIRST_PROP.concat("=").concat(INSTALLED);
        this.appendToInstalledRegistry(contentToAppend);
        String userContent = FIRST_PROP.concat("=").concat(USER);
        this.addUserRegistry(userContent);
        Properties preProps = this.createPreProperties();
        preProps.setProperty(FIRST_PROP, PRE);
        Properties postProps = this.createPostProperties();
        postProps.setProperty(FIRST_PROP, POST);
        PySystemState.initialize(preProps, postProps);
        Properties registry = PySystemState.registry;
        String first = registry.getProperty(FIRST_PROP, ANY);
        PySystemState_registry_Test.assertEquals((String)POST, (String)first);
    }

    private void findRoot() throws Exception {
        Class<?> thisClass = ((Object)((Object)this)).getClass();
        String classFileName = "/".concat(thisClass.getName().replace('.', '/')).concat(".class");
        URL url = thisClass.getResource(classFileName);
        PySystemState_registry_Test.assertNotNull((Object)url);
        String path = URLDecoder.decode(url.getPath(), "UTF-8");
        PySystemState_registry_Test.assertTrue((boolean)path.endsWith(classFileName));
        String classesDirName = path.substring(0, path.length() - classFileName.length());
        File classesDir = new File(classesDirName);
        PySystemState_registry_Test.assertTrue((boolean)classesDir.exists());
        PySystemState_registry_Test.assertTrue((boolean)classesDir.isDirectory());
        this._root = new File(classesDir.getParentFile().getParentFile(), DIST);
        PySystemState_registry_Test.assertTrue((boolean)this._root.exists());
        PySystemState_registry_Test.assertTrue((boolean)this._root.isDirectory());
    }

    private void uninitialize() throws Exception {
        Field field = PySystemState.class.getDeclaredField("initialized");
        field.setAccessible(true);
        field.set(null, false);
        PySystemState.registry = null;
    }

    private void storeOriginals() throws Exception {
        this._originalRegistry = PySystemState.registry;
        this._originalUserHome = System.getProperty(USER_HOME);
        File installedRegistry = new File(this.getRoot(), REGISTRY);
        PySystemState_registry_Test.assertTrue((boolean)installedRegistry.exists());
        this._originalRegistryContent = this.readAll(installedRegistry);
    }

    private void restoreOriginals() throws Exception {
        PySystemState.registry = this._originalRegistry;
        String originalUserHome = this.getOriginalUserHome();
        if (originalUserHome != null) {
            System.setProperty(USER_HOME, originalUserHome);
        }
        this.writeInstalledRegistry(this.getOriginalRegistryContent());
    }

    private void writeInstalledRegistry(String content) throws IOException {
        if (content != null && content.length() > 0) {
            File installedRegistry = new File(this.getRoot(), REGISTRY);
            PySystemState_registry_Test.assertTrue((boolean)installedRegistry.exists());
            this.write(installedRegistry, content);
        }
    }

    private void appendToInstalledRegistry(String contentToAppend) throws IOException {
        if (contentToAppend != null && contentToAppend.length() > 0) {
            String content = this.getOriginalRegistryContent().concat(contentToAppend);
            this.writeInstalledRegistry(content);
        }
    }

    private void addUserRegistry(String content) throws Exception {
        File tmpDir = this.createTempDir();
        System.setProperty(USER_HOME, tmpDir.getCanonicalPath());
        File userRegistry = new File(tmpDir, USER_REGISTRY);
        this.write(userRegistry, content);
        PySystemState_registry_Test.assertTrue((boolean)userRegistry.exists());
        PySystemState_registry_Test.assertTrue((boolean)userRegistry.isFile());
    }

    private Properties createPreProperties() {
        return new Properties(System.getProperties());
    }

    private Properties createPostProperties() throws Exception {
        Properties postProps = new Properties();
        postProps.setProperty(PYTHON_HOME, this.getRoot().getCanonicalPath());
        return postProps;
    }

    private File createTempDir() throws Exception {
        String name = ((Object)((Object)this)).getClass().getSimpleName();
        File tmpFile = File.createTempFile(name, "");
        PySystemState_registry_Test.assertTrue((boolean)tmpFile.exists());
        PySystemState_registry_Test.assertTrue((boolean)tmpFile.isFile());
        File parent = tmpFile.getParentFile();
        PySystemState_registry_Test.assertTrue((boolean)parent.exists());
        PySystemState_registry_Test.assertTrue((boolean)parent.isDirectory());
        PySystemState_registry_Test.assertTrue((boolean)tmpFile.delete());
        File tmpDir = new File(parent, name);
        PySystemState_registry_Test.assertTrue((boolean)tmpDir.mkdir());
        PySystemState_registry_Test.assertTrue((boolean)tmpDir.exists());
        PySystemState_registry_Test.assertTrue((boolean)tmpDir.isDirectory());
        this._tmpDir = tmpDir;
        return tmpDir;
    }

    private void cleanup() {
        File tmpDir = this.getTmpDir();
        if (tmpDir != null && tmpDir.exists()) {
            PySystemState_registry_Test.assertTrue((boolean)this.rmdir(tmpDir));
        }
        this._tmpDir = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readAll(File file) throws IOException {
        try (FileReader fileReader = new FileReader(file);){
            int n2;
            StringBuffer sb = new StringBuffer();
            char[] b2 = new char[8192];
            while ((n2 = fileReader.read(b2)) > 0) {
                sb.append(b2, 0, n2);
            }
            String string = sb.toString();
            return string;
        }
    }

    private void write(File file, String content) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write(content);
        writer.flush();
        writer.close();
    }

    private boolean rmdir(File dir) {
        boolean success = true;
        if (dir.exists()) {
            File[] files = dir.listFiles();
            for (int i2 = 0; i2 < files.length; ++i2) {
                File file = files[i2];
                if (file.isFile()) {
                    success = this.carryOnResult(file.delete(), success);
                    continue;
                }
                if (!file.isDirectory()) continue;
                success = this.carryOnResult(this.rmdir(file), success);
            }
            success = this.carryOnResult(dir.delete(), success);
        }
        return success;
    }

    private boolean carryOnResult(boolean newResult, boolean existingResult) {
        if (existingResult) {
            return newResult;
        }
        return existingResult;
    }

    private File getRoot() {
        return this._root;
    }

    private File getTmpDir() {
        return this._tmpDir;
    }

    private String getOriginalUserHome() {
        return this._originalUserHome;
    }

    private String getOriginalRegistryContent() {
        return this._originalRegistryContent;
    }
}

