/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.OutputStream;
import org.python.core.Py;
import org.python.core.PyAttributeDeleted;
import org.python.core.PyException;
import org.python.core.PyFile;
import org.python.core.PyFileWriter;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.util.StringUtil;

public class StdoutWrapper
extends OutputStream {
    protected String name = "stdout";

    protected PyObject getObject(PySystemState ss) {
        return ss.stdout;
    }

    protected void setObject(PySystemState ss, PyObject out) {
        ss.stdout = out;
    }

    protected PyObject myFile() {
        PySystemState ss = Py.getSystemState();
        PyObject out = this.getObject(ss);
        if (out == null) {
            throw Py.AttributeError("missing sys." + this.name);
        }
        if (out instanceof PyAttributeDeleted) {
            throw Py.RuntimeError("lost sys." + this.name);
        }
        if (out.getJavaProxy() != null) {
            PyFile f2 = null;
            Object tojava = out.__tojava__(OutputStream.class);
            if (tojava != null && tojava != Py.NoConversion) {
                f2 = new PyFile((OutputStream)tojava);
            }
            if (f2 != null) {
                this.setObject(ss, f2);
                return f2;
            }
        }
        return out;
    }

    @Override
    public void flush() {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            ((PyFile)out).flush();
        } else {
            try {
                out.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
        }
    }

    public void write(String s2) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            ((PyFile)out).write(s2);
        } else {
            out.invoke("write", new PyString(s2));
        }
    }

    @Override
    public void write(int i2) {
        this.write(new String(new char[]{(char)i2}));
    }

    @Override
    public void write(byte[] data, int off, int len) {
        this.write(StringUtil.fromBytes(data, off, len));
    }

    public void flushLine() {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            if (file.softspace) {
                file.write("\n");
            }
            file.flush();
            file.softspace = false;
        } else {
            PyObject ss = out.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                out.invoke("write", Py.Newline);
            }
            try {
                out.invoke("flush");
            }
            catch (PyException pyException) {
                // empty catch block
            }
            out.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }

    private String printToFile(PyFile file, PyObject o2) {
        String s2 = o2 instanceof PyUnicode ? ((PyUnicode)o2).encode(file.encoding, file.errors) : o2.__str__().toString();
        file.write(s2);
        return s2;
    }

    private String printToFileWriter(PyFileWriter file, PyObject o2) {
        String s2 = o2 instanceof PyString ? ((PyString)o2).getString() : o2.__str__().toString();
        file.write(s2);
        return s2;
    }

    private void printToFileObject(PyObject file, PyObject o2) {
        if (!(o2 instanceof PyUnicode)) {
            o2 = o2.__str__();
        }
        file.invoke("write", o2);
    }

    public void print(PyObject[] args, PyObject sep, PyObject end) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            for (int i2 = 0; i2 < args.length; ++i2) {
                this.printToFile(file, args[i2]);
                if (i2 >= args.length - 1) continue;
                this.printToFile(file, sep);
            }
            this.printToFile(file, end);
        } else if (out instanceof PyFileWriter) {
            PyFileWriter file = (PyFileWriter)out;
            for (int i3 = 0; i3 < args.length; ++i3) {
                this.printToFileWriter(file, args[i3]);
                if (i3 >= args.length - 1) continue;
                this.printToFileWriter(file, sep);
            }
            this.printToFileWriter(file, end);
        } else {
            for (int i4 = 0; i4 < args.length; ++i4) {
                this.printToFileObject(out, args[i4]);
                if (i4 >= args.length - 1) continue;
                this.printToFileObject(out, sep);
            }
            this.printToFileObject(out, end);
        }
    }

    public void print(PyObject o2, boolean space, boolean newline) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            if (file.softspace) {
                file.write(" ");
                file.softspace = false;
            }
            String s2 = this.printToFile(file, o2);
            if (o2 instanceof PyString) {
                int len = s2.length();
                if (len == 0 || !Character.isWhitespace(s2.charAt(len - 1)) || s2.charAt(len - 1) == ' ') {
                    file.softspace = space;
                }
            } else {
                file.softspace = space;
            }
            if (newline) {
                file.write("\n");
                file.softspace = false;
            }
            file.flush();
        } else if (out instanceof PyFileWriter) {
            PyFileWriter file = (PyFileWriter)out;
            if (file.softspace) {
                file.write(" ");
                file.softspace = false;
            }
            String s3 = this.printToFileWriter(file, o2);
            if (o2 instanceof PyString) {
                int len = s3.length();
                if (len == 0 || !Character.isWhitespace(s3.charAt(len - 1)) || s3.charAt(len - 1) == ' ') {
                    file.softspace = space;
                }
            } else {
                file.softspace = space;
            }
            if (newline) {
                file.write("\n");
                file.softspace = false;
            }
            file.flush();
        } else {
            PyObject ss = out.__findattr__("softspace");
            if (ss != null && ss.__nonzero__()) {
                out.invoke("write", Py.Space);
                out.__setattr__("softspace", (PyObject)Py.Zero);
            }
            this.printToFileObject(out, o2);
            if (o2 instanceof PyString) {
                String s4 = o2.toString();
                int len = s4.length();
                if (len == 0 || !Character.isWhitespace(s4.charAt(len - 1)) || s4.charAt(len - 1) == ' ') {
                    out.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
                }
            } else {
                out.__setattr__("softspace", (PyObject)(space ? Py.One : Py.Zero));
            }
            if (newline) {
                out.invoke("write", Py.Newline);
                out.__setattr__("softspace", (PyObject)Py.Zero);
            }
        }
    }

    public void print(String s2) {
        this.print(Py.newStringOrUnicode(s2), false, false);
    }

    public void println(String s2) {
        this.print(Py.newStringOrUnicode(s2), false, true);
    }

    public void print(PyObject o2) {
        this.print(o2, false, false);
    }

    public void printComma(PyObject o2) {
        this.print(o2, true, false);
    }

    public void println(PyObject o2) {
        this.print(o2, false, true);
    }

    public void println() {
        this.println(false);
    }

    public void println(boolean useUnicode) {
        PyObject out = this.myFile();
        if (out instanceof PyFile) {
            PyFile file = (PyFile)out;
            file.write("\n");
            file.flush();
            file.softspace = false;
        } else {
            if (useUnicode) {
                out.invoke("write", Py.UnicodeNewline);
            } else {
                out.invoke("write", Py.Newline);
            }
            out.__setattr__("softspace", (PyObject)Py.Zero);
        }
    }
}

