/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.python.core.PyString;
import org.python.core.PySystemState;
import org.python.core.Untraversable;

@Untraversable
public class SyspathArchive
extends PyString {
    private ZipFile zipFile;

    public SyspathArchive(String archiveName) throws IOException {
        super(archiveName);
        archiveName = SyspathArchive.getArchiveName(archiveName);
        if (archiveName == null) {
            throw new IOException("path '" + archiveName + "' not an archive");
        }
        this.zipFile = new ZipFile(new File(archiveName));
        if (PySystemState.isPackageCacheEnabled()) {
            PySystemState.packageManager.addJar(archiveName, true);
        }
    }

    SyspathArchive(ZipFile zipFile, String archiveName) {
        super(archiveName);
        this.zipFile = zipFile;
    }

    static String getArchiveName(String dir) {
        String lowerName = dir.toLowerCase();
        int idx = lowerName.indexOf(".zip");
        if (idx < 0) {
            idx = lowerName.indexOf(".jar");
        }
        if (idx < 0) {
            return null;
        }
        if (idx == dir.length() - 4) {
            return dir;
        }
        char ch = dir.charAt(idx + 4);
        if (ch == File.separatorChar || ch == '/') {
            return dir.substring(0, idx + 4);
        }
        return null;
    }

    public SyspathArchive makeSubfolder(String folder) {
        return new SyspathArchive(this.zipFile, super.toString() + "/" + folder);
    }

    private String makeEntry(String entry) {
        String archive = super.toString();
        String folder = SyspathArchive.getArchiveName(super.toString());
        if (archive.length() == folder.length()) {
            return entry;
        }
        return archive.substring(folder.length() + 1) + "/" + entry;
    }

    ZipEntry getEntry(String entryName) {
        return this.zipFile.getEntry(this.makeEntry(entryName));
    }

    public String asUriCompatibleString() {
        String result = this.__str__().toString();
        if (File.separatorChar == '\\') {
            return result.replace(File.separatorChar, '/');
        }
        return result;
    }

    InputStream getInputStream(ZipEntry entry) throws IOException {
        int l2;
        int len;
        InputStream istream = this.zipFile.getInputStream(entry);
        byte[] buffer = new byte[len];
        int off = 0;
        for (len = (int)entry.getSize(); len > 0; len -= l2) {
            l2 = istream.read(buffer, off, buffer.length - off);
            if (l2 < 0) {
                return null;
            }
            off += l2;
        }
        istream.close();
        return new ByteArrayInputStream(buffer);
    }
}

