/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.adapter;

import java.math.BigInteger;
import org.python.core.Py;
import org.python.core.PyArray;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyJavaType;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyProxy;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.adapter.ClassAdapter;
import org.python.core.adapter.ExtensiblePyObjectAdapter;
import org.python.core.adapter.PyObjectAdapter;

public class ClassicPyObjectAdapter
extends ExtensiblePyObjectAdapter {
    public ClassicPyObjectAdapter() {
        this.addPreClass(new PyObjectAdapter(){

            @Override
            public PyObject adapt(Object o2) {
                return (PyObject)o2;
            }

            @Override
            public boolean canAdapt(Object o2) {
                return o2 instanceof PyObject;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            @Override
            public PyObject adapt(Object o2) {
                return ((PyProxy)o2)._getPyInstance();
            }

            @Override
            public boolean canAdapt(Object o2) {
                return o2 instanceof PyProxy;
            }
        });
        this.addPreClass(new PyObjectAdapter(){

            @Override
            public boolean canAdapt(Object o2) {
                return o2 == null;
            }

            @Override
            public PyObject adapt(Object o2) {
                return Py.None;
            }
        });
        this.add(new ClassAdapter(String.class){

            @Override
            public PyObject adapt(Object o2) {
                return new PyUnicode((String)o2);
            }
        });
        this.add(new ClassAdapter(Character.class){

            @Override
            public PyObject adapt(Object o2) {
                return Py.makeCharacter((Character)o2);
            }
        });
        this.add(new ClassAdapter(Class.class){

            @Override
            public PyObject adapt(Object o2) {
                return PyType.fromClass((Class)o2, false);
            }
        });
        this.add(new NumberToPyFloat(Double.class));
        this.add(new NumberToPyFloat(Float.class));
        this.add(new NumberToPyInteger(Integer.class));
        this.add(new NumberToPyInteger(Byte.class));
        this.add(new NumberToPyInteger(Short.class));
        this.add(new ClassAdapter(Long.class){

            @Override
            public PyObject adapt(Object o2) {
                return new PyLong(((Number)o2).longValue());
            }
        });
        this.add(new ClassAdapter(BigInteger.class){

            @Override
            public PyObject adapt(Object o2) {
                return new PyLong((BigInteger)o2);
            }
        });
        this.add(new ClassAdapter(Boolean.class){

            @Override
            public PyObject adapt(Object o2) {
                return (Boolean)o2 != false ? Py.True : Py.False;
            }
        });
        this.addPostClass(new PyObjectAdapter(){

            @Override
            public PyObject adapt(Object o2) {
                return new PyArray(o2.getClass().getComponentType(), o2);
            }

            @Override
            public boolean canAdapt(Object o2) {
                return o2.getClass().isArray();
            }
        });
    }

    @Override
    public boolean canAdapt(Object o2) {
        return true;
    }

    @Override
    public PyObject adapt(Object o2) {
        PyObject result = super.adapt(o2);
        if (result != null) {
            return result;
        }
        return PyJavaType.wrapJavaObject(o2);
    }

    private static class NumberToPyFloat
    extends ClassAdapter {
        public NumberToPyFloat(Class c2) {
            super(c2);
        }

        @Override
        public PyObject adapt(Object o2) {
            return new PyFloat(((Number)o2).doubleValue());
        }
    }

    private static class NumberToPyInteger
    extends ClassAdapter {
        public NumberToPyInteger(Class c2) {
            super(c2);
        }

        @Override
        public PyObject adapt(Object o2) {
            return new PyInteger(((Number)o2).intValue());
        }
    }
}

