/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import java.nio.ByteBuffer;
import org.python.core.Py;
import org.python.core.PyBuffer;
import org.python.core.PyException;

public abstract class BaseBuffer
implements PyBuffer {
    protected int[] shape;
    protected int[] strides;
    protected byte[] storage;
    protected int index0;
    protected int exports = 1;
    private int gFeatureFlags = -281;

    protected BaseBuffer(int featureFlags) {
        this.setFeatureFlags(featureFlags | 4 | 0x10000000);
    }

    protected final int getFeatureFlags() {
        return 0x118 ^ ~this.gFeatureFlags;
    }

    protected final void setFeatureFlags(int flags) {
        this.gFeatureFlags = 0xFFFFFEE7 ^ flags;
    }

    protected final void addFeatureFlags(int flags) {
        this.setFeatureFlags(flags | this.getFeatureFlags());
    }

    protected void checkRequestFlags(int flags) throws PyException {
        int syndrome = this.gFeatureFlags & (flags ^ 0x118);
        if (syndrome != 0) {
            throw BaseBuffer.bufferErrorFromSyndrome(syndrome);
        }
    }

    @Override
    public boolean isReadonly() {
        return (this.gFeatureFlags & 1) != 0;
    }

    @Override
    public boolean hasArray() {
        return (this.gFeatureFlags & 0x10000000) != 0;
    }

    @Override
    public int getNdim() {
        return this.shape.length;
    }

    @Override
    public int[] getShape() {
        return this.shape;
    }

    @Override
    public int getLen() {
        return this.shape[0] * this.getItemsize();
    }

    @Override
    public byte byteAt(int index) throws IndexOutOfBoundsException {
        return this.storage[this.calcIndex(index)];
    }

    @Override
    public int intAt(int index) throws IndexOutOfBoundsException {
        return 0xFF & this.byteAt(index);
    }

    @Override
    public void storeAt(byte value, int index) throws IndexOutOfBoundsException, PyException {
        if (this.isReadonly()) {
            throw BaseBuffer.notWritable();
        }
        this.storage[this.calcIndex((int)index)] = value;
    }

    protected int calcIndex(int index) throws IndexOutOfBoundsException {
        return this.index0 + index * this.getStrides()[0];
    }

    @Override
    public byte byteAt(int ... indices) throws IndexOutOfBoundsException {
        return this.storage[this.calcIndex(indices)];
    }

    @Override
    public int intAt(int ... indices) throws IndexOutOfBoundsException {
        return 0xFF & this.byteAt(indices);
    }

    @Override
    public void storeAt(byte value, int ... indices) throws IndexOutOfBoundsException, PyException {
        if (this.isReadonly()) {
            throw BaseBuffer.notWritable();
        }
        this.storage[this.calcIndex((int[])indices)] = value;
    }

    protected int calcIndex(int ... indices) throws IndexOutOfBoundsException {
        int N2 = this.checkDimension(indices);
        int index = this.index0;
        if (N2 > 0) {
            int[] strides = this.getStrides();
            for (int k2 = 0; k2 < N2; ++k2) {
                index += indices[k2] * strides[k2];
            }
        }
        return index;
    }

    protected int calcGreatestIndex() throws IndexOutOfBoundsException {
        int N2 = this.shape.length;
        int index = this.index0;
        if (N2 > 0) {
            int[] strides = this.getStrides();
            for (int k2 = 0; k2 < N2; ++k2) {
                int stride = strides[k2];
                if (stride <= 0) continue;
                index += (this.shape[k2] - 1) * stride;
            }
        }
        return index;
    }

    protected int calcLeastIndex() throws IndexOutOfBoundsException {
        int N2 = this.shape.length;
        int index = this.index0;
        if (N2 > 0) {
            int[] strides = this.getStrides();
            for (int k2 = 0; k2 < N2; ++k2) {
                int stride = strides[k2];
                if (stride >= 0) continue;
                index += (this.shape[k2] - 1) * stride;
            }
        }
        return index;
    }

    @Override
    public void copyTo(byte[] dest, int destPos) throws IndexOutOfBoundsException {
        this.copyTo(0, dest, destPos, this.shape[0]);
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int length) throws IndexOutOfBoundsException {
        int s2;
        int d2 = destPos;
        int itemsize = this.getItemsize();
        int stride = this.getStrides()[0];
        int skip = stride - itemsize;
        if (skip == 0) {
            System.arraycopy(this.storage, s2, dest, d2, length * itemsize);
        } else if (itemsize == 1) {
            int limit = s2 + length * stride;
            for (s2 = this.calcIndex(srcIndex); s2 < limit; s2 += stride) {
                dest[d2++] = this.storage[s2];
            }
        } else {
            int limit = s2 + length * stride;
            while (s2 < limit) {
                int t2 = s2 + itemsize;
                while (s2 < t2) {
                    dest[d2++] = this.storage[s2++];
                }
                s2 += skip;
            }
        }
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int length) throws IndexOutOfBoundsException, PyException {
        int d2;
        if (this.isReadonly()) {
            throw BaseBuffer.notWritable();
        }
        int s2 = srcPos;
        int itemsize = this.getItemsize();
        int stride = this.getStrides()[0];
        int skip = stride - itemsize;
        if (skip == 0) {
            System.arraycopy(src, srcPos, this.storage, d2, length * itemsize);
        } else if (itemsize == 1) {
            int limit = d2 + length * stride;
            for (d2 = this.calcIndex(destIndex); d2 != limit; d2 += stride) {
                this.storage[d2] = src[s2++];
            }
        } else {
            int limit = d2 + length * stride;
            while (d2 != limit) {
                int t2 = d2 + itemsize;
                while (d2 < t2) {
                    this.storage[d2++] = src[s2++];
                }
                d2 += skip;
            }
        }
    }

    @Override
    public void copyFrom(PyBuffer src) throws IndexOutOfBoundsException, PyException {
        int d2;
        if (this.isReadonly()) {
            throw BaseBuffer.notWritable();
        }
        if (src.getLen() != this.getLen() || src.getItemsize() != this.getItemsize()) {
            throw BaseBuffer.differentStructure();
        }
        int s2 = 0;
        int itemsize = this.getItemsize();
        int stride = this.getStrides()[0];
        if (stride == itemsize) {
            src.copyTo(this.storage, d2);
        } else if (itemsize == 1) {
            int limit = d2 + src.getLen() * stride;
            for (d2 = this.calcIndex(0); d2 != limit; d2 += stride) {
                this.storage[d2] = src.byteAt(s2++);
            }
        } else {
            int limit = d2 + src.getShape()[0] * stride;
            while (d2 != limit) {
                PyBuffer.Pointer srcItem = src.getPointer(s2++);
                System.arraycopy(srcItem.storage, srcItem.offset, this.storage, d2, itemsize);
                d2 += stride;
            }
        }
    }

    @Override
    public synchronized PyBuffer getBuffer(int flags) {
        if (this.exports > 0) {
            return this.getBufferAgain(flags);
        }
        throw BaseBuffer.bufferReleased("getBuffer");
    }

    public synchronized BaseBuffer getBufferAgain(int flags) {
        this.checkRequestFlags(flags);
        ++this.exports;
        return this;
    }

    @Override
    public void release() {
        if (--this.exports == 0) {
            this.releaseAction();
        } else if (this.exports < 0) {
            this.exports = 0;
            throw BaseBuffer.bufferReleased("release");
        }
    }

    @Override
    public void close() {
        this.release();
    }

    @Override
    public boolean isReleased() {
        return this.exports <= 0;
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length) {
        return this.getBufferSlice(flags, start, length, 1);
    }

    @Override
    public ByteBuffer getNIOByteBuffer() {
        int length = this.calcGreatestIndex() + this.getItemsize() - this.index0;
        ByteBuffer b2 = ByteBuffer.wrap(this.storage, this.index0, length);
        return this.isReadonly() ? b2.asReadOnlyBuffer() : b2;
    }

    @Override
    public PyBuffer.Pointer getBuf() {
        return new PyBuffer.Pointer(this.storage, this.index0);
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) throws IndexOutOfBoundsException {
        return new PyBuffer.Pointer(this.storage, this.calcIndex(index));
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) throws IndexOutOfBoundsException {
        return new PyBuffer.Pointer(this.storage, this.calcIndex(indices));
    }

    @Override
    public int[] getStrides() {
        return this.strides;
    }

    @Override
    public int[] getSuboffsets() {
        return null;
    }

    @Override
    public boolean isContiguous(char order) {
        return true;
    }

    @Override
    public String getFormat() {
        return "B";
    }

    @Override
    public int getItemsize() {
        return 1;
    }

    protected void releaseAction() {
    }

    protected PyBuffer getRoot() {
        return this;
    }

    int checkDimension(int[] indices) throws PyException {
        int n2 = indices.length;
        this.checkDimension(n2);
        return n2;
    }

    void checkDimension(int n2) throws PyException {
        int ndim = this.getNdim();
        if (n2 != ndim) {
            String fmt = "buffer with %d dimension%s accessed as having %d dimension%s";
            String msg = String.format(fmt, ndim, ndim == 1 ? "" : "s", n2, n2, n2 == 1 ? "" : "s");
            throw Py.BufferError(msg);
        }
    }

    @Override
    public String toString() {
        int n2 = this.getLen();
        StringBuilder sb = new StringBuilder(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            sb.appendCodePoint(this.intAt(i2));
        }
        return sb.toString();
    }

    private static PyException bufferErrorFromSyndrome(int syndrome) {
        if ((syndrome & 8) != 0) {
            return BaseBuffer.bufferRequires("shape array");
        }
        if ((syndrome & 1) != 0) {
            return BaseBuffer.bufferIsNot("writable");
        }
        if ((syndrome & 0x10000000) != 0) {
            return BaseBuffer.bufferIsNot("accessible as a Java array");
        }
        if ((syndrome & 0x38) != 0) {
            return BaseBuffer.bufferIsNot("C-contiguous");
        }
        if ((syndrome & 0x58) != 0) {
            return BaseBuffer.bufferIsNot("Fortran-contiguous");
        }
        if ((syndrome & 0x98) != 0) {
            return BaseBuffer.bufferIsNot("contiguous");
        }
        if ((syndrome & 0x18) != 0) {
            return BaseBuffer.bufferRequires("strides array");
        }
        if ((syndrome & 0x118) != 0) {
            return BaseBuffer.bufferRequires("suboffsets array");
        }
        return BaseBuffer.bufferIsNot("capable of matching request");
    }

    protected static PyException notWritable() {
        return Py.TypeError("cannot modify read-only memory");
    }

    protected static PyException bufferIsNot(String property) {
        return Py.BufferError("underlying buffer is not " + property);
    }

    protected static PyException differentStructure() {
        return Py.ValueError("buffer assignment: lvalue and rvalue have different structures");
    }

    protected static PyException bufferRequires(String feature) {
        return Py.BufferError("buffer structure requires consumer to use " + feature);
    }

    protected static PyException bufferReleased(String operation) {
        String op = operation == null ? "" : operation + " ";
        return Py.BufferError(op + "operation forbidden on released buffer object");
    }
}

