/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import java.nio.ByteBuffer;
import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.BaseBuffer;
import org.python.core.buffer.Strided1DBuffer;
import org.python.core.buffer.ZeroByteBuffer;
import org.python.core.util.StringUtil;

public class SimpleBuffer
extends BaseBuffer {
    protected static final int[] SIMPLE_STRIDES = new int[]{1};

    protected SimpleBuffer() {
        super(224);
        this.shape = new int[1];
        this.strides = SIMPLE_STRIDES;
    }

    public SimpleBuffer(byte[] storage, int index0, int size) throws PyException, ArrayIndexOutOfBoundsException {
        this();
        this.storage = storage;
        this.index0 = index0;
        this.shape[0] = size;
        if ((index0 | size | storage.length - (index0 + size)) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
    }

    public SimpleBuffer(int flags, byte[] storage, int index0, int size) throws PyException, ArrayIndexOutOfBoundsException, NullPointerException {
        this(storage, index0, size);
        this.checkRequestFlags(flags);
    }

    public SimpleBuffer(byte[] storage) throws NullPointerException {
        this();
        this.storage = storage;
        this.shape[0] = storage.length;
    }

    public SimpleBuffer(int flags, byte[] storage) throws PyException, NullPointerException {
        this(storage);
        this.checkRequestFlags(flags);
    }

    @Override
    public boolean isReadonly() {
        return true;
    }

    @Override
    public int getLen() {
        return this.shape[0];
    }

    @Override
    public byte byteAt(int index) throws IndexOutOfBoundsException {
        return this.storage[this.index0 + index];
    }

    @Override
    public int intAt(int index) throws IndexOutOfBoundsException {
        return 0xFF & this.storage[this.index0 + index];
    }

    @Override
    protected int calcIndex(int index) throws IndexOutOfBoundsException {
        return this.index0 + index;
    }

    @Override
    public byte byteAt(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices.length);
        return this.byteAt(indices[0]);
    }

    @Override
    protected int calcIndex(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices.length);
        return this.calcIndex(indices[0]);
    }

    @Override
    public void copyTo(int srcIndex, byte[] dest, int destPos, int length) throws IndexOutOfBoundsException {
        System.arraycopy(this.storage, this.index0 + srcIndex, dest, destPos, length);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length) {
        if (length > 0) {
            int compIndex0 = this.index0 + start;
            return new SimpleView(this.getRoot(), flags, this.storage, compIndex0, length);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
        if (stride == 1 || length < 2) {
            return this.getBufferSlice(flags, start, length);
        }
        int compIndex0 = this.index0 + start;
        return new Strided1DBuffer.SlicedView(this.getRoot(), flags, this.storage, compIndex0, length, stride);
    }

    @Override
    public ByteBuffer getNIOByteBuffer() {
        ByteBuffer b2 = ByteBuffer.wrap(this.storage, this.index0, this.shape[0]);
        return this.isReadonly() ? b2.asReadOnlyBuffer() : b2;
    }

    @Override
    public PyBuffer.Pointer getPointer(int index) throws IndexOutOfBoundsException {
        return new PyBuffer.Pointer(this.storage, this.index0 + index);
    }

    @Override
    public PyBuffer.Pointer getPointer(int ... indices) throws IndexOutOfBoundsException {
        this.checkDimension(indices.length);
        return this.getPointer(indices[0]);
    }

    @Override
    public String toString() {
        return StringUtil.fromBytes(this.storage, this.index0, this.shape[0]);
    }

    static class SimpleView
    extends SimpleBuffer {
        PyBuffer root;

        public SimpleView(PyBuffer root, int flags, byte[] storage, int offset, int size) {
            super(flags, storage, offset, size);
            this.root = root.getBuffer(284);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public void releaseAction() {
            this.root.release();
        }
    }
}

