/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.buffer;

import org.python.core.PyBuffer;
import org.python.core.PyException;
import org.python.core.buffer.Strided1DBuffer;
import org.python.core.buffer.ZeroByteBuffer;

public class Strided1DWritableBuffer
extends Strided1DBuffer {
    public Strided1DWritableBuffer(int flags, byte[] storage, int index0, int length, int stride) throws ArrayIndexOutOfBoundsException, NullPointerException, PyException {
        super(storage, index0, length, stride);
        this.addFeatureFlags(1);
        this.checkRequestFlags(flags);
    }

    @Override
    public boolean isReadonly() {
        return false;
    }

    @Override
    public void storeAt(byte value, int index) throws IndexOutOfBoundsException, PyException {
        this.storage[this.index0 + index * this.stride] = value;
    }

    @Override
    public void copyFrom(byte[] src, int srcPos, int destIndex, int length) throws IndexOutOfBoundsException, PyException {
        int d2;
        int s2 = srcPos;
        if (this.stride == 1) {
            System.arraycopy(src, srcPos, this.storage, d2, length);
        } else {
            int limit = d2 + length * this.stride;
            for (d2 = this.index0 + destIndex * this.stride; d2 != limit; d2 += this.stride) {
                this.storage[d2] = src[s2++];
            }
        }
    }

    @Override
    public PyBuffer getBufferSlice(int flags, int start, int length, int stride) {
        if (length > 0) {
            int compStride = this.stride * stride;
            int compIndex0 = this.index0 + start * this.stride;
            return new SlicedView(this.getRoot(), flags, this.storage, compIndex0, length, compStride);
        }
        return new ZeroByteBuffer.View(this.getRoot(), flags);
    }

    static class SlicedView
    extends Strided1DWritableBuffer {
        PyBuffer root;

        public SlicedView(PyBuffer root, int flags, byte[] storage, int index0, int len, int stride) throws PyException {
            super(flags, storage, index0, len, stride);
            this.root = root.getBuffer(285);
        }

        @Override
        protected PyBuffer getRoot() {
            return this.root;
        }

        @Override
        public void releaseAction() {
            this.root.release();
        }
    }
}

