/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.packagecache;

import java.io.File;
import java.util.Properties;
import java.util.StringTokenizer;
import org.python.core.Py;
import org.python.core.PyJavaPackage;
import org.python.core.PyList;
import org.python.core.PySystemState;
import org.python.core.packagecache.PathPackageManager;

public class SysPackageManager
extends PathPackageManager {
    @Override
    protected void message(String msg) {
        Py.writeMessage("*sys-package-mgr*", msg);
    }

    @Override
    protected void warning(String warn) {
        Py.writeWarning("*sys-package-mgr*", warn);
    }

    @Override
    protected void comment(String msg) {
        Py.writeComment("*sys-package-mgr*", msg);
    }

    @Override
    protected void debug(String msg) {
        Py.writeDebug("*sys-package-mgr*", msg);
    }

    public SysPackageManager(File cachedir, Properties registry) {
        if (this.useCacheDir(cachedir)) {
            this.initCache();
            this.findAllPackages(registry);
            this.saveCache();
        }
    }

    @Override
    public void addJar(String jarfile, boolean cache) {
        this.addJarToPackages(new File(jarfile), cache);
        if (cache) {
            this.saveCache();
        }
    }

    @Override
    public void addJarDir(String jdir, boolean cache) {
        this.addJarDir(jdir, cache, cache);
    }

    private void addJarDir(String jdir, boolean cache, boolean saveCache) {
        File file = new File(jdir);
        if (!file.isDirectory()) {
            return;
        }
        String[] files = file.list();
        for (int i2 = 0; i2 < files.length; ++i2) {
            String entry = files[i2];
            if (!entry.endsWith(".jar") && !entry.endsWith(".zip")) continue;
            this.addJarToPackages(new File(jdir, entry), cache);
        }
        if (saveCache) {
            this.saveCache();
        }
    }

    private void addJarPath(String path) {
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            String entry = tok.nextToken();
            this.addJarDir(entry, true, false);
        }
    }

    private void findAllPackages(Properties registry) {
        String tmp;
        String entry;
        String paths = registry.getProperty("python.packages.paths", "java.class.path,sun.boot.class.path");
        String directories = registry.getProperty("python.packages.directories", "java.ext.dirs");
        String fakepath = registry.getProperty("python.packages.fakepath", null);
        StringTokenizer tok = new StringTokenizer(paths, ",");
        while (tok.hasMoreTokens()) {
            entry = tok.nextToken().trim();
            tmp = registry.getProperty(entry);
            if (tmp == null) continue;
            this.addClassPath(tmp);
        }
        tok = new StringTokenizer(directories, ",");
        while (tok.hasMoreTokens()) {
            entry = tok.nextToken().trim();
            tmp = registry.getProperty(entry);
            if (tmp == null) continue;
            this.addJarPath(tmp);
        }
        if (fakepath != null) {
            this.addClassPath(fakepath);
        }
    }

    @Override
    public void notifyPackageImport(String pkg, String name) {
        if (pkg != null && pkg.length() > 0) {
            name = pkg + '.' + name;
        }
        Py.writeComment("import", "'" + name + "' as java package");
    }

    @Override
    public Class findClass(String pkg, String name) {
        Class c2 = super.findClass(pkg, name);
        if (c2 != null) {
            Py.writeComment("import", "'" + name + "' as java class");
        }
        return c2;
    }

    @Override
    public Class findClass(String pkg, String name, String reason) {
        if (pkg != null && pkg.length() > 0) {
            name = pkg + '.' + name;
        }
        return Py.findClassEx(name, reason);
    }

    @Override
    public PyList doDir(PyJavaPackage jpkg, boolean instantiate, boolean exclpkgs) {
        PyList basic = this.basicDoDir(jpkg, instantiate, exclpkgs);
        PyList ret = new PyList();
        this.doDir(this.searchPath, ret, jpkg, instantiate, exclpkgs);
        PySystemState system = Py.getSystemState();
        if (system.getClassLoader() == null) {
            this.doDir(system.path, ret, jpkg, instantiate, exclpkgs);
        }
        return this.merge(basic, ret);
    }

    @Override
    public boolean packageExists(String pkg, String name) {
        if (this.packageExists(this.searchPath, pkg, name)) {
            return true;
        }
        PySystemState system = Py.getSystemState();
        return system.getClassLoader() == null && this.packageExists(Py.getSystemState().path, pkg, name);
    }
}

