/*
 * Decompiled with CFR 0.152.
 */
package org.python.core.stringlib;

import org.python.core.stringlib.InternalFormat;

public class TextFormatter
extends InternalFormat.Formatter {
    public TextFormatter(StringBuilder result, InternalFormat.Spec spec) {
        super(result, spec);
    }

    public TextFormatter(InternalFormat.Spec spec) {
        this(new StringBuilder(), spec);
    }

    @Override
    public TextFormatter append(char c2) {
        super.append(c2);
        return this;
    }

    @Override
    public TextFormatter append(CharSequence csq) {
        super.append(csq);
        return this;
    }

    @Override
    public TextFormatter append(CharSequence csq, int start, int end) throws IndexOutOfBoundsException {
        super.append(csq, start, end);
        return this;
    }

    public TextFormatter format(String value) {
        this.setStart();
        int p2 = this.spec.precision;
        int n2 = value.length();
        if (InternalFormat.Spec.specified(p2) && p2 < n2) {
            int space = Math.max(this.spec.width, p2);
            this.result.ensureCapacity(this.result.length() + space + (this.bytes ? 0 : space / 4));
            int count2 = 0;
            while (count2 < p2) {
                char c2 = value.charAt(count2++);
                this.result.append(c2);
                if (!Character.isHighSurrogate(c2) || p2 >= n2) continue;
                ++p2;
            }
            this.lenWhole = count2;
        } else {
            this.lenWhole = n2;
            this.result.append(value);
        }
        return this;
    }

    @Override
    public TextFormatter pad() {
        int n2 = this.spec.width - this.result.codePointCount(this.mark, this.result.length());
        if (n2 > 0) {
            this.pad(this.mark, n2);
        }
        return this;
    }
}

