/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl;

import java.text.CharacterIterator;
import java.util.HashSet;
import java.util.Iterator;
import org.python.icu.impl.ICUResourceBundle;
import org.python.icu.text.BreakIterator;
import org.python.icu.text.FilteredBreakIteratorBuilder;
import org.python.icu.text.UCharacterIterator;
import org.python.icu.util.BytesTrie;
import org.python.icu.util.CharsTrie;
import org.python.icu.util.CharsTrieBuilder;
import org.python.icu.util.StringTrieBuilder;
import org.python.icu.util.ULocale;
import org.python.icu.util.UResourceBundle;

public class SimpleFilteredSentenceBreakIterator
extends BreakIterator {
    private BreakIterator delegate;
    private UCharacterIterator text;
    private CharsTrie backwardsTrie;
    private CharsTrie forwardsPartialTrie;

    public SimpleFilteredSentenceBreakIterator(BreakIterator adoptBreakIterator, CharsTrie forwardsPartialTrie, CharsTrie backwardsTrie) {
        this.delegate = adoptBreakIterator;
        this.forwardsPartialTrie = forwardsPartialTrie;
        this.backwardsTrie = backwardsTrie;
    }

    public int next() {
        int n2 = this.delegate.next();
        if (n2 == -1 || this.backwardsTrie == null) {
            return n2;
        }
        this.text = UCharacterIterator.getInstance((CharacterIterator)this.delegate.getText().clone());
        do {
            this.text.setIndex(n2);
            this.backwardsTrie.reset();
            int uch = this.text.previousCodePoint();
            if (uch != 32) {
                uch = this.text.nextCodePoint();
            }
            BytesTrie.Result r2 = BytesTrie.Result.INTERMEDIATE_VALUE;
            int bestPosn = -1;
            int bestValue = -1;
            while ((uch = this.text.previousCodePoint()) != -1 && (r2 = this.backwardsTrie.nextForCodePoint(uch)).hasNext()) {
                if (!r2.hasValue()) continue;
                bestPosn = this.text.getIndex();
                bestValue = this.backwardsTrie.getValue();
            }
            if (r2.matches()) {
                bestValue = this.backwardsTrie.getValue();
                bestPosn = this.text.getIndex();
            }
            if (bestPosn >= 0) {
                if (bestValue == 2) {
                    n2 = this.delegate.next();
                    if (n2 != -1) continue;
                    return n2;
                }
                if (bestValue == 1 && this.forwardsPartialTrie != null) {
                    this.forwardsPartialTrie.reset();
                    BytesTrie.Result rfwd = BytesTrie.Result.INTERMEDIATE_VALUE;
                    this.text.setIndex(bestPosn);
                    while ((uch = this.text.nextCodePoint()) != -1 && (rfwd = this.forwardsPartialTrie.nextForCodePoint(uch)).hasNext()) {
                    }
                    if (rfwd.matches()) {
                        n2 = this.delegate.next();
                        if (n2 != -1) continue;
                        return n2;
                    }
                    return n2;
                }
                return n2;
            }
            return n2;
        } while (n2 != -1);
        return n2;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleFilteredSentenceBreakIterator other = (SimpleFilteredSentenceBreakIterator)obj;
        return this.delegate.equals(other.delegate) && this.text.equals(other.text) && this.backwardsTrie.equals(other.backwardsTrie) && this.forwardsPartialTrie.equals(other.forwardsPartialTrie);
    }

    public int hashCode() {
        return this.forwardsPartialTrie.hashCode() * 39 + this.backwardsTrie.hashCode() * 11 + this.delegate.hashCode();
    }

    public Object clone() {
        SimpleFilteredSentenceBreakIterator other = (SimpleFilteredSentenceBreakIterator)super.clone();
        return other;
    }

    public int first() {
        return this.delegate.first();
    }

    public int last() {
        return this.delegate.last();
    }

    public int next(int n2) {
        throw new UnsupportedOperationException("next(int) is not yet implemented");
    }

    public int previous() {
        throw new UnsupportedOperationException("previous() is not yet implemented");
    }

    public int following(int offset) {
        throw new UnsupportedOperationException("following(int) is not yet implemented");
    }

    public int current() {
        return this.delegate.current();
    }

    public int preceding(int offset) {
        throw new UnsupportedOperationException("preceding(int) is not yet implemented");
    }

    public CharacterIterator getText() {
        return this.delegate.getText();
    }

    public void setText(CharacterIterator newText) {
        this.delegate.setText(newText);
    }

    public static class Builder
    extends FilteredBreakIteratorBuilder {
        private HashSet<String> filterSet;
        static final int PARTIAL = 1;
        static final int MATCH = 2;
        static final int SuppressInReverse = 1;
        static final int AddToForward = 2;

        public Builder(ULocale loc) {
            ICUResourceBundle rb = (ICUResourceBundle)UResourceBundle.getBundleInstance("org/python/icu/impl/data/icudt56b/brkitr", loc);
            ICUResourceBundle exceptions2 = rb.findWithFallback("exceptions");
            ICUResourceBundle breaks = exceptions2.findWithFallback("SentenceBreak");
            this.filterSet = new HashSet();
            if (breaks != null) {
                int size = breaks.getSize();
                for (int index = 0; index < size; ++index) {
                    ICUResourceBundle b2 = (ICUResourceBundle)breaks.get(index);
                    String br = b2.getString();
                    this.filterSet.add(br);
                }
            }
        }

        public Builder() {
            this.filterSet = new HashSet();
        }

        public boolean suppressBreakAfter(String str) {
            if (this.filterSet == null) {
                this.filterSet = new HashSet();
            }
            return this.filterSet.add(str);
        }

        public boolean unsuppressBreakAfter(String str) {
            if (this.filterSet == null) {
                return false;
            }
            return this.filterSet.remove(str);
        }

        public BreakIterator build(BreakIterator adoptBreakIterator) {
            CharsTrieBuilder builder = new CharsTrieBuilder();
            CharsTrieBuilder builder2 = new CharsTrieBuilder();
            int revCount = 0;
            int fwdCount = 0;
            int subCount = this.filterSet.size();
            String[] ustrs = new String[subCount];
            int[] partials = new int[subCount];
            CharsTrie backwardsTrie = null;
            CharsTrie forwardsPartialTrie = null;
            int i2 = 0;
            Iterator<String> i$ = this.filterSet.iterator();
            while (i$.hasNext()) {
                String s2;
                ustrs[i2] = s2 = i$.next();
                partials[i2] = 0;
                ++i2;
            }
            for (i2 = 0; i2 < subCount; ++i2) {
                int nn = ustrs[i2].indexOf(46);
                if (nn <= -1 || nn + 1 == ustrs[i2].length()) continue;
                int sameAs = -1;
                for (int j2 = 0; j2 < subCount; ++j2) {
                    if (j2 == i2 || !ustrs[i2].regionMatches(0, ustrs[j2], 0, nn + 1)) continue;
                    if (partials[j2] == 0) {
                        partials[j2] = 3;
                        continue;
                    }
                    if ((partials[j2] & 1) == 0) continue;
                    sameAs = j2;
                }
                if (sameAs != -1 || partials[i2] != 0) continue;
                StringBuilder prefix = new StringBuilder(ustrs[i2].substring(0, nn + 1));
                prefix.reverse();
                builder.add(prefix, 1);
                ++revCount;
                partials[i2] = 3;
            }
            for (i2 = 0; i2 < subCount; ++i2) {
                if (partials[i2] == 0) {
                    StringBuilder reversed = new StringBuilder(ustrs[i2]).reverse();
                    builder.add(reversed, 2);
                    ++revCount;
                    continue;
                }
                builder2.add(ustrs[i2], 2);
                ++fwdCount;
            }
            if (revCount > 0) {
                backwardsTrie = builder.build(StringTrieBuilder.Option.FAST);
            }
            if (fwdCount > 0) {
                forwardsPartialTrie = builder2.build(StringTrieBuilder.Option.FAST);
            }
            return new SimpleFilteredSentenceBreakIterator(adoptBreakIterator, forwardsPartialTrie, backwardsTrie);
        }
    }
}

