/*
 * Decompiled with CFR 0.152.
 */
package org.python.icu.impl.coll;

import org.python.icu.impl.coll.CollationData;
import org.python.icu.impl.coll.CollationIterator;
import org.python.icu.text.UCharacterIterator;

public class IterCollationIterator
extends CollationIterator {
    protected UCharacterIterator iter;

    public IterCollationIterator(CollationData d2, boolean numeric, UCharacterIterator ui) {
        super(d2, numeric);
        this.iter = ui;
    }

    public void resetToOffset(int newOffset) {
        this.reset();
        this.iter.setIndex(newOffset);
    }

    public int getOffset() {
        return this.iter.getIndex();
    }

    public int nextCodePoint() {
        return this.iter.nextCodePoint();
    }

    public int previousCodePoint() {
        return this.iter.previousCodePoint();
    }

    protected long handleNextCE32() {
        int c2 = this.iter.next();
        if (c2 < 0) {
            return -4294967104L;
        }
        return this.makeCodePointAndCE32Pair(c2, this.trie.getFromU16SingleLead((char)c2));
    }

    protected char handleGetTrailSurrogate() {
        int trail = this.iter.next();
        if (!IterCollationIterator.isTrailSurrogate(trail) && trail >= 0) {
            this.iter.previous();
        }
        return (char)trail;
    }

    protected void forwardNumCodePoints(int num) {
        this.iter.moveCodePointIndex(num);
    }

    protected void backwardNumCodePoints(int num) {
        this.iter.moveCodePointIndex(-num);
    }
}

