/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import org.python.indexer.NBinding;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NUrl;

public class Def {
    private int start;
    private int end;
    private NBinding binding;
    private String fileOrUrl;
    private String name;

    public Def(NNode node) {
        this(node, null);
    }

    public Def(NNode node, NBinding b2) {
        if (node == null) {
            throw new IllegalArgumentException("null 'node' param");
        }
        this.binding = b2;
        if (node instanceof NUrl) {
            String url = ((NUrl)node).getURL();
            this.fileOrUrl = url.startsWith("file://") ? url.substring("file://".length()) : url;
            return;
        }
        this.start = node.start();
        this.end = node.end();
        this.fileOrUrl = node.getFile();
        if (this.fileOrUrl == null) {
            throw new IllegalArgumentException("Non-URL nodes must have a non-null file");
        }
        if (node instanceof NName) {
            this.name = ((NName)node).id;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getFile() {
        return this.isURL() ? null : this.fileOrUrl;
    }

    public String getURL() {
        return this.isURL() ? this.fileOrUrl : null;
    }

    public String getFileOrUrl() {
        return this.fileOrUrl;
    }

    public boolean isURL() {
        return this.fileOrUrl.startsWith("http://");
    }

    public boolean isModule() {
        return this.binding != null && this.binding.kind == NBinding.Kind.MODULE;
    }

    public int start() {
        return this.start;
    }

    public int end() {
        return this.end;
    }

    public int length() {
        return this.end - this.start;
    }

    public boolean isName() {
        return this.name != null;
    }

    void setBinding(NBinding b2) {
        this.binding = b2;
    }

    public NBinding getBinding() {
        return this.binding;
    }

    public String toString() {
        return "<Def:" + (this.name == null ? "" : this.name) + ":" + this.start + ":" + this.fileOrUrl + ">";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Def)) {
            return false;
        }
        Def def = (Def)obj;
        if (this.start != def.start) {
            return false;
        }
        if (this.end != def.end) {
            return false;
        }
        if (this.name != null ? !this.name.equals(def.name) : def.name != null) {
            return false;
        }
        return !(this.fileOrUrl != null ? !this.fileOrUrl.equals(def.fileOrUrl) : def.fileOrUrl != null);
    }

    public int hashCode() {
        return ("" + this.fileOrUrl + this.name + this.start + this.end).hashCode();
    }
}

