/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.TreeSet;
import org.python.indexer.Indexer;

public class Util {
    private static final String UTF_8 = "UTF-8";
    private static final char SEPCHAR = File.separatorChar;
    private static final String SEP = File.separator;
    private static final String INIT_PY = "__init__.py";
    private static final String SEP_INIT_PY = SEP + "__init__.py";
    private static int gensymCount = -1;

    public static String gensym(String base) {
        return base + ++gensymCount;
    }

    public static String getSystemTempDir() {
        String tmp = System.getProperty("java.io.tmpdir");
        if (tmp.endsWith(SEP)) {
            return tmp;
        }
        return tmp + SEP;
    }

    public static String getQnameParent(String qname) {
        if (qname == null || qname.length() == 0) {
            return "";
        }
        int index = qname.lastIndexOf(".");
        if (index == -1) {
            return "";
        }
        return qname.substring(0, index);
    }

    public static String moduleQname(String file) {
        boolean initpy = file.endsWith(SEP_INIT_PY);
        if (initpy) {
            file = file.substring(0, file.length() - SEP_INIT_PY.length());
        } else if (file.endsWith(".py")) {
            file = file.substring(0, file.length() - ".py".length());
        }
        for (String root : Indexer.idx.getLoadPath()) {
            if (!file.startsWith(root)) continue;
            return file.substring(root.length()).replace(SEPCHAR, '.');
        }
        return null;
    }

    public static String arrayToString(Collection<String> strings) {
        StringBuffer sb = new StringBuffer();
        for (String s2 : strings) {
            sb.append(s2).append("\n");
        }
        return sb.toString();
    }

    public static String arrayToSortedStringSet(Collection<String> strings) {
        TreeSet<String> sorter = new TreeSet<String>();
        sorter.addAll(strings);
        return Util.arrayToString(sorter);
    }

    public static String moduleNameFor(String path) {
        File f2 = new File(path);
        if (f2.isDirectory()) {
            throw new IllegalStateException("failed assertion: " + path);
        }
        String fname = f2.getName();
        if (fname.equals(INIT_PY)) {
            return f2.getParentFile().getName();
        }
        return fname.substring(0, fname.lastIndexOf(46));
    }

    public static File joinPath(File dir, String file) {
        return Util.joinPath(dir.getAbsolutePath(), file);
    }

    public static File joinPath(String dir, String file) {
        if (dir.endsWith(SEP)) {
            return new File(dir + file);
        }
        return new File(dir + SEP + file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(String path, String contents) throws Exception {
        try (PrintWriter out = null;){
            out = new PrintWriter(new BufferedWriter(new FileWriter(path)));
            out.print(contents);
            out.flush();
        }
    }

    public static String readFile(String filename) throws Exception {
        return Util.readFile(new File(filename));
    }

    public static String readFile(File path) throws Exception {
        return new String(Util.getBytesFromFile(path), UTF_8);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        try (FileInputStream is = null;){
            int offset;
            is = new FileInputStream(file);
            long length = file.length();
            if (length > Integer.MAX_VALUE) {
                throw new IOException("file too large: " + file);
            }
            byte[] bytes = new byte[(int)length];
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Failed to read whole file " + file);
            }
            byte[] byArray = bytes;
            return byArray;
        }
    }

    public static String getMD5(File path) throws Exception {
        byte[] bytes = Util.getBytesFromFile(path);
        return Util.getMD5(bytes);
    }

    public static String getMD5(byte[] fileContents) throws Exception {
        MessageDigest algorithm = MessageDigest.getInstance("MD5");
        algorithm.reset();
        algorithm.update(fileContents);
        byte[] messageDigest = algorithm.digest();
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < messageDigest.length; ++i2) {
            sb.append(String.format("%02x", 0xFF & messageDigest[i2]));
        }
        return sb.toString();
    }

    public static String canonicalize(String path) {
        File f2 = new File(path);
        path = f2.getAbsolutePath();
        if (f2.isDirectory() && !path.endsWith(SEP)) {
            return path + SEP;
        }
        return path;
    }

    static boolean isReadableFile(String path) {
        File f2 = new File(path);
        return f2.canRead() && f2.isFile();
    }
}

