/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnionType;
import org.python.indexer.types.NUnknownType;

public class NAttribute
extends NNode {
    static final long serialVersionUID = -1120979305017812255L;
    public NNode target;
    public NName attr;

    public NAttribute(NNode target, NName attr) {
        this(target, attr, 0, 1);
    }

    public NAttribute(NNode target, NName attr, int start, int end) {
        super(start, end);
        this.setTarget(target);
        this.setAttr(attr);
        this.addChildren(target, attr);
    }

    public String getAttributeName() {
        return this.attr.id;
    }

    public void setAttr(NName attr) {
        if (attr == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.attr = attr;
    }

    public NName getAttr() {
        return this.attr;
    }

    public void setTarget(NNode target) {
        if (target == null) {
            throw new IllegalArgumentException("param cannot be null");
        }
        this.target = target;
    }

    public NNode getTarget() {
        return this.target;
    }

    public void setAttr(Scope s2, NType v2) throws Exception {
        this.setType(new NUnknownType());
        NType targetType = NAttribute.resolveExpr(this.target, s2);
        if (targetType.isUnionType() && (targetType = targetType.asUnionType().firstKnownNonNullAlternate()) == null) {
            return;
        }
        if ((targetType = targetType.follow()) == Indexer.idx.builtins.None) {
            return;
        }
        NBinding b2 = targetType.getTable().putAttr(this.attr.id, this.attr, v2, NBinding.Kind.ATTRIBUTE);
        if (b2 != null) {
            this.setType(this.attr.setType(b2.followType()));
        }
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        this.setType(new NUnknownType());
        NType targetType = NAttribute.resolveExpr(this.target, s2);
        if (targetType.isUnionType()) {
            NType ret = new NUnknownType();
            for (NType tp : targetType.asUnionType().getTypes()) {
                this.resolveAttributeOnType(tp);
                ret = NUnionType.union(ret, this.getType());
            }
            this.setType(this.attr.setType(ret.follow()));
        } else {
            this.resolveAttributeOnType(targetType);
        }
        return this.getType();
    }

    private void resolveAttributeOnType(NType targetType) {
        NType ttype = targetType.follow();
        NBinding b2 = ttype.getTable().lookupAttr(this.attr.id);
        if (b2 == null) {
            b2 = this.makeProvisionalBinding(ttype);
        }
        if (b2 != null) {
            Indexer.idx.putLocation(this.attr, b2);
            this.setType(this.attr.setType(b2.getType()));
        }
    }

    private NBinding makeProvisionalBinding(NType targetType) {
        if (targetType.isNative()) {
            return null;
        }
        Scope targetScope = targetType.getTable();
        if ("".equals(targetScope.getPath())) {
            return null;
        }
        NUnknownType utype = new NUnknownType();
        NBinding b2 = targetScope.putAttr(this.attr.id, null, utype, NBinding.Kind.ATTRIBUTE);
        if (b2 != null) {
            b2.setProvisional(true);
            utype.getTable().setPath(b2.getQname());
        }
        return b2;
    }

    public String toString() {
        return "<Attribute:" + this.start() + ":" + this.target + "." + this.getAttributeName() + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.target, v2);
            this.visitNode(this.attr, v2);
        }
    }
}

