/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NGlobal
extends NNode {
    static final long serialVersionUID = 5978320165592263568L;
    public List<NName> names;

    public NGlobal(List<NName> names) {
        this(names, 0, 1);
    }

    public NGlobal(List<NName> names, int start, int end) {
        super(start, end);
        this.names = names;
        this.addChildren(names);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        Scope moduleTable = s2.getGlobalTable();
        for (NName name : this.names) {
            if (s2.isGlobalName(name.id)) continue;
            s2.addGlobalName(name.id);
            NBinding b2 = moduleTable.lookup(name);
            if (b2 == null) {
                b2 = moduleTable.put(name.id, null, new NUnknownType(), NBinding.Kind.SCOPE);
            }
            Indexer.idx.putLocation(name, b2);
        }
        return this.getType();
    }

    public String toString() {
        return "<Global:" + this.names + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNodeList(this.names, v2);
        }
    }
}

