/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAlias;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.ast.NQname;
import org.python.indexer.ast.NUrl;
import org.python.indexer.ast.NameBinder;
import org.python.indexer.types.NModuleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NImport
extends NNode {
    static final long serialVersionUID = -2180402676651342012L;
    public List<NAlias> aliases;

    public NImport(List<NAlias> aliases) {
        this(aliases, 0, 1);
    }

    public NImport(List<NAlias> aliases, int start, int end) {
        super(start, end);
        this.aliases = aliases;
        this.addChildren(aliases);
    }

    @Override
    public boolean bindsName() {
        return true;
    }

    @Override
    protected void bindNames(Scope s2) throws Exception {
        NImport.bindAliases(s2, this.aliases);
    }

    static void bindAliases(Scope s2, List<NAlias> aliases) throws Exception {
        NameBinder binder = NameBinder.make();
        for (NAlias a2 : aliases) {
            if (a2.aname == null) continue;
            binder.bind(s2, a2.aname, (NType)new NUnknownType());
        }
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        Scope scope = s2.getScopeSymtab();
        for (NAlias a2 : this.aliases) {
            NType modtype = NImport.resolveExpr(a2, s2);
            if (!modtype.isModuleType()) continue;
            this.importName(scope, a2, modtype.asModuleType());
        }
        return this.getType();
    }

    private void importName(Scope s2, NAlias a2, NModuleType mt) throws Exception {
        if (a2.aname != null) {
            if (mt.getFile() != null) {
                NameBinder.make().bind(s2, a2.aname, (NType)mt);
            } else {
                s2.update(a2.aname.id, new NUrl("http://docs.python.org/library/" + mt.getTable().getPath() + ".html"), (NType)mt, NBinding.Kind.SCOPE);
            }
        }
        NImport.addReferences(s2, a2.qname, true);
    }

    static void addReferences(Scope s2, NQname qname, boolean putTopInScope) {
        if (qname == null) {
            return;
        }
        if (!qname.getType().isModuleType()) {
            return;
        }
        NModuleType mt = qname.getType().asModuleType();
        String modQname = mt.getTable().getPath();
        NBinding mb = Indexer.idx.lookupQname(modQname);
        if (mb == null) {
            mb = Indexer.idx.moduleTable.lookup(modQname);
        }
        if (mb == null) {
            Indexer.idx.putProblem(qname.getName(), "module not found");
            return;
        }
        Indexer.idx.putLocation(qname.getName(), mb);
        if (putTopInScope && qname.isTop()) {
            s2.put(qname.getName().id, mb);
        }
        NImport.addReferences(s2, qname.getNext(), false);
    }

    public String toString() {
        return "<Import:" + this.aliases + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNodeList(this.aliases, v2);
        }
    }
}

