/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NCall;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NName
extends NNode {
    static final long serialVersionUID = -1160862551327528304L;
    public final String id;

    public NName(String id) {
        this(id, 0, 1);
    }

    public NName(String id, int start, int end) {
        super(start, end);
        if (id == null) {
            throw new IllegalArgumentException("'id' param cannot be null");
        }
        this.id = id;
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NBinding b2 = s2.lookup(this.id);
        if (b2 == null) {
            b2 = this.makeTempBinding(s2);
        }
        Indexer.idx.putLocation(this, b2);
        return this.setType(b2.followType());
    }

    @Override
    public boolean isCall() {
        NNode gramps;
        if (this.parent != null && this.parent.isCall() && this == ((NCall)this.parent).func) {
            return true;
        }
        return this.parent instanceof NAttribute && this == ((NAttribute)this.parent).attr && (gramps = this.parent.parent) instanceof NCall && this.parent == ((NCall)gramps).func;
    }

    private NBinding makeTempBinding(Scope s2) {
        Scope scope = s2.getScopeSymtab();
        NBinding b2 = scope.put(this.id, this, new NUnknownType(), NBinding.Kind.SCOPE);
        this.setType(b2.getType().follow());
        this.getTable().setPath(scope.extendPath(this.id));
        return b2;
    }

    public boolean isAttribute() {
        return this.parent instanceof NAttribute && ((NAttribute)this.parent).getAttr() == this;
    }

    public String toString() {
        return "<Name:" + this.start() + ":" + this.id + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        v2.visit(this);
    }
}

