/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import org.python.indexer.Scope;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;

public class NRaise
extends NNode {
    static final long serialVersionUID = 5384576775167988640L;
    public NNode exceptionType;
    public NNode inst;
    public NNode traceback;

    public NRaise(NNode exceptionType, NNode inst, NNode traceback) {
        this(exceptionType, inst, traceback, 0, 1);
    }

    public NRaise(NNode exceptionType, NNode inst, NNode traceback, int start, int end) {
        super(start, end);
        this.exceptionType = exceptionType;
        this.inst = inst;
        this.traceback = traceback;
        this.addChildren(exceptionType, inst, traceback);
    }

    @Override
    public NType resolve(Scope s2) throws Exception {
        NRaise.resolveExpr(this.exceptionType, s2);
        NRaise.resolveExpr(this.inst, s2);
        NRaise.resolveExpr(this.traceback, s2);
        return this.getType();
    }

    public String toString() {
        return "<Raise:" + this.traceback + ":" + this.exceptionType + ">";
    }

    @Override
    public void visit(NNodeVisitor v2) {
        if (v2.visit(this)) {
            this.visitNode(this.exceptionType, v2);
            this.visitNode(this.inst, v2);
            this.visitNode(this.traceback, v2);
        }
    }
}

