/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NAttribute;
import org.python.indexer.ast.NList;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NSubscript;
import org.python.indexer.ast.NTuple;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NameBinder {
    private static final NameBinder DEFAULT_BINDER = new NameBinder();
    private static final NameBinder ATTRIBUTE_BINDER = new NameBinder(NBinding.Kind.ATTRIBUTE);
    private static final NameBinder CLASS_BINDER = new NameBinder(NBinding.Kind.CLASS);
    private static final NameBinder CONSTRUCTOR_BINDER = new NameBinder(NBinding.Kind.CONSTRUCTOR);
    private static final NameBinder FUNCTION_BINDER = new NameBinder(NBinding.Kind.FUNCTION);
    private static final NameBinder METHOD_BINDER = new NameBinder(NBinding.Kind.METHOD);
    private static final NameBinder MODULE_BINDER = new NameBinder(NBinding.Kind.MODULE);
    private static final NameBinder PARAMETER_BINDER = new NameBinder(NBinding.Kind.PARAMETER);
    private static final NameBinder VARIABLE_BINDER = new NameBinder(NBinding.Kind.VARIABLE);
    private NBinding.Kind kind;

    public static NameBinder make() {
        return DEFAULT_BINDER;
    }

    public static NameBinder make(NBinding.Kind kind) {
        switch (kind) {
            case ATTRIBUTE: {
                return ATTRIBUTE_BINDER;
            }
            case CLASS: {
                return CLASS_BINDER;
            }
            case CONSTRUCTOR: {
                return CONSTRUCTOR_BINDER;
            }
            case FUNCTION: {
                return FUNCTION_BINDER;
            }
            case METHOD: {
                return METHOD_BINDER;
            }
            case MODULE: {
                return MODULE_BINDER;
            }
            case PARAMETER: {
                return PARAMETER_BINDER;
            }
            case VARIABLE: {
                return VARIABLE_BINDER;
            }
        }
        return DEFAULT_BINDER;
    }

    private NameBinder() {
    }

    private NameBinder(NBinding.Kind kind) {
        this.kind = kind;
    }

    public void bind(Scope s2, NNode target, NType rvalue) throws Exception {
        if (target instanceof NName) {
            this.bindName(s2, (NName)target, rvalue);
            return;
        }
        if (target instanceof NTuple) {
            this.bind(s2, ((NTuple)target).elts, rvalue);
            return;
        }
        if (target instanceof NList) {
            this.bind(s2, ((NList)target).elts, rvalue);
            return;
        }
        if (target instanceof NAttribute) {
            if (!s2.isNameBindingPhase()) {
                ((NAttribute)target).setAttr(s2, rvalue);
            }
            return;
        }
        if (target instanceof NSubscript) {
            if (!s2.isNameBindingPhase()) {
                NNode.resolveExpr(target, s2);
            }
            return;
        }
        Indexer.idx.putProblem(target, "invalid location for assignment");
    }

    public void bind(Scope s2, List<NNode> xs, NType rvalue) throws Exception {
        if (rvalue.isTupleType()) {
            List<NType> vs = rvalue.asTupleType().getElementTypes();
            if (xs.size() != vs.size()) {
                this.reportUnpackMismatch(xs, vs.size());
            } else {
                for (int i2 = 0; i2 < xs.size(); ++i2) {
                    this.bind(s2, xs.get(i2), vs.get(i2));
                }
            }
            return;
        }
        if (rvalue.isListType()) {
            this.bind(s2, xs, (NType)rvalue.asListType().toTupleType(xs.size()));
            return;
        }
        if (rvalue.isDictType()) {
            this.bind(s2, xs, (NType)rvalue.asDictType().toTupleType(xs.size()));
            return;
        }
        if (!rvalue.isUnknownType()) {
            Indexer.idx.putProblem(xs.get(0).getFile(), xs.get(0).start(), xs.get(xs.size() - 1).end(), "unpacking non-iterable: " + rvalue);
        }
        for (int i3 = 0; i3 < xs.size(); ++i3) {
            this.bind(s2, xs.get(i3), (NType)new NUnknownType());
        }
    }

    public NBinding bindName(Scope s2, NName name, NType rvalue) throws Exception {
        NBinding b2;
        if (s2.isGlobalName(name.id)) {
            b2 = s2.getGlobalTable().put(name.id, name, rvalue, this.kindOr(NBinding.Kind.SCOPE));
            Indexer.idx.putLocation(name, b2);
        } else {
            Scope bindingScope = s2.getScopeSymtab();
            b2 = bindingScope.put(name.id, name, rvalue, this.kindOr(bindingScope.isFunctionScope() ? NBinding.Kind.VARIABLE : NBinding.Kind.SCOPE));
        }
        name.setType(b2.followType());
        NType nameType = name.getType();
        if (!nameType.isModuleType() && !nameType.isClassType()) {
            nameType.getTable().setPath(b2.getQname());
        }
        return b2;
    }

    public void bindIter(Scope s2, NNode target, NNode iter2) throws Exception {
        NType iterType = NNode.resolveExpr(iter2, s2);
        if (iterType.isListType()) {
            this.bind(s2, target, iterType.asListType().getElementType());
        } else if (iterType.isTupleType()) {
            this.bind(s2, target, iterType.asTupleType().toListType().getElementType());
        } else {
            NBinding ent = iterType.getTable().lookupAttr("__iter__");
            if (ent == null || !ent.getType().isFuncType()) {
                if (!iterType.isUnknownType()) {
                    iter2.addWarning("not an iterable type: " + iterType);
                }
                this.bind(s2, target, (NType)new NUnknownType());
            } else {
                this.bind(s2, target, ent.getType().asFuncType().getReturnType());
            }
        }
    }

    private void reportUnpackMismatch(List<NNode> xs, int vsize) {
        int xsize = xs.size();
        int beg = xs.get(0).start();
        int end = xs.get(xs.size() - 1).end();
        int diff = xsize - vsize;
        String msg = diff > 0 ? "ValueError: need more than " + vsize + " values to unpack" : "ValueError: too many values to unpack";
        Indexer.idx.putProblem(xs.get(0).getFile(), beg, end, msg);
    }

    private NBinding.Kind kindOr(NBinding.Kind k2) {
        return this.kind != null ? this.kind : k2;
    }
}

