/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.types;

import java.util.HashSet;
import java.util.Set;
import org.python.indexer.Indexer;
import org.python.indexer.types.NDictType;
import org.python.indexer.types.NFuncType;
import org.python.indexer.types.NListType;
import org.python.indexer.types.NTupleType;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

public class NUnionType
extends NType {
    private static final int MAX_RECURSION_DEPTH = 15;
    private Set<NType> types = new HashSet<NType>();

    public NUnionType() {
    }

    public NUnionType(NType ... initialTypes) {
        this();
        for (NType nt : initialTypes) {
            this.addType(nt);
        }
    }

    public void setTypes(Set<NType> types2) {
        this.types = types2;
    }

    public Set<NType> getTypes() {
        return this.types;
    }

    public void addType(NType t2) {
        if (t2 == null) {
            throw new IllegalArgumentException("null type");
        }
        if (t2.isUnionType()) {
            this.types.addAll(t2.asUnionType().types);
        } else {
            this.types.add(t2);
        }
    }

    public boolean contains(NType t2) {
        return this.types.contains(t2);
    }

    public static NType union(NType u2, NType v2) {
        NType wv;
        NType wu = NUnknownType.follow(u2);
        if (wu == (wv = NUnknownType.follow(v2))) {
            return u2;
        }
        if (wu == Indexer.idx.builtins.None) {
            return v2;
        }
        if (wv == Indexer.idx.builtins.None) {
            return u2;
        }
        if (wu.isUnknownType() && !NUnionType.occurs(wu, wv, 0)) {
            NUnknownType.point(wu, wv);
            return u2;
        }
        if (wv.isUnknownType() && !NUnionType.occurs(wv, wu, 0)) {
            NUnknownType.point(wv, wu);
            return v2;
        }
        if (wu.isTupleType() && wv.isTupleType()) {
            NTupleType tu = (NTupleType)wu;
            NTupleType tv = (NTupleType)wv;
            if (tu.getElementTypes().size() == tv.getElementTypes().size()) {
                NTupleType ret = new NTupleType();
                for (int i2 = 0; i2 < tu.getElementTypes().size(); ++i2) {
                    ret.add(NUnionType.union(tu.getElementTypes().get(i2), tv.getElementTypes().get(i2)));
                }
                return ret;
            }
            return NUnionType.newUnion(wu, wv);
        }
        if (wu.isListType() && wv.isListType()) {
            return new NListType(NUnionType.union(wu.asListType().getElementType(), wv.asListType().getElementType()));
        }
        if (wu.isDictType() && wv.isDictType()) {
            NDictType du = (NDictType)wu;
            NDictType dv = (NDictType)wv;
            return new NDictType(NUnionType.union(du.getKeyType(), dv.getKeyType()), NUnionType.union(du.getValueType(), dv.getValueType()));
        }
        if (wu.isFuncType() && wv.isFuncType()) {
            return new NFuncType(NUnionType.union(wu.asFuncType().getReturnType(), wv.asFuncType().getReturnType()));
        }
        if (wu.isFuncType() && wv.isClassType()) {
            NUnknownType.point(wu.asFuncType().getReturnType(), wv);
            NUnknownType.point(u2, wv);
            return u2;
        }
        if (wu.isClassType() && wv.isFuncType()) {
            NUnknownType.point(wv.asFuncType().getReturnType(), wu);
            NUnknownType.point(v2, wu);
            return v2;
        }
        return NUnionType.newUnion(wu, wv);
    }

    private static boolean occurs(NType u2, NType v2, int depth) {
        if (depth++ > 15) {
            return true;
        }
        if ((u2 = NUnknownType.follow(u2)) == (v2 = NUnknownType.follow(v2))) {
            return true;
        }
        if (v2.isTupleType()) {
            for (NType vv : v2.asTupleType().getElementTypes()) {
                if (!NUnionType.occurs(u2, vv, depth)) continue;
                return true;
            }
            return false;
        }
        if (v2.isListType()) {
            return NUnionType.occurs(u2, v2.asListType().getElementType(), depth);
        }
        if (v2.isDictType()) {
            return NUnionType.occurs(u2, v2.asDictType().getKeyType(), depth) || NUnionType.occurs(u2, v2.asDictType().getValueType(), depth);
        }
        if (v2.isFuncType()) {
            NType ret = v2.asFuncType().getReturnType();
            if (NUnionType.occurs(v2, ret, depth)) {
                return true;
            }
            return NUnionType.occurs(u2, ret, depth);
        }
        if (v2.isUnionType()) {
            for (NType vv : v2.asUnionType().types) {
                if (!NUnionType.occurs(u2, vv, depth)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static NUnionType newUnion(NType ... types2) {
        NUnionType ret = new NUnionType();
        for (NType type : types2) {
            ret.addType(type);
        }
        return ret;
    }

    public NType firstKnownAlternate() {
        for (NType type : this.types) {
            if (type.follow().isUnknownType()) continue;
            return type;
        }
        return null;
    }

    public NType firstKnownNonNullAlternate() {
        for (NType type : this.types) {
            NType tt = type.follow();
            if (tt.isUnknownType() || tt == Indexer.idx.builtins.None) continue;
            return type;
        }
        return null;
    }

    @Override
    public void printKids(NType.CyclicTypeRecorder ctr, StringBuilder sb) {
        sb.append("[");
        for (NType u2 : this.types) {
            u2.print(ctr, sb);
            sb.append(",");
        }
        sb.setLength(sb.length() - 1);
        sb.append("]");
    }
}

