/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Iterator;
import org.python.core.Py;
import org.python.core.PyDictionary;
import org.python.core.PyInteger;
import org.python.core.PyNone;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.codecs;
import org.python.expose.ExposedType;
import org.python.modules._codecs$EncodingMap$PyExposer;

public class _codecs {
    public static void register(PyObject search_function) {
        codecs.register(search_function);
    }

    private static String _castString(PyString pystr) {
        if (pystr == null) {
            return null;
        }
        String s2 = pystr.toString();
        if (pystr instanceof PyUnicode) {
            return s2;
        }
        return codecs.PyUnicode_EncodeASCII(s2, s2.length(), null);
    }

    public static PyTuple lookup(PyString encoding) {
        return codecs.lookup(_codecs._castString(encoding));
    }

    public static PyObject lookup_error(PyString handlerName) {
        return codecs.lookup_error(_codecs._castString(handlerName));
    }

    public static void register_error(String name, PyObject errorHandler) {
        codecs.register_error(name, errorHandler);
    }

    public static PyObject decode(PyString bytes) {
        return _codecs.decode(bytes, null, null);
    }

    public static PyObject decode(PyString bytes, PyString encoding) {
        return _codecs.decode(bytes, encoding, null);
    }

    public static PyObject decode(PyString bytes, PyString encoding, PyString errors) {
        return codecs.decode(bytes, _codecs._castString(encoding), _codecs._castString(errors));
    }

    public static PyString encode(PyUnicode unicode) {
        return _codecs.encode(unicode, null, null);
    }

    public static PyString encode(PyUnicode unicode, PyString encoding) {
        return _codecs.encode(unicode, encoding, null);
    }

    public static PyString encode(PyUnicode unicode, PyString encoding, PyString errors) {
        return Py.newString(codecs.encode(unicode, _codecs._castString(encoding), _codecs._castString(errors)));
    }

    public static PyObject charmap_build(PyUnicode map) {
        return EncodingMap.buildEncodingMap(map);
    }

    private static PyTuple decode_tuple(String u2, int bytesConsumed) {
        return new PyTuple(new PyUnicode(u2), Py.newInteger(bytesConsumed));
    }

    private static PyTuple decode_tuple(String u2, int[] consumed, int defConsumed) {
        return _codecs.decode_tuple(u2, consumed != null ? consumed[0] : defConsumed);
    }

    private static PyTuple decode_tuple(String u2, int bytesConsumed, ByteOrder order) {
        int bo = order.code();
        return new PyTuple(new PyUnicode(u2), Py.newInteger(bytesConsumed), Py.newInteger(bo));
    }

    private static PyTuple decode_tuple_str(String s2, int len) {
        return new PyTuple(new PyString(s2), Py.newInteger(len));
    }

    private static PyTuple encode_tuple(String s2, int len) {
        return new PyTuple(new PyString(s2), Py.newInteger(len));
    }

    public static PyTuple utf_8_decode(String str) {
        return _codecs.utf_8_decode(str, null);
    }

    public static PyTuple utf_8_decode(String str, String errors) {
        return _codecs.utf_8_decode(str, errors, false);
    }

    public static PyTuple utf_8_decode(String str, String errors, PyObject final_) {
        return _codecs.utf_8_decode(str, errors, final_.__nonzero__());
    }

    public static PyTuple utf_8_decode(String str, String errors, boolean final_) {
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeUTF8Stateful(str, errors, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_8_encode(String str) {
        return _codecs.utf_8_encode(str, null);
    }

    public static PyTuple utf_8_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF8(str, errors), size);
    }

    public static PyTuple utf_7_decode(String bytes) {
        return _codecs.utf_7_decode(bytes, null);
    }

    public static PyTuple utf_7_decode(String bytes, String errors) {
        return _codecs.utf_7_decode(bytes, null, false);
    }

    public static PyTuple utf_7_decode(String bytes, String errors, boolean finalFlag) {
        int[] consumed = finalFlag ? null : new int[1];
        String decoded = codecs.PyUnicode_DecodeUTF7Stateful(bytes, errors, consumed);
        return _codecs.decode_tuple(decoded, consumed, bytes.length());
    }

    public static PyTuple utf_7_encode(String str) {
        return _codecs.utf_7_encode(str, null);
    }

    public static PyTuple utf_7_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeUTF7(str, false, false, errors), size);
    }

    public static PyTuple escape_decode(String str) {
        return _codecs.escape_decode(str, null);
    }

    public static PyTuple escape_decode(String str, String errors) {
        return _codecs.decode_tuple_str(PyString.decode_UnicodeEscape(str, 0, str.length(), errors, true), str.length());
    }

    public static PyTuple escape_encode(String str) {
        return _codecs.escape_encode(str, null);
    }

    public static PyTuple escape_encode(String str, String errors) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple charmap_decode(String bytes) {
        return _codecs.charmap_decode(bytes, null, null);
    }

    public static PyTuple charmap_decode(String bytes, String errors) {
        return _codecs.charmap_decode(bytes, errors, null);
    }

    public static PyTuple charmap_decode(String bytes, String errors, PyObject mapping) {
        if (mapping == null || mapping == Py.None) {
            return _codecs.latin_1_decode(bytes, errors);
        }
        return _codecs.charmap_decode(bytes, errors, mapping, false);
    }

    public static PyTuple charmap_decode(String bytes, String errors, PyObject mapping, boolean ignoreUnmapped) {
        int size = bytes.length();
        StringBuilder v2 = new StringBuilder(size);
        for (int i2 = 0; i2 < size; ++i2) {
            char b2 = bytes.charAt(i2);
            if (b2 > '\u00ff') {
                i2 = codecs.insertReplacementAndGetResume(v2, errors, "charmap", bytes, i2, i2 + 1, "ordinal not in range(255)") - 1;
                continue;
            }
            PyInteger w2 = Py.newInteger(b2);
            PyObject x2 = mapping.__finditem__(w2);
            if (x2 == null) {
                if (ignoreUnmapped) {
                    v2.appendCodePoint(b2);
                    continue;
                }
                i2 = codecs.insertReplacementAndGetResume(v2, errors, "charmap", bytes, i2, i2 + 1, "no mapping found") - 1;
                continue;
            }
            if (x2 instanceof PyInteger) {
                int value = ((PyInteger)x2).getValue();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError("character mapping must return integer greater than 0 and less than sys.maxunicode");
                }
                v2.appendCodePoint(value);
                continue;
            }
            if (x2 == Py.None) {
                i2 = codecs.insertReplacementAndGetResume(v2, errors, "charmap", bytes, i2, i2 + 1, "character maps to <undefined>") - 1;
                continue;
            }
            if (x2 instanceof PyString) {
                String s2 = x2.toString();
                if (s2.charAt(0) == '\ufffe') {
                    i2 = codecs.insertReplacementAndGetResume(v2, errors, "charmap", bytes, i2, i2 + 1, "character maps to <undefined>") - 1;
                    continue;
                }
                v2.append(s2);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.decode_tuple(v2.toString(), size);
    }

    public static PyObject translateCharmap(PyUnicode str, String errors, PyObject mapping) {
        StringBuilder buf = new StringBuilder(str.toString().length());
        Iterator<Integer> iter2 = str.newSubsequenceIterator();
        while (iter2.hasNext()) {
            int codePoint = iter2.next();
            PyObject result = mapping.__finditem__(Py.newInteger(codePoint));
            if (result == null) {
                buf.appendCodePoint(codePoint);
                continue;
            }
            if (result == Py.None) continue;
            if (result instanceof PyInteger) {
                int value = result.asInt();
                if (value < 0 || value > 0x10FFFF) {
                    throw Py.TypeError(String.format("character mapping must be in range(0x%x)", 0x110000));
                }
                buf.appendCodePoint(value);
                continue;
            }
            if (result instanceof PyUnicode) {
                buf.append(result.toString());
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or unicode");
        }
        return new PyUnicode(buf.toString());
    }

    public static PyTuple charmap_encode(String str) {
        return _codecs.charmap_encode(str, null, null);
    }

    public static PyTuple charmap_encode(String str, String errors) {
        return _codecs.charmap_encode(str, errors, null);
    }

    public static PyTuple charmap_encode(String str, String errors, PyObject mapping) {
        if (mapping == null || mapping == Py.None) {
            return _codecs.latin_1_encode(str, errors);
        }
        return _codecs.charmap_encode_internal(str, errors, mapping, new StringBuilder(str.length()), true);
    }

    private static PyTuple charmap_encode_internal(String str, String errors, PyObject mapping, StringBuilder v2, boolean letLookupHandleError) {
        EncodingMap encodingMap = mapping instanceof EncodingMap ? (EncodingMap)mapping : null;
        int size = str.length();
        for (int i2 = 0; i2 < size; ++i2) {
            int result;
            char ch = str.charAt(i2);
            PyObject x2 = encodingMap != null ? ((result = encodingMap.lookup(ch)) == -1 ? null : Py.newInteger(result)) : mapping.__finditem__(Py.newInteger(ch));
            if (x2 == null) {
                if (letLookupHandleError) {
                    i2 = _codecs.handleBadMapping(str, errors, mapping, v2, size, i2);
                    continue;
                }
                throw Py.UnicodeEncodeError("charmap", str, i2, i2 + 1, "character maps to <undefined>");
            }
            if (x2 instanceof PyInteger) {
                int value = ((PyInteger)x2).getValue();
                if (value < 0 || value > 255) {
                    throw Py.TypeError("character mapping must be in range(256)");
                }
                v2.append((char)value);
                continue;
            }
            if (x2 instanceof PyString && !(x2 instanceof PyUnicode)) {
                v2.append(x2.toString());
                continue;
            }
            if (x2 instanceof PyNone) {
                i2 = _codecs.handleBadMapping(str, errors, mapping, v2, size, i2);
                continue;
            }
            throw Py.TypeError("character mapping must return integer, None or str");
        }
        return _codecs.encode_tuple(v2.toString(), size);
    }

    private static int handleBadMapping(String str, String errors, PyObject mapping, StringBuilder v2, int size, int i2) {
        if (errors != null) {
            if (errors.equals("ignore")) {
                return i2;
            }
            if (errors.equals("replace")) {
                String replStr = "?";
                _codecs.charmap_encode_internal(replStr, errors, mapping, v2, false);
                return i2;
            }
            if (errors.equals("xmlcharrefreplace")) {
                String replStr = codecs.xmlcharrefreplace(i2, i2 + 1, str).toString();
                _codecs.charmap_encode_internal(replStr, errors, mapping, v2, false);
                return i2;
            }
            if (errors.equals("backslashreplace")) {
                String replStr = codecs.backslashreplace(i2, i2 + 1, str).toString();
                _codecs.charmap_encode_internal(replStr, errors, mapping, v2, false);
                return i2;
            }
        }
        String msg = "character maps to <undefined>";
        PyObject replacement = codecs.encoding_error(errors, "charmap", str, i2, i2 + 1, msg);
        String replStr = replacement.__getitem__(0).toString();
        _codecs.charmap_encode_internal(replStr, errors, mapping, v2, false);
        return codecs.calcNewPosition(size, replacement) - 1;
    }

    public static PyTuple ascii_decode(String str) {
        return _codecs.ascii_decode(str, null);
    }

    public static PyTuple ascii_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeASCII(str, size, errors), size);
    }

    public static PyTuple ascii_encode(String str) {
        return _codecs.ascii_encode(str, null);
    }

    public static PyTuple ascii_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeASCII(str, size, errors), size);
    }

    public static PyTuple latin_1_decode(String str) {
        return _codecs.latin_1_decode(str, null);
    }

    public static PyTuple latin_1_decode(String str, String errors) {
        int size = str.length();
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeLatin1(str, size, errors), size);
    }

    public static PyTuple latin_1_encode(String str) {
        return _codecs.latin_1_encode(str, null);
    }

    public static PyTuple latin_1_encode(String str, String errors) {
        int size = str.length();
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeLatin1(str, size, errors), size);
    }

    public static PyTuple utf_16_encode(String str) {
        return _codecs.utf_16_encode(str, null);
    }

    public static PyTuple utf_16_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, 0), str.length());
    }

    public static PyTuple utf_16_encode(String str, String errors, int byteorder) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, byteorder), str.length());
    }

    public static PyTuple utf_16_le_encode(String str) {
        return _codecs.utf_16_le_encode(str, null);
    }

    public static PyTuple utf_16_le_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, -1), str.length());
    }

    public static PyTuple utf_16_be_encode(String str) {
        return _codecs.utf_16_be_encode(str, null);
    }

    public static PyTuple utf_16_be_encode(String str, String errors) {
        return _codecs.encode_tuple(_codecs.encode_UTF16(str, errors, 1), str.length());
    }

    public static String encode_UTF16(String str, String errors, int byteorder) {
        Charset utf16 = byteorder == 0 ? Charset.forName("UTF-16") : (byteorder == -1 ? Charset.forName("UTF-16LE") : Charset.forName("UTF-16BE"));
        ByteBuffer bbuf = utf16.encode(str);
        StringBuilder v2 = new StringBuilder(bbuf.limit());
        while (bbuf.remaining() > 0) {
            int val = bbuf.get();
            if (val < 0) {
                val = 256 + val;
            }
            v2.appendCodePoint(val);
        }
        return v2.toString();
    }

    public static PyTuple utf_16_decode(String str) {
        return _codecs.utf_16_decode(str, null);
    }

    public static PyTuple utf_16_decode(String str, String errors) {
        return _codecs.utf_16_decode(str, errors, false);
    }

    public static PyTuple utf_16_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_le_decode(String str) {
        return _codecs.utf_16_le_decode(str, null);
    }

    public static PyTuple utf_16_le_decode(String str, String errors) {
        return _codecs.utf_16_le_decode(str, errors, false);
    }

    public static PyTuple utf_16_le_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{-1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_be_decode(String str) {
        return _codecs.utf_16_be_decode(str, null);
    }

    public static PyTuple utf_16_be_decode(String str, String errors) {
        return _codecs.utf_16_be_decode(str, errors, false);
    }

    public static PyTuple utf_16_be_decode(String str, String errors, boolean final_) {
        int[] bo = new int[]{1};
        int[] consumed = final_ ? null : new int[1];
        return _codecs.decode_tuple(_codecs.decode_UTF16(str, errors, bo, consumed), final_ ? str.length() : consumed[0]);
    }

    public static PyTuple utf_16_ex_decode(String str) {
        return _codecs.utf_16_ex_decode(str, null);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors) {
        return _codecs.utf_16_ex_decode(str, errors, 0);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors, int byteorder) {
        return _codecs.utf_16_ex_decode(str, errors, byteorder, false);
    }

    public static PyTuple utf_16_ex_decode(String str, String errors, int byteorder, boolean final_) {
        int[] bo = new int[]{0};
        int[] consumed = final_ ? null : new int[1];
        String decoded = _codecs.decode_UTF16(str, errors, bo, consumed);
        return new PyTuple(new PyUnicode(decoded), Py.newInteger(final_ ? str.length() : consumed[0]), Py.newInteger(bo[0]));
    }

    private static String decode_UTF16(String str, String errors, int[] byteorder) {
        return _codecs.decode_UTF16(str, errors, byteorder, null);
    }

    private static String decode_UTF16(String str, String errors, int[] byteorder, int[] consumed) {
        int i2;
        int bo = 0;
        if (byteorder != null) {
            bo = byteorder[0];
        }
        int size = str.length();
        StringBuilder v2 = new StringBuilder(size / 2);
        for (i2 = 0; i2 < size; i2 += 2) {
            char ch1 = str.charAt(i2);
            if (i2 + 1 == size) {
                if (consumed != null) break;
                i2 = codecs.insertReplacementAndGetResume(v2, errors, "utf-16", str, i2, i2 + 1, "truncated data");
                continue;
            }
            char ch2 = str.charAt(i2 + 1);
            if (ch1 == '\u00fe' && ch2 == '\u00ff') {
                bo = 1;
                continue;
            }
            if (ch1 == '\u00ff' && ch2 == '\u00fe') {
                bo = -1;
                continue;
            }
            int W1 = bo == -1 ? ch2 << 8 | ch1 : ch1 << 8 | ch2;
            if (W1 < 55296 || W1 > 57343) {
                v2.appendCodePoint(W1);
                continue;
            }
            if (W1 >= 55296 && W1 <= 56319 && i2 < size - 1) {
                char ch3 = str.charAt(i2 += 2);
                char ch4 = str.charAt(i2 + 1);
                int W2 = bo == -1 ? ch4 << 8 | ch3 : ch3 << 8 | ch4;
                if (W2 >= 56320 && W2 <= 57343) {
                    int U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                    v2.appendCodePoint(U);
                    continue;
                }
                i2 = codecs.insertReplacementAndGetResume(v2, errors, "utf-16", str, i2, i2 + 1, "illegal UTF-16 surrogate");
                continue;
            }
            i2 = codecs.insertReplacementAndGetResume(v2, errors, "utf-16", str, i2, i2 + 1, "illegal encoding");
        }
        if (byteorder != null) {
            byteorder[0] = bo;
        }
        if (consumed != null) {
            consumed[0] = i2;
        }
        return v2.toString();
    }

    public static PyTuple utf_32_encode(String unicode) {
        return _codecs.utf_32_encode(unicode, null);
    }

    public static PyTuple utf_32_encode(String unicode, String errors) {
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, ByteOrder.UNDEFINED);
    }

    public static PyTuple utf_32_encode(String unicode, String errors, int byteorder) {
        ByteOrder order = ByteOrder.fromInt(byteorder);
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, order);
    }

    public static PyTuple utf_32_le_encode(String unicode) {
        return _codecs.utf_32_le_encode(unicode, null);
    }

    public static PyTuple utf_32_le_encode(String unicode, String errors) {
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, ByteOrder.LE);
    }

    public static PyTuple utf_32_be_encode(String unicode) {
        return _codecs.utf_32_be_encode(unicode, null);
    }

    public static PyTuple utf_32_be_encode(String unicode, String errors) {
        return _codecs.PyUnicode_EncodeUTF32(unicode, errors, ByteOrder.BE);
    }

    private static PyTuple PyUnicode_EncodeUTF32(String unicode, String errors, ByteOrder order) {
        StringBuilder v2 = new StringBuilder(4 * (unicode.length() + 1));
        int uptr = 0;
        if (order == ByteOrder.UNDEFINED) {
            v2.append("\u0000\u0000\u00fe\u00ff");
            order = ByteOrder.BE;
        }
        uptr = order != ByteOrder.LE ? _codecs.PyUnicode_EncodeUTF32BELoop(v2, unicode, errors) : _codecs.PyUnicode_EncodeUTF32LELoop(v2, unicode, errors);
        return _codecs.encode_tuple(v2.toString(), uptr);
    }

    private static int PyUnicode_EncodeUTF32BELoop(StringBuilder v2, String unicode, String errors) {
        int len = unicode.length();
        int uptr = 0;
        char[] buf = new char[6];
        while (uptr < len) {
            int ch;
            if (((ch = unicode.charAt(uptr++)) & 0xF800) == 55296) {
                if ((ch & 0x400) == 0) {
                    if (uptr < len) {
                        char ch2;
                        if (((ch2 = unicode.charAt(uptr++)) & 0xFC00) == 56320) {
                            ch = ((ch & 0x3FF) << 10) + (ch2 & 0x3FF) + 65536;
                            buf[3] = (char)(ch >> 16 & 0xFF);
                            buf[4] = (char)(ch >> 8 & 0xFF);
                            buf[5] = (char)(ch & 0xFF);
                            v2.append(buf, 2, 4);
                            continue;
                        }
                        uptr = _codecs.PyUnicode_EncodeUTF32Error(v2, errors, ByteOrder.BE, unicode, uptr - 2, uptr - 1, "second surrogate missing");
                        continue;
                    }
                    uptr = _codecs.PyUnicode_EncodeUTF32Error(v2, errors, ByteOrder.BE, unicode, uptr - 1, len, "truncated data");
                    continue;
                }
                uptr = _codecs.PyUnicode_EncodeUTF32Error(v2, errors, ByteOrder.BE, unicode, uptr - 2, uptr - 1, "unexpected second surrogate");
                continue;
            }
            if (ch > 255) {
                buf[3] = (char)(ch >> 8 & 0xFF);
                buf[4] = (char)(ch & 0xFF);
                v2.append(buf, 1, 4);
                continue;
            }
            buf[3] = (char)(ch & 0xFF);
            v2.append(buf, 0, 4);
        }
        return uptr;
    }

    private static int PyUnicode_EncodeUTF32LELoop(StringBuilder v2, String unicode, String errors) {
        int len = unicode.length();
        int uptr = 0;
        char[] buf = new char[6];
        while (uptr < len) {
            int ch;
            if (((ch = unicode.charAt(uptr++)) & 0xF800) == 55296) {
                if ((ch & 0x400) == 0) {
                    if (uptr < len) {
                        char ch2;
                        if (((ch2 = unicode.charAt(uptr++)) & 0xFC00) == 56320) {
                            ch = ((ch & 0x3FF) << 10) + (ch2 & 0x3FF) + 65536;
                            buf[0] = (char)(ch & 0xFF);
                            buf[1] = (char)(ch >> 8 & 0xFF);
                            buf[2] = (char)(ch >> 16 & 0xFF);
                            v2.append(buf, 0, 4);
                            continue;
                        }
                        uptr = _codecs.PyUnicode_EncodeUTF32Error(v2, errors, ByteOrder.LE, unicode, uptr - 2, uptr - 1, "second surrogate missing");
                        continue;
                    }
                    uptr = _codecs.PyUnicode_EncodeUTF32Error(v2, errors, ByteOrder.LE, unicode, uptr - 1, len, "truncated data");
                    continue;
                }
                uptr = _codecs.PyUnicode_EncodeUTF32Error(v2, errors, ByteOrder.LE, unicode, uptr - 2, uptr - 1, "unexpected second surrogate");
                continue;
            }
            if (ch > 255) {
                buf[1] = (char)(ch & 0xFF);
                buf[2] = (char)(ch >> 8 & 0xFF);
                v2.append(buf, 1, 4);
                continue;
            }
            buf[2] = (char)(ch & 0xFF);
            v2.append(buf, 2, 4);
        }
        return uptr;
    }

    private static int PyUnicode_EncodeUTF32Error(StringBuilder v2, String errors, ByteOrder order, String toEncode, int start, int end, String reason) {
        if (errors != null) {
            if (errors.equals("ignore")) {
                return end;
            }
            if (errors.equals("replace")) {
                for (int i2 = start; i2 < end; ++i2) {
                    if (order != ByteOrder.LE) {
                        v2.append("\u0000\u0000\u0000?");
                        continue;
                    }
                    v2.append("?\u0000\u0000\u0000");
                }
                return end;
            }
        }
        PyObject replacementSpec = codecs.encoding_error(errors, "utf-32", toEncode, start, end, reason);
        String u2 = replacementSpec.__getitem__(0).toString();
        _codecs.PyUnicode_EncodeUTF32BELoop(v2, u2, errors);
        return codecs.calcNewPosition(toEncode.length(), replacementSpec);
    }

    public static PyTuple utf_32_decode(String bytes) {
        return _codecs.utf_32_decode(bytes, null);
    }

    public static PyTuple utf_32_decode(String bytes, String errors) {
        return _codecs.utf_32_decode(bytes, errors, false);
    }

    public static PyTuple utf_32_decode(String bytes, String errors, boolean isFinal) {
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, ByteOrder.UNDEFINED, isFinal, false);
    }

    public static PyTuple utf_32_le_decode(String bytes) {
        return _codecs.utf_32_le_decode(bytes, null);
    }

    public static PyTuple utf_32_le_decode(String bytes, String errors) {
        return _codecs.utf_32_le_decode(bytes, errors, false);
    }

    public static PyTuple utf_32_le_decode(String bytes, String errors, boolean isFinal) {
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, ByteOrder.LE, isFinal, false);
    }

    public static PyTuple utf_32_be_decode(String bytes) {
        return _codecs.utf_32_be_decode(bytes, null);
    }

    public static PyTuple utf_32_be_decode(String bytes, String errors) {
        return _codecs.utf_32_be_decode(bytes, errors, false);
    }

    public static PyTuple utf_32_be_decode(String bytes, String errors, boolean isFinal) {
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, ByteOrder.BE, isFinal, false);
    }

    public static PyTuple utf_32_ex_decode(String bytes, String errors, int byteorder) {
        return _codecs.utf_32_ex_decode(bytes, errors, byteorder, false);
    }

    public static PyTuple utf_32_ex_decode(String bytes, String errors, int byteorder, boolean isFinal) {
        ByteOrder order = ByteOrder.fromInt(byteorder);
        return _codecs.PyUnicode_DecodeUTF32Stateful(bytes, errors, order, isFinal, true);
    }

    private static PyTuple PyUnicode_DecodeUTF32Stateful(String bytes, String errors, ByteOrder order, boolean isFinal, boolean findOrder) {
        int size = bytes.length();
        int limit = size & 0xFFFFFFFC;
        StringBuilder unicode = new StringBuilder(1 + limit / 4);
        int q2 = 0;
        if (limit > 0) {
            if (order == ByteOrder.UNDEFINED) {
                char a2 = bytes.charAt(q2);
                if (a2 == '\u00ff') {
                    if (bytes.charAt(q2 + 1) == '\u00fe' && bytes.charAt(q2 + 2) == '\u0000' && bytes.charAt(q2 + 3) == '\u0000') {
                        order = ByteOrder.LE;
                        q2 += 4;
                    }
                } else if (a2 == '\u0000' && bytes.charAt(q2 + 1) == '\u0000' && bytes.charAt(q2 + 2) == '\u00fe' && bytes.charAt(q2 + 3) == '\u00ff') {
                    order = ByteOrder.BE;
                    q2 += 4;
                }
            }
            q2 = order != ByteOrder.LE ? _codecs.PyUnicode_DecodeUTF32BELoop(unicode, bytes, q2, limit, errors) : _codecs.PyUnicode_DecodeUTF32LELoop(unicode, bytes, q2, limit, errors);
        }
        if (isFinal && q2 < size) {
            q2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-32", bytes, q2, size, "truncated data");
        }
        if (findOrder) {
            return _codecs.decode_tuple(unicode.toString(), q2, order);
        }
        return _codecs.decode_tuple(unicode.toString(), q2);
    }

    private static int PyUnicode_DecodeUTF32BELoop(StringBuilder unicode, String bytes, int q2, int limit, String errors) {
        while (q2 < limit) {
            int hi = bytes.charAt(q2) << 8 | bytes.charAt(q2 + 1);
            int lo = bytes.charAt(q2 + 2) << 8 | bytes.charAt(q2 + 3);
            if (hi == 0) {
                unicode.append((char)lo);
                q2 += 4;
                continue;
            }
            try {
                unicode.appendCodePoint((hi << 16) + lo);
                q2 += 4;
            }
            catch (IllegalArgumentException e2) {
                q2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-32", bytes, q2, q2 + 4, "codepoint not in range(0x110000)");
            }
        }
        return q2;
    }

    private static int PyUnicode_DecodeUTF32LELoop(StringBuilder unicode, String bytes, int q2, int limit, String errors) {
        while (q2 < limit) {
            int hi = bytes.charAt(q2 + 3) << 8 | bytes.charAt(q2 + 2);
            int lo = bytes.charAt(q2 + 1) << 8 | bytes.charAt(q2);
            if (hi == 0) {
                unicode.append((char)lo);
                q2 += 4;
                continue;
            }
            try {
                unicode.appendCodePoint((hi << 16) + lo);
                q2 += 4;
            }
            catch (IllegalArgumentException e2) {
                q2 = codecs.insertReplacementAndGetResume(unicode, errors, "utf-32", bytes, q2, q2 + 4, "codepoint not in range(0x110000)");
            }
        }
        return q2;
    }

    public static PyTuple raw_unicode_escape_encode(String str) {
        return _codecs.raw_unicode_escape_encode(str, null);
    }

    public static PyTuple raw_unicode_escape_encode(String str, String errors) {
        return _codecs.encode_tuple(codecs.PyUnicode_EncodeRawUnicodeEscape(str, errors, false), str.length());
    }

    public static PyTuple raw_unicode_escape_decode(String str) {
        return _codecs.raw_unicode_escape_decode(str, null);
    }

    public static PyTuple raw_unicode_escape_decode(String str, String errors) {
        return _codecs.decode_tuple(codecs.PyUnicode_DecodeRawUnicodeEscape(str, errors), str.length());
    }

    public static PyTuple unicode_escape_encode(String str) {
        return _codecs.unicode_escape_encode(str, null);
    }

    public static PyTuple unicode_escape_encode(String str, String errors) {
        return _codecs.encode_tuple(PyString.encode_UnicodeEscape(str, false), str.length());
    }

    public static PyTuple unicode_escape_decode(String str) {
        return _codecs.unicode_escape_decode(str, null);
    }

    public static PyTuple unicode_escape_decode(String str, String errors) {
        int n2 = str.length();
        return _codecs.decode_tuple(PyString.decode_UnicodeEscape(str, 0, n2, errors, true), n2);
    }

    @Deprecated
    public static PyTuple unicode_internal_encode(String unicode) {
        return _codecs.utf_32_be_encode(unicode, null);
    }

    @Deprecated
    public static PyTuple unicode_internal_encode(String unicode, String errors) {
        return _codecs.utf_32_be_encode(unicode, errors);
    }

    @Deprecated
    public static PyTuple unicode_internal_decode(String bytes) {
        return _codecs.utf_32_be_decode(bytes, null, true);
    }

    @Deprecated
    public static PyTuple unicode_internal_decode(String bytes, String errors) {
        return _codecs.utf_32_be_decode(bytes, errors, true);
    }

    @Untraversable
    @ExposedType(name="EncodingMap", isBaseType=false)
    public static class EncodingMap
    extends PyObject {
        char[] level1;
        char[] level23;
        int count2;
        int count3;

        private EncodingMap(char[] level1, char[] level23, int count2, int count3) {
            this.level1 = level1;
            this.level23 = level23;
            this.count2 = count2;
            this.count3 = count3;
        }

        public static PyObject buildEncodingMap(PyObject string) {
            int i2;
            if (!(string instanceof PyUnicode) || string.__len__() != 256) {
                throw Py.TypeError("bad argument type for built-in operation");
            }
            boolean needDict = false;
            char[] level1 = new char[32];
            char[] level23 = new char[512];
            int count2 = 0;
            int count3 = 0;
            String decode = string.toString();
            for (i2 = 0; i2 < level1.length; ++i2) {
                level1[i2] = 255;
            }
            for (i2 = 0; i2 < level23.length; ++i2) {
                level23[i2] = 255;
            }
            if (decode.charAt(0) != '\u0000') {
                needDict = true;
            }
            for (i2 = 1; i2 < 256; ++i2) {
                char charAt = decode.charAt(i2);
                if (charAt == '\u0000') {
                    needDict = true;
                }
                if (charAt == '\ufffe') continue;
                int l1 = charAt >> 11;
                int l2 = charAt >> 7;
                if (level1[l1] == '\u00ff') {
                    level1[l1] = (char)count2++;
                }
                if (level23[l2] != '\u00ff') continue;
                level23[l2] = (char)count3++;
            }
            if (count2 > 255 || count3 > 255) {
                needDict = true;
            }
            if (needDict) {
                PyDictionary result = new PyDictionary();
                for (i2 = 0; i2 < 256; ++i2) {
                    ((PyObject)result).__setitem__(Py.newInteger(decode.charAt(i2)), (PyObject)Py.newInteger(i2));
                }
                return result;
            }
            int length2 = 16 * count2;
            int length3 = 128 * count3;
            level23 = new char[length2 + length3];
            EncodingMap result = new EncodingMap(level1, level23, count2, count3);
            for (i2 = 0; i2 < length2; ++i2) {
                level23[i2] = 255;
            }
            for (i2 = length2; i2 < length2 + length3; ++i2) {
                level23[i2] = '\u0000';
            }
            count3 = 0;
            for (i2 = 1; i2 < 256; ++i2) {
                char charAt = decode.charAt(i2);
                if (charAt == '\ufffe') continue;
                int o1 = charAt >> 11;
                int o2 = charAt >> 7 & 0xF;
                int i22 = 16 * level1[o1] + o2;
                if (level23[i22] == '\u00ff') {
                    level23[i22] = (char)count3++;
                }
                int o3 = charAt & 0x7F;
                int i3 = 128 * level23[i22] + o3;
                level23[length2 + i3] = (char)i2;
            }
            return result;
        }

        public int lookup(char c2) {
            int l1 = c2 >> 11;
            int l2 = c2 >> 7 & 0xF;
            int l3 = c2 & 0x7F;
            if (c2 == '\u0000') {
                return 0;
            }
            char i2 = this.level1[l1];
            if (i2 == '\u00ff') {
                return -1;
            }
            if ((i2 = this.level23[16 * i2 + l2]) == '\u00ff') {
                return -1;
            }
            if ((i2 = this.level23[16 * this.count2 + 128 * i2 + l3]) == '\u0000') {
                return -1;
            }
            return i2;
        }

        static {
            PyType.addBuilder(EncodingMap.class, new _codecs$EncodingMap$PyExposer());
        }
    }

    static enum ByteOrder {
        LE,
        UNDEFINED,
        BE;


        int code() {
            return this.ordinal() - 1;
        }

        static ByteOrder fromInt(int byteorder) {
            switch (byteorder) {
                case -1: {
                    return LE;
                }
                case 1: {
                    return BE;
                }
            }
            return UNDEFINED;
        }
    }
}

