/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules._json;

import java.util.Iterator;
import org.python.core.ArgParser;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyBuiltinFunctionNarrow;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyUnicode;
import org.python.core.Untraversable;
import org.python.core.__builtin__;
import org.python.core.codecs;
import org.python.modules._json.Encoder;
import org.python.modules._json.Scanner;

public class _json
implements ClassDictInit {
    public static final PyString __doc__ = new PyString("Port of _json C module.");
    public static final PyObject module = Py.newString("_json");
    private static PyObject errmsg_fn;

    public static void classDictInit(PyObject dict) {
        dict.__setitem__("__name__", (PyObject)new PyString("_json"));
        dict.__setitem__("__doc__", (PyObject)__doc__);
        dict.__setitem__("encode_basestring_ascii", (PyObject)new EncodeBasestringAsciiFunction());
        dict.__setitem__("make_encoder", (PyObject)Encoder.TYPE);
        dict.__setitem__("make_scanner", (PyObject)Scanner.TYPE);
        dict.__setitem__("scanstring", (PyObject)new ScanstringFunction());
        dict.__setitem__("__module__", (PyObject)new PyString("_json"));
        Encoder.TYPE.setName("_json.Encoder");
        Scanner.TYPE.setName("_json.Scanner");
        dict.__setitem__("classDictInit", null);
    }

    private static synchronized PyObject get_errmsg_fn() {
        PyObject decoder;
        PyObject json;
        if (errmsg_fn == null && (json = __builtin__.__import__("json")) != null && (decoder = json.__findattr__("decoder")) != null) {
            errmsg_fn = decoder.__findattr__("errmsg");
        }
        return errmsg_fn;
    }

    static void raise_errmsg(String msg, PyObject s2) {
        _json.raise_errmsg(msg, s2, Py.None, Py.None);
    }

    static void raise_errmsg(String msg, PyObject s2, int pos) {
        _json.raise_errmsg(msg, s2, Py.newInteger(pos), Py.None);
    }

    static void raise_errmsg(String msg, PyObject s2, PyObject pos, PyObject end) {
        PyObject errmsg_fn = _json.get_errmsg_fn();
        if (errmsg_fn != null) {
            throw Py.ValueError(errmsg_fn.__call__(Py.newString(msg), s2, pos, end).asString());
        }
        throw Py.ValueError(msg);
    }

    static PyTuple scanstring(PyString pystr, int end, String encoding, boolean strict) {
        int next;
        int len = pystr.__len__();
        int begin = end - 1;
        if (end < 0 || len <= end) {
            throw Py.ValueError("end is out of bounds");
        }
        PyList chunks = new PyList();
        while (true) {
            int c2 = 0;
            for (next = end; next < len && (c2 = pystr.getInt(next)) != 34 && c2 != 92; ++next) {
                if (!strict || c2 > 31) continue;
                _json.raise_errmsg("Invalid control character at", pystr, next);
            }
            if (c2 != 34 && c2 != 92) {
                _json.raise_errmsg("Unterminated string starting at", pystr, begin);
            }
            if (next != end) {
                PyString strchunk = (PyString)pystr.__getslice__(Py.newInteger(end), Py.newInteger(next));
                if (strchunk instanceof PyUnicode) {
                    chunks.append(strchunk);
                } else {
                    chunks.append(codecs.decode(strchunk, encoding, null));
                }
            }
            ++next;
            if (c2 == 34) break;
            if (next == len) {
                _json.raise_errmsg("Unterminated string starting at", pystr, begin);
            }
            if ((c2 = pystr.getInt(next)) != 117) {
                end = next + 1;
                switch (c2) {
                    case 34: {
                        break;
                    }
                    case 92: {
                        break;
                    }
                    case 47: {
                        break;
                    }
                    case 98: {
                        c2 = 8;
                        break;
                    }
                    case 102: {
                        c2 = 12;
                        break;
                    }
                    case 110: {
                        c2 = 10;
                        break;
                    }
                    case 114: {
                        c2 = 13;
                        break;
                    }
                    case 116: {
                        c2 = 9;
                        break;
                    }
                    default: {
                        c2 = 0;
                    }
                }
                if (c2 == 0) {
                    _json.raise_errmsg("Invalid \\escape", pystr, end - 2);
                }
            } else {
                c2 = 0;
                if ((end = ++next + 4) >= len) {
                    _json.raise_errmsg("Invalid \\uXXXX escape", pystr, next - 1);
                }
                while (next < end) {
                    int digit = pystr.getInt(next);
                    c2 <<= 4;
                    switch (digit) {
                        case 48: 
                        case 49: 
                        case 50: 
                        case 51: 
                        case 52: 
                        case 53: 
                        case 54: 
                        case 55: 
                        case 56: 
                        case 57: {
                            c2 |= digit - 48;
                            break;
                        }
                        case 97: 
                        case 98: 
                        case 99: 
                        case 100: 
                        case 101: 
                        case 102: {
                            c2 |= digit - 97 + 10;
                            break;
                        }
                        case 65: 
                        case 66: 
                        case 67: 
                        case 68: 
                        case 69: 
                        case 70: {
                            c2 |= digit - 65 + 10;
                            break;
                        }
                        default: {
                            _json.raise_errmsg("Invalid \\uXXXX escape", pystr, end - 5);
                        }
                    }
                    ++next;
                }
                if ((c2 & 0xFC00) == 55296) {
                    int c22 = 0;
                    if (end + 6 >= len) {
                        _json.raise_errmsg("Unpaired high surrogate", pystr, end - 5);
                    }
                    if (pystr.getInt(next++) != 92 || pystr.getInt(next++) != 117) {
                        _json.raise_errmsg("Unpaired high surrogate", pystr, end - 5);
                    }
                    end += 6;
                    while (next < end) {
                        int digit = pystr.getInt(next);
                        c22 <<= 4;
                        switch (digit) {
                            case 48: 
                            case 49: 
                            case 50: 
                            case 51: 
                            case 52: 
                            case 53: 
                            case 54: 
                            case 55: 
                            case 56: 
                            case 57: {
                                c22 |= digit - 48;
                                break;
                            }
                            case 97: 
                            case 98: 
                            case 99: 
                            case 100: 
                            case 101: 
                            case 102: {
                                c22 |= digit - 97 + 10;
                                break;
                            }
                            case 65: 
                            case 66: 
                            case 67: 
                            case 68: 
                            case 69: 
                            case 70: {
                                c22 |= digit - 65 + 10;
                                break;
                            }
                            default: {
                                _json.raise_errmsg("Invalid \\uXXXX escape", pystr, end - 5);
                            }
                        }
                        ++next;
                    }
                    if ((c22 & 0xFC00) != 56320) {
                        _json.raise_errmsg("Unpaired high surrogate", pystr, end - 5);
                    }
                    c2 = 65536 + (c2 - 55296 << 10 | c22 - 56320);
                } else if ((c2 & 0xFC00) == 56320) {
                    _json.raise_errmsg("Unpaired low surrogate", pystr, end - 5);
                }
            }
            chunks.append(new PyUnicode(c2));
        }
        end = next;
        return new PyTuple(Py.EmptyUnicode.join(chunks), Py.newInteger(end));
    }

    static PyString encode_basestring_ascii(PyObject pystr) {
        if (pystr instanceof PyUnicode) {
            return _json.ascii_escape((PyUnicode)pystr);
        }
        if (pystr instanceof PyString) {
            return _json.ascii_escape((PyString)pystr);
        }
        throw Py.TypeError(String.format("first argument must be a string, not %.80s", pystr.getType().fastGetName()));
    }

    private static PyString ascii_escape(PyUnicode pystr) {
        StringBuilder rval = new StringBuilder(pystr.__len__());
        rval.append("\"");
        Iterator<Integer> iter2 = pystr.newSubsequenceIterator();
        while (iter2.hasNext()) {
            _json._write_char(rval, iter2.next());
        }
        rval.append("\"");
        return new PyString(rval.toString());
    }

    private static PyString ascii_escape(PyString pystr) {
        int len = pystr.__len__();
        String s2 = pystr.getString();
        StringBuilder rval = new StringBuilder(len);
        rval.append("\"");
        for (int i2 = 0; i2 < len; ++i2) {
            char c2 = s2.charAt(i2);
            if (c2 > '\u007f') {
                return _json.ascii_escape(new PyUnicode(codecs.PyUnicode_DecodeUTF8(s2, null)));
            }
            _json._write_char(rval, c2);
        }
        rval.append("\"");
        return new PyString(rval.toString());
    }

    private static void _write_char(StringBuilder builder, int c2) {
        if (c2 >= 32 && c2 <= 126 && c2 != 92 & c2 != 34) {
            builder.append((char)c2);
        } else {
            _json._ascii_escape_char(builder, c2);
        }
    }

    private static void _write_hexchar(StringBuilder builder, int c2) {
        builder.append("0123456789abcdef".charAt(c2 & 0xF));
    }

    private static void _ascii_escape_char(StringBuilder builder, int c2) {
        builder.append('\\');
        switch (c2) {
            case 92: {
                builder.append((char)c2);
                break;
            }
            case 34: {
                builder.append((char)c2);
                break;
            }
            case 8: {
                builder.append('b');
                break;
            }
            case 12: {
                builder.append('f');
                break;
            }
            case 10: {
                builder.append('n');
                break;
            }
            case 13: {
                builder.append('r');
                break;
            }
            case 9: {
                builder.append('t');
                break;
            }
            default: {
                if (c2 >= 65536) {
                    int v2 = c2 - 65536;
                    c2 = 0xD800 | v2 >> 10 & 0x3FF;
                    builder.append('u');
                    _json._write_hexchar(builder, c2 >> 12);
                    _json._write_hexchar(builder, c2 >> 8);
                    _json._write_hexchar(builder, c2 >> 4);
                    _json._write_hexchar(builder, c2);
                    c2 = 0xDC00 | v2 & 0x3FF;
                    builder.append('\\');
                }
                builder.append('u');
                _json._write_hexchar(builder, c2 >> 12);
                _json._write_hexchar(builder, c2 >> 8);
                _json._write_hexchar(builder, c2 >> 4);
                _json._write_hexchar(builder, c2);
            }
        }
    }

    @Untraversable
    static class EncodeBasestringAsciiFunction
    extends PyBuiltinFunctionNarrow {
        EncodeBasestringAsciiFunction() {
            super("encode_basestring_ascii", 1, 1, "encode_basestring_ascii");
        }

        @Override
        public PyObject getModule() {
            return module;
        }

        @Override
        public PyObject __call__(PyObject pystr) {
            return _json.encode_basestring_ascii(pystr);
        }
    }

    @Untraversable
    static class ScanstringFunction
    extends PyBuiltinFunctionNarrow {
        ScanstringFunction() {
            super("scanstring", 2, 4, "scanstring");
        }

        @Override
        public PyObject getModule() {
            return module;
        }

        @Override
        public PyObject __call__(PyObject s2, PyObject end) {
            return this.__call__(s2, end, (PyObject)new PyString("utf-8"), (PyObject)Py.True);
        }

        @Override
        public PyObject __call__(PyObject s2, PyObject end, PyObject encoding) {
            return this.__call__(s2, end, encoding, (PyObject)Py.True);
        }

        @Override
        public PyObject __call__(PyObject[] args, String[] kwds) {
            ArgParser ap = new ArgParser("scanstring", args, kwds, new String[]{"s", "end", "encoding", "strict"}, 2);
            return this.__call__(ap.getPyObject(0), ap.getPyObject(1), ap.getPyObject(2, new PyString("utf-8")), ap.getPyObject(3, Py.True));
        }

        @Override
        public PyObject __call__(PyObject s2, PyObject end, PyObject encoding, PyObject strict) {
            int end_idx = end.asIndex(Py.OverflowError);
            boolean is_strict = strict.__nonzero__();
            if (s2 instanceof PyString) {
                return _json.scanstring((PyString)s2, end_idx, encoding == Py.None ? null : encoding.toString(), is_strict);
            }
            throw Py.TypeError(String.format("first argument must be a string, not %.80s", s2.getType().fastGetName()));
        }
    }
}

