/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.itertools;

import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyIterator;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.itertools.itertools;
import org.python.modules.itertools.permutations$PyExposer;

@ExposedType(name="itertools.permutations", base=PyObject.class, doc="permutations(iterable[, r]) --> permutations object\n\nReturn successive r-length permutations of elements in the iterable.\n\npermutations(range(3), 2) --> (0,1), (0,2), (1,0), (1,2), (2,0), (2,1)")
public class permutations
extends PyIterator {
    public static final PyType TYPE;
    private PyIterator iter;
    public static final String permutations_doc = "permutations(iterable[, r]) --> permutations object\n\nReturn successive r-length permutations of elements in the iterable.\n\npermutations(range(3), 2) --> (0,1), (0,2), (1,0), (1,2), (2,0), (2,1)";

    public permutations() {
    }

    public permutations(PyType subType) {
        super(subType);
    }

    public permutations(PyObject iterable, int r2) {
        this.permutations___init__(iterable, r2);
    }

    @ExposedNew
    final void permutations___init__(PyObject[] args, String[] kwds) {
        int perm_length;
        if (args.length > 2) {
            throw Py.TypeError("permutations() takes at most 2 arguments (3 given)");
        }
        ArgParser ap = new ArgParser("permutations", args, kwds, "iterable", "r");
        PyObject iterable = ap.getPyObject(0);
        PyObject r2 = ap.getPyObject(1, Py.None);
        if (r2 == Py.None) {
            perm_length = iterable.__len__();
        } else {
            perm_length = r2.asInt();
            if (perm_length < 0) {
                throw Py.ValueError("r must be non-negative");
            }
        }
        this.permutations___init__(iterable, perm_length);
    }

    private void permutations___init__(PyObject iterable, final int r2) {
        final PyTuple pool = PyTuple.fromIterable(iterable);
        final int n2 = pool.__len__();
        final int[] indices = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            indices[i2] = i2;
        }
        final int[] cycles = new int[r2];
        for (int i3 = 0; i3 < r2; ++i3) {
            cycles[i3] = n2 - i3;
        }
        this.iter = new itertools.ItertoolsIterator(){
            boolean firstthru = true;

            @Override
            public PyObject __iternext__() {
                if (r2 > n2) {
                    return null;
                }
                if (this.firstthru) {
                    this.firstthru = false;
                    return itertools.makeIndexedTuple(pool, indices, r2);
                }
                for (int i2 = r2 - 1; i2 >= 0; --i2) {
                    int first;
                    int n22 = i2;
                    cycles[n22] = cycles[n22] - 1;
                    if (cycles[i2] == 0) {
                        first = indices[i2];
                        for (int j2 = i2; j2 < n2 - 1; ++j2) {
                            indices[j2] = indices[j2 + 1];
                        }
                    } else {
                        int j3 = cycles[i2];
                        int index = indices[i2];
                        indices[i2] = indices[n2 - j3];
                        indices[n2 - j3] = index;
                        return itertools.makeIndexedTuple(pool, indices, r2);
                    }
                    indices[n2 - 1] = first;
                    cycles[i2] = n2 - i2;
                }
                return null;
            }
        };
    }

    @Override
    public PyObject __iternext__() {
        return this.iter.__iternext__();
    }

    @Override
    public PyObject next() {
        return this.doNext(this.__iternext__());
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        return this.iter != null ? visit.visit(this.iter, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (this.iter == ob || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(permutations.class, new permutations$PyExposer());
        TYPE = PyType.fromClass(permutations.class);
    }
}

