/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import java.util.Arrays;
import java.util.Map;
import org.python.objectweb.asm.AnnotationVisitor;
import org.python.objectweb.asm.Type;

public class CodegenUtils {
    public static String c(String p2) {
        return p2.replace('/', '.');
    }

    public static String p(Class n2) {
        return n2.getName().replace('.', '/');
    }

    public static String ci(Class n2) {
        if (n2.isArray()) {
            if ((n2 = n2.getComponentType()).isPrimitive()) {
                if (n2 == Byte.TYPE) {
                    return "[B";
                }
                if (n2 == Boolean.TYPE) {
                    return "[Z";
                }
                if (n2 == Short.TYPE) {
                    return "[S";
                }
                if (n2 == Character.TYPE) {
                    return "[C";
                }
                if (n2 == Integer.TYPE) {
                    return "[I";
                }
                if (n2 == Float.TYPE) {
                    return "[F";
                }
                if (n2 == Double.TYPE) {
                    return "[D";
                }
                if (n2 == Long.TYPE) {
                    return "[J";
                }
                throw new RuntimeException("Unrecognized type in compiler: " + n2.getName());
            }
            return "[" + CodegenUtils.ci(n2);
        }
        if (n2.isPrimitive()) {
            if (n2 == Byte.TYPE) {
                return "B";
            }
            if (n2 == Boolean.TYPE) {
                return "Z";
            }
            if (n2 == Short.TYPE) {
                return "S";
            }
            if (n2 == Character.TYPE) {
                return "C";
            }
            if (n2 == Integer.TYPE) {
                return "I";
            }
            if (n2 == Float.TYPE) {
                return "F";
            }
            if (n2 == Double.TYPE) {
                return "D";
            }
            if (n2 == Long.TYPE) {
                return "J";
            }
            if (n2 == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("Unrecognized type in compiler: " + n2.getName());
        }
        return "L" + CodegenUtils.p(n2) + ";";
    }

    public static String human(Class n2) {
        return n2.getCanonicalName();
    }

    public static String humanShort(Class n2) {
        return n2.getSimpleName();
    }

    public static String sig(Class retval, Class ... params) {
        return CodegenUtils.sigParams(params) + CodegenUtils.ci(retval);
    }

    public static String sig(Class[] retvalParams) {
        Class[] justParams = new Class[retvalParams.length - 1];
        System.arraycopy(retvalParams, 1, justParams, 0, justParams.length);
        return CodegenUtils.sigParams(justParams) + CodegenUtils.ci(retvalParams[0]);
    }

    public static String sig(Class retval, String descriptor, Class ... params) {
        return CodegenUtils.sigParams(descriptor, params) + CodegenUtils.ci(retval);
    }

    public static String sigParams(Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.ci(params[i2]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String sigParams(String descriptor, Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        signature.append(descriptor);
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.ci(params[i2]));
        }
        signature.append(")");
        return signature.toString();
    }

    public static String pretty(Class retval, Class ... params) {
        return CodegenUtils.prettyParams(params) + CodegenUtils.human(retval);
    }

    public static String prettyParams(Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.human(params[i2]));
            if (i2 >= params.length - 1) continue;
            signature.append(',');
        }
        signature.append(")");
        return signature.toString();
    }

    public static String prettyShortParams(Class ... params) {
        StringBuilder signature = new StringBuilder("(");
        for (int i2 = 0; i2 < params.length; ++i2) {
            signature.append(CodegenUtils.humanShort(params[i2]));
            if (i2 >= params.length - 1) continue;
            signature.append(',');
        }
        signature.append(")");
        return signature.toString();
    }

    public static Class[] params(Class ... classes) {
        return classes;
    }

    public static Class[] params(Class cls, int times) {
        Object[] classes = new Class[times];
        Arrays.fill(classes, cls);
        return classes;
    }

    public static Class[] params(Class cls1, Class clsFill, int times) {
        Object[] classes = new Class[times + 1];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        return classes;
    }

    public static Class[] params(Class cls1, Class cls2, Class clsFill, int times) {
        Object[] classes = new Class[times + 2];
        Arrays.fill(classes, clsFill);
        classes[0] = cls1;
        classes[1] = cls2;
        return classes;
    }

    public static String getAnnotatedBindingClassName(String javaMethodName, String typeName, boolean isStatic, int required, int optional, boolean multi, boolean framed) {
        String commonClassSuffix = multi ? (isStatic ? "$s$" : "$i$") + javaMethodName : (isStatic ? "$s$" : "$i$") + required + "$" + optional + "$" + javaMethodName;
        return typeName + commonClassSuffix;
    }

    public static void visitAnnotationFields(AnnotationVisitor visitor, Map<String, Object> fields) {
        for (Map.Entry<String, Object> fieldEntry : fields.entrySet()) {
            Object value = fieldEntry.getValue();
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                AnnotationVisitor arrayV = visitor.visitArray(fieldEntry.getKey());
                for (int i2 = 0; i2 < values.length; ++i2) {
                    arrayV.visit(null, values[i2]);
                }
                arrayV.visitEnd();
                continue;
            }
            if (value.getClass().isEnum()) {
                visitor.visitEnum(fieldEntry.getKey(), CodegenUtils.ci(value.getClass()), value.toString());
                continue;
            }
            if (value instanceof Class) {
                visitor.visit(fieldEntry.getKey(), Type.getType((Class)value));
                continue;
            }
            visitor.visit(fieldEntry.getKey(), value);
        }
    }

    public static Class getBoxType(Class type) {
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new RuntimeException("Not a native type: " + type);
    }
}

