/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.math.BigInteger;
import org.python.core.ClassDictInit;
import org.python.core.Py;
import org.python.core.PyException;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyLong;
import org.python.core.PyObject;
import org.python.core.PyTuple;
import org.python.core.__builtin__;
import org.python.modules.math_erf;
import org.python.modules.math_gamma;

public class math
implements ClassDictInit {
    public static PyFloat pi = new PyFloat(Math.PI);
    public static PyFloat e = new PyFloat(Math.E);
    private static final double ZERO = 0.0;
    private static final double MINUS_ZERO = -0.0;
    private static final double ONE = 1.0;
    private static final double MINUS_ONE = -1.0;
    private static final double TWO = 2.0;
    private static final double EIGHT = 8.0;
    static final double LN2 = 0.6931471805599453;
    private static final double INF = Double.POSITIVE_INFINITY;
    private static final double NINF = Double.NEGATIVE_INFINITY;
    private static final double NAN = Double.NaN;
    private static final BigInteger MAX_LONG_BIGINTEGER = new BigInteger(String.valueOf(Long.MAX_VALUE));
    private static final BigInteger MIN_LONG_BIGINTEGER = new BigInteger(String.valueOf(Long.MIN_VALUE));

    public static void classDictInit(PyObject dict) {
    }

    public static double gamma(double v2) {
        return math_gamma.gamma(v2);
    }

    public static double lgamma(double v2) {
        return math_gamma.lgamma(v2);
    }

    public static double erf(double v2) {
        return math_erf.erf(v2);
    }

    public static double erfc(double v2) {
        return math_erf.erfc(v2);
    }

    public static double expm1(double v2) {
        if (Double.POSITIVE_INFINITY == v2) {
            return v2;
        }
        double result = Math.expm1(v2);
        if (Double.isInfinite(result)) {
            throw Py.OverflowError(Double.toString(v2));
        }
        return result;
    }

    public static double acos(double v2) {
        return math.exceptNaN(Math.acos(v2), v2);
    }

    public static double acosh(double y2) {
        if (y2 < 1.0) {
            throw math.mathDomainError();
        }
        if (y2 < 2.0) {
            double u2 = y2 - 1.0;
            double s2 = Math.sqrt(u2 * (2.0 + u2));
            return Math.log1p(u2 + s2);
        }
        if (y2 < 1.34217728E8) {
            double u3 = 1.0 / y2;
            double t2 = Math.sqrt((1.0 + u3) * (1.0 - u3));
            return Math.log(y2 * (1.0 + t2));
        }
        return Math.log(y2) + 0.6931471805599453;
    }

    public static double asin(double v2) {
        return math.exceptNaN(Math.asin(v2), v2);
    }

    public static double asinh(double v2) {
        if (math.isnan(v2) || math.isinf(v2)) {
            return v2;
        }
        double ln2 = 0.6931471805599453;
        double large = 2.68435456E8;
        double small = 3.725290298461914E-9;
        boolean sign = false;
        if (v2 < 0.0) {
            v2 = -v2;
            sign = true;
        }
        double temp = v2 > 2.68435456E8 ? math.log(v2) + 0.6931471805599453 : (v2 > 2.0 ? math.log(2.0 * v2 + 1.0 / (math.sqrt(v2 * v2 + 1.0) + v2)) : (v2 < 3.725290298461914E-9 ? v2 : math.log1p(v2 + v2 * v2 / (1.0 + math.sqrt(1.0 + v2 * v2)))));
        return sign ? -temp : temp;
    }

    public static double atan(double v2) {
        return math.exceptNaN(Math.atan(v2), v2);
    }

    public static double atanh(double y2) {
        double absy = Math.abs(y2);
        if (absy >= 1.0) {
            throw math.mathDomainError();
        }
        double u2 = (absy + absy) / (1.0 - absy);
        double x2 = 0.5 * Math.log1p(u2);
        return Math.copySign(x2, y2);
    }

    public static double atan2(double v2, double w2) {
        return Math.atan2(v2, w2);
    }

    public static double ceil(PyObject v2) {
        return math.ceil(v2.asDouble());
    }

    public static double ceil(double v2) {
        return Math.ceil(v2);
    }

    public static double cos(double v2) {
        return math.exceptNaN(Math.cos(v2), v2);
    }

    public static double cosh(double v2) {
        return math.exceptInf(Math.cosh(v2), v2);
    }

    public static double exp(double v2) {
        return math.exceptInf(Math.exp(v2), v2);
    }

    public static double floor(PyObject v2) {
        return math.floor(v2.asDouble());
    }

    public static double floor(double v2) {
        return Math.floor(v2);
    }

    public static double log(PyObject v2) {
        return math.log(v2, null);
    }

    public static double log(PyObject v2, PyObject base) {
        double doubleValue = v2 instanceof PyLong ? math.calculateLongLog((PyLong)v2) : math.log(v2.asDouble());
        return base == null ? doubleValue : math.applyLoggedBase(doubleValue, base);
    }

    public static double pow(double v2, double w2) {
        if (w2 == 0.0) {
            return 1.0;
        }
        if (v2 == 1.0) {
            return v2;
        }
        if (math.isnan(v2) || math.isnan(w2)) {
            return Double.NaN;
        }
        if (v2 == 0.0) {
            if (w2 == 0.0) {
                return 1.0;
            }
            if (w2 > 0.0 || math.ispinf(w2)) {
                return 0.0;
            }
            throw math.mathDomainError();
        }
        if (math.isninf(v2)) {
            if (math.isninf(w2)) {
                return 0.0;
            }
            if (math.isinf(w2)) {
                return Double.POSITIVE_INFINITY;
            }
            if (w2 == 0.0) {
                return 1.0;
            }
            if (w2 > 0.0) {
                if (math.isOdd(w2)) {
                    return Double.NEGATIVE_INFINITY;
                }
                return Double.POSITIVE_INFINITY;
            }
            if (math.isOdd(w2)) {
                return -0.0;
            }
            return 0.0;
        }
        if (math.isninf(w2) && v2 < 0.0) {
            if (v2 == -1.0) {
                return 1.0;
            }
            if (v2 < -1.0) {
                return 0.0;
            }
            return Double.POSITIVE_INFINITY;
        }
        if (math.ispinf(w2) && v2 < 0.0) {
            if (v2 == -1.0) {
                return 1.0;
            }
            if (v2 < -1.0) {
                return Double.POSITIVE_INFINITY;
            }
            return 0.0;
        }
        if (v2 < 0.0 && !math.isIntegral(w2)) {
            throw math.mathDomainError();
        }
        return Math.pow(v2, w2);
    }

    public static double sin(PyObject v2) {
        return math.sin(v2.asDouble());
    }

    public static double sin(double v2) {
        return math.exceptNaN(Math.sin(v2), v2);
    }

    public static double sqrt(PyObject v2) {
        return math.sqrt(v2.asDouble());
    }

    public static double sqrt(double v2) {
        return math.exceptNaN(Math.sqrt(v2), v2);
    }

    public static double tan(double v2) {
        return math.exceptNaN(Math.tan(v2), v2);
    }

    public static double log10(PyObject v2) {
        if (v2 instanceof PyLong) {
            int[] exp = new int[1];
            double x2 = ((PyLong)v2).scaledDoubleValue(exp);
            if (x2 <= 0.0) {
                throw math.mathDomainError();
            }
            return math.log10(x2) + (double)exp[0] * 8.0 * math.log10(2.0);
        }
        return math.log10(v2.asDouble());
    }

    public static double sinh(double v2) {
        return math.exceptInf(Math.sinh(v2), v2);
    }

    public static double tanh(double v2) {
        return math.exceptInf(Math.tanh(v2), v2);
    }

    public static double fabs(double v2) {
        return Math.abs(v2);
    }

    public static double fmod(double v2, double w2) {
        if (math.isnan(v2) || math.isnan(w2)) {
            return Double.NaN;
        }
        if (math.isinf(w2)) {
            return v2;
        }
        if (w2 == 0.0) {
            throw math.mathDomainError();
        }
        if (math.isinf(v2) && w2 == 1.0) {
            throw math.mathDomainError();
        }
        return v2 % w2;
    }

    public static PyTuple modf(double v2) {
        if (math.isnan(v2)) {
            return new PyTuple(new PyFloat(v2), new PyFloat(v2));
        }
        if (math.isinf(v2)) {
            double first = 0.0;
            if (math.isninf(v2)) {
                first = -0.0;
            }
            return new PyTuple(new PyFloat(first), new PyFloat(v2));
        }
        double w2 = v2 % 1.0;
        return new PyTuple(new PyFloat(w2), new PyFloat(v2 -= w2));
    }

    public static PyTuple frexp(double x2) {
        double mantissa;
        int exponent = Math.getExponent(x2);
        switch (exponent) {
            default: {
                mantissa = Math.scalb(x2, -(++exponent));
                break;
            }
            case 1024: {
                mantissa = x2;
                exponent = 0;
                break;
            }
            case -1023: {
                if (x2 == 0.0) {
                    mantissa = x2;
                    exponent = 0;
                    break;
                }
                exponent = Math.getExponent(x2 * 4.503599627370496E15) - 51;
                mantissa = Math.scalb(x2, -exponent);
            }
        }
        return new PyTuple(new PyFloat(mantissa), new PyInteger(exponent));
    }

    public static PyObject trunc(PyObject number) {
        return number.__getattr__("__trunc__").__call__();
    }

    public static double ldexp(double v2, PyObject wObj) {
        long w2 = math.getLong(wObj);
        if (w2 < Integer.MIN_VALUE) {
            w2 = Integer.MIN_VALUE;
        } else if (w2 > Integer.MAX_VALUE) {
            w2 = Integer.MAX_VALUE;
        }
        return math.exceptInf(Math.scalb(v2, (int)w2), v2);
    }

    public static double hypot(double x2, double y2) {
        double mag = Math.hypot(x2, y2);
        if (Double.isInfinite(mag) && !Double.isInfinite(x2) && !Double.isInfinite(y2)) {
            throw math.mathRangeError();
        }
        return mag;
    }

    public static double radians(double v2) {
        return Math.toRadians(v2);
    }

    public static double degrees(double v2) {
        return Math.toDegrees(v2);
    }

    public static boolean isnan(double v2) {
        return Double.isNaN(v2);
    }

    public static boolean isinf(double v2) {
        return Double.isInfinite(v2);
    }

    public static double copysign(double v2, double w2) {
        return Math.copySign(v2, w2);
    }

    public static PyLong factorial(double v2) {
        if (v2 == 0.0 || v2 == 1.0) {
            return new PyLong(1L);
        }
        if (v2 < 0.0 || math.isnan(v2) || math.isinf(v2)) {
            throw math.mathDomainError();
        }
        if (!math.isIntegral(v2)) {
            throw math.mathDomainError();
        }
        long value = (long)v2;
        BigInteger bi = new BigInteger(Long.toString(value));
        for (long l2 = value - 1L; l2 > 1L; --l2) {
            bi = bi.multiply(new BigInteger(Long.toString(l2)));
        }
        return new PyLong(bi);
    }

    public static double log1p(double v2) {
        if (v2 <= -1.0) {
            throw math.mathDomainError();
        }
        return Math.log1p(v2);
    }

    public static double fsum(PyObject iterable) {
        PyFloat result = (PyFloat)__builtin__.__import__("_fsum").invoke("fsum", iterable);
        return result.asDouble();
    }

    private static double calculateLongLog(PyLong v2) {
        int[] exp = new int[1];
        double x2 = v2.scaledDoubleValue(exp);
        if (x2 <= 0.0) {
            throw math.mathDomainError();
        }
        return math.log(x2) + (double)exp[0] * 8.0 * math.log(2.0);
    }

    private static double applyLoggedBase(double loggedValue, PyObject base) {
        double loggedBase = base instanceof PyLong ? math.calculateLongLog((PyLong)base) : math.log(base.asDouble());
        return loggedValue / loggedBase;
    }

    private static double log(double v2) {
        if (v2 <= 0.0) {
            throw math.mathDomainError();
        }
        return Math.log(v2);
    }

    private static double log10(double v2) {
        if (v2 <= 0.0) {
            throw math.mathDomainError();
        }
        return Math.log10(v2);
    }

    private static boolean isninf(double v2) {
        return v2 == Double.NEGATIVE_INFINITY;
    }

    private static boolean ispinf(double v2) {
        return v2 == Double.POSITIVE_INFINITY;
    }

    static PyException mathDomainError() {
        return Py.ValueError("math domain error");
    }

    static PyException mathRangeError() {
        return Py.OverflowError("math range error");
    }

    private static double exceptNaN(double result, double arg) throws PyException {
        if (Double.isNaN(result) && !Double.isNaN(arg)) {
            throw math.mathDomainError();
        }
        return result;
    }

    private static double exceptInf(double result, double arg) {
        if (Double.isInfinite(result) && !Double.isInfinite(arg)) {
            throw math.mathRangeError();
        }
        return result;
    }

    private static long getLong(PyObject pyo) {
        if (pyo instanceof PyLong) {
            return math.getLong((PyLong)pyo);
        }
        return pyo.asLong();
    }

    private static long getLong(PyLong pyLong) {
        BigInteger value = pyLong.getValue();
        if (value.compareTo(MAX_LONG_BIGINTEGER) > 0) {
            return Long.MAX_VALUE;
        }
        if (value.compareTo(MIN_LONG_BIGINTEGER) < 0) {
            return Long.MIN_VALUE;
        }
        return value.longValue();
    }

    private static boolean isIntegral(double v2) {
        return math.ceil(v2) - v2 == 0.0;
    }

    private static boolean isOdd(double v2) {
        return math.isIntegral(v2) && v2 % 2.0 != 0.0;
    }
}

