/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import org.python.core.Py;

public class math_gamma {
    static final double pi = Math.PI;
    static final double sqrtpi = 1.772453850905516;
    static final int LANCZOS_N = 13;
    static final double lanczos_g = 6.02468004077673;
    static final double lanczos_g_minus_half = 5.52468004077673;
    static final double[] lanczos_num_coeffs = new double[]{2.353137688041076E10, 4.29198036426491E10, 3.571195923735567E10, 1.792103442603721E10, 6.039542586352028E9, 1.4397204073117216E9, 2.4887455786205417E8, 3.1426415585400194E7, 2876370.6289353725, 186056.26539522348, 8071.672002365816, 210.82427775157936, 2.5066282746310002};
    static final double[] lanczos_den_coeffs = new double[]{0.0, 3.99168E7, 1.2054384E8, 1.50917976E8, 1.05258076E8, 4.599573E7, 1.3339535E7, 2637558.0, 357423.0, 32670.0, 1925.0, 66.0, 1.0};
    static final int NGAMMA_INTEGRAL = 23;
    static final double[] gamma_integral = new double[]{1.0, 1.0, 2.0, 6.0, 24.0, 120.0, 720.0, 5040.0, 40320.0, 362880.0, 3628800.0, 3.99168E7, 4.790016E8, 6.2270208E9, 8.71782912E10, 1.307674368E12, 2.0922789888E13, 3.55687428096E14, 6.402373705728E15, 1.21645100408832E17, 2.43290200817664E18, 5.109094217170944E19, 1.1240007277776077E21};

    static double sinpi(double x2) {
        double r2;
        double y2 = Math.abs(x2) % 2.0;
        int n2 = (int)Math.round(2.0 * y2);
        assert (0 <= n2 && n2 <= 4);
        switch (n2) {
            case 0: {
                r2 = Math.sin(Math.PI * y2);
                break;
            }
            case 1: {
                r2 = Math.cos(Math.PI * (y2 - 0.5));
                break;
            }
            case 2: {
                r2 = Math.sin(Math.PI * (1.0 - y2));
                break;
            }
            case 3: {
                r2 = -Math.cos(Math.PI * (y2 - 1.5));
                break;
            }
            case 4: {
                r2 = Math.sin(Math.PI * (y2 - 2.0));
                break;
            }
            default: {
                assert (false);
                r2 = 3.0;
            }
        }
        return Math.copySign(1.0, x2) * r2;
    }

    static double lanczos_sum(double x2) {
        double num = 0.0;
        double den = 0.0;
        assert (x2 > 0.0);
        if (x2 < 5.0) {
            int i2 = 13;
            while (--i2 >= 0) {
                num = num * x2 + lanczos_num_coeffs[i2];
                den = den * x2 + lanczos_den_coeffs[i2];
            }
        } else {
            for (int i3 = 0; i3 < 13; ++i3) {
                num = num / x2 + lanczos_num_coeffs[i3];
                den = den / x2 + lanczos_den_coeffs[i3];
            }
        }
        return num / den;
    }

    public static double gamma(double x2) {
        double r2;
        double z2;
        double absx;
        if (Double.isNaN(x2)) {
            return x2;
        }
        if (Double.isInfinite(x2)) {
            if (x2 > 0.0) {
                return x2;
            }
            throw Py.ValueError("math domain error");
        }
        if (x2 == 0.0) {
            throw Py.ValueError("math domain error");
        }
        if (x2 == Math.floor(x2)) {
            if (x2 < 0.0) {
                throw Py.ValueError("math domain error");
            }
            if (x2 <= 23.0) {
                return gamma_integral[(int)x2 - 1];
            }
        }
        if ((absx = Math.abs(x2)) < 1.0E-20) {
            double r3 = 1.0 / x2;
            if (Double.isInfinite(r3)) {
                throw Py.OverflowError("math range error");
            }
            return r3;
        }
        if (absx > 200.0) {
            if (x2 < 0.0) {
                return 0.0 / math_gamma.sinpi(x2);
            }
            throw Py.OverflowError("math range error");
        }
        double y2 = absx + 5.52468004077673;
        if (absx > 5.52468004077673) {
            double q2 = y2 - absx;
            z2 = q2 - 5.52468004077673;
        } else {
            double q3 = y2 - 5.52468004077673;
            z2 = q3 - absx;
        }
        z2 = z2 * 6.02468004077673 / y2;
        if (x2 < 0.0) {
            r2 = -Math.PI / math_gamma.sinpi(absx) / absx * Math.exp(y2) / math_gamma.lanczos_sum(absx);
            r2 -= z2 * r2;
            if (absx < 140.0) {
                r2 /= Math.pow(y2, absx - 0.5);
            } else {
                double sqrtpow = Math.pow(y2, absx / 2.0 - 0.25);
                r2 /= sqrtpow;
                r2 /= sqrtpow;
            }
        } else {
            r2 = math_gamma.lanczos_sum(absx) / Math.exp(y2);
            r2 += z2 * r2;
            if (absx < 140.0) {
                r2 *= Math.pow(y2, absx - 0.5);
            } else {
                double sqrtpow = Math.pow(y2, absx / 2.0 - 0.25);
                r2 *= sqrtpow;
                r2 *= sqrtpow;
            }
        }
        if (Double.isInfinite(r2)) {
            throw Py.OverflowError("math range error");
        }
        return r2;
    }

    public static double lgamma(double x2) {
        if (Double.isNaN(x2)) {
            return x2;
        }
        if (Double.isInfinite(x2)) {
            return Double.POSITIVE_INFINITY;
        }
        if (x2 == Math.floor(x2) && x2 <= 2.0) {
            if (x2 <= 0.0) {
                throw Py.ValueError("math domain error");
            }
            return 0.0;
        }
        double absx = Math.abs(x2);
        if (absx < 1.0E-20) {
            return -Math.log(absx);
        }
        double r2 = x2 > 0.0 ? Math.log(math_gamma.lanczos_sum(x2)) - 6.02468004077673 + (x2 - 0.5) * (Math.log(x2 + 6.02468004077673 - 0.5) - 1.0) : Math.log(Math.PI) - Math.log(Math.abs(math_gamma.sinpi(absx))) - Math.log(absx) - (Math.log(math_gamma.lanczos_sum(absx)) - 6.02468004077673 + (absx - 0.5) * (Math.log(absx + 6.02468004077673 - 0.5) - 1.0));
        if (Double.isInfinite(r2)) {
            throw Py.OverflowError("math range error");
        }
        return r2;
    }
}

