/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.posix;

import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import jnr.posix.FileStat;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.posix.PosixModule;
import org.python.modules.posix.PyStatResult$PyExposer;

@ExposedType(name="stat_result", isBaseType=false)
public class PyStatResult
extends PyTuple {
    public static final PyType TYPE;
    public PyObject st_mode;
    public PyObject st_ino;
    public PyObject st_dev;
    public PyObject st_nlink;
    public PyObject st_uid;
    public PyObject st_gid;
    public PyObject st_size;
    public PyObject st_atime;
    public PyObject st_mtime;
    public PyObject st_ctime;
    public static final int n_sequence_fields = 10;
    public static final int n_fields = 10;
    public static final int n_unnamed_fields = 10;
    private static final int ST_ATIME = 7;
    private static final int ST_MTIME = 8;
    private static final int ST_CTIME = 9;

    PyStatResult(PyObject ... vals) {
        super(TYPE, vals);
        this.st_mode = vals[0];
        this.st_ino = vals[1];
        this.st_dev = vals[2];
        this.st_nlink = vals[3];
        this.st_uid = vals[4];
        this.st_gid = vals[5];
        this.st_size = vals[6];
        this.st_atime = vals[7];
        this.st_mtime = vals[8];
        this.st_ctime = vals[9];
    }

    @ExposedNew
    static PyObject stat_result_new(PyNewWrapper wrapper, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("stat_result", args, keywords, new String[]{"tuple"}, 1);
        PyObject obj = ap.getPyObject(0);
        if (obj instanceof PyTuple) {
            if (obj.__len__() != 10) {
                String msg = String.format("stat_result() takes a %s-sequence (%s-sequence given)", 10, obj.__len__());
                throw Py.TypeError(msg);
            }
            return new PyStatResult(((PyTuple)obj).getArray());
        }
        PyList seq = new PyList(obj);
        if (seq.__len__() != 10) {
            String msg = String.format("stat_result() takes a %s-sequence (%s-sequence given)", 10, obj.__len__());
            throw Py.TypeError(msg);
        }
        return new PyStatResult((PyObject[])seq.__tojava__(PyObject[].class));
    }

    public static PyStatResult fromFileStat(FileStat stat) {
        return new PyStatResult(Py.newInteger(stat.mode()), Py.newInteger(stat.ino()), Py.newLong(stat.dev()), Py.newInteger(stat.nlink()), Py.newInteger(stat.uid()), Py.newInteger(stat.gid()), Py.newInteger(stat.st_size()), Py.newFloat(stat.atime()), Py.newFloat(stat.mtime()), Py.newFloat(stat.ctime()));
    }

    private static double fromFileTime(FileTime fileTime) {
        return (double)fileTime.to(TimeUnit.NANOSECONDS) / 1.0E9;
    }

    private static Long zeroOrValue(Long value) {
        if (value == null) {
            return new Long(0L);
        }
        return value;
    }

    private static Integer zeroOrValue(Integer value) {
        if (value == null) {
            return new Integer(0);
        }
        return value;
    }

    public static PyStatResult fromUnixFileAttributes(Map<String, Object> stat) {
        Integer mode = PyStatResult.zeroOrValue((Integer)stat.get("mode"));
        Long ino = PyStatResult.zeroOrValue((Long)stat.get("ino"));
        Long dev = PyStatResult.zeroOrValue((Long)stat.get("dev"));
        Integer nlink = PyStatResult.zeroOrValue((Integer)stat.get("nlink"));
        Integer uid = PyStatResult.zeroOrValue((Integer)stat.get("uid"));
        Integer gid = PyStatResult.zeroOrValue((Integer)stat.get("gid"));
        Long size = PyStatResult.zeroOrValue((Long)stat.get("size"));
        return new PyStatResult(Py.newInteger(mode), Py.newInteger(ino), Py.newLong(dev), Py.newInteger(nlink), Py.newInteger(uid), Py.newInteger(gid), Py.newInteger(size), Py.newFloat(PyStatResult.fromFileTime((FileTime)stat.get("lastAccessTime"))), Py.newFloat(PyStatResult.fromFileTime((FileTime)stat.get("lastModifiedTime"))), Py.newFloat(PyStatResult.fromFileTime((FileTime)stat.get("ctime"))));
    }

    public static PyStatResult fromDosFileAttributes(int mode, DosFileAttributes stat) {
        return new PyStatResult(Py.newInteger(mode), Py.newInteger(0), Py.newLong(0), Py.newInteger(0), Py.newInteger(0), Py.newInteger(0), Py.newInteger(stat.size()), Py.newFloat(PyStatResult.fromFileTime(stat.lastAccessTime())), Py.newFloat(PyStatResult.fromFileTime(stat.lastModifiedTime())), Py.newFloat(PyStatResult.fromFileTime(stat.creationTime())));
    }

    @Override
    public PyObject pyget(int index) {
        if (index == 7 || index == 8 || index == 9) {
            return super.pyget(index).__int__();
        }
        return super.pyget(index);
    }

    @Override
    protected PyObject getslice(int start, int stop2, int step) {
        if (step > 0 && stop2 < start) {
            stop2 = start;
        }
        int n2 = PyStatResult.sliceLength(start, stop2, step);
        PyObject[] newArray = new PyObject[n2];
        int i2 = start;
        for (int j2 = 0; j2 < n2; ++j2) {
            newArray[j2] = this.pyget(i2);
            i2 += step;
        }
        return new PyTuple(newArray, false);
    }

    @Override
    public synchronized PyObject __eq__(PyObject o2) {
        return this.stat_result___eq__(o2);
    }

    final synchronized PyObject stat_result___eq__(PyObject o2) {
        int ol;
        if (this.getType() != o2.getType() && !this.getType().isSubType(o2.getType())) {
            return null;
        }
        int tl = this.__len__();
        if (tl != (ol = o2.__len__())) {
            return Py.False;
        }
        int i2 = PyStatResult.cmp(this, tl, o2, ol);
        return i2 < 0 ? Py.True : Py.False;
    }

    @Override
    public synchronized PyObject __ne__(PyObject o2) {
        return this.stat_result___ne__(o2);
    }

    final synchronized PyObject stat_result___ne__(PyObject o2) {
        PyObject eq = this.stat_result___eq__(o2);
        if (eq == null) {
            return null;
        }
        return eq.__not__();
    }

    @Override
    public PyObject __reduce__() {
        return this.stat_result___reduce__();
    }

    final PyObject stat_result___reduce__() {
        PyTuple newargs = this.__getnewargs__();
        return new PyTuple(this.getType(), newargs);
    }

    @Override
    public PyTuple __getnewargs__() {
        return new PyTuple(new PyList(this.getArray()));
    }

    @Override
    public PyString __repr__() {
        return (PyString)Py.newString(TYPE.fastGetName() + "(" + "st_mode=%r, st_ino=%r, st_dev=%r, st_nlink=%r, st_uid=%r, " + "st_gid=%r, st_size=%r, st_atime=%r, st_mtime=%r, st_ctime=%r)").__mod__(this);
    }

    @Override
    public int traverse(Visitproc visit, Object arg) {
        int retVal = super.traverse(visit, arg);
        if (retVal != 0) {
            return retVal;
        }
        if (this.st_mode != null && (retVal = visit.visit(this.st_mode, arg)) != 0) {
            return retVal;
        }
        if (this.st_ino != null && (retVal = visit.visit(this.st_ino, arg)) != 0) {
            return retVal;
        }
        if (this.st_dev != null && (retVal = visit.visit(this.st_dev, arg)) != 0) {
            return retVal;
        }
        if (this.st_nlink != null && (retVal = visit.visit(this.st_nlink, arg)) != 0) {
            return retVal;
        }
        if (this.st_uid != null && (retVal = visit.visit(this.st_uid, arg)) != 0) {
            return retVal;
        }
        if (this.st_gid != null && (retVal = visit.visit(this.st_gid, arg)) != 0) {
            return retVal;
        }
        if (this.st_size != null && (retVal = visit.visit(this.st_size, arg)) != 0) {
            return retVal;
        }
        if (this.st_atime != null && (retVal = visit.visit(this.st_atime, arg)) != 0) {
            return retVal;
        }
        if (this.st_mtime != null && (retVal = visit.visit(this.st_mtime, arg)) != 0) {
            return retVal;
        }
        return this.st_ctime != null ? visit.visit(this.st_ctime, arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == this.st_mode || ob == this.st_ino || ob == this.st_dev || ob == this.st_nlink || ob == this.st_uid || ob == this.st_gid || ob == this.st_size || ob == this.st_atime || ob == this.st_mtime || ob == this.st_ctime || super.refersDirectlyTo(ob));
    }

    static {
        PyType.addBuilder(PyStatResult.class, new PyStatResult$PyExposer());
        TYPE = PyType.fromClass(PyStatResult.class);
        TYPE.setName(PosixModule.getOSName() + "." + TYPE.fastGetName());
    }
}

