/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.python.core.ucnhashAPI;

public class ucnhash
implements ucnhashAPI {
    private static int n;
    private static int m;
    private static int minchar;
    private static int maxchar;
    private static int alphasz;
    private static int maxlen;
    private static int maxidx;
    private static int maxklen;
    private static short[] G;
    private static short[] T0;
    private static short[] T1;
    private static short[] T2;
    private static byte[] worddata;
    private static short[] wordoffs;
    private static short wordstart;
    private static short wordcutoff;
    private static byte[] rawdata;
    private static char[] rawindex;
    private static char[] codepoint;
    public static String[] __depends__;
    private static final char[] charmap;
    private static String cjkPrefix;
    private static int cjkPrefixLen;
    private static boolean initialized;
    private static boolean loaded;
    private static boolean debug;

    public static void loadTables() throws Exception {
        InputStream instream = ucnhash.class.getResourceAsStream("ucnhash.dat");
        if (instream == null) {
            throw new IOException("Unicode name database not found: ucnhash.dat");
        }
        DataInputStream in = new DataInputStream(new BufferedInputStream(instream));
        n = in.readShort();
        m = in.readShort();
        minchar = in.readShort();
        maxchar = in.readShort();
        alphasz = in.readShort();
        maxlen = in.readShort();
        maxidx = maxlen * alphasz - minchar;
        G = ucnhash.readShortTable(in);
        if (in.readShort() != 3) {
            throw new IOException("UnicodeNameMap file corrupt, unknown dimension");
        }
        T0 = ucnhash.readShortTable(in);
        T1 = ucnhash.readShortTable(in);
        T2 = ucnhash.readShortTable(in);
        wordoffs = ucnhash.readShortTable(in);
        worddata = ucnhash.readByteTable(in);
        wordstart = in.readShort();
        wordcutoff = in.readShort();
        maxklen = in.readShort();
        rawdata = ucnhash.readByteTable(in);
        rawindex = ucnhash.readCharTable(in);
        codepoint = ucnhash.readCharTable(in);
    }

    private static short[] readShortTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, shorttable");
        }
        int n2 = in.readUnsignedShort() / 2;
        short[] table = new short[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            table[i2] = in.readShort();
        }
        return table;
    }

    private static char[] readCharTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, chartable");
        }
        int n2 = in.readUnsignedShort() / 2;
        char[] table = new char[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            table[i2] = in.readChar();
        }
        return table;
    }

    private static byte[] readByteTable(DataInputStream in) throws IOException {
        if (in.read() != 116) {
            throw new IOException("UnicodeNameMap file corrupt, byte table");
        }
        int n2 = in.readUnsignedShort();
        byte[] table = new byte[n2];
        in.readFully(table);
        return table;
    }

    public static int hash(String key) {
        return ucnhash.hash(key, 0, key.length());
    }

    public static int hash(String key, int start, int end) {
        int i2 = -minchar;
        int f2 = 0;
        int f1 = 0;
        int f0 = 0;
        for (int j2 = start; j2 < end; ++j2) {
            char ch = key.charAt(j2);
            if (ch >= 'a' && ch <= 'z') {
                ch = (char)(ch - 97 + 65);
            }
            f0 += T0[i2 + ch];
            f1 += T1[i2 + ch];
            f2 += T2[i2 + ch];
            if ((i2 += alphasz) < maxidx) continue;
            i2 = -minchar;
        }
        return (G[f0 %= n] + G[f1 %= n] + G[f2 %= n]) % m;
    }

    private static String getWord(int idx) {
        int offset = wordoffs[idx];
        int end = worddata.length;
        if (idx < wordoffs.length - 1) {
            end = wordoffs[idx + 1];
        }
        StringBuilder buf = new StringBuilder();
        for (int i2 = offset; i2 < end; ++i2) {
            buf.append(charmap[worddata[i2]]);
        }
        return buf.toString();
    }

    private static boolean match(int idx, byte[] raw, int begin, int end) {
        short woff = wordoffs[idx];
        int wend = worddata.length;
        if (idx < wordoffs.length - 1) {
            wend = wordoffs[idx + 1];
        }
        if (end - begin != wend - woff) {
            return false;
        }
        int l2 = end - begin;
        for (int i2 = 0; i2 < l2; ++i2) {
            if (worddata[woff + i2] == raw[begin + i2]) continue;
            return false;
        }
        return true;
    }

    private static int compare(byte[] a1, int off1, int len1, byte[] a2, int off2, int len2) {
        for (int i2 = 0; i2 < len1 && i2 < len2; ++i2) {
            int d2 = (a1[off1 + i2] & 0xFF) - (a2[off2 + i2] & 0xFF);
            if (d2 == 0) continue;
            return d2;
        }
        return len1 - len2;
    }

    private static int binarysearch(byte[] rawlist, int start, int end) {
        int off;
        int floor = 0;
        int ceiling = rawindex.length / 5;
        while (floor < ceiling - 1) {
            int len;
            int d2;
            int middle = (floor + ceiling) / 2;
            if (debug) {
                System.out.println("floor:" + floor + " ceiling:" + ceiling + " => " + middle);
            }
            if ((d2 = ucnhash.compare(rawlist, start, end - start, rawdata, off = rawindex[middle * 5], len = rawindex[middle * 5 + 4] & 0x1F)) < 0) {
                ceiling = middle;
                continue;
            }
            if (d2 > 0) {
                floor = middle;
                continue;
            }
            return middle * 12;
        }
        int tmp = floor * 5;
        off = rawindex[tmp++];
        long lengths = (long)rawindex[tmp++] << 48 | (long)rawindex[tmp++] << 32 | (long)rawindex[tmp++] << 16 | (long)rawindex[tmp++];
        floor *= 12;
        for (int i2 = 0; i2 < 12; ++i2) {
            int len = (int)(lengths >> i2 * 5) & 0x1F;
            if (ucnhash.compare(rawlist, start, end, rawdata, off, len) == 0) {
                return floor;
            }
            off += len;
            ++floor;
        }
        return -1;
    }

    public static int lookup(String name) {
        return ucnhash.lookup(name, 0, name.length());
    }

    private static int lookup(String name, int start, int end) {
        int idx;
        byte[] rawlist = new byte[32];
        int ridx = 0;
        int rbegin = 0;
        int rstart = 0;
        while (true) {
            boolean isWord;
            int i2;
            rbegin = ridx;
            int begin = start;
            for (i2 = start; i2 < end; ++i2) {
                int v2;
                char ch = name.charAt(i2);
                if (ch == ' ') {
                    start = i2 + 1;
                    break;
                }
                if (ch >= 'a' && ch <= 'z') {
                    ch = (char)(ch - 97 + 65);
                }
                if (ch >= 'A' && ch <= 'Z') {
                    v2 = ch - 65 + 1;
                } else if (ch >= '0' && ch <= '9') {
                    v2 = ch - 48 + 27;
                } else if (ch == '-') {
                    v2 = 37;
                } else {
                    return -1;
                }
                rawlist[ridx++] = (byte)v2;
                if (ch != '-' || start == i2) continue;
                start = ++i2;
                break;
            }
            int hash = ucnhash.hash(name, begin, i2);
            if (debug) {
                System.out.println(name.substring(begin, i2) + " " + hash);
            }
            boolean bl = isWord = hash >= 0 && ridx - rbegin > 1 && ucnhash.match(hash, rawlist, rbegin, ridx);
            if (isWord) {
                if (debug) {
                    System.out.println("match " + ucnhash.getWord(hash));
                }
                ridx = rstart;
                if ((hash += wordstart) > wordcutoff) {
                    rawlist[ridx++] = (byte)((hash >> 8) + wordcutoff);
                    rawlist[ridx++] = (byte)(hash & 0xFF);
                } else {
                    rawlist[ridx++] = (byte)hash;
                }
            }
            rstart = ridx;
            if (i2 >= end) break;
            if (isWord) continue;
            rawlist[ridx++] = 0;
        }
        if (debug) {
            System.out.print("rawdata: ");
            for (int k2 = 0; k2 < ridx; ++k2) {
                System.out.print((rawlist[k2] & 0xFF) + " ");
            }
            System.out.println();
        }
        if ((idx = ucnhash.binarysearch(rawlist, 0, ridx)) < 0) {
            return idx;
        }
        if (debug) {
            System.out.println("idx:" + idx);
            System.out.println("codepoint:" + codepoint[idx] + " " + Integer.toHexString(codepoint[idx]));
        }
        return codepoint[idx];
    }

    @Override
    public int getCchMax() {
        if (!this.initialized()) {
            return -1;
        }
        return maxklen;
    }

    @Override
    public int getValue(String s2, int start, int end) {
        if (!this.initialized()) {
            return -1;
        }
        if (s2.regionMatches(start, cjkPrefix, 0, cjkPrefixLen)) {
            try {
                String hex = s2.substring(start + cjkPrefixLen, end);
                int v2 = Integer.parseInt(hex, 16);
                return v2;
            }
            catch (NumberFormatException exc) {
                return -1;
            }
        }
        return ucnhash.lookup(s2, start, end);
    }

    private synchronized boolean initialized() {
        if (initialized && loaded) {
            return true;
        }
        if (initialized) {
            return false;
        }
        try {
            ucnhash.loadTables();
            loaded = true;
        }
        catch (Exception exc) {
            return false;
        }
        initialized = true;
        return true;
    }

    public static void main(String[] args) throws Exception {
        ucnhash.loadTables();
        debug = true;
        System.out.println(ucnhash.lookup("BACKSPACE"));
    }

    static {
        __depends__ = new String[]{"/org/python/modules/ucnhash.dat"};
        charmap = " ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-".toCharArray();
        cjkPrefix = "CJK COMPATIBILITY IDEOGRAPH-";
        cjkPrefixLen = cjkPrefix.length();
        initialized = false;
        loaded = false;
        debug = false;
    }
}

