/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.channel;

import org.python.netty.channel.ChannelFuture;
import org.python.netty.channel.ChannelHandlerContext;
import org.python.netty.channel.ChannelOutboundBuffer;
import org.python.netty.channel.ChannelPromise;
import org.python.netty.channel.ChannelPromiseAggregator;
import org.python.netty.channel.MessageSizeEstimator;
import org.python.netty.channel.VoidChannelPromise;
import org.python.netty.util.Recycler;
import org.python.netty.util.ReferenceCountUtil;
import org.python.netty.util.internal.logging.InternalLogger;
import org.python.netty.util.internal.logging.InternalLoggerFactory;

public final class PendingWriteQueue {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PendingWriteQueue.class);
    private final ChannelHandlerContext ctx;
    private final ChannelOutboundBuffer buffer;
    private final MessageSizeEstimator.Handle estimatorHandle;
    private PendingWrite head;
    private PendingWrite tail;
    private int size;

    public PendingWriteQueue(ChannelHandlerContext ctx) {
        if (ctx == null) {
            throw new NullPointerException("ctx");
        }
        this.ctx = ctx;
        this.buffer = ctx.channel().unsafe().outboundBuffer();
        this.estimatorHandle = ctx.channel().config().getMessageSizeEstimator().newHandle();
    }

    public boolean isEmpty() {
        assert (this.ctx.executor().inEventLoop());
        return this.head == null;
    }

    public int size() {
        assert (this.ctx.executor().inEventLoop());
        return this.size;
    }

    public void add(Object msg, ChannelPromise promise) {
        assert (this.ctx.executor().inEventLoop());
        if (msg == null) {
            throw new NullPointerException("msg");
        }
        if (promise == null) {
            throw new NullPointerException("promise");
        }
        int messageSize = this.estimatorHandle.size(msg);
        if (messageSize < 0) {
            messageSize = 0;
        }
        PendingWrite write2 = PendingWrite.newInstance(msg, messageSize, promise);
        PendingWrite currentTail = this.tail;
        if (currentTail == null) {
            this.tail = this.head = write2;
        } else {
            currentTail.next = write2;
            this.tail = write2;
        }
        ++this.size;
        if (this.buffer != null) {
            this.buffer.incrementPendingOutboundBytes(write2.size);
        }
    }

    public void removeAndFailAll(Throwable cause) {
        assert (this.ctx.executor().inEventLoop());
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite write2 = this.head;
        this.tail = null;
        this.head = null;
        this.size = 0;
        while (write2 != null) {
            PendingWrite next = write2.next;
            ReferenceCountUtil.safeRelease(write2.msg);
            ChannelPromise promise = write2.promise;
            this.recycle(write2, false);
            PendingWriteQueue.safeFail(promise, cause);
            write2 = next;
        }
        this.assertEmpty();
    }

    public void removeAndFail(Throwable cause) {
        assert (this.ctx.executor().inEventLoop());
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return;
        }
        ReferenceCountUtil.safeRelease(write2.msg);
        ChannelPromise promise = write2.promise;
        PendingWriteQueue.safeFail(promise, cause);
        this.recycle(write2, true);
    }

    public ChannelFuture removeAndWriteAll() {
        assert (this.ctx.executor().inEventLoop());
        if (this.size == 1) {
            return this.removeAndWrite();
        }
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        this.tail = null;
        this.head = null;
        this.size = 0;
        ChannelPromise p2 = this.ctx.newPromise();
        ChannelPromiseAggregator aggregator = new ChannelPromiseAggregator(p2);
        while (write2 != null) {
            PendingWrite next = write2.next;
            Object msg = write2.msg;
            ChannelPromise promise = write2.promise;
            this.recycle(write2, false);
            this.ctx.write(msg, promise);
            aggregator.add(promise);
            write2 = next;
        }
        this.assertEmpty();
        return p2;
    }

    private void assertEmpty() {
        assert (this.tail == null && this.head == null && this.size == 0);
    }

    public ChannelFuture removeAndWrite() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        Object msg = write2.msg;
        ChannelPromise promise = write2.promise;
        this.recycle(write2, true);
        return this.ctx.write(msg, promise);
    }

    public ChannelPromise remove() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        ChannelPromise promise = write2.promise;
        ReferenceCountUtil.safeRelease(write2.msg);
        this.recycle(write2, true);
        return promise;
    }

    public Object current() {
        assert (this.ctx.executor().inEventLoop());
        PendingWrite write2 = this.head;
        if (write2 == null) {
            return null;
        }
        return write2.msg;
    }

    private void recycle(PendingWrite write2, boolean update) {
        PendingWrite next = write2.next;
        long writeSize = write2.size;
        if (update) {
            if (next == null) {
                this.tail = null;
                this.head = null;
                this.size = 0;
            } else {
                this.head = next;
                --this.size;
                assert (this.size > 0);
            }
        }
        write2.recycle();
        if (this.buffer != null) {
            this.buffer.decrementPendingOutboundBytes(writeSize);
        }
    }

    private static void safeFail(ChannelPromise promise, Throwable cause) {
        if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause)) {
            logger.warn("Failed to mark a promise as failure because it's done already: {}", (Object)promise, (Object)cause);
        }
    }

    static final class PendingWrite {
        private static final Recycler<PendingWrite> RECYCLER = new Recycler<PendingWrite>(){

            @Override
            protected PendingWrite newObject(Recycler.Handle handle) {
                return new PendingWrite(handle);
            }
        };
        private final Recycler.Handle handle;
        private PendingWrite next;
        private long size;
        private ChannelPromise promise;
        private Object msg;

        private PendingWrite(Recycler.Handle handle) {
            this.handle = handle;
        }

        static PendingWrite newInstance(Object msg, int size, ChannelPromise promise) {
            PendingWrite write2 = RECYCLER.get();
            write2.size = size;
            write2.msg = msg;
            write2.promise = promise;
            return write2;
        }

        private void recycle() {
            this.size = 0L;
            this.next = null;
            this.msg = null;
            this.promise = null;
            RECYCLER.recycle(this, this.handle);
        }
    }
}

