/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.handler.ssl;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import org.python.apache.tomcat.jni.SSLContext;
import org.python.apache.tomcat.jni.SessionTicketKey;
import org.python.netty.handler.ssl.OpenSslSessionStats;
import org.python.netty.handler.ssl.OpenSslSessionTicketKey;

public abstract class OpenSslSessionContext
implements SSLSessionContext {
    private static final Enumeration<byte[]> EMPTY = new EmptyEnumeration();
    private final OpenSslSessionStats stats;
    final long context;

    OpenSslSessionContext(long context) {
        this.context = context;
        this.stats = new OpenSslSessionStats(context);
    }

    @Override
    public SSLSession getSession(byte[] bytes) {
        if (bytes == null) {
            throw new NullPointerException("bytes");
        }
        return null;
    }

    @Override
    public Enumeration<byte[]> getIds() {
        return EMPTY;
    }

    @Deprecated
    public void setTicketKeys(byte[] keys) {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        SSLContext.setSessionTicketKeys((long)this.context, (byte[])keys);
    }

    public void setTicketKeys(OpenSslSessionTicketKey ... keys) {
        if (keys == null) {
            throw new NullPointerException("keys");
        }
        SessionTicketKey[] ticketKeys = new SessionTicketKey[keys.length];
        for (int i2 = 0; i2 < ticketKeys.length; ++i2) {
            ticketKeys[i2] = keys[i2].key;
        }
        SSLContext.setSessionTicketKeys((long)this.context, (SessionTicketKey[])ticketKeys);
    }

    public abstract void setSessionCacheEnabled(boolean var1);

    public abstract boolean isSessionCacheEnabled();

    public OpenSslSessionStats stats() {
        return this.stats;
    }

    private static final class EmptyEnumeration
    implements Enumeration<byte[]> {
        private EmptyEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        @Override
        public byte[] nextElement() {
            throw new NoSuchElementException();
        }
    }
}

