/*
 * Decompiled with CFR 0.152.
 */
package org.python.netty.util.internal;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import org.python.netty.util.internal.MpscLinkedQueueNode;
import org.python.netty.util.internal.MpscLinkedQueueTailRef;
import org.python.netty.util.internal.ReadOnlyIterator;

final class MpscLinkedQueue<E>
extends MpscLinkedQueueTailRef<E>
implements Queue<E> {
    private static final long serialVersionUID = -1878402552271506449L;
    long p00;
    long p01;
    long p02;
    long p03;
    long p04;
    long p05;
    long p06;
    long p07;
    long p30;
    long p31;
    long p32;
    long p33;
    long p34;
    long p35;
    long p36;
    long p37;

    MpscLinkedQueue() {
        DefaultNode<Object> tombstone = new DefaultNode<Object>(null);
        this.setHeadRef(tombstone);
        this.setTailRef(tombstone);
    }

    private MpscLinkedQueueNode<E> peekNode() {
        MpscLinkedQueueNode head = this.headRef();
        MpscLinkedQueueNode next = head.next();
        if (next == null && head != this.tailRef()) {
            while ((next = head.next()) == null) {
            }
        }
        return next;
    }

    @Override
    public boolean offer(E value) {
        DefaultNode<E> newTail;
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (value instanceof MpscLinkedQueueNode) {
            newTail = (DefaultNode<E>)value;
            newTail.setNext(null);
        } else {
            newTail = new DefaultNode<E>(value);
        }
        MpscLinkedQueueNode<E> oldTail = this.getAndSetTailRef(newTail);
        oldTail.setNext(newTail);
        return true;
    }

    @Override
    public E poll() {
        MpscLinkedQueueNode<E> next = this.peekNode();
        if (next == null) {
            return null;
        }
        MpscLinkedQueueNode oldHead = this.headRef();
        this.lazySetHeadRef(next);
        oldHead.unlink();
        return next.clearMaybe();
    }

    @Override
    public E peek() {
        MpscLinkedQueueNode<E> next = this.peekNode();
        if (next == null) {
            return null;
        }
        return next.value();
    }

    @Override
    public int size() {
        MpscLinkedQueueNode<E> next;
        int count2 = 0;
        MpscLinkedQueueNode<E> n2 = this.peekNode();
        while (n2 != null && n2.value() != null && n2 != (next = n2.next())) {
            n2 = next;
            if (++count2 != Integer.MAX_VALUE) continue;
            break;
        }
        return count2;
    }

    @Override
    public boolean isEmpty() {
        return this.headRef() == this.tailRef();
    }

    @Override
    public boolean contains(Object o2) {
        MpscLinkedQueueNode<E> n2 = this.peekNode();
        while (n2 != null) {
            E value = n2.value();
            if (value == null) {
                return false;
            }
            if (value == o2) {
                return true;
            }
            MpscLinkedQueueNode<E> next = n2.next();
            if (n2 == next) break;
            n2 = next;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new ReadOnlyIterator<E>(this.toList().iterator());
    }

    @Override
    public boolean add(E e2) {
        if (this.offer(e2)) {
            return true;
        }
        throw new IllegalStateException("queue full");
    }

    @Override
    public E remove() {
        E e2 = this.poll();
        if (e2 != null) {
            return e2;
        }
        throw new NoSuchElementException();
    }

    @Override
    public E element() {
        E e2 = this.peek();
        if (e2 != null) {
            return e2;
        }
        throw new NoSuchElementException();
    }

    private List<E> toList(int initialCapacity) {
        return this.toList(new ArrayList(initialCapacity));
    }

    private List<E> toList() {
        return this.toList(new ArrayList());
    }

    private List<E> toList(List<E> elements) {
        MpscLinkedQueueNode<E> next;
        E value;
        MpscLinkedQueueNode<E> n2 = this.peekNode();
        while (n2 != null && (value = n2.value()) != null && elements.add(value) && n2 != (next = n2.next())) {
            n2 = next;
        }
        return elements;
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a2) {
        return this.toList(a2.length).toArray(a2);
    }

    @Override
    public boolean remove(Object o2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c2) {
        for (Object e2 : c2) {
            if (this.contains(e2)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c2) {
        if (c2 == null) {
            throw new NullPointerException("c");
        }
        if (c2 == this) {
            throw new IllegalArgumentException("c == this");
        }
        boolean modified = false;
        for (E e2 : c2) {
            this.add(e2);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        while (this.poll() != null) {
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        for (E e2 : this) {
            out.writeObject(e2);
        }
        out.writeObject(null);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object e2;
        in.defaultReadObject();
        DefaultNode<Object> tombstone = new DefaultNode<Object>(null);
        this.setHeadRef(tombstone);
        this.setTailRef(tombstone);
        while ((e2 = in.readObject()) != null) {
            this.add(e2);
        }
    }

    private static final class DefaultNode<T>
    extends MpscLinkedQueueNode<T> {
        private T value;

        DefaultNode(T value) {
            this.value = value;
        }

        @Override
        public T value() {
            return this.value;
        }

        @Override
        protected T clearMaybe() {
            T value = this.value;
            this.value = null;
            return value;
        }
    }
}

