/*
 * Decompiled with CFR 0.152.
 */
package org.python.sizeof;

import java.lang.reflect.Field;
import java.nio.ByteOrder;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.python.sizeof.RamUsageEstimator;
import sun.misc.Unsafe;

public final class BlackMagic {
    public static Unsafe getUnsafe() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            return (Unsafe)unsafeField.get(null);
        }
        catch (Throwable t2) {
            throw new RuntimeException("Unsafe not available.", t2);
        }
    }

    public static String objectMemoryAsString(Object o2) {
        Unsafe unsafe = BlackMagic.getUnsafe();
        ByteOrder byteOrder = ByteOrder.nativeOrder();
        StringBuilder b2 = new StringBuilder();
        int obSize = (int)RamUsageEstimator.shallowSizeOf(o2);
        for (int i2 = 0; i2 < obSize; i2 += 2) {
            if ((i2 & 0xF) == 0) {
                if (i2 > 0) {
                    b2.append("\n");
                }
                b2.append(String.format(Locale.ENGLISH, "%#06x", i2));
            }
            short shortValue = unsafe.getShort(o2, i2);
            if (byteOrder == ByteOrder.BIG_ENDIAN) {
                b2.append(String.format(Locale.ENGLISH, " %02x", shortValue >>> 8 & 0xFF));
                b2.append(String.format(Locale.ENGLISH, " %02x", shortValue & 0xFF));
                continue;
            }
            b2.append(String.format(Locale.ENGLISH, " %02x", shortValue & 0xFF));
            b2.append(String.format(Locale.ENGLISH, " %02x", shortValue >>> 8 & 0xFF));
        }
        return b2.toString();
    }

    public static String fieldsLayoutAsString(Class<?> clazz) {
        Unsafe unsafe = BlackMagic.getUnsafe();
        TreeMap<Long, String> fields = new TreeMap<Long, String>();
        for (Class<?> c2 = clazz; c2 != null; c2 = c2.getSuperclass()) {
            for (Field f2 : c2.getDeclaredFields()) {
                fields.put(unsafe.objectFieldOffset(f2), f2.getDeclaringClass().getSimpleName() + "." + f2.getName());
            }
        }
        fields.put(RamUsageEstimator.shallowSizeOfInstance(clazz), "#shallowSizeOfInstance(" + clazz.getName() + ")");
        StringBuilder b2 = new StringBuilder();
        Object[] entries = fields.entrySet().toArray();
        for (int i2 = 0; i2 < entries.length; ++i2) {
            Map.Entry e2 = (Map.Entry)entries[i2];
            Map.Entry next = i2 + 1 < entries.length ? (Map.Entry)entries[i2 + 1] : null;
            b2.append(String.format(Locale.ENGLISH, "@%02d %2s %s\n", e2.getKey(), next == null ? "" : Long.valueOf((Long)next.getKey() - (Long)e2.getKey()), e2.getValue()));
        }
        return b2.toString();
    }
}

